/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers.airline;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.dict.AirlineCardVM;
import com.gridnine.xtrip.client.fx.model.dict.AirlinePanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.airline.AirlineControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.airline.AirlineHandlerConfigurator;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineCard;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;

public class StandardAirlineHandlerConfigurator
implements AirlineHandlerConfigurator {
    @Override
    public void configureListParameters(DictListParameters params) {
    }

    @Override
    public void configureController(List<BiConsumer<Airline, AirlinePanelVM>> toVM, List<BiConsumer<AirlinePanelVM, Airline>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new AirlineControllerInterceptor());
        toVM.add((model, vm) -> {
            vm.getMain().setNotUpdate(model.isNotUpdatable());
            vm.getMain().setAlliance(model.getAlliance());
            vm.getMain().setClosedDate(DateUtils.asLocalDate((Date)model.getCloseDate()));
            vm.getMain().setCode(model.getCode());
            vm.getMain().setCountry(model.getCountry());
            vm.getMain().setNumber(model.getAirlineNumber());
            vm.getMain().setRegistrationId(model.getRegistrationId());
            vm.getMain().setKpp(model.getKpp());
            vm.getMain().setBin(model.getBin());
            vm.getMain().setVatSeriesNumber(model.getVatSeriesNumber());
            vm.getMain().setVatSeriesDate(DateUtils.asLocalDate((Date)model.getVatSeriesDate()));
            vm.getMain().setPhone(model.getPhone());
            vm.getMain().setOpenedDate(DateUtils.asLocalDate((Date)model.getOpenDate()));
            vm.getMain().setLegalForm(model.getLegalForm());
            model.getAcceptableCards().forEach(card -> {
                AirlineCardVM cardVM = new AirlineCardVM();
                cardVM.setCode(card.getCode());
                cardVM.setVendor(card.getVendor());
                vm.getAcceptableCards().add(cardVM);
            });
            DictHandlersHelper.codeVariantsToVM(model.getCodeVariants(), vm.getCodeVariants().getContent());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
            DictHandlersHelper.spellVariantsToVM(model.getSpellVariants(), vm.getSpellVariants().getContent());
        });
        fromVM.add((vm, model) -> {
            model.setNotUpdatable(vm.getMain().isNotUpdate());
            model.setAlliance(vm.getMain().getAlliance());
            model.setCloseDate(DateUtils.asDate((LocalDate)vm.getMain().getClosedDate()));
            model.setCode(StringUtils.trim((String)vm.getMain().getCode()));
            model.setCountry(vm.getMain().getCountry());
            model.setAirlineNumber(vm.getMain().getNumber());
            model.setOpenDate(DateUtils.asDate((LocalDate)vm.getMain().getOpenedDate()));
            model.setRegistrationId(vm.getMain().getRegistrationId());
            model.setKpp(vm.getMain().getKpp());
            model.setBin(vm.getMain().getBin());
            model.setVatSeriesNumber(vm.getMain().getVatSeriesNumber());
            model.setVatSeriesDate(DateUtils.asDate((LocalDate)vm.getMain().getVatSeriesDate()));
            model.setPhone(vm.getMain().getPhone());
            model.setLegalForm(vm.getMain().getLegalForm());
            model.getAcceptableCards().clear();
            vm.getAcceptableCards().forEach(cardVM -> {
                AirlineCard card = new AirlineCard();
                card.setCode(cardVM.getCode());
                card.setVendor(cardVM.getVendor());
                model.getAcceptableCards().add(card);
            });
            DictHandlersHelper.codeVariantsFromVM(vm.getCodeVariants().getContent(), model.getCodeVariants());
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
            DictHandlersHelper.spellVariantsFromVM(vm.getSpellVariants().getContent(), model.getSpellVariants());
        });
    }
}

