/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers.hotelsubprovider;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.dict.HotelSubProviderPanel;
import com.gridnine.xtrip.client.fx.model.dict.HotelSubProviderPanelController;
import com.gridnine.xtrip.client.fx.model.dict.HotelSubProviderPanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.hotelsubprovider.HotelSubProviderHandlerConfigurator;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelSubProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelSubProviderReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;

public class HotelSubProviderHandler
extends BaseDictHandler<HotelSubProviderPanel, HotelSubProvider, HotelSubProviderPanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_CODE);
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), HotelSubProvider.Property.provider.name(), Messages.Provider, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
        params.getFilters().add(DictHandlersHelper.createColumn(this.getDictType(), HotelSubProvider.Property.provider.name(), Messages.Provider, (Renderer)StandardRenderers.GENERIC));
    }

    @Override
    protected void configureController(List<BiConsumer<HotelSubProvider, HotelSubProviderPanelVM>> toVM, List<BiConsumer<HotelSubProviderPanelVM, HotelSubProvider>> fromVM) {
        toVM.add((model, vm) -> {
            vm.setCode(model.getCode());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
            vm.setGds(model.getGds());
            vm.setProvider(model.getProvider());
        });
        fromVM.add((vm, model) -> {
            model.setCode(StringUtils.trim((String)vm.getCode()));
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
            model.setGds(vm.getGds());
            model.setProvider(vm.getProvider());
        });
        ClientRegistry.get().allOf(HotelSubProviderHandlerConfigurator.TYPE).values().forEach(cfg -> cfg.configureController(toVM, fromVM));
    }

    public Class<HotelSubProvider> getDictType() {
        return HotelSubProvider.class;
    }

    public DictionaryReference<HotelSubProvider> createReference(String code) {
        return new HotelSubProviderReference(code);
    }

    @Override
    protected HotelSubProviderPanelVM createVM() {
        return new HotelSubProviderPanelVM();
    }

    @Override
    protected ViewController<HotelSubProviderPanel, HotelSubProviderPanelVM> createController() {
        return new HotelSubProviderPanelController(false);
    }
}

