/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPaneConfiguration;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.BaseEntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.model.profile.TripartiteContractFullPanel;
import com.gridnine.xtrip.client.fx.model.profile.TripartiteContractSpace;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.ValueHolder;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.binding.BooleanExpression;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SelectionMode;

public class AddClientsToContractAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.ADD_CLIENTS_TO_CONTRACT;
    }

    public double getWeight() {
        return 50.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.getEntityHandler().getEntityClass().equals(TripartiteContract.class);
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return context.getMode().equals((Object)EditingMode.EDIT);
    }

    public void execute(Control source, final RootEntityPane<?, ?> context, boolean alt) {
        final MultiSupplier listParametersSupplier = BaseEntityBoxWidget.createDefaultListParametersSupplier(Organization.class);
        IndexListPane<Organization, EntityIndex<Organization>> pane = new IndexListPane<Organization, EntityIndex<Organization>>(new ObservableMutex(), (MultiSupplier)new MultiSupplier<IndexListPaneConfiguration<Organization, EntityIndex<Organization>>>(){

            public int count() {
                return listParametersSupplier.count();
            }

            public String getDisplayName(int idx) {
                return listParametersSupplier.getDisplayName(idx);
            }

            public IndexListPaneConfiguration<Organization, EntityIndex<Organization>> get(int idx) {
                IndexListParameters parameters = (IndexListParameters)listParametersSupplier.get(idx);
                parameters.getSearchCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.CORPORATE_CLIENT.name()));
                IndexListPaneConfiguration result = new IndexListPaneConfiguration(parameters.getIndexType());
                result.setSelectionMode(SelectionMode.MULTIPLE);
                result.setPatternSearchEnabled(true);
                result.setActionsEnabled(false);
                result.setLimit(parameters.getLimit());
                result.applyParameters(parameters);
                return result;
            }
        }){

            protected void newConfigurationPopulated() {
                super.newConfigurationPopulated();
                this.getTableView().getColumns().add((Object)TableColumnSettings.createActionColumn(item -> RootEntityEditingService.navigateTo((EntityReference)item.getSource())));
            }
        };
        Consumer<List<ValueHolder<EntityReference<Organization>>>> consumer = new Consumer<List<ValueHolder<EntityReference<Organization>>>>(){

            @Override
            public void accept(List<ValueHolder<EntityReference<Organization>>> list) {
                TripartiteContractSpace node = (TripartiteContractSpace)context.getEditor();
                TableWidget table = (TableWidget)((TripartiteContractFullPanel)node.getMainTile().getFullNode()).getClientsCard().getContent();
                list.stream().forEach(item -> {
                    table.addRow(table.getRowsCount());
                    EntityBoxWidget widget = (EntityBoxWidget)((TableWidgetColumn)table.getColumns().get(0)).getWidget(table.getRowsCount() - 1);
                    widget.setValue((EntityReference)item.getValue());
                });
            }
        };
        new Dialog().setTitle(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Organizations).setBody((Node)pane).setExpandToParent(true).addButton(DialogButtonStyle.DECLINE, Messages.General_Cancel).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.General_Choose, () -> AddClientsToContractAction.lambda$execute$1((IndexListPane)pane, consumer), (BooleanExpression)pane.selectionPresentProperty()).show((Node)source);
    }

    public String getId() {
        return "add-clients-to-contract";
    }

    private static /* synthetic */ void lambda$execute$1(IndexListPane pane, Consumer consumer) {
        List items = pane.getSelectedItems();
        consumer.accept(items.stream().map(idx -> new ValueHolder((Object)idx.getSource())).collect(Collectors.toList()));
    }
}

