/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductIndex;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class BaseProductExchangeListAction
implements IndexListAction {
    private static final Collection<Class<?>> ALLOWED_TYPES = Collections.singletonList(UniversalProductIndex.class);

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.EXCHANGE;
    }

    public double getWeight() {
        return 8.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        return ALLOWED_TYPES.contains(context.getIndexType());
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return context.getSelectedItems().size() == 1;
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        Dialog.confirm((Node)source, (String)Messages.Exchange_of_the_base_product, () -> {
            List selectedItems = context.getSelectedItems();
            EntityIndex bfInd = (EntityIndex)selectedItems.get(0);
            EntityReference bfRef = bfInd.getSource();
            Notifications.get().submitTask(() -> {
                EntityContainer bfCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), bfRef);
                if (bfCtr == null) {
                    Dialog.info((Node)context, (String)Messages.Order_Not_Found);
                    return;
                }
                BaseProduct selectedProduct = BookingHelper.findProductByUid((String)bfInd.getNavigationKey(), (BookingFile)((BookingFile)bfCtr.getEntity()));
                ProductStatus productStatus = BookingHelper.getProductStatus((BaseProduct)selectedProduct);
                if (productStatus != ProductStatus.SELL) {
                    Dialog.info((Node)context, (String)Messages.Return_is_not_possible_Not_in_Sale);
                    return;
                }
                if (ProductHandler.of((BaseProduct)selectedProduct).getNextProduct(selectedProduct) != null) {
                    Dialog.info((Node)context, (String)Messages.Return_is_not_possible_Already_Exchanged_or_Returned);
                    return;
                }
                EntityReference ref = bfInd.getSource();
                String prodUid = selectedProduct.getUid();
                BookingFileService.ProductRPCResult result = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).exchangeProduct(ServiceInvocationContext.get(), prodUid, ref, new ProductExchangeRefundProperties(new Date(), new EntityReference(), false, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, new ArrayList(), new ArrayList(), new ArrayList(), ""));
                Notifications.get().showMessages((Collection)result.getResultMessageList());
                EventBus.get().publishAsync((Event)new EntityModificationEvent(null, new EntityModification(ref, EntityModification.ModificationType.CHANGE)));
            }, context.getMutex());
        });
    }

    public String getId() {
        return "base-product-list-exchange";
    }
}

