/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.standard.entity.RootEntityActivityHandler;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.profile.TripartiteContract;
import com.gridnine.xtrip.common.model.profile.TripartiteContractType;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import java.util.ArrayList;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class CreateTripartiteContractAction
implements IndexListAction {
    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.ADD;
    }

    public String getId() {
        return "entity-tripartitecontract-create";
    }

    public double getWeight() {
        return -1.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        EntityType ett = MetaRegistryHelper.getEntityTypeForIndex((String)context.getIndexType().getName());
        return TripartiteContract.class.getName().equals(ett.getId());
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return true;
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        ComboBoxWidget typeWidget = new ComboBoxWidget(false);
        typeWidget.setNoNulls(true);
        typeWidget.setItemsSupplier(() -> {
            ArrayList<TripartiteContractType> list = new ArrayList<TripartiteContractType>();
            list.add(TripartiteContractType.AVIA);
            list.add(TripartiteContractType.CAR);
            list.add(TripartiteContractType.HOTEL);
            return list;
        });
        typeWidget.valueProperty().set((Object)TripartiteContractType.AVIA);
        new Dialog().setTitle(Messages.Choose_type_of_tripartite_agreement).setBody((Node)typeWidget).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Select, () -> RootEntityActivityHandler.editNew(this.createContract((TripartiteContractType)typeWidget.valueProperty().get()))).show(context);
    }

    private DataTransferPackage<TripartiteContract, Void> createContract(TripartiteContractType type) {
        EntityContainer ctr = new EntityContainer(TripartiteContract.class);
        ((TripartiteContract)ctr.getEntity()).setType(type);
        return new DataTransferPackage(ctr);
    }

    public AclQuery getACLQuery(IndexListPane<?, ?> context) {
        return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_TRIPARTITE_CONTRACT.getId());
    }
}

