/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RadioBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.util.StringConverter;

public class DeliverySelectionPanel
extends CardsContainer {
    protected RadioBoxWidget<BookingFileType> bookingFileRadioBox;
    protected RadioBoxWidget<ReservationType> reservationRadioBox;
    protected RadioBoxWidget<DeliveryType> deliveryRadioBox;
    protected EntityBoxWidget<BookingFile> bookingFileWidget;
    protected ComboBoxWidget<Reservation> reservationWidget;
    protected ComboBoxWidget<Delivery> deliveryWidget;
    protected GridCell<Node> bookingFileCell;
    protected GridCell<ComboBoxWidget<Reservation>> reservationCell;
    protected GridCell<Node> deliveryCell;
    private final ReadOnlyBooleanWrapper valid = new ReadOnlyBooleanWrapper(false);
    private final boolean allowReservationSelection;
    private final boolean allowFromProducts;
    private final List<EntityReference<BookingFile>> selectedBookingFileList;

    public DeliverySelectionPanel(boolean allowReservationSelection, boolean allowFromProducts, List<EntityReference<BookingFile>> selectedBookingFileList) {
        this.allowReservationSelection = allowReservationSelection;
        this.allowFromProducts = allowFromProducts;
        this.selectedBookingFileList = selectedBookingFileList;
        this.createGUI();
        this.createBindings();
        this.createListeners();
    }

    private void createGUI() {
        this.bookingFileRadioBox = new RadioBoxWidget(false);
        this.bookingFileRadioBox.setValue((Object)BookingFileType.NEW);
        if (this.allowFromProducts) {
            this.bookingFileRadioBox.setItemsSupplier(Suppliers.createEnumSupplier(BookingFileType.class));
        } else {
            this.bookingFileRadioBox.setItemsSupplier(() -> Arrays.asList(BookingFileType.NEW, BookingFileType.EXISTING));
        }
        this.reservationRadioBox = new RadioBoxWidget(false);
        this.reservationRadioBox.setValue((Object)ReservationType.NEW);
        this.reservationRadioBox.getViewState().setNotEditable(true);
        this.reservationRadioBox.setItemsSupplier(Suppliers.createEnumSupplier(ReservationType.class));
        this.deliveryRadioBox = new RadioBoxWidget(false);
        this.deliveryRadioBox.setValue((Object)DeliveryType.NEW);
        this.deliveryRadioBox.getViewState().setNotEditable(true);
        this.deliveryRadioBox.setItemsSupplier(Suppliers.createEnumSupplier(DeliveryType.class));
        this.bookingFileWidget = new EntityBoxWidget(BookingFile.class, false);
        this.reservationWidget = new ComboBoxWidget(false);
        this.reservationWidget.setNoNulls(true);
        this.reservationWidget.setLive(true);
        this.reservationWidget.setConverter((StringConverter)new StringConverter<Reservation>(){

            public String toString(Reservation reservation) {
                return Optional.ofNullable(reservation).map(CommonReservationGdsNameInfoHelper::getDisplayedRecordLocator).orElse(Messages.No_Name);
            }

            public Reservation fromString(String string) {
                return null;
            }
        });
        this.deliveryWidget = new ComboBoxWidget(false);
        this.deliveryWidget.setNoNulls(true);
        this.deliveryWidget.setLive(true);
        this.deliveryWidget.setConverter((StringConverter)new StringConverter<Delivery>(){

            public String toString(Delivery product) {
                return product != null ? ProductHandler.of((BaseProduct)product).generateShortProductName((BaseProduct)product) : Messages.No_Name;
            }

            public Delivery fromString(String string) {
                return null;
            }
        });
        this.bookingFileCell = new GridCell(this.bookingFileWidget);
        this.bookingFileCell.setHidden(true);
        this.reservationCell = new GridCell(this.reservationWidget);
        this.reservationCell.setHidden(true);
        this.deliveryCell = new GridCell(this.deliveryWidget);
        this.deliveryCell.setHidden(true);
        GridContainer bookingFilePanel = new GridContainer(1);
        GridContainer reservationPanel = new GridContainer(1);
        GridContainer deliveryPanel = new GridContainer(1);
        Card bookingCard = new Card("booking", UiCardsContainer.Style.STATIC, Messages.Select_order, (Node)bookingFilePanel);
        Card reservationCard = new Card("reservation", UiCardsContainer.Style.STATIC, Messages.Select_reservation, (Node)reservationPanel);
        Card deliveryCard = new Card("delivery", UiCardsContainer.Style.STATIC, Messages.Select_delivery, (Node)deliveryPanel);
        reservationCard.setHidden(!this.allowReservationSelection);
        bookingFilePanel.getCells().addAll((Object[])new GridCell[]{new GridCell(this.bookingFileRadioBox), GridCell.NEW_ROW_MARKER, this.bookingFileCell});
        reservationPanel.getCells().addAll((Object[])new GridCell[]{new GridCell(this.reservationRadioBox), GridCell.NEW_ROW_MARKER, this.reservationCell});
        deliveryPanel.getCells().addAll((Object[])new GridCell[]{new GridCell(this.deliveryRadioBox), GridCell.NEW_ROW_MARKER, this.deliveryCell});
        this.getCards().addAll((Object[])new Card[]{bookingCard, reservationCard, deliveryCard});
    }

    private void createBindings() {
        this.valid.bind((ObservableValue)Bindings.createBooleanBinding(() -> !(this.bookingFileRadioBox.getValue() != BookingFileType.NEW && this.bookingFileWidget.getValue() == null || this.reservationRadioBox.getValue() != ReservationType.NEW && this.reservationWidget.getValue() == null || this.deliveryRadioBox.getValue() != DeliveryType.NEW && this.deliveryWidget.getValue() == null), (Observable[])new Observable[]{this.bookingFileWidget.valueProperty(), this.reservationWidget.valueProperty(), this.deliveryWidget.valueProperty(), this.bookingFileRadioBox.valueProperty(), this.reservationRadioBox.valueProperty(), this.deliveryRadioBox.valueProperty()}));
    }

    private void createListeners() {
        this.bookingFileWidget.valueProperty().addListener((obesrvable, oldValue, newValue) -> {
            if (newValue != null) {
                Notifications.get().submitTask(() -> {
                    try {
                        BookingFile bookingFile = Optional.ofNullable(((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), newValue)).map(item -> (BookingFile)item.getEntity()).orElse(null);
                        FxUtil.waitForFxThread(() -> {
                            if (this.allowReservationSelection) {
                                List reservations = bookingFile != null ? bookingFile.getReservations() : Collections.emptyList();
                                this.reservationWidget.setItemsSupplier(() -> reservations);
                                this.reservationWidget.setValue(reservations.size() == 1 ? (Reservation)reservations.get(0) : null);
                            } else {
                                List products = bookingFile != null ? bookingFile.getReservations().stream().flatMap(item -> item.getProducts().stream()).filter(baseProduct -> baseProduct instanceof Delivery).map(baseProduct -> (Delivery)baseProduct).collect(Collectors.toList()) : Collections.emptyList();
                                this.deliveryWidget.setItemsSupplier(() -> products);
                                this.deliveryWidget.setValue(products.size() == 1 ? (Delivery)products.get(0) : null);
                            }
                        });
                    }
                    catch (Exception e) {
                        ErrorHandler.handle((Throwable)e);
                    }
                }, Messages.Loading_order_data);
            } else if (this.allowReservationSelection) {
                this.reservationWidget.setItemsSupplier(() -> Collections.emptyList());
                this.reservationWidget.setValue(null);
            } else {
                this.deliveryWidget.setItemsSupplier(() -> Collections.emptyList());
                this.deliveryWidget.setValue(null);
            }
        });
        this.reservationWidget.valueProperty().addListener((obesrvable, oldValue, newValue) -> {
            List products = newValue != null ? newValue.getProducts().stream().filter(baseProduct -> baseProduct instanceof Delivery).map(baseProduct -> (Delivery)baseProduct).collect(Collectors.toList()) : Collections.emptyList();
            this.deliveryWidget.setItemsSupplier(() -> products);
            this.deliveryWidget.setValue(products.size() == 1 ? (Delivery)products.get(0) : null);
        });
        this.bookingFileRadioBox.valueProperty().addListener((obesrvable, oldValue, newValue) -> {
            if (newValue == BookingFileType.NEW) {
                this.bookingFileCell.setHidden(true);
                if (this.allowReservationSelection) {
                    this.reservationRadioBox.getViewState().setNotEditable(true);
                } else {
                    this.deliveryRadioBox.getViewState().setNotEditable(true);
                }
            } else if (newValue == BookingFileType.FROM_PRODUCTS) {
                this.bookingFileWidget.setItemsSupplier(() -> new ArrayList<EntityReference<BookingFile>>(this.selectedBookingFileList), false);
                this.bookingFileCell.setHidden(false);
                if (this.allowReservationSelection) {
                    this.reservationRadioBox.getViewState().setNotEditable(false);
                } else {
                    this.deliveryRadioBox.getViewState().setNotEditable(false);
                }
            } else if (newValue == BookingFileType.EXISTING) {
                this.bookingFileWidget.setItemsSupplier(null, false);
                this.bookingFileCell.setHidden(false);
                if (this.allowReservationSelection) {
                    this.reservationRadioBox.getViewState().setNotEditable(false);
                } else {
                    this.deliveryRadioBox.getViewState().setNotEditable(false);
                }
            }
            if (this.allowReservationSelection) {
                this.reservationRadioBox.setValue((Object)ReservationType.NEW);
            } else {
                this.deliveryRadioBox.setValue((Object)DeliveryType.NEW);
            }
        });
        this.reservationRadioBox.valueProperty().addListener((obesrvable, oldValue, newValue) -> {
            if (newValue == ReservationType.NEW) {
                this.reservationCell.setHidden(true);
                this.deliveryRadioBox.getViewState().setNotEditable(true);
            } else if (newValue == ReservationType.EXISTING) {
                this.reservationCell.setHidden(false);
                this.deliveryRadioBox.getViewState().setNotEditable(false);
            }
            this.deliveryRadioBox.setValue((Object)DeliveryType.NEW);
        });
        this.deliveryRadioBox.valueProperty().addListener((obesrvable, oldValue, newValue) -> {
            if (newValue == DeliveryType.NEW) {
                this.deliveryCell.setHidden(true);
            } else if (newValue == DeliveryType.EXISTING) {
                this.deliveryCell.setHidden(false);
            }
        });
    }

    public ReadOnlyBooleanProperty validProperty() {
        return this.valid.getReadOnlyProperty();
    }

    public void readData(DeliverySelectionData data) {
        this.bookingFileRadioBox.setValue((Object)(data.getBookingFile() != null ? BookingFileType.EXISTING : BookingFileType.NEW));
        this.bookingFileWidget.setValue(data.getBookingFile());
        this.reservationRadioBox.setValue((Object)(data.getReservation() != null ? ReservationType.EXISTING : ReservationType.NEW));
        this.reservationWidget.setValue((Object)data.getReservation());
        this.deliveryRadioBox.setValue((Object)(data.getDelivery() != null ? DeliveryType.EXISTING : DeliveryType.NEW));
        this.deliveryWidget.setValue((Object)data.getDelivery());
    }

    public void writeData(DeliverySelectionData data) {
        data.setBookingFile(this.bookingFileRadioBox.getValue() != BookingFileType.NEW ? this.bookingFileWidget.getValue() : null);
        if (this.allowReservationSelection) {
            data.setReservation(this.reservationRadioBox.getValue() == ReservationType.EXISTING ? (Reservation)this.reservationWidget.getValue() : null);
        } else {
            data.setReservation(this.deliveryRadioBox.getValue() == DeliveryType.EXISTING ? (Reservation)Optional.ofNullable(this.deliveryWidget.getValue()).map(item -> item.getReservation()).orElse(null) : null);
        }
        data.setDelivery(this.deliveryRadioBox.getValue() == DeliveryType.EXISTING ? (Delivery)this.deliveryWidget.getValue() : null);
    }

    public static class DeliverySelectionData {
        private EntityReference<BookingFile> bookingFile;
        private Reservation reservation;
        private Delivery delivery;

        public EntityReference<BookingFile> getBookingFile() {
            return this.bookingFile;
        }

        public void setBookingFile(EntityReference<BookingFile> bookingFile) {
            this.bookingFile = bookingFile;
        }

        public Reservation getReservation() {
            return this.reservation;
        }

        public void setReservation(Reservation reservation) {
            this.reservation = reservation;
        }

        public Delivery getDelivery() {
            return this.delivery;
        }

        public void setDelivery(Delivery delivery) {
            this.delivery = delivery;
        }
    }

    static enum DeliveryType {
        NEW{

            public String toString() {
                return Messages.deliverySelectDeliveryNew;
            }
        }
        ,
        EXISTING{

            public String toString() {
                return Messages.deliverySelectDeliveryExisting;
            }
        };

    }

    static enum ReservationType {
        NEW{

            public String toString() {
                return Messages.deliverySelectReservationNew;
            }
        }
        ,
        EXISTING{

            public String toString() {
                return Messages.deliverySelectReservationExisting;
            }
        };

    }

    static enum BookingFileType {
        NEW{

            public String toString() {
                return Messages.deliverySelectBookingFileNew;
            }
        }
        ,
        FROM_PRODUCTS{

            public String toString() {
                return Messages.deliverySelectBookingFileFromProducts;
            }
        }
        ,
        EXISTING{

            public String toString() {
                return Messages.deliverySelectBookingFileExisting;
            }
        };

    }
}

