/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.ExportProperties;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.RetArchiveExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.SsodArchiveExchangeDocument;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.Control;

public class ProcessExchangeFilesAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.PROCESS;
    }

    public double getWeight() {
        return 23.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && BaseExchangeDocument.class.isAssignableFrom(context.getEntityHandler().getEntityClass());
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        if (context.getMode() == EditingMode.CREATE) {
            return false;
        }
        return !context.getEntityHandler().getEntityClass().equals(SsodArchiveExchangeDocument.class) && !context.getEntityHandler().getEntityClass().equals(RetArchiveExchangeDocument.class);
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        this.processParser((EntityReference<? extends BaseEntity>)context.getData().getContainer().toReference());
    }

    private void processParser(final EntityReference<? extends BaseEntity> ref) {
        Notifications.get().enqueueAsyncTask(new ServerTaskHandler(){

            protected String getTitle() {
                return Messages.Processing_of_exchange_files;
            }

            protected void onCompleted(Object result, List<Message> log) {
                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)ProcessExchangeFilesAction.this, new EntityModification(ref, EntityModification.ModificationType.CHANGE)));
            }

            protected Serializable getTaskParameters() {
                ExportProperties properties = new ExportProperties();
                ArrayList<EntityReference> refList = new ArrayList<EntityReference>();
                refList.add(ref);
                properties.setReferenceList(refList);
                return properties;
            }

            protected String getTaskClassName() {
                return "com.gridnine.xtrip.server.fx.async.entityactions.ExchangeFilesProcessAsyncTask";
            }
        });
    }

    public String getId() {
        return "process-exchange-files";
    }
}

