/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.ExportProperties;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.RetArchiveExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.SsodArchiveExchangeDocument;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.scene.control.Control;

public class ProcessExchangeFilesListAction
implements IndexListAction {
    private static final Collection<String> FORBIDDEN_CLASS_NAMES = Collections.unmodifiableCollection(new HashSet<String>(Arrays.asList(SsodArchiveExchangeDocument.class.getName(), RetArchiveExchangeDocument.class.getName())));

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.PROCESS;
    }

    public double getWeight() {
        return 25.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        EntityType ett = MetaRegistryHelper.getEntityTypeForIndex((String)context.getIndexType().getName());
        if (FORBIDDEN_CLASS_NAMES.contains(ett.getId())) {
            return false;
        }
        try {
            return BaseExchangeDocument.class.isAssignableFrom(XSHelper.getClass((String)ett.getId()));
        }
        catch (ClassNotFoundException e) {
            ErrorHandler.handle((Throwable)e);
            return false;
        }
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return true;
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        boolean itemsAreSelected;
        ArrayList documentsToProcess = new ArrayList();
        HashSet<String> uids = new HashSet<String>();
        boolean bl = itemsAreSelected = context.getSelectedItems().size() > 0;
        if (itemsAreSelected) {
            context.getSelectedItems().forEach(item -> {
                documentsToProcess.add(item.getSource());
                uids.add(item.getUid());
            });
            if (!documentsToProcess.isEmpty()) {
                this.processParsers(context.getIndexType(), context.buildQuery(), uids, documentsToProcess);
            }
        } else {
            Dialog.confirm((String)Messages.Process_all_submitted_files, () -> {
                context.getTableView().getItems().forEach(item -> {
                    documentsToProcess.add(item.getSource());
                    uids.add(item.getUid());
                });
                if (!documentsToProcess.isEmpty()) {
                    this.processParsers(context.getIndexType(), context.buildQuery(), uids, documentsToProcess);
                }
            });
        }
    }

    private <E extends BaseEntity, I extends EntityIndex<E>> void processParsers(final Class<I> entityIndexType, final SearchQuery query, final Set<String> uids, final List<EntityReference<?>> selectedItems) {
        if ("com.gridnine.xtrip.common.parsers.model.amadeus.AmadeusExchangeDocument".equals(selectedItems.get(0).getType().getName())) {
            query.getCriteria().getOrders().clear();
            query.getCriteria().getOrders().put("created", SortOrder.ASC);
        }
        if ("com.gridnine.xtrip.common.parsers.model.TchXmlCommissionsExchangeDocument".equals(selectedItems.get(0).getType().getName())) {
            query.getCriteria().getOrders().clear();
            query.getCriteria().getOrders().put("notificationDate", SortOrder.ASC);
        }
        Notifications.get().enqueueAsyncTask(new ServerTaskHandler(){

            protected String getTitle() {
                return Messages.Processing_of_exchange_files;
            }

            protected void onCompleted(Object result, List<Message> log) {
                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)ProcessExchangeFilesListAction.this, (Collection)selectedItems.stream().map(ref -> new EntityModification(ref, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
            }

            protected Serializable getTaskParameters() {
                ExportProperties properties = new ExportProperties();
                properties.setEntityIndexType(entityIndexType);
                properties.setQuery(query);
                properties.setUids(uids);
                return properties;
            }

            protected String getTaskClassName() {
                return "com.gridnine.xtrip.server.fx.async.entityactions.ExchangeFilesProcessAsyncTask";
            }
        });
    }

    public String getId() {
        return "process-exchange-files";
    }
}

