/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.ProductRecalculateFOPListTask;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class ProductRecalculateFOPListAction
implements IndexListAction {
    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.FOP;
    }

    public double getWeight() {
        return 51.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        ProductFXHandler<?, ?, ?, ?> productFXHandler = ProductFXHandler.forProductIndexClass(context.getIndexType());
        return productFXHandler != null && productFXHandler.isFOPRecalculatable();
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        Dialog.confirm((Node)source, (String)Messages.Recalculate_FOP, () -> {
            List<EntityIndex> selectedItems = context.getSelectedItems().stream().collect(Collectors.toList());
            ProductFXHandler<?, ?, ?, ?> productFXHandler = ProductFXHandler.forProductIndex((EntityIndex<BookingFile>)((EntityIndex)selectedItems.get(0)));
            if (productFXHandler != null) {
                HashMap<String, EntityReference<BookingFile>> productMap = new HashMap<String, EntityReference<BookingFile>>();
                selectedItems.forEach(productIndex -> productMap.put(productIndex.getNavigationKey(), productIndex.getSource()));
                Notifications.get().enqueueAsyncTask(new ProductRecalculateFOPListTask(productMap));
            }
        });
    }

    public String getId() {
        return "booking-file-list-recalculateFOP";
    }
}

