/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.AirProductRefundDialog;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class ProductRefundListAction
implements IndexListAction {
    private static final Collection<Class<?>> ALLOWED_TYPES = Arrays.asList(ProductIndex.class);

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.REFUND;
    }

    public double getWeight() {
        return 9.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        return ALLOWED_TYPES.contains(context.getIndexType());
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return context.getSelectedItems().size() == 1;
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        List selectedItems = context.getSelectedItems();
        Notifications.get().submitTask(() -> {
            EntityIndex bfInd = (EntityIndex)selectedItems.get(0);
            EntityReference bfRef = bfInd.getSource();
            EntityContainer bfCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), bfRef);
            if (bfCtr == null) {
                Dialog.info((Node)context, (String)Messages.Order_Not_Found);
                return;
            }
            BaseProduct selectedProduct = BookingHelper.findProductByUid((String)bfInd.getNavigationKey(), (BookingFile)((BookingFile)bfCtr.getEntity()));
            if (!AirProductHelper.isAirProduct((BaseProduct)selectedProduct)) {
                Dialog.info((Node)context, (String)Messages.Return_is_not_possible_Not_Air_Ticket);
                return;
            }
            ProductStatus productStatus = BookingHelper.getProductStatus((BaseProduct)selectedProduct);
            if (productStatus != ProductStatus.SELL) {
                Dialog.info((Node)context, (String)Messages.Return_is_not_possible_Not_in_Sale);
                return;
            }
            if (((Product)selectedProduct).getNextProduct() != null) {
                Dialog.info((Node)context, (String)Messages.Return_is_not_possible_Already_Exchanged_or_Returned);
                return;
            }
            if (AirProductHelper.isAirProduct((BaseProduct)selectedProduct)) {
                FxUtil.submitToFxThread(() -> {
                    AirProductRefundDialog dialog = new AirProductRefundDialog((Node)source, (EntityReference<BookingFile>)bfRef, (Product)selectedProduct, null);
                    dialog.showDialog();
                });
            }
        }, context.getMutex());
    }

    public String getId() {
        return "product-list-refund";
    }
}

