/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RendererWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.RendererWidgetColumn;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.booking.SabreHotelSearchPane;
import com.gridnine.xtrip.client.fx.model.booking.SabreHotelSearchResultItemVM;
import com.gridnine.xtrip.client.fx.model.profile.SalesPointSpace;
import com.gridnine.xtrip.client.fx.standard.custom.ValidatorEntityBoxWidget;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.hotel.HotelSearchConfigurator;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.renderer.StandardNodeRenderer;
import com.gridnine.xtrip.client.fx.standard.tasks.ProductReplaceDetailsListTask;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicketIndex;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.MCOFeesIndex;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductReplaceDetailsType;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProductIndex;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentIndex;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicIndex;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductIndex;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.booking.transfers.TransferIndex;
import com.gridnine.xtrip.common.model.booking.visa.VisaProductIndex;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductIndex;
import com.gridnine.xtrip.common.model.delivery.DeliveryIndex;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.Hotel;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.model.profile.ValidatorIndex;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableObjectValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class ProductReplaceDetailsListAction
implements IndexListAction {
    private static final Collection<Class<?>> ALLOWED_TYPES = Arrays.asList(ProductIndex.class, CommonProductIndex.class, MainHotelProductIndex.class, TransferIndex.class, CarRentalProductIndex.class, InsuranceAccidentIndex.class, RailwayProductIndex.class, AeroexpressTicketIndex.class, VisaProductIndex.class, DeliveryIndex.class, MCOFeesIndex.class, InsuranceTouristicIndex.class, UniversalProductIndex.class);

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.UPDATE;
    }

    public double getWeight() {
        return 50.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        return ALLOWED_TYPES.contains(context.getIndexType());
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    public String getId() {
        return "product-replace-details";
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        Notifications.get().submitTask(() -> {
            List selectedItems = context.getSelectedItems();
            BookingFilesData bookingFilesData = this.createBookingFilesData(selectedItems);
            FxUtil.waitForFxThread(() -> {
                ObservableSet selectedTypes = FXCollections.observableSet((Object[])new ProductReplaceDetailsType[0]);
                TableWidget tableWidget = new TableWidget(false);
                tableWidget.setItemsProvider(() -> new ProductReplaceDetail());
                tableWidget.setControlButtonsAvailability(ControlsPane.ADD_REMOVE);
                tableWidget.setColumns(this.createTableColumns(context.getIndexType(), (Set<ProductReplaceDetailsType>)selectedTypes, bookingFilesData.getAvailableTypes()));
                tableWidget.setOnRowsAction(event -> {
                    if (event.getTarget() != tableWidget) {
                        return;
                    }
                    if (event.getEventType().equals(TableRowEvent.ROW_ADD)) {
                        int rowIndex = event.getRowIndex();
                        ComboBoxWidget typeWidget = (ComboBoxWidget)((ComboBoxWidgetColumn)tableWidget.getColumn("type")).getWidget(rowIndex);
                        RendererWidget valueWidget = (RendererWidget)((RendererWidgetColumn)tableWidget.getColumn("value")).getWidget(rowIndex);
                        typeWidget.valueProperty().addListener((observable, oldValue, newValue) -> {
                            if (newValue != null) {
                                TypeWrapper wrapper = this.createWrapper((ProductReplaceDetailsType)newValue);
                                valueWidget.setRenderer(wrapper.getRenderer());
                                this.updateSelectedNames((TableWidget<ProductReplaceDetail>)tableWidget, (Set<ProductReplaceDetailsType>)selectedTypes);
                                wrapper.setListParametersSupplier(valueWidget.getValueNode(), bookingFilesData);
                                valueWidget.setValue(null);
                            }
                        });
                    } else if (event.getEventType().equals(TableRowEvent.ROW_REMOVE)) {
                        this.updateSelectedNames((TableWidget<ProductReplaceDetail>)tableWidget, (Set<ProductReplaceDetailsType>)selectedTypes);
                    }
                });
                tableWidget.addRow(0);
                if (bookingFilesData.getAvailableTypes().isEmpty()) {
                    Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.editProductPermissionDenied, (Object[])new Object[0])});
                } else {
                    Dialog dialog = new Dialog();
                    dialog.setTitle(Messages.Change_of_requisites);
                    dialog.setBody((Node)tableWidget).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Action_Change, () -> this.write(tableWidget.getRowsData(), selectedItems), (BooleanExpression)Bindings.isNotEmpty((ObservableSet)selectedTypes)).show((Node)source);
                }
            });
        }, context.getMutex());
    }

    private BookingFilesData createBookingFilesData(Collection<EntityIndex<BookingFile>> selectedItems) throws Exception {
        HashMap entityReferenceToUidMap = new HashMap();
        selectedItems.forEach(selectedItem -> entityReferenceToUidMap.computeIfAbsent(selectedItem.getSource(), key -> new ArrayList()).add(selectedItem.getNavigationKey()));
        BookingFileService.ProductReplaceDetailsPrepareResult prepareResult = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).prepareProductReplaceDetails(ServiceInvocationContext.get(), entityReferenceToUidMap);
        BookingFilesData bookingFilesData = new BookingFilesData();
        bookingFilesData.getPayerUids().addAll(prepareResult.getPayerUids());
        bookingFilesData.getAvailableTypes().addAll(prepareResult.getAvailableTypes());
        bookingFilesData.setCustomer((EntityReference<Organization>)prepareResult.getCustomer());
        bookingFilesData.setSubagency((EntityReference<Organization>)prepareResult.getSubagency());
        bookingFilesData.setProvider(prepareResult.getProvider());
        return bookingFilesData;
    }

    public void write(Collection<ProductReplaceDetail> rowsData, Collection<EntityIndex<BookingFile>> selectedItems) {
        Map<String, EntityReference<BookingFile>> entityReferenceToUidMap = selectedItems.stream().collect(Collectors.toMap(EntityIndex::getNavigationKey, EntityIndex::getSource));
        Notifications.get().enqueueAsyncTask((ClientTask)new ProductReplaceDetailsListTask(entityReferenceToUidMap, rowsData.stream().filter(replaceDetail -> replaceDetail.getType() != null && ((ProductReplaceDetail)replaceDetail).getValue() != null).collect(Collectors.toMap(ProductReplaceDetail::getType, rec$ -> ((ProductReplaceDetail)rec$).getValue(), (first, second) -> first))));
    }

    private void updateSelectedNames(TableWidget<ProductReplaceDetail> tableWidget, Set<ProductReplaceDetailsType> selectedNames) {
        selectedNames.clear();
        ComboBoxWidgetColumn nameColumn = (ComboBoxWidgetColumn)tableWidget.getColumn("type");
        IntStream.range(0, tableWidget.getRowsCount()).forEach(idx -> selectedNames.add((ProductReplaceDetailsType)((ComboBoxWidget)nameColumn.getWidget(idx)).getValue()));
    }

    private List<TableWidgetColumn<ProductReplaceDetail, ?>> createTableColumns(Class<?> indexType, Set<ProductReplaceDetailsType> selectedTypes, Set<ProductReplaceDetailsType> allowedTypes) {
        ArrayList result = new ArrayList();
        ComboBoxWidgetColumn col = new ComboBoxWidgetColumn(ProductReplaceDetail::getType, (rec$, x$0) -> ((ProductReplaceDetail)rec$).setType(x$0));
        col.setId("type");
        col.setCaption(Messages.Field_Name);
        col.setPrefWidthEm(Double.valueOf(20.0));
        col.setLive(true);
        col.setNoNulls(true);
        col.setItemsSupplier(Suppliers.createEnumSupplier(ProductReplaceDetailsType.class, type -> !selectedTypes.contains(type) && this.createWrapper((ProductReplaceDetailsType)type).isSupported(indexType) && allowedTypes.contains(type)));
        result.add((TableWidgetColumn<ProductReplaceDetail, ?>)col);
        col = new RendererWidgetColumn(rec$ -> ((ProductReplaceDetail)rec$).getValue(), (rec$, x$0) -> ((ProductReplaceDetail)rec$).setValue(x$0));
        col.setId("value");
        col.setCaption(Messages.New_value);
        col.setPrefWidthEm(Double.valueOf(20.0));
        result.add((TableWidgetColumn<ProductReplaceDetail, ?>)col);
        return result;
    }

    TypeWrapper createWrapper(ProductReplaceDetailsType type) {
        switch (type) {
            case AGENT: 
            case VENDOR_FOP_AGENT: 
            case SUBAGENCY_FOP_AGENT: 
            case CLIENT_FOP_AGENT: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.ENTITYBOX_PERSON;
                    }

                    @Override
                    void setListParametersSupplier(Node node, BookingFilesData bookingFilesData) {
                        StandardNodeRenderer.ENTITYBOX_PERSON.setListParametersSupplier(node, ControllerInterceptorsHelper::getActiveAgents);
                    }
                };
            }
            case BOOKING_AGENCY: 
            case AGENCY: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.ENTITYBOX_ORGANIZATION;
                    }

                    @Override
                    void setListParametersSupplier(Node node, BookingFilesData bookingFilesData) {
                        StandardNodeRenderer.ENTITYBOX_ORGANIZATION.setListParametersSupplier(node, ControllerInterceptorsHelper::getAgencies);
                    }
                };
            }
            case SUBAGENCY: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.ENTITYBOX_ORGANIZATION;
                    }

                    @Override
                    boolean isSupported(Class<?> indexClass) {
                        return Arrays.asList(ProductIndex.class, CommonProductIndex.class, MainHotelProductIndex.class, TransferIndex.class, CarRentalProductIndex.class, InsuranceAccidentIndex.class, RailwayProductIndex.class, AeroexpressTicketIndex.class, VisaProductIndex.class, InsuranceTouristicIndex.class, UniversalProductIndex.class).contains(indexClass);
                    }

                    @Override
                    void setListParametersSupplier(Node node, BookingFilesData bookingFilesData) {
                        StandardNodeRenderer.ENTITYBOX_ORGANIZATION.setListParametersSupplier(node, ControllerInterceptorsHelper::getAgencies);
                    }
                };
            }
            case VALIDATOR: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.ENTITYBOX_VALIDATOR;
                    }

                    @Override
                    boolean isSupported(Class<?> indexClass) {
                        return Arrays.asList(ProductIndex.class, RailwayProductIndex.class).contains(indexClass);
                    }

                    @Override
                    void setListParametersSupplier(Node node, BookingFilesData bookingFilesData) {
                        ValidatorEntityBoxWidget validatorEntityBoxWidget = (ValidatorEntityBoxWidget)node;
                        validatorEntityBoxWidget.setListParametersSupplier(() -> {
                            IndexListParameters result = new IndexListParameters();
                            result.setIndexType(ValidatorIndex.class);
                            result.getSearchCriterions().add(SearchCriterion.eq((String)ValidatorIndex.Property.disabled.name(), (Object)Boolean.FALSE));
                            TableColumnSettings colSettings = new TableColumnSettings();
                            colSettings.setId(ValidatorIndex.Property.number.name());
                            result.getColumns().add(colSettings);
                            colSettings = new TableColumnSettings();
                            colSettings.setId(ValidatorIndex.Property.agency.name());
                            result.getColumns().add(colSettings);
                            colSettings = new TableColumnSettings();
                            colSettings.setId(ValidatorIndex.Property.blankOwner.name());
                            result.getColumns().add(colSettings);
                            colSettings = new TableColumnSettings();
                            colSettings.setId(ValidatorIndex.Property.salesPoint.name());
                            result.getColumns().add(colSettings);
                            return result;
                        });
                        validatorEntityBoxWidget.setNestedReferenceBuilder(idx -> new NestedEntityReference(idx.getSource(), idx.getNavigationKey(), Validator.class, ((ValidatorIndex)idx).getNumber()));
                        validatorEntityBoxWidget.setNavigationCallback(pane -> {
                            if (!(pane.getEditor() instanceof SalesPointSpace)) {
                                return;
                            }
                            SalesPointSpace space = (SalesPointSpace)pane.getEditor();
                            space.expand(space.getValidatorsTile());
                        });
                        validatorEntityBoxWidget.valueProperty().addListener((f, old, val) -> validatorEntityBoxWidget.setValidatorCode(val.getCaption()));
                    }
                };
            }
            case BLANK_OWNER: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.ENTITYBOX_ORGANIZATION;
                    }

                    @Override
                    boolean isSupported(Class<?> indexClass) {
                        return Arrays.asList(ProductIndex.class, CommonProductIndex.class, RailwayProductIndex.class, MainHotelProductIndex.class, TransferIndex.class, CarRentalProductIndex.class, InsuranceAccidentIndex.class, InsuranceTouristicIndex.class, AeroexpressTicketIndex.class, VisaProductIndex.class, UniversalProductIndex.class).contains(indexClass);
                    }

                    @Override
                    void setListParametersSupplier(Node node, BookingFilesData bookingFilesData) {
                        StandardNodeRenderer.ENTITYBOX_ORGANIZATION.setListParametersSupplier(node, ControllerInterceptorsHelper::getBlankOwners);
                    }
                };
            }
            case BLANK_TYPE: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.ENUMBOX_BLANK_TYPE;
                    }

                    @Override
                    boolean isSupported(Class<?> indexClass) {
                        return Arrays.asList(ProductIndex.class, RailwayProductIndex.class, InsuranceTouristicIndex.class, InsuranceAccidentIndex.class, AeroexpressTicketIndex.class, MCOFeesIndex.class, UniversalProductIndex.class).contains(indexClass);
                    }
                };
            }
            case ISSUE_DATE: 
            case CLIENT_SHIPMENTS_DATE: 
            case SUBAGENT_SHIPMENTS_DATE: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.DATETIME;
                    }
                };
            }
            case TCH_ACCOMPAYING_DOCUMENT_TYPE: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.ENUMBOX_TCH_ACC_DOC;
                    }

                    @Override
                    boolean isSupported(Class<?> indexClass) {
                        return ProductIndex.class.equals(indexClass);
                    }
                };
            }
            case COMPLETED: 
            case CHECKED: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.BOOLEAN_COMPACT;
                    }
                };
            }
            case MCO_CATEGORY: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.ENUMBOX_MCO_CATEGORY;
                    }

                    @Override
                    boolean isSupported(Class<?> indexClass) {
                        return ProductIndex.class.equals(indexClass);
                    }
                };
            }
            case CLIENT: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.ENTITYBOX_ORGANIZATION;
                    }

                    @Override
                    void setListParametersSupplier(Node node, BookingFilesData bookingFilesData) {
                        StandardNodeRenderer.ENTITYBOX_ORGANIZATION.setListParametersSupplier(node, ControllerInterceptorsHelper::getClients);
                    }
                };
            }
            case PAYER: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.ENTITYBOX_ORGANIZATION;
                    }

                    @Override
                    void setListParametersSupplier(Node node, BookingFilesData bookingFilesData) {
                        StandardNodeRenderer.ENTITYBOX_ORGANIZATION.setListParametersSupplier(node, () -> ControllerInterceptorsHelper.getPayers(bookingFilesData.getPayerUids()));
                    }
                };
            }
            case BRANCH: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.ENTITYBOX_BRANCH;
                    }

                    @Override
                    boolean isSupported(Class<?> indexClass) {
                        return Arrays.asList(ProductIndex.class, MainHotelProductIndex.class, TransferIndex.class, InsuranceAccidentIndex.class, InsuranceTouristicIndex.class, RailwayProductIndex.class, AeroexpressTicketIndex.class, DeliveryIndex.class, MCOFeesIndex.class, UniversalProductIndex.class).contains(indexClass);
                    }

                    @Override
                    void setListParametersSupplier(Node node, BookingFilesData bookingFilesData) {
                        StandardNodeRenderer.ENTITYBOX_BRANCH.setListParametersSupplier(node, ControllerInterceptorsHelper::getActiveBranches);
                    }
                };
            }
            case SUPPLIER: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.ENTITYBOX_ORGANIZATION;
                    }

                    @Override
                    boolean isSupported(Class<?> indexClass) {
                        return Arrays.asList(ProductIndex.class, CommonProductIndex.class, MainHotelProductIndex.class, TransferIndex.class, CarRentalProductIndex.class, InsuranceAccidentIndex.class, RailwayProductIndex.class, AeroexpressTicketIndex.class, VisaProductIndex.class, InsuranceTouristicIndex.class, UniversalProductIndex.class).contains(indexClass);
                    }

                    @Override
                    void setListParametersSupplier(Node node, BookingFilesData bookingFilesData) {
                        StandardNodeRenderer.ENTITYBOX_ORGANIZATION.setListParametersSupplier(node, ControllerInterceptorsHelper::getSuppliers);
                    }
                };
            }
            case SUBSIDIZED_TARIFF: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.BOOLEAN;
                    }

                    @Override
                    boolean isSupported(Class<?> indexClass) {
                        return ProductIndex.class.equals(indexClass);
                    }
                };
            }
            case TARIFF_TYPE_AIR: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.ENUMBOX_TARIFF_TYPE;
                    }

                    @Override
                    boolean isSupported(Class<?> indexClass) {
                        return ProductIndex.class.equals(indexClass);
                    }
                };
            }
            case TARIFF_TYPE_HOTEL: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.ENUMBOX_HOTEL_TARIFF_TYPE;
                    }

                    @Override
                    boolean isSupported(Class<?> indexClass) {
                        return MainHotelProductIndex.class.equals(indexClass);
                    }
                };
            }
            case TICKET_TYPE: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.ENUMBOX_TICKET_TYPE;
                    }

                    @Override
                    boolean isSupported(Class<?> indexClass) {
                        return Arrays.asList(ProductIndex.class, CommonProductIndex.class, MainHotelProductIndex.class, TransferIndex.class, CarRentalProductIndex.class, InsuranceAccidentIndex.class, RailwayProductIndex.class, AeroexpressTicketIndex.class, VisaProductIndex.class, InsuranceTouristicIndex.class, UniversalProductIndex.class).contains(indexClass);
                    }
                };
            }
            case SALES_POINT: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.ENTITYBOX_SALES_POINT;
                    }

                    @Override
                    void setListParametersSupplier(Node node, BookingFilesData bookingFilesData) {
                        StandardNodeRenderer.ENTITYBOX_SALES_POINT.setListParametersSupplier(node, ControllerInterceptorsHelper::getSalesPoints);
                    }
                };
            }
            case VENDOR_FOP: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.ENUMBOX_PAYMENT_TYPE;
                    }

                    @Override
                    boolean isSupported(Class<?> indexClass) {
                        return Arrays.asList(ProductIndex.class, CommonProductIndex.class, MainHotelProductIndex.class, TransferIndex.class, CarRentalProductIndex.class, InsuranceAccidentIndex.class, RailwayProductIndex.class, AeroexpressTicketIndex.class, VisaProductIndex.class, InsuranceTouristicIndex.class, UniversalProductIndex.class).contains(indexClass);
                    }

                    @Override
                    void setListParametersSupplier(Node node, BookingFilesData bookingFilesData) {
                        StandardNodeRenderer.ENUMBOX_PAYMENT_TYPE.setItemSupplier(node, () -> Prefetched.getData().getAvailablePaymentTypes());
                    }
                };
            }
            case SUBAGENT_FOP: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.ENUMBOX_PAYMENT_TYPE;
                    }

                    @Override
                    boolean isSupported(Class<?> indexClass) {
                        return Arrays.asList(ProductIndex.class, CommonProductIndex.class, MainHotelProductIndex.class, TransferIndex.class, CarRentalProductIndex.class, InsuranceAccidentIndex.class, RailwayProductIndex.class, AeroexpressTicketIndex.class, VisaProductIndex.class, InsuranceTouristicIndex.class, UniversalProductIndex.class).contains(indexClass);
                    }

                    @Override
                    void setListParametersSupplier(Node node, BookingFilesData bookingFilesData) {
                        StandardNodeRenderer.ENUMBOX_PAYMENT_TYPE.setItemSupplier(node, () -> Prefetched.getData().getAvailablePaymentTypes());
                    }
                };
            }
            case CLIENT_FOP: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.ENUMBOX_PAYMENT_TYPE;
                    }

                    @Override
                    boolean isSupported(Class<?> indexClass) {
                        return Arrays.asList(ProductIndex.class, CommonProductIndex.class, MainHotelProductIndex.class, TransferIndex.class, CarRentalProductIndex.class, InsuranceAccidentIndex.class, RailwayProductIndex.class, AeroexpressTicketIndex.class, VisaProductIndex.class, InsuranceTouristicIndex.class, UniversalProductIndex.class).contains(indexClass);
                    }

                    @Override
                    void setListParametersSupplier(Node node, BookingFilesData bookingFilesData) {
                        StandardNodeRenderer.ENUMBOX_PAYMENT_TYPE.setItemSupplier(node, () -> Prefetched.getData().getAvailablePaymentTypes());
                    }
                };
            }
            case CLIENT_FEE_FOP: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.ENUMBOX_PAYMENT_TYPE;
                    }

                    @Override
                    boolean isSupported(Class<?> indexClass) {
                        return Arrays.asList(ProductIndex.class, CommonProductIndex.class, MainHotelProductIndex.class, TransferIndex.class, CarRentalProductIndex.class, InsuranceAccidentIndex.class, RailwayProductIndex.class, AeroexpressTicketIndex.class, VisaProductIndex.class, InsuranceTouristicIndex.class, UniversalProductIndex.class).contains(indexClass);
                    }

                    @Override
                    void setListParametersSupplier(Node node, BookingFilesData bookingFilesData) {
                        StandardNodeRenderer.ENUMBOX_PAYMENT_TYPE.setItemSupplier(node, () -> Prefetched.getData().getAvailablePaymentTypes());
                    }
                };
            }
            case COMMENTS: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.TEXTFIELD;
                    }
                };
            }
            case CLIENT_CONTRACT: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return StandardNodeRenderer.ENTITYBOX_CONTRACT;
                    }

                    @Override
                    void setListParametersSupplier(Node node, BookingFilesData bookingFilesData) {
                        EntityBoxWidget entityBoxWidget = (EntityBoxWidget)node;
                        entityBoxWidget.setListParametersSupplier(() -> {
                            IndexListParameters<Contract, ContractIndex> result = ControllerInterceptorsHelper.getContractsByType(ContractType.CLIENT);
                            if (bookingFilesData.getCustomer() != null) {
                                result.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), bookingFilesData.getCustomer()));
                            }
                            if (bookingFilesData.getSubagency() != null) {
                                result.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), bookingFilesData.getSubagency()));
                            }
                            return result;
                        });
                    }
                };
            }
            case HOTEL: {
                return new TypeWrapper(){

                    @Override
                    NodeRenderer getRenderer() {
                        return new NodeRenderer(){

                            public Node createNode(boolean readonly) {
                                return new HotelWidget(readonly);
                            }

                            public Object getValue(Node node) {
                                return node != null ? ((HotelWidget)node).getHotel() : null;
                            }

                            public void setValue(Node node, Object value) {
                                ((HotelWidget)node).setValue((String)value);
                            }

                            public void setReadonly(boolean readonly, Node node) {
                                ((HotelWidget)node).getViewState().setReadonly(readonly);
                            }
                        };
                    }

                    @Override
                    void setListParametersSupplier(Node node, BookingFilesData bookingFilesData) {
                        HotelWidget hotelWidget = (HotelWidget)node;
                        ProductReplaceDetailsListAction.this.installHotel(hotelWidget, bookingFilesData.getProvider());
                    }
                };
            }
        }
        throw Xeption.forDeveloper((String)("unsupported type: " + type), (Object[])new Object[0]);
    }

    private void installHotel(HotelWidget hotelWidget, HotelProvider provider) {
        ArrayList confs = new ArrayList(ClientRegistry.get().allOf(HotelSearchConfigurator.TYPE).values());
        Collections.reverse(confs);
        hotelWidget.setActionHandler((IconShape)StandardIconShapes.SEARCH_12x12, Messages.Hotel_search, node -> {
            SabreHotelSearchPane pane = new SabreHotelSearchPane(false);
            Iterator iterator = confs.iterator();
            if (iterator.hasNext()) {
                HotelSearchConfigurator configurator = (HotelSearchConfigurator)iterator.next();
                configurator.configure(pane, provider);
            }
            Dialog dialog = new Dialog();
            dialog.setTitle(Messages.Hotel_search).setBody((Node)pane).setExpandToParent(true).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Select, () -> {
                SabreHotelSearchResultItemVM vm = (SabreHotelSearchResultItemVM)pane.getSearchResultNode().getTableView().getSelectionModel().getSelectedItem();
                if (vm == null) {
                    return;
                }
                Hotel hotel = vm.getHotel();
                hotelWidget.setHotel(hotel);
                hotelWidget.setValue(hotel.getName());
            }, (BooleanExpression)Bindings.isNotNull((ObservableObjectValue)pane.getSearchResultNode().getTableView().getSelectionModel().selectedItemProperty())).show((Node)node);
        });
    }

    public static class HotelWidget
    extends TextFieldWidget {
        private Hotel hotel;

        public HotelWidget(boolean ro) {
            super(ro);
        }

        public Hotel getHotel() {
            return this.hotel;
        }

        public void setHotel(Hotel hotel) {
            this.hotel = hotel;
        }
    }

    private static class BookingFilesData {
        private final List<String> payerUids = new ArrayList<String>();
        public final Set<ProductReplaceDetailsType> availableTypes = new HashSet<ProductReplaceDetailsType>();
        private EntityReference<Organization> customer;
        private EntityReference<Organization> subagency;
        private HotelProvider provider;

        private BookingFilesData() {
        }

        public List<String> getPayerUids() {
            return this.payerUids;
        }

        public Set<ProductReplaceDetailsType> getAvailableTypes() {
            return this.availableTypes;
        }

        public EntityReference<Organization> getCustomer() {
            return this.customer;
        }

        public void setCustomer(EntityReference<Organization> customer) {
            this.customer = customer;
        }

        public EntityReference<Organization> getSubagency() {
            return this.subagency;
        }

        public void setSubagency(EntityReference<Organization> subagency) {
            this.subagency = subagency;
        }

        public HotelProvider getProvider() {
            return this.provider;
        }

        public void setProvider(HotelProvider provider) {
            this.provider = provider;
        }
    }

    private static class ProductReplaceDetail {
        private ProductReplaceDetailsType type;
        private Object value;

        private ProductReplaceDetail() {
        }

        public ProductReplaceDetailsType getType() {
            return this.type;
        }

        private void setType(ProductReplaceDetailsType type) {
            this.type = type;
        }

        private Object getValue() {
            return this.value;
        }

        private void setValue(Object param) {
            this.value = param;
        }
    }

    private static abstract class TypeWrapper {
        private TypeWrapper() {
        }

        abstract NodeRenderer getRenderer();

        boolean isSupported(Class<?> indexClass) {
            return true;
        }

        void setListParametersSupplier(Node node, BookingFilesData bookingFilesData) {
        }
    }
}

