/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.activity.ActivityManager;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.standard.entity.RootEntityActivityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.actions.RollbackVersionEntityActionConfigurator;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.assets.ActivityItem;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.service.AssetService;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.Control;

public class RollbackVersionEntityAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.RECOVER;
    }

    public String getId() {
        return "entity-rollback-version";
    }

    public double getWeight() {
        return 10.0;
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return RollbackVersionEntityActionConfigurator.all().stream().allMatch(p -> p.isEnabled(context.getEntityHandler().getEntityClass(), context.getData().getContainer()));
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return !context.isLastVersion();
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        EntityContainer ctr = context.getData().getContainer();
        Dialog.confirm(context, (String)(Messages.Restore_Version + (ctr.getVersionInfo().getVersionNumber() + 1) + " ?"), null, (String)Messages.Restore, () -> Notifications.get().submitTask(() -> this.doRestore(ctr), context.getMutex()), null);
    }

    private void doRestore(EntityContainer<?> versionCtr) {
        try {
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            EntityReference ref = versionCtr.toReference();
            SearchQuery query = new SearchQuery();
            String activityToken = RootEntityActivityHandler.buildToken(ref);
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ActivityItem.Property.lockToken.name(), (Object)activityToken));
            query.getPreferredProperties().add(ActivityItem.Property.owner.name());
            List lockedItems = ((AssetService)RpcServiceManager.get().getService(AssetService.class)).search(sic, ActivityItem.class, query).getData();
            ValueHolder dataChanged = new ValueHolder((Object)Boolean.FALSE);
            if (!lockedItems.isEmpty()) {
                String lockOwner = ((ActivityItem)lockedItems.get(0)).getOwner();
                if (!MiscUtil.equals((Object)sic.getUser(), (Object)lockOwner)) {
                    Notifications.get().showStaticNotification(Messages.Couldnt_restore_version_Blocked_by_user + lockOwner, null);
                    return;
                }
                FxUtil.waitForFxThread(() -> ActivityManager.get().find(activityToken, false, node -> {
                    RootEntityPane pane = (RootEntityPane)node;
                    dataChanged.set((Object)pane.isDataChanged());
                }));
            }
            if (((Boolean)dataChanged.get()).booleanValue()) {
                Notifications.get().showStaticNotification(L10n.replace((String)Messages.Couldnt_restore_version_Not_Saved_Changes, (Object[])new Object[]{ref.toString()}), null);
                return;
            }
            ArrayList messages = new ArrayList();
            if (!RollbackVersionEntityActionConfigurator.all().stream().allMatch(p -> p.isEnabled(versionCtr, messages::add))) {
                if (!messages.isEmpty()) {
                    Notifications.get().showStaticNotification(String.join((CharSequence)"\n", messages), null);
                }
                return;
            }
            VersionInfo newVersion = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).rollback(sic, ref, versionCtr.getVersionInfo());
            Notifications.get().showStaticNotification(L10n.replace((String)Messages.Restore_version_completed, (Object[])new Object[]{ref.toString(), versionCtr.getVersionInfo().getVersionNumber() + 1, newVersion.getVersionNumber() + 1}), null);
            EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(ref, EntityModification.ModificationType.CHANGE)));
            RootEntityEditingService editingService = RootEntityEditingService.get();
            if (editingService != null) {
                editingService.open(ref, true);
            }
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }
}

