/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBooking;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBookingHelper;
import com.gridnine.xtrip.common.model.helpers.ValidationUtil;
import com.gridnine.xtrip.common.model.rpc.ModelService;
import com.gridnine.xtrip.common.model.system.ArchivedEntity;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Collection;
import java.util.List;
import javafx.scene.control.Control;

public class UnArchivedBookingAction
implements RootEntityAction {
    public String getId() {
        return "entity-unarchive";
    }

    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.RECOVER;
    }

    public double getWeight() {
        return 0.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && ArchivedBooking.class.isAssignableFrom(context.getEntityHandler().getEntityClass());
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return true;
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        EntityReference ref = context.getData().getContainer().toReference();
        ArchivedEntity booking = ((ArchivedBooking)context.getData().getContainer().getEntity()).getBooking();
        EntityReference bookingRef = ArchivedBookingHelper.getLastVersion((ArchivedEntity)booking).toReference();
        Notifications.get().submitTask(() -> {
            List messages = ((ModelService)RpcServiceManager.get().getService(ModelService.class)).unArchiveBooking(ServiceInvocationContext.get(), ref);
            if (!ValidationUtil.hasErrors((Iterable)messages)) {
                RootEntityEditingService.navigateTo((EntityReference)bookingRef);
                EventBus.get().publishAsync((Event)new EntityModificationEvent(null, new EntityModification(ref, EntityModification.ModificationType.DELETE)));
            }
            Notifications.get().showMessages((Collection)messages);
        }, context.getMutex());
    }
}

