/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.delete;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.entity.actions.delete.DeleteEntityActionHandler;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.EntityDeleteTask;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import java.util.Collections;
import java.util.Optional;
import javafx.scene.control.Control;

public class DeleteEntityAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.DELETE;
    }

    public double getWeight() {
        return 30.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion();
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        if (context.getMode() != EditingMode.EDIT) {
            return false;
        }
        if (context.getData() == null || context.getData().getContainer() == null) {
            return false;
        }
        return this.isDeletable(context.getData().getContainer());
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        Dialog.confirm(context, (String)Messages.Confirm_the_deletion, (String)context.getData().getContainer().getEntity().toString(), (String)Messages.Delete, () -> {
            EntityReference reference = context.getData().getContainer().toReference();
            DeleteEntityActionHandler handler = DeleteEntityActionHandler.forEntityClass(reference.getType());
            if (handler != null) {
                try {
                    handler.delete(Collections.singleton(reference));
                }
                catch (Exception ex) {
                    ErrorHandler.handle((Throwable)ex);
                }
            } else {
                Notifications.get().enqueueAsyncTask((ClientTask)new EntityDeleteTask(reference));
            }
        }, null);
    }

    public String getId() {
        return "entity-delete";
    }

    public AclQuery getACLQuery(RootEntityPane<?, ?> context) {
        return Optional.ofNullable(context.getData()).map(item -> item.getContainer().toReference()).map(item -> AclQuery.AclQueryBuilder.get().entry(StandardRestrictionResourceOperations.DELETE.getId(), item.getType().getName(), item).build()).orElse(null);
    }

    private <E extends BaseEntity> boolean isDeletable(EntityContainer<E> container) {
        DeleteEntityActionHandler<E> handler = DeleteEntityActionHandler.forEntityClass(container.getEntityType());
        return handler == null || handler.isDeletable(container);
    }
}

