/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.delete;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class DeleteProductClientTask
extends ClientTask {
    private List<MiscUtil.Pair<EntityReference<BookingFile>, String>> pairList;

    DeleteProductClientTask(List<MiscUtil.Pair<EntityReference<BookingFile>, String>> pairList) {
        this.pairList = pairList;
    }

    protected String getTitle() {
        return Messages.DeleteProductListAction_deleting_product;
    }

    protected void execute() throws Exception {
        MiscUtil.Pair rpcResult = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).checkDeleteProductPermissions(ServiceInvocationContext.get(), this.pairList);
        this.pairList = (List)rpcResult.getFirst();
        this.addMessages((List)rpcResult.getSecond());
        HashSet setBf = new HashSet();
        this.pairList.forEach(pair -> setBf.add(pair.getFirst()));
        HashSet<EntityReference> changeBookingFileRef = new HashSet<EntityReference>();
        ValueHolder valueWaitActionUser = new ValueHolder();
        for (EntityReference bf : setBf) {
            EntityContainer containerBF = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), bf);
            if (containerBF == null) {
                Iterator<MiscUtil.Pair<EntityReference<BookingFile>, String>> itr = this.pairList.iterator();
                while (itr.hasNext()) {
                    MiscUtil.Pair<EntityReference<BookingFile>, String> pair2 = itr.next();
                    if (!((EntityReference)pair2.getFirst()).equals((Object)bf)) continue;
                    itr.remove();
                    Message msg = MessagesHelper.createMessageWithDetails((MessageType)MessageType.ERROR, (String)Messages.DeleteProductListAction_unable_to_load_bf, (String)Messages.DeleteProductListAction_products_from_bf_not_deleted, (Object[])new Object[]{bf});
                    this.addMessages(new Message[]{msg});
                }
                continue;
            }
            ArrayList<BaseProduct> productsToDelete = new ArrayList<BaseProduct>();
            for (Reservation res : ((BookingFile)containerBF.getEntity()).getReservations()) {
                for (BaseProduct product : res.getProducts()) {
                    for (MiscUtil.Pair<EntityReference<BookingFile>, String> pair3 : this.pairList) {
                        ProductFXHandler<BaseProduct, ?, ?, ?> productFXHandler;
                        if (!((String)pair3.getSecond()).equals(product.getUid()) || (productFXHandler = ProductFXHandler.forProduct(product)) == null) continue;
                        if (productFXHandler.getNextProduct(product) != null && this.pairList.stream().noneMatch(it -> ((String)it.getSecond()).equals(productFXHandler.getNextProduct(product).getUid()))) {
                            Message msg = MessagesHelper.createMessageWithDetails((MessageType)MessageType.ERROR, (String)Messages.DeleteProductListAction_product_not_deleted, (String)Messages.DeleteProductListAction_product_has_sales_chain, (Object[])new Object[]{BookingHelper.generateShortProductName((BaseProduct)product)});
                            this.addMessages(new Message[]{msg});
                            continue;
                        }
                        List<BaseProduct> chainProductsToDelete = this.getProductsToDelete(product, productFXHandler, (EntityContainer<BookingFile>)containerBF);
                        if (chainProductsToDelete.size() > 1) {
                            valueWaitActionUser.set((Object)Boolean.TRUE);
                            FxUtil.waitForFxThread(() -> Dialog.confirm((Node)Dialog.getGlobalWindow(), (String)String.format(Messages.DeleteProductListAction_confirm_delete_products, BookingHelper.generateShortProductName((BaseProduct)product), chainProductsToDelete.size() - 1), (String)"", (String)Messages.DeleteProductListAction_delete, () -> valueWaitActionUser.set(null), () -> valueWaitActionUser.set((Object)Boolean.FALSE)));
                        }
                        while (valueWaitActionUser.get() != null && ((Boolean)valueWaitActionUser.get()).equals(Boolean.TRUE)) {
                            Thread.sleep(100L);
                        }
                        if (valueWaitActionUser.get() != null && ((Boolean)valueWaitActionUser.get()).equals(Boolean.FALSE)) {
                            Message msg = MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.DeleteProductListAction_product_not_deleted, (Object[])new Object[]{BookingHelper.generateShortProductName((BaseProduct)product)});
                            this.addMessages(new Message[]{msg});
                            continue;
                        }
                        productsToDelete.addAll(chainProductsToDelete);
                    }
                }
            }
            Collections.reverse(productsToDelete);
            this.removeProduct((EntityContainer<BookingFile>)containerBF, productsToDelete);
            containerBF.getVersionInfo().setDataSource("fx-delete-product");
            ((EntityService)RpcServiceManager.get().getService(EntityService.class)).save(ServiceInvocationContext.get(), containerBF, null, true);
            changeBookingFileRef.add(containerBF.toReference());
        }
        FxUtil.waitForFxThread(() -> EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)changeBookingFileRef.stream().map(ref -> new EntityModification(ref, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList()))));
    }

    private void removeProduct(EntityContainer<BookingFile> containerBF, List<BaseProduct> productsToDelete) {
        productsToDelete.forEach(baseProduct -> baseProduct.getReservation().getProducts().remove(baseProduct));
        productsToDelete.forEach(baseProduct -> {
            ProductFXHandler<BaseProduct, ?, ?, ?> productFXHandler = ProductFXHandler.forProduct(baseProduct);
            productFXHandler.remove((BaseProduct)baseProduct);
            Message msg = MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.DeleteProductListAction_product_was_deleted, (Object[])new Object[]{BookingHelper.generateShortProductName((BaseProduct)baseProduct)});
            this.addMessages(new Message[]{msg});
            this.removeProductFromOtherProductsRelations((BookingFile)containerBF.getEntity(), (BaseProduct)baseProduct);
        });
        ((BookingFile)containerBF.getEntity()).getReservations().stream().filter(reservation -> reservation.getProducts().isEmpty()).collect(Collectors.toList()).forEach(emptyReservation -> ((BookingFile)containerBF.getEntity()).getReservations().remove(emptyReservation));
    }

    private void removeProductFromOtherProductsRelations(BookingFile bookingFile, BaseProduct baseProduct) {
        bookingFile.getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).forEach(product -> {
            ProductFXHandler<BaseProduct, ?, ?, ?> productFXHandler = ProductFXHandler.forProduct(product);
            if (productFXHandler != null) {
                productFXHandler.getRelatedProducts((BaseProduct)product).remove(baseProduct);
            }
        });
    }

    private List<BaseProduct> getProductsToDelete(BaseProduct baseProduct, ProductFXHandler<BaseProduct, ?, ?, ?> productFXHandler, EntityContainer<BookingFile> ctr) {
        ArrayList<BaseProduct> result = new ArrayList<BaseProduct>();
        result.add(baseProduct);
        result.add(this.getPreviousProductToDelete(baseProduct, productFXHandler));
        result.addAll(this.getRelatedProductsToDelete(baseProduct, (BookingFile)ctr.getEntity()));
        return result.stream().filter(product -> !Objects.isNull(product)).collect(Collectors.toList());
    }

    private BaseProduct getPreviousProductToDelete(BaseProduct baseProduct, ProductFXHandler<BaseProduct, ?, ?, ?> productFXHandler) {
        BaseProduct previousProduct = productFXHandler.getPreviousProduct(baseProduct);
        return previousProduct != null && ProductStatus.EXCHANGE.equals((Object)productFXHandler.getProductStatus(previousProduct)) ? previousProduct : null;
    }

    private List<BaseProduct> getRelatedProductsToDelete(BaseProduct baseProduct, BookingFile bookingFile) {
        return bookingFile.getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).filter(potentialMCOProduct -> {
            ProductFXHandler<BaseProduct, ?, ?, ?> productFXHandler = ProductFXHandler.forProduct(potentialMCOProduct);
            List<BaseProduct> relatedProducts = productFXHandler.getRelatedProducts((BaseProduct)potentialMCOProduct);
            return productFXHandler.isEMDOrExcessBagage((BaseProduct)potentialMCOProduct) && relatedProducts.contains(baseProduct) && relatedProducts.size() == 1;
        }).collect(Collectors.toList());
    }
}

