/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.exporthelpers;

import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.acl.AclAsset;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.assets.Workspace;
import com.gridnine.xtrip.common.model.handlers.EntitiesGroupHandler;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.profile.Agency;
import com.gridnine.xtrip.common.model.profile.Agent;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.Vendor;
import com.gridnine.xtrip.common.model.system.exchange.EntityQueryData;
import com.gridnine.xtrip.common.model.system.exchange.ExportType;
import com.gridnine.xtrip.common.model.system.exchange.ItemExportSettings;
import com.gridnine.xtrip.common.model.system.exchange.ItemType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.security.acl.entry.AclEntry;
import com.gridnine.xtrip.common.security.acl.principal.AclGroup;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.security.acl.registry.AclRegistryAsset;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class ExportImportHelper {
    private static final String dictsGroupId = "dicts";
    private static final String rootGroupId = "root";
    private static final String assetsGroupId = "assets";
    private static final String bookingsGroupId = "bookings";
    private static final String profilesGroupId = "profiles";
    private static final Set<String> ASSET_IDS = new HashSet<String>(Arrays.asList(AclEntry.class.getName(), AclAsset.class.getName(), AclRegistryAsset.class.getName(), UserAccount.class.getName(), AclGroup.class.getName(), AclUser.class.getName(), Workspace.class.getName()));

    public static String toString(String objectId) {
        if (rootGroupId.equals(objectId)) {
            return Messages.Objects;
        }
        if (dictsGroupId.equals(objectId)) {
            return Messages.Directories;
        }
        if (assetsGroupId.equals(objectId)) {
            return Messages.Auxiliary_objects;
        }
        if (bookingsGroupId.equals(objectId)) {
            return Messages.Reservation;
        }
        if (profilesGroupId.equals(objectId)) {
            return Messages.Profiles;
        }
        DictionaryType dictType = (DictionaryType)MetaRegistry.get().getDictionaries().get(objectId);
        if (dictType != null) {
            return dictType.getDisplayName();
        }
        EntityType ettType = (EntityType)MetaRegistry.get().getEntities().get(objectId);
        if (ettType != null) {
            return ettType.getDisplayName();
        }
        if (ASSET_IDS.contains(objectId)) {
            return objectId.substring(objectId.lastIndexOf(".") + 1);
        }
        EntitiesGroupHandler.GroupInfo group = ExportImportHelper.findGroup(objectId);
        if (group != null) {
            return group.getTitle().toString();
        }
        return null;
    }

    private static EntitiesGroupHandler.GroupInfo findGroup(String objectId) {
        for (EntitiesGroupHandler handler : HandlersRegistry.get().getAllEntitiesGroupHandlers()) {
            EntitiesGroupHandler.GroupInfo group;
            if (!handler.accept(objectId) || (group = handler.getGroup(objectId)) == null) continue;
            return group;
        }
        return null;
    }

    private static boolean isSkippAll(ItemExportSettings settings) {
        if (settings.getExportType() == ExportType.NONE) {
            return true;
        }
        if (settings.getExportType() == ExportType.INHERITED && settings.getParent() != null) {
            return ExportImportHelper.isSkippAll(settings.getParent());
        }
        return false;
    }

    public static ItemExportSettings createModelExport() {
        return ExportImportHelper.createModelExport(null);
    }

    public static ItemExportSettings createModelExport(Predicate<String> objectFilter) {
        ItemExportSettings root = new ItemExportSettings();
        root.setGroup(true);
        root.setObjectId(rootGroupId);
        root.setExportType(ExportType.NONE);
        HashMap<Object, ItemExportSettings> entitiesMaps = new HashMap<Object, ItemExportSettings>();
        for (EntityType entityType : MetaRegistry.get().getEntities().values()) {
            if (!MetaRegistryHelper.isRoot((EntityType)entityType) || entityType.isAbstract() || entityType.isHidden() || entityType.isDeprecated() && !ExportImportHelper.getDeprecated().contains(entityType.getId())) continue;
            String type = entityType.getId();
            if (objectFilter != null && !objectFilter.test(type)) continue;
            EntitiesGroupHandler.GroupInfo group = ExportImportHelper.findGroup(type);
            if (group != null && !entitiesMaps.containsKey(group.getId())) {
                ItemExportSettings itemExportSettings = new ItemExportSettings();
                itemExportSettings.setGroup(true);
                itemExportSettings.setObjectId(group.getId());
                itemExportSettings.setExportType(ExportType.INHERITED);
                entitiesMaps.put(group.getId(), itemExportSettings);
            }
            ItemExportSettings itemExportSettings = new ItemExportSettings();
            itemExportSettings.setObjectId(type);
            itemExportSettings.setItemType(ItemType.ENTITY);
            itemExportSettings.setExportType(ExportType.INHERITED);
            ExportImportHelper.switchToNewClasses(itemExportSettings, entityType);
            if (group != null) {
                ((ItemExportSettings)entitiesMaps.get(group.getId())).getChildren().add(itemExportSettings);
                continue;
            }
            entitiesMaps.put(type, itemExportSettings);
        }
        Comparator<ItemExportSettings> comparator = new Comparator<ItemExportSettings>(){

            @Override
            public int compare(ItemExportSettings o1, ItemExportSettings o2) {
                return TextUtil.compare((String)ExportImportHelper.toString(o1.getObjectId()), (String)ExportImportHelper.toString(o2.getObjectId()), (boolean)false, (boolean)false);
            }
        };
        ArrayList entities = new ArrayList(entitiesMaps.values());
        Collections.sort(entities, comparator);
        for (Object settings : entities) {
            root.getChildren().add(settings);
            Collections.sort(settings.getChildren(), comparator);
        }
        ArrayList<ItemExportSettings> dictionaries = new ArrayList<ItemExportSettings>(MetaRegistry.get().getDictionaries().size());
        for (Map.Entry entry : MetaRegistry.get().getDictionaries().entrySet()) {
            if (((DictionaryType)entry.getValue()).isInternal() || objectFilter != null && !objectFilter.test((String)entry.getKey())) continue;
            ItemExportSettings settings = new ItemExportSettings();
            settings.setObjectId((String)entry.getKey());
            settings.setExportType(ExportType.INHERITED);
            settings.setItemType(ItemType.DICTIONARY);
            dictionaries.add(settings);
        }
        if (!dictionaries.isEmpty()) {
            Collections.sort(dictionaries, comparator);
            ItemExportSettings dicts = new ItemExportSettings();
            dicts.setGroup(true);
            dicts.setObjectId(dictsGroupId);
            dicts.setExportType(ExportType.INHERITED);
            dicts.getChildren().addAll(dictionaries);
            dicts.setParent(root);
            root.getChildren().add(dicts);
        }
        ArrayList<ItemExportSettings> assets = new ArrayList<ItemExportSettings>(ASSET_IDS.size());
        for (String type : ASSET_IDS) {
            if (objectFilter != null && !objectFilter.test(type)) continue;
            ItemExportSettings settings = new ItemExportSettings();
            settings.setObjectId(type);
            settings.setExportType(ExportType.INHERITED);
            settings.setItemType(ItemType.ASSET);
            assets.add(settings);
        }
        if (!assets.isEmpty()) {
            Collections.sort(assets, comparator);
            ItemExportSettings itemExportSettings = new ItemExportSettings();
            itemExportSettings.setGroup(true);
            itemExportSettings.setObjectId(assetsGroupId);
            itemExportSettings.setExportType(ExportType.INHERITED);
            itemExportSettings.getChildren().addAll(assets);
            itemExportSettings.setParent(root);
            root.getChildren().add(itemExportSettings);
        }
        return root;
    }

    static Set<String> getDeprecated() {
        HashSet<String> result = new HashSet<String>();
        result.add(Agency.class.getName());
        result.add(Agent.class.getName());
        result.add(Vendor.class.getName());
        return result;
    }

    private static void switchToNewClasses(ItemExportSettings item, EntityType entityType) {
        if (entityType.getId().equals(Agent.class.getName())) {
            item.setExportType(ExportType.QUERY);
            EntityQueryData queryData = new EntityQueryData();
            queryData.setIndexClassName(PersonIndex.class.getName());
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)PersonIndex.Property.types.name(), (Object)PersonType.AGENT));
            queryData.setQuery(query);
            item.setQueryData(queryData);
        } else if (entityType.getId().equals(Agency.class.getName())) {
            item.setExportType(ExportType.QUERY);
            EntityQueryData queryData = new EntityQueryData();
            queryData.setIndexClassName(OrganizationIndex.class.getName());
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.AGENCY));
            queryData.setQuery(query);
            item.setQueryData(queryData);
        } else if (entityType.getId().equals(Vendor.class.getName())) {
            item.setExportType(ExportType.QUERY);
            EntityQueryData queryData = new EntityQueryData();
            queryData.setIndexClassName(OrganizationIndex.class.getName());
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.contains((String)OrganizationIndex.Property.types.name(), (Object)OrganizationType.BLANK_OWNER));
            queryData.setQuery(query);
            item.setQueryData(queryData);
        }
    }
}

