/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.financelist;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.entity.actions.financelist.ListFinanceDocumentsActionFromList;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.FinanceDocumentsParametersPane;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.FinanceDocumentsService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.finance.document.FinanceDocumentsCreateTaskParameters;
import com.gridnine.xtrip.common.model.finance.document.FinanceDocumentsCreateTaskResult;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javafx.beans.binding.BooleanExpression;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class FinanceDocumentsCreateListAction
implements ListFinanceDocumentsActionFromList {
    @Override
    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    @Override
    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        List products = context.getSelectedItems().stream().map(item -> new NestedEntityReference(item.getSource(), item.getNavigationKey(), BaseProduct.class, null)).distinct().collect(Collectors.toList());
        Notifications.get().submitTask(() -> {
            List invalidProductNames = ((FinanceDocumentsService)RpcServiceManager.get().getService(FinanceDocumentsService.class)).getInvalidFinanceDocumentProducts(ServiceInvocationContext.get(), (Collection)products);
            FxUtil.submitToFxThread(() -> {
                if (CollectionUtil.isNotEmpty((Collection)invalidProductNames)) {
                    TextAreaWidget widget = new TextAreaWidget(true);
                    widget.setValue(Messages.financeDocumentsCreateValidationConfirm + "\n\n" + TextUtil.join((String)"\n", (Iterable)invalidProductNames));
                    widget.setWrapText(true);
                    widget.getViewState().setNotEditable(true);
                    new Dialog().setTitle(com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Accepting_required).setBody((Node)widget).addButton(DialogButtonStyle.DECLINE, com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Cancel).addButton(DialogButtonStyle.ACCEPT_REGULAR, () -> this.doAction(source, context, products)).show((Node)source);
                } else {
                    this.doAction(source, context, products);
                }
            });
        }, context.getMutex());
    }

    @Override
    public String getName() {
        return Messages.Finance_documents_create;
    }

    private void doAction(Control source, IndexListPane<?, ?> context, List<NestedEntityReference<BookingFile, BaseProduct>> products) {
        Notifications.get().submitTask(() -> {
            Date date = new Date();
            Map datas = ((FinanceDocumentsService)RpcServiceManager.get().getService(FinanceDocumentsService.class)).getFinanceDocumentProductDatas(ServiceInvocationContext.get(), (Collection)products, Prefetched.getData().getCurrentAgentData().getSubagency(), date);
            final FinanceDocumentsParametersPane.FinanceDocumentsParameters parameters = new FinanceDocumentsParametersPane.FinanceDocumentsParameters();
            parameters.setDate(date);
            EntityReference agent = Prefetched.getData().getCurrentAgentData().getAgent();
            EntityContainer agentCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), agent);
            if (agentCtr != null) {
                List organizations = ((Person)agentCtr.getEntity()).getEmployments().stream().map(PersonEmployment::getOrganization).collect(Collectors.toList());
                datas.entrySet().removeIf(entry -> ((Set)entry.getValue()).stream().noneMatch(item -> organizations.contains(item.getAgency()) || organizations.contains(item.getSubagency())));
                if (!datas.isEmpty()) {
                    parameters.getAllowedContractTypes().add(ContractType.CLIENT);
                    if (datas.values().stream().allMatch(value -> value.stream().filter(item -> ContractType.SUBAGENCY.equals((Object)item.getContractType())).allMatch(item -> organizations.contains(item.getAgency())))) {
                        parameters.getAllowedContractTypes().add(ContractType.SUBAGENCY);
                        parameters.setContractType(ContractType.SUBAGENCY);
                    }
                }
            }
            parameters.getProducts().clear();
            parameters.getProducts().putAll(datas.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> ((Set)item.getValue()).stream().map(data -> new MiscUtil.Pair(data, (Object)products.stream().anyMatch(p -> p.getNestedEntityUid().equals(((NestedEntityReference)item.getKey()).getNestedEntityUid()) && p.getUid().equals(((NestedEntityReference)item.getKey()).getUid())))).collect(Collectors.toSet()), (o1, o2) -> o1, () -> new TreeMap(MiscUtil.comparator(item -> ((FinanceDocumentsHelper.FinanceDocumentProductData)((Set)datas.get(item)).stream().findFirst().get()).getProduct(), (Comparator)FinanceDocumentsHelper.productComparator)))));
            FxUtil.waitForFxThread(() -> {
                FinanceDocumentsParametersPane pane = new FinanceDocumentsParametersPane();
                pane.readData(parameters);
                new Dialog().setTitle(Messages.financeDocumentsCreate).setBody((Node)pane).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Create, () -> {
                    pane.writeData(parameters);
                    Notifications.get().enqueueAsyncTask(new ServerTaskHandler(){

                        protected String getTitle() {
                            return Messages.financeDocumentsCreateProcess;
                        }

                        protected String getTaskClassName() {
                            return "com.gridnine.xtrip.server.fx.async.entityactions.FinanceDocumentCreateAsyncTask";
                        }

                        protected Serializable getTaskParameters() {
                            FinanceDocumentsCreateTaskParameters taskParameters = new FinanceDocumentsCreateTaskParameters();
                            taskParameters.setDate(parameters.getDate());
                            taskParameters.setUseDelegate(parameters.getUseDelegate());
                            taskParameters.setUseFacsimile(parameters.getUseFacsimile());
                            taskParameters.setContractType(parameters.getContractType());
                            taskParameters.getProducts().clear();
                            taskParameters.getProducts().addAll(parameters.getProducts().entrySet().stream().filter(item -> item.getValue() != null && ((Set)item.getValue()).stream().anyMatch(MiscUtil.Pair::getSecond)).map(Map.Entry::getKey).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
                            return taskParameters;
                        }

                        protected void onCompleted(Object onject, List<Message> messages) {
                            FinanceDocumentsCreateTaskResult result = (FinanceDocumentsCreateTaskResult)onject;
                            if (result.getChangeData() != null) {
                                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)result.getChangeData().getChanged().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
                                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)result.getChangeData().getDeleted().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.DELETE)).collect(Collectors.toList())));
                            }
                            for (int i = 0; i < result.getDocuments().size(); ++i) {
                                RootEntityEditingService.get().open((EntityReference)result.getDocuments().get(i), false, null, i != 0);
                            }
                        }
                    });
                }, (BooleanExpression)pane.validProperty()).setExpandToParent(true).show((Node)source);
            });
        }, context.getMutex());
    }
}

