/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.fiscal;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.BooleanValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileFiscalCancelTableVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileFiscalSelectFopsCancelContainer;
import com.gridnine.xtrip.client.fx.standard.entity.actions.fiscal.AbstractBookingFileFiscalSelectFopsDialog;
import com.gridnine.xtrip.client.fx.standard.entity.actions.fiscal.BookingFileFiscalCancelPreviewDialog;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.fiscal.IBusFiscalReceiptContextKeys;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;

public class BookingFileFiscalCancelSelectFopsDialog
extends AbstractBookingFileFiscalSelectFopsDialog {
    BookingFileFiscalCancelSelectFopsDialog(Control source) {
        super(source);
    }

    @Override
    protected void showSelectFopsDialog(Map<BaseProduct, List<GeneralProductFop>> productToFops, List<NestedEntityReference<BookingFile, BaseProduct>> productsReferences, List<String> selectedProductUids) throws Exception {
        ArrayList<BookingFileFiscalCancelTableVM> modelVM = new ArrayList<BookingFileFiscalCancelTableVM>();
        for (Map.Entry<BaseProduct, List<GeneralProductFop>> entry : productToFops.entrySet()) {
            BaseProduct product = entry.getKey();
            for (GeneralProductFop fop : entry.getValue()) {
                BookingFileFiscalCancelTableVM productVM = new BookingFileFiscalCancelTableVM();
                productVM.setNumberBookingFile(TextUtil.buildFullNumber((CompositeNumber)product.getReservation().getBookingFile()));
                productVM.setNameProduct(BookingHelper.generateShortProductName((BaseProduct)product));
                productVM.setServiceFOP(!GeneralProductHelper.isPaymentFop((GeneralProductFop)fop));
                productVM.setPaymentType(fop.getType());
                productVM.setAmount(fop.getEquivalentAmount());
                productVM.setAmountToPay(fop.getEquivalentAmount());
                productVM.setIsCancel(selectedProductUids.contains(product.getUid()));
                productVM.setProductFop(fop);
                productVM.setProduct(product);
                modelVM.add(productVM);
            }
        }
        FxUtil.waitForFxThread(() -> {
            final BookingFileFiscalSelectFopsCancelContainer body = this.createBody();
            TableWidgetController<TableWidget<BookingFileFiscalCancelTableVM>, BookingFileFiscalCancelTableVM> controller = new TableWidgetController<TableWidget<BookingFileFiscalCancelTableVM>, BookingFileFiscalCancelTableVM>(){

                public TableWidget<BookingFileFiscalCancelTableVM> getView() {
                    return (TableWidget)body.getContent();
                }
            };
            controller.readData(modelVM);
            VBox vBody = new VBox(new Node[]{body});
            Dialog dialog = new Dialog();
            dialog.setTitle(Messages.Fiscal_to_cancel).setAutoClose(false).setBody((Node)vBody).setOnCloseRequest(() -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.Fiscal_Cancel, () -> this.lambda$null$4(dialog, vBody, (TableWidgetController)controller, modelVM, productsReferences)).show((Node)this.source);
        });
    }

    @Override
    protected List<GeneralProductFop> filterProductFops(List<GeneralProductFop> source, ProductStatus status) {
        Map availablePaymentTypes = Prefetched.getData().getFiscalSettings().getAvailablePaymentTypes();
        return source.stream().filter(fop -> (fop.getType() == PaymentType.CASH || fop.getType() == PaymentType.CREDIT_CARD_AGENCY || fop.getType() == PaymentType.CREDIT_CARD || fop.getType() == PaymentType.CREDIT_CARD_TCH || fop.getType() == PaymentType.TICKET || availablePaymentTypes.containsKey(fop.getType())) && status != ProductStatus.VOID || fop.getOperationDate() != null && !MiscUtil.isZero((BigDecimal)fop.getEquivalentAmount(), (boolean)true)).sorted(Comparator.comparing(GeneralProductHelper::isPaymentFop).reversed()).collect(Collectors.toList());
    }

    private Map<NestedEntityReference<BookingFile, BaseProduct>, List<NestedEntityReference<BookingFile, Fop>>> mapToProductToCancelReference(Collection<BookingFileFiscalCancelTableVM> modelVM, List<NestedEntityReference<BookingFile, BaseProduct>> productsReferences) {
        HashMap<NestedEntityReference<BookingFile, BaseProduct>, List<NestedEntityReference<BookingFile, Fop>>> result = new HashMap<NestedEntityReference<BookingFile, BaseProduct>, List<NestedEntityReference<BookingFile, Fop>>>();
        modelVM.stream().filter(BookingFileFiscalCancelTableVM::isIsCancel).forEach(vm -> {
            NestedEntityReference reference = productsReferences.stream().filter(ref -> MiscUtil.equals((Object)ref.getNestedEntityUid(), (Object)vm.getProduct().getUid())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"Missing product reference!", (Object[])new Object[0]));
            result.computeIfAbsent(reference, ref -> new ArrayList()).add(new NestedEntityReference((EntityReference)reference, vm.getProductFop().getUid(), Fop.class, null));
        });
        return result;
    }

    private List<Node> validateDialog(Collection<BookingFileFiscalCancelTableVM> modelVM) {
        ArrayList<Node> result = new ArrayList<Node>();
        List<BookingFileFiscalCancelTableVM> selectedPositions = modelVM.stream().filter(BookingFileFiscalCancelTableVM::isIsCancel).collect(Collectors.toList());
        if (selectedPositions.isEmpty()) {
            result.add((Node)MessagePane.error((String)Messages.Fiscal_no_product_selected));
        } else {
            selectedPositions.forEach(vm -> {
                if (MiscUtil.compare((Comparable)vm.getAmount(), (Comparable)vm.getAmountToPay()) < 0) {
                    result.add((Node)MessagePane.error((String)L10nResourcesManager.replace((String)Messages.Fiscal_payment_amount_does_not_match, (Object[])new Object[]{vm.getNameProduct()})));
                }
            });
        }
        return result;
    }

    private BookingFileFiscalSelectFopsCancelContainer createBody() {
        BookingFileFiscalSelectFopsCancelContainer body = new BookingFileFiscalSelectFopsCancelContainer(false);
        ((TableWidget)body.getContent()).getColumn("numberBookingFile").setNotEditable(Boolean.valueOf(true));
        ((TableWidget)body.getContent()).getColumn("nameProduct").setNotEditable(Boolean.valueOf(true));
        ((TableWidget)body.getContent()).getColumn("serviceFOP").setNotEditable(Boolean.valueOf(true));
        ((TableWidget)body.getContent()).getColumn("amount").setNotEditable(Boolean.valueOf(true));
        ((TableWidget)body.getContent()).getColumn("paymentType").setNotEditable(Boolean.valueOf(true));
        ((TableWidget)body.getContent()).getColumn("amountToPay").setNotEditable(Boolean.valueOf(true));
        ((TableWidget)body.getContent()).setControlButtonsAvailability(ControlsPane.NONE);
        ((ComboBoxWidgetColumn)((TableWidget)body.getContent()).getColumn("paymentType")).setItemsSupplier(() -> Arrays.asList(PaymentType.CASH, PaymentType.CREDIT_CARD_AGENCY));
        ((BooleanValueWidgetColumn)((TableWidget)body.getContent()).getColumn("serviceFOP")).setConverter((StringConverter)new StringConverter<Boolean>(){

            public String toString(Boolean serviceFOP) {
                if (serviceFOP == null) {
                    serviceFOP = Boolean.FALSE;
                }
                return serviceFOP != false ? Messages.Fiscal_service_FOP : Messages.Fiscal_product_FOP;
            }

            public Boolean fromString(String string) {
                return null;
            }
        });
        return body;
    }

    private /* synthetic */ void lambda$null$4(Dialog dialog, VBox vBody, TableWidgetController controller, Collection modelVM, List productsReferences) {
        dialog.close();
        vBody.getChildren().removeAll((Collection)vBody.getChildren().stream().filter(node -> node.getClass() == MessagePane.class).collect(Collectors.toList()));
        controller.writeData(modelVM);
        List<Node> listMessage = this.validateDialog(modelVM);
        if (!listMessage.isEmpty()) {
            listMessage.forEach(error -> vBody.getChildren().add(0, error));
            return;
        }
        Map<NestedEntityReference<BookingFile, BaseProduct>, List<NestedEntityReference<BookingFile, Fop>>> mapProductsToCancelReference = this.mapToProductToCancelReference(modelVM, productsReferences);
        Notifications.get().submitTask(() -> {
            HashMap<String, Object> ctx = new HashMap<String, Object>();
            ctx.put(IBusFiscalReceiptContextKeys.PRODUCTS_TO_PAY_REFERENCE.name(), mapProductsToCancelReference);
            ctx.put(IBusFiscalReceiptContextKeys.RECEIPT_SERVICE_TYPE.name(), this.getReceiptServiceType());
            ctx.put(IBusFiscalReceiptContextKeys.MESSAGE.name(), new ArrayList());
            HashSet<String> outKeys = new HashSet<String>(Arrays.asList(IBusFiscalReceiptContextKeys.RECEIPT_CONTAINERS.name(), IBusFiscalReceiptContextKeys.PREVIOUS_RECEIPTS.name(), IBusFiscalReceiptContextKeys.IS_CANCELLATION.name()));
            Map data = ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), "receipt:fiscal:create-cancel-fiscal-receipt", ctx, outKeys);
            List receiptContainers = (List)data.get(IBusFiscalReceiptContextKeys.RECEIPT_CONTAINERS.name());
            Map previousReceipts = (Map)data.get(IBusFiscalReceiptContextKeys.PREVIOUS_RECEIPTS.name());
            for (EntityContainer receiptContainer : receiptContainers) {
                EntityContainer previousReceipt = (EntityContainer)previousReceipts.get(receiptContainer.toReference());
                if (previousReceipt != null) continue;
                Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439 \u0447\u0435\u043a \u0434\u043b\u044f \u043e\u0442\u043c\u0435\u043d\u044b", (Object[])new Object[0])});
                return;
            }
            FxUtil.waitForFxThread(() -> {
                BookingFileFiscalCancelPreviewDialog previewDialog = new BookingFileFiscalCancelPreviewDialog(this.source);
                previewDialog.showDialog(data);
                dialog.close();
            });
        }, Messages.Notifications_saving_data);
    }
}

