/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.productcopy;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RadioBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiEntityWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.settings.gdsnames.GdsSettingsHelper;
import com.gridnine.xtrip.client.fx.standard.tasks.CopyMode;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CopyTaskPersistentParameters;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.FormattedNumberUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javax.naming.OperationNotSupportedException;
import org.xml.sax.InputSource;

public class CopyTask
extends ClientTask {
    private final CopyMode mode;
    private final BaseProduct srcProduct;
    private final String ticketNum;
    private final int ticketsAmount;
    private final GdsName gdsName;
    private final RecordLocatorType recordLocatorType;
    private final String reservationNum;
    private final EntityReference<BookingFile> srcBookingFileEntityReference;
    private final boolean forwardAgencyMemo;
    private final EntityReference<Organization> targetClient;
    private final boolean changeRetailPayer;

    public static void showCopyDialog(EntityReference<BookingFile> bookingRef, String productUid, Node context, ObservableMutex mutex) {
        CopyTask.showCopyDialog(bookingRef, productUid, false, context, mutex, false);
    }

    public static void showCopyDialog(EntityReference<BookingFile> bookingRef, String productUid, boolean forwardAgencyMemo, Node context, ObservableMutex mutex, boolean notGenerateSystemNumber) {
        Notifications.get().submitTask(() -> {
            BookingFileService.CopyProductActionParameters params = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).getCopyActionParameters(ServiceInvocationContext.get(), bookingRef, productUid);
            if (params == null || params.getBookingCtr() == null) {
                Dialog.info((Node)context, (String)Messages.Order_Not_Found);
                return;
            }
            CopyTaskPersistentParameters taskPersistentParameters = CopyTask.loadParamenters();
            BaseProduct selectedProduct = BookingHelper.findProductByUid((String)productUid, (BookingFile)((BookingFile)params.getBookingCtr().getEntity()));
            FxUtil.submitToFxThread(() -> CopyTask.showCopyDialogInt(selectedProduct, (EntityContainer<BookingFile>)params.getBookingCtr(), params.getPayers(), forwardAgencyMemo, context, taskPersistentParameters, notGenerateSystemNumber));
        }, mutex);
    }

    private static CopyTaskPersistentParameters loadParamenters() throws Exception {
        File file = CopyTask.getPreferredDataFile();
        if (!file.exists()) {
            return null;
        }
        CopyTaskPersistentParameters result = new CopyTaskPersistentParameters();
        result.fromXML(DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)new ByteArrayInputStream(Files.readAllBytes(file.toPath())))).getDocumentElement());
        return result;
    }

    private static File getPreferredDataFile() {
        return new File(Environment.getDataFolder(), "settings/preferred_data_copy_product_task.xml");
    }

    private static void showCopyDialogInt(BaseProduct product, EntityContainer<BookingFile> bookingCtr, List<EntityReference<Organization>> payers, boolean forwardAgencyMemo, Node context, CopyTaskPersistentParameters taskPersistentParameters, boolean notGenerateSystemNumber) {
        EntityReference bookingFileEntityReference = bookingCtr.toReference();
        ProductStatus status = BookingHelper.getProductStatus((BaseProduct)product);
        RadioBoxWidget modeBox = new RadioBoxWidget(false);
        TextFieldWidget ticketNum = new TextFieldWidget(false);
        if (!notGenerateSystemNumber) {
            String systemNumber = BookingHelper.getSystemNumber((BaseProduct)product);
            try {
                if (forwardAgencyMemo) {
                    if (systemNumber != null) {
                        systemNumber = systemNumber + "-1";
                    }
                } else {
                    systemNumber = !TextUtil.isBlank((String)systemNumber) && (status == ProductStatus.SELL || status == ProductStatus.VOID) ? FormattedNumberUtil.add((String)systemNumber, (long)1L) : null;
                }
                ticketNum.setValue(systemNumber);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ticketNum.getViewState().setNotEditable(notGenerateSystemNumber || ProductStatusHandler.getAllVoidStatuses().contains(status));
        GridCell radioBoxCell = new GridCell(Messages.Location_of_the_new_ticket, (Node)modeBox);
        radioBoxCell.setColSpan(Integer.MAX_VALUE);
        GridCell ticketNumCell = new GridCell(Messages.Number_of_ticket, (Node)ticketNum);
        IntValueWidget ticketsAmount = new IntValueWidget(false);
        ticketsAmount.setDefaultValue((Number)1);
        ticketsAmount.setValueValidator(val -> val > 0 && val < 1000);
        GridCell ticketsNumCell = new GridCell(Messages.Number_of_tickets, (Node)ticketsAmount);
        ComboBoxWidget gdsName = new ComboBoxWidget(false);
        GdsSettingsHelper.configureComboBoxWidget((ComboBoxWidget<GdsName>)gdsName);
        gdsName.setValue(null);
        GridCell gdsNameCell = new GridCell(Messages.Gds, (Node)gdsName);
        gdsName.getViewState().setNotEditable(true);
        ComboBoxWidget recordLocatorType = new ComboBoxWidget(false);
        recordLocatorType.setItemsSupplier(Suppliers.createEnumSupplier(RecordLocatorType.class));
        recordLocatorType.setValue(null);
        GridCell recordLocatorTypeCell = new GridCell(Messages.Record_locator_type, (Node)recordLocatorType);
        recordLocatorType.getViewState().setNotEditable(true);
        TextFieldWidget bookingNum = new TextFieldWidget(false);
        bookingNum.setValue(null);
        GridCell bookingNumCell = new GridCell(Messages.Booking_number, (Node)bookingNum);
        bookingNum.getViewState().setNotEditable(true);
        EntityBoxWidget client = new EntityBoxWidget(Organization.class, false);
        GridCell clientCell = new GridCell(Messages.Client, (Node)client);
        client.getViewState().setNotEditable(modeBox.getValue() != CopyMode.NEW_BOOKING_FILE);
        client.setValue(((BookingFile)bookingCtr.getEntity()).getCustomerProfile());
        modeBox.valueProperty().addListener((obj, o, n) -> {
            gdsName.getViewState().setNotEditable(n == CopyMode.SAME_RESERVATION);
            gdsName.setValue(null);
            recordLocatorType.getViewState().setNotEditable(n == CopyMode.SAME_RESERVATION);
            recordLocatorType.setValue(null);
            bookingNum.getViewState().setNotEditable(n == CopyMode.SAME_RESERVATION);
            bookingNum.setValue(null);
            client.getViewState().setNotEditable(n != CopyMode.NEW_BOOKING_FILE);
        });
        MultiEntityWidget payersWidget = new MultiEntityWidget(Organization.class, true);
        GridCell payersCell = new GridCell(Messages.Payer, (Node)payersWidget);
        payersWidget.getValues().addAll(payers);
        BooleanValueWidget changeRetailPayer = new BooleanValueWidget(true, false);
        changeRetailPayer.setConverter(Converters.boolConverter((String)Messages.Change, (String)Messages.Dont_Change));
        GridCell changeRetailPayerCell = new GridCell(Messages.Change_retail_client, (Node)changeRetailPayer);
        changeRetailPayerCell.setHelp(() -> new QuickHelp(Messages.Change_retail_client_help));
        changeRetailPayer.setValue(true);
        if (taskPersistentParameters != null) {
            changeRetailPayer.setValue(taskPersistentParameters.isChangeRetailPayer());
        }
        GridContainer container = new GridContainer(3);
        container.setStyle("-fx-pref-width: 60em;");
        container.getCells().addAll((Object[])new GridCell[]{radioBoxCell, ticketNumCell, ticketsNumCell, gdsNameCell, recordLocatorTypeCell, bookingNumCell, clientCell, payersCell, changeRetailPayerCell});
        Dialog result = new Dialog().setTitle(Messages.Copying_of_the_ticket).setBody((Node)container);
        modeBox.setItemsSupplier(Suppliers.createEnumSupplier(CopyMode.class));
        modeBox.setValue((Object)CopyMode.SAME_RESERVATION);
        result.setAutoClose(false).setOnCloseRequest(() -> ((Dialog)result).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Copy, () -> {
            ArrayList<Message> messages = new ArrayList<Message>();
            if (modeBox.getValue() == CopyMode.NEW_RESERVATION || modeBox.getValue() == CopyMode.NEW_BOOKING_FILE) {
                if (gdsName.getValue() == null) {
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.No_gds_name, (Object[])new Object[0]));
                }
                if (recordLocatorType.getValue() == null) {
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.No_record_locator_type, (Object[])new Object[0]));
                }
                if (TextUtil.isBlank((String)bookingNum.getValue())) {
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.No_booking_number, (Object[])new Object[0]));
                }
            } else if (ticketNum.getValue() == null && !notGenerateSystemNumber) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Missing_ticket_number, (Object[])new Object[0]));
            }
            if (!messages.isEmpty()) {
                result.setValidationMessages(true, messages.toArray(new Message[0]));
            } else {
                Notifications.get().enqueueAsyncTask((ClientTask)new CopyTask((CopyMode)((Object)((Object)modeBox.getValue())), product, (EntityReference<BookingFile>)bookingFileEntityReference, ticketNum.getValue(), (Integer)ticketsAmount.getValue(), (GdsName)gdsName.getValue(), (RecordLocatorType)recordLocatorType.getValue(), bookingNum.getValue(), forwardAgencyMemo, (EntityReference<Organization>)client.getValue(), changeRetailPayer.getValue()));
                result.close();
            }
        }).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)result).close());
        result.show(context);
    }

    private CopyTask(CopyMode aMode, BaseProduct aProduct, EntityReference<BookingFile> aBookingFileEntityReference, String ticketNum, int ticketsAmount, GdsName gdsName, RecordLocatorType recordLocatorType, String aReservationNum, boolean forwardAgencyMemo, EntityReference<Organization> targetClient, boolean changeRetailPayer) {
        this.mode = aMode;
        this.srcProduct = aProduct;
        this.srcBookingFileEntityReference = aBookingFileEntityReference;
        this.ticketNum = ticketNum;
        this.ticketsAmount = ticketsAmount;
        this.gdsName = gdsName;
        this.recordLocatorType = recordLocatorType;
        this.reservationNum = aReservationNum;
        this.forwardAgencyMemo = forwardAgencyMemo;
        this.targetClient = targetClient;
        this.changeRetailPayer = changeRetailPayer;
    }

    protected String getTitle() {
        return Messages.Copying_of_the_ticket;
    }

    protected void execute() throws Exception {
        BookingFileService.BookingFileRPCResult bookingFileRPCResult;
        this.saveParameters();
        EntityReference sourceReference = this.srcBookingFileEntityReference;
        switch (this.mode) {
            case SAME_RESERVATION: {
                bookingFileRPCResult = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).cloneProductToSameReservation(ServiceInvocationContext.get(), this.srcProduct.getUid(), this.srcBookingFileEntityReference, this.reservationNum, this.ticketNum, this.ticketsAmount, this.forwardAgencyMemo);
                break;
            }
            case NEW_RESERVATION: {
                bookingFileRPCResult = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).cloneProductToNewReservation(ServiceInvocationContext.get(), this.srcProduct.getUid(), this.srcBookingFileEntityReference, this.gdsName, this.recordLocatorType, this.reservationNum, this.ticketNum, this.ticketsAmount, this.forwardAgencyMemo);
                break;
            }
            case NEW_BOOKING_FILE: {
                bookingFileRPCResult = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).cloneProductToNewBookingFile(ServiceInvocationContext.get(), this.srcProduct.getUid(), this.srcBookingFileEntityReference, this.gdsName, this.recordLocatorType, this.reservationNum, this.ticketNum, this.ticketsAmount, this.forwardAgencyMemo, this.targetClient, this.changeRetailPayer);
                sourceReference = bookingFileRPCResult.getResultObject();
                break;
            }
            default: {
                throw new OperationNotSupportedException();
            }
        }
        List resultMessageList = bookingFileRPCResult.getResultMessageList();
        if (bookingFileRPCResult.getResultUid() == null) {
            Message nullError = new Message();
            nullError.setType(MessageType.ERROR);
            L10nMessage l10n = new L10nMessage();
            l10n.setKey(Messages.Copy_Error);
            nullError.setMessage(l10n);
            nullError.setDetails(this.srcProduct.getUid());
            resultMessageList.add(nullError);
            this.addMessages(resultMessageList);
            return;
        }
        this.addMessages(resultMessageList);
        if (resultMessageList.stream().noneMatch(message -> message.getType() == MessageType.ERROR || message.getType() == MessageType.WARNING)) {
            RootEntityEditingService.get().open(sourceReference, true, rootEntityPane -> {
                BookingFileSpace tilesSpace = (BookingFileSpace)rootEntityPane.getEditor();
                CompactNavigatorWidget navigator = (CompactNavigatorWidget)((BookingFileProductsFullPanel)tilesSpace.getProductsTile().getFullNode()).getContent();
                Node node = UiUtil.findViewWithModelUid((Iterable)navigator.getViews(), (String)bookingFileRPCResult.getResultUid());
                if (node == null) {
                    Notifications.get().submitTask(() -> {
                        rootEntityPane.reloadData();
                        FxUtil.waitForFxThread(() -> {
                            Node node2 = UiUtil.findViewWithModelUid((Iterable)navigator.getViews(), (String)bookingFileRPCResult.getResultUid());
                            if (node2 != null) {
                                tilesSpace.expand(tilesSpace.getProductsTile());
                                navigator.selectView(node2);
                            }
                        });
                    }, Messages.Notifications_getting_data);
                } else {
                    tilesSpace.expand(tilesSpace.getProductsTile());
                    navigator.selectView(node);
                }
            });
        }
        this.refreshView(this.srcBookingFileEntityReference);
    }

    private void saveParameters() throws Exception {
        CopyTaskPersistentParameters persistentParameters = new CopyTaskPersistentParameters();
        persistentParameters.setChangeRetailPayer(this.changeRetailPayer);
        File file = CopyTask.getPreferredDataFile();
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        Files.write(file.toPath(), XSUtil.toByteArray((XSSerializable)persistentParameters), new OpenOption[0]);
    }

    private void refreshView(EntityReference<BookingFile> bookingFileEntityReference) {
        EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(bookingFileEntityReference, EntityModification.ModificationType.CHANGE)));
    }
}

