/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions.receipts;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceController;
import com.gridnine.xtrip.client.fx.standard.entity.actions.receipts.ListReceiptsAction;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.AirRefundReceiptDialog;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.RefundReceiptDialog;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.InformationNote;
import com.gridnine.xtrip.common.model.dict.InformationNoteType;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SortOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class ProductRefundReceiptAction
implements ListReceiptsAction {
    public String getId() {
        return "product-refund-receipt";
    }

    @Override
    public boolean isEnabled(RootEntityPane<?, ?> context) {
        DataTransferPackage dtp = context.getData();
        if (dtp == null || dtp.getContainer() == null) {
            return false;
        }
        List<BaseProduct> products = this.getSuitableProducts((BookingFile)dtp.getContainer().getEntity());
        return !products.isEmpty();
    }

    @Override
    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        DataTransferPackage dtp = context.getData();
        BookingFile bf = (BookingFile)dtp.getContainer().getEntity();
        List<BaseProduct> products = this.getSuitableProducts(bf);
        Notifications.get().submitTask(() -> {
            DictService dictService = (DictService)RpcServiceManager.get().getService(DictService.class);
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            DictQuery dictQuery = new DictQuery();
            dictQuery.getFields().add(BaseDictionary.Property.code.name());
            dictQuery.getFields().add(BaseDictionary.Property.translations.name());
            dictQuery.getFields().add(InformationNote.Property.priority.name());
            dictQuery.getFields().add(InformationNote.Property.persistent.name());
            dictQuery.getFields().add(InformationNote.Property.types.name());
            dictQuery.getCriterions().add(new DictQuery.SearchCriterion(InformationNote.Property.types.name(), new Object[]{InformationNoteType.REFUND_RECEIPT}));
            dictQuery.getSorting().put(InformationNote.Property.priority.name(), SortOrder.ASC);
            List notes = dictService.search(sic, InformationNote.class, dictQuery);
            Map<BaseProduct, EntityReference<BookingFile>> products2Bookings = products.stream().collect(Collectors.toMap(obj -> obj, obj -> dtp.getContainer().toReference()));
            Node selectedView = ((CompactNavigatorWidget)((BookingFileSpaceController)context.getEditor().getProperties().get((Object)"controller")).getProductsFull().getView().getContent()).getSelectedView();
            String selectedProductUid = (String)selectedView.getProperties().get((Object)"model-uid");
            RefundReceiptDialog receiptDialog = ClientRegistry.get().allOf(RefundReceiptDialog.TYPE).values().stream().filter(dialog -> dialog.getPaneClassList().contains(selectedView.getClass())).findFirst().orElse(null);
            if (receiptDialog != null) {
                RefundReceiptDialog finalReceiptDialog = receiptDialog;
                products2Bookings.keySet().removeIf(product -> !product.getClass().equals(finalReceiptDialog.getProductClass()));
            } else {
                products2Bookings.keySet().removeIf(product -> !(product instanceof Product));
                receiptDialog = new AirRefundReceiptDialog();
            }
            receiptDialog.initDialog(source, products2Bookings, notes, selectedProductUid);
            FxUtil.submitToFxThread(receiptDialog::showDialog);
        }, context.getMutex());
    }

    @Override
    public String getName() {
        return Messages.Product_refund_receipt;
    }

    private List<BaseProduct> getSuitableProducts(BookingFile bf) {
        ArrayList<BaseProduct> result = new ArrayList<BaseProduct>();
        if (bf == null) {
            return result;
        }
        bf.getReservations().stream().flatMap(r -> r.getProducts().stream().filter(baseProduct -> AirProductHelper.isAirProduct((BaseProduct)baseProduct) || baseProduct instanceof RailwayProduct)).forEach(baseProduct -> {
            ProductStatus productStatus = GeneralProductHelper.getStatus((BaseProduct)baseProduct);
            if (ProductStatus.REFUND == productStatus) {
                result.add((BaseProduct)baseProduct);
            }
        });
        return result;
    }
}

