/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.fiscal.model.FiscalSettingsPaymentTypesSettingsVM;
import com.gridnine.xtrip.client.fx.fiscal.model.FiscalSettingsSpace;
import com.gridnine.xtrip.client.fx.fiscal.model.FiscalSettingsSpaceController;
import com.gridnine.xtrip.client.fx.fiscal.model.FiscalSettingsSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.FiscalSettingsSpaceControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.fiscal.model.FiscalSettings;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import java.util.List;
import java.util.function.BiConsumer;

public class FiscalSettingsHandler
extends BaseRootEntityHandler<FiscalSettings, Void, FiscalSettingsSpaceVM, FiscalSettingsSpace> {
    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<FiscalSettings, Void>, FiscalSettingsSpaceVM>> toVM, List<BiConsumer<FiscalSettingsSpaceVM, DataTransferPackage<FiscalSettings, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new FiscalSettingsSpaceControllerInterceptor());
        toVM.add((dtp, vm) -> {
            FiscalSettings model = (FiscalSettings)dtp.getContainer().getEntity();
            vm.getSettingsFull().setIsUseMidofficeCashier(model.isUseMidofficeCashier());
            vm.getSettingsFull().getPaymentTypesSettings().clear();
            VMHelper.copy(model.getRuleSet(), vm.getRulesFull());
            model.getAvailablePaymentTypes().forEach((key, value) -> {
                FiscalSettingsPaymentTypesSettingsVM paymentTypesSettingsVM = new FiscalSettingsPaymentTypesSettingsVM();
                paymentTypesSettingsVM.setMidofficePaymentType(key);
                paymentTypesSettingsVM.setKktPaymentType(value);
                vm.getSettingsFull().getPaymentTypesSettings().add(paymentTypesSettingsVM);
            });
        });
        fromVM.add((vm, dtp) -> {
            FiscalSettings model = (FiscalSettings)dtp.getContainer().getEntity();
            model.setUseMidofficeCashier(vm.getSettingsFull().isIsUseMidofficeCashier());
            VMHelper.copy(vm.getRulesFull(), model.getRuleSet());
            model.getAvailablePaymentTypes().clear();
            vm.getSettingsFull().getPaymentTypesSettings().forEach(paymentTypesSettingsVM -> model.getAvailablePaymentTypes().put(paymentTypesSettingsVM.getMidofficePaymentType(), paymentTypesSettingsVM.getKktPaymentType()));
        });
    }

    @Override
    protected ViewController<FiscalSettingsSpace, FiscalSettingsSpaceVM> createSpaceController(boolean readonly) {
        return new FiscalSettingsSpaceController(readonly);
    }

    @Override
    protected FiscalSettingsSpaceVM createVM() {
        return new FiscalSettingsSpaceVM();
    }

    public Class<FiscalSettings> getEntityClass() {
        return FiscalSettings.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return BasicSystemSettingsIndex.class;
    }
}

