/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.archive;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.booking.ArchivedBookingSpace;
import com.gridnine.xtrip.client.fx.model.booking.ArchivedBookingSpaceController;
import com.gridnine.xtrip.client.fx.model.booking.ArchivedBookingSpaceVM;
import com.gridnine.xtrip.client.fx.model.booking.ArchivedBookingTableDetailsPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.ArchivedInfoSuperColumnTableVM;
import com.gridnine.xtrip.client.fx.model.booking.ArchivedInfoVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.archive.interceptors.ArchivedBookingControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBooking;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.uidata.ArchivedBookingUIData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class ArchivedBookingHandler
extends BaseRootEntityHandler<ArchivedBooking, ArchivedBookingUIData, ArchivedBookingSpaceVM, ArchivedBookingSpace> {
    public Class<ArchivedBooking> getEntityClass() {
        return ArchivedBooking.class;
    }

    public Class<ArchivedBookingUIData> getSupplementClass() {
        return ArchivedBookingUIData.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return null;
    }

    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<ArchivedBooking, ArchivedBookingUIData>, ArchivedBookingSpaceVM>> toVM, List<BiConsumer<ArchivedBookingSpaceVM, DataTransferPackage<ArchivedBooking, ArchivedBookingUIData>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new ArchivedBookingControllerInterceptor());
        toVM.add((dtp, vm) -> {
            ArchivedBooking model = (ArchivedBooking)dtp.getContainer().getEntity();
            ArchivedBookingUIData supplement = (ArchivedBookingUIData)dtp.getSupplement();
            ArrayList containers = new ArrayList();
            containers.add(model.getBooking().getVersions().get(0));
            containers.addAll(model.getAdditionalEntities().stream().map(el -> (EntityContainer)el.getVersions().get(0)).collect(Collectors.toList()));
            containers.forEach(el -> {
                ArchivedInfoVM infoVM = new ArchivedInfoVM();
                infoVM.setCreatedDate(DateUtils.asLocalDate((Date)el.getCreated()));
                infoVM.setName(el.getEntity().toString());
                infoVM.setType(el.getEntityType().getName());
                infoVM.setUidValue(el.getUid());
                if (el.getEntityType().equals(BookingFile.class)) {
                    ArchivedBookingHandler.bookingFileToVM((BookingFile)el.getEntity(), infoVM.getDetails(), supplement);
                }
                vm.getInfo().add(infoVM);
            });
        });
    }

    @Override
    protected ViewController<ArchivedBookingSpace, ArchivedBookingSpaceVM> createSpaceController(boolean readonly) {
        return new ArchivedBookingSpaceController(readonly);
    }

    @Override
    protected ArchivedBookingSpaceVM createVM() {
        return new ArchivedBookingSpaceVM();
    }

    private static void bookingFileToVM(BookingFile bookingFile, ArchivedBookingTableDetailsPanelVM vm, ArchivedBookingUIData uiData) {
        if (bookingFile.getAgency() != null) {
            vm.setAgency(bookingFile.getAgency().getCaption());
        }
        if (uiData.getSubagency() != null) {
            vm.setSubagency(uiData.getSubagency().getCaption());
        }
        if (bookingFile.getCustomerProfile() != null) {
            vm.setClient(bookingFile.getCustomerProfile().getCaption());
        }
        vm.setBookingNumber(bookingFile.getNumber());
        vm.setCreationDate((String)StandardRenderers.DATE.apply((Object)bookingFile.getCreateDate()));
        List tickets = vm.getTickets();
        bookingFile.getReservations().stream().flatMap(r -> r.getProducts().stream()).forEach(pr -> {
            ProductHandler commonHandler;
            ArchivedInfoSuperColumnTableVM ticketVm = new ArchivedInfoSuperColumnTableVM();
            tickets.add(ticketVm);
            ProductFXHandler<BaseProduct, ?, ?, ?> handler = ProductFXHandler.forProduct(pr);
            if (handler != null) {
                ticketVm.setPassenger(ArchivedBookingHandler.getTravellers(handler.getTravellers((BaseProduct)pr)));
                ticketVm.setType(handler.getDisplayName());
            }
            if ((commonHandler = GeneralProductHelper.getHandler((BaseProduct)pr)) != null) {
                EntityReference issuingAgent = commonHandler.findIssuingAgent(pr);
                if (issuingAgent != null) {
                    ticketVm.setAgent(issuingAgent.getCaption());
                }
                ticketVm.setDate((String)StandardRenderers.DATE.apply((Object)commonHandler.findFirstTravelDate(pr)));
                ticketVm.setNumber(String.join((CharSequence)",", commonHandler.getProductNumbers(pr)));
            }
            if (pr instanceof Product) {
                ticketVm.setAdditional(ArchivedBookingHandler.getAirSegments((Product)pr));
            } else if (pr instanceof RailwayProduct) {
                ticketVm.setAdditional(ArchivedBookingHandler.getRailwaySegments((RailwayProduct)pr));
            } else if (pr instanceof HotelProduct) {
                ticketVm.setAdditional(ArchivedBookingHandler.getHotelInfo((HotelProduct)pr));
            }
        });
    }

    private static String getTravellers(Collection<Traveller> travellers) {
        ArrayList lst = new ArrayList();
        travellers.forEach(tr -> lst.add(tr.getName()));
        return String.join((CharSequence)", ", lst);
    }

    private static String getRailwaySegments(RailwayProduct product) {
        ArrayList lst = new ArrayList();
        product.getSegments().forEach(s -> lst.add(String.format("\u0418\u0437 %s \u0412 %s", s.getDepartureStation() == null ? "-" : s.getDepartureStation().getCaption(), s.getArriveStation() == null ? "-" : s.getArriveStation().getCaption())));
        return String.join((CharSequence)" // ", lst);
    }

    private static String getAirSegments(Product product) {
        ArrayList lst = new ArrayList();
        product.getSegmentTariffs().stream().flatMap(st -> st.getSegments().stream()).forEach(s -> lst.add(String.format("\u0418\u0437 %s \u0412 %s", s.getDepartureLocation() == null ? "-" : s.getDepartureLocation().getCode(), s.getArriveLocation() == null ? "-" : s.getArriveLocation().getCode())));
        return String.join((CharSequence)" // ", lst);
    }

    private static String getHotelInfo(HotelProduct product) {
        ArrayList<String> result = new ArrayList<String>();
        if (product.getHotelName() != null) {
            result.add(product.getHotelName());
        }
        if (product.getHotelLocation() != null && product.getHotelLocation().getCode() != null) {
            result.add(product.getHotelLocation().getCode());
        }
        return String.join((CharSequence)" - ", result);
    }
}

