/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileReservationsFullContainerVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileReservationsFullPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileReservationsFullProductsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileReservationsFullRecordLocatorInfoVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileReservationsFullRemarksVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileReservationsFullSystemInfoVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.RecordLocatorInfo;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationGdsNameInfo;
import com.gridnine.xtrip.common.model.booking.ReservationSystemInfo;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.BooleanUtils;

public final class ReservationsTileHelper {
    private ReservationsTileHelper() {
    }

    static void toVM(BookingFile bookingFile, BookingFileReservationsFullPanelVM full, BookingFileUIData uiData) {
        VMHelper.transfer(bookingFile.getReservations(), full.getContent(), reservation -> new BookingFileReservationsFullContainerVM(), (res, resVM) -> {
            resVM.getGeneralParameters().setClient(res.getBookingFile() == null ? null : res.getBookingFile().getCustomerProfile());
            resVM.getGeneralParameters().setSubagency(res.getSubagency());
            resVM.getGeneralParameters().setSalesPoint(res.getSalesPoint());
            resVM.getGeneralParameters().setType(res.getType());
            resVM.getGeneralParameters().setResDate(DateUtils.asLocalDateTime((Date)res.getResDate()));
            resVM.getGeneralParameters().setBookingAgent(res.getBookingAgent());
            resVM.getGeneralParameters().setTimeLimit(DateUtils.asLocalDateTime((Date)res.getTimeLimit()));
            resVM.getGeneralParameters().setManualTimeLimit(res.isManualTimeLimit());
            List reservationRemarks = res.getReservationRemarks();
            if (reservationRemarks != null) {
                reservationRemarks.forEach(remark -> {
                    BookingFileReservationsFullRemarksVM remarkVM = new BookingFileReservationsFullRemarksVM();
                    remarkVM.setRemark(remark.getRemarkText());
                    remarkVM.setRemarkReference(remark);
                    resVM.getRemarks().add(remarkVM);
                });
            }
            res.getProducts().forEach(product -> ReservationsTileHelper.addProduct(product, resVM));
            Boolean isCreatedByClient = (Boolean)uiData.getResIsCreatedByClient().get(res.getUid());
            if (isCreatedByClient != null) {
                resVM.getGeneralParameters().setCreatedByClient(isCreatedByClient.booleanValue());
            }
            resVM.getGeneralParameters().setExcludedFromAutoSync(BooleanUtils.isTrue((Boolean)res.getExcludedFromAutoSync()));
            ReservationGdsNameInfo gdsNameInfo = res.getGdsNameInfo();
            gdsNameInfo.getSystemInfos().forEach(si -> {
                BookingFileReservationsFullSystemInfoVM siVM = new BookingFileReservationsFullSystemInfoVM();
                siVM.setGdsName(si.getGdsName());
                siVM.setBookingAgentDutyCode(si.getBookingAgentDutyCode());
                siVM.setBookingPcc(si.getBookingPcc());
                siVM.getSuperColumn().getContent().addAll(si.getRecordLocators().stream().map(rli -> {
                    BookingFileReservationsFullRecordLocatorInfoVM rliVM = new BookingFileReservationsFullRecordLocatorInfoVM();
                    ReservationsTileHelper.toVMRecordLocatorInfoCommonParameters(rliVM, rli);
                    return rliVM;
                }).collect(Collectors.toList()));
                resVM.getGdsNameInfo().getSystemInfos().add(siVM);
            });
            resVM.getGdsNameInfo().setRulesGdsName(gdsNameInfo.getRulesGdsName());
            resVM.getGdsNameInfo().setStatisticsGdsName(gdsNameInfo.getStatisticsGdsName());
        });
    }

    static void fromVM(BookingFileReservationsFullPanelVM full, BookingFile model) {
        VMHelper.transfer(full.getContent(), model.getReservations(), resVM -> new Reservation(), (resvVM, res) -> {
            res.setBookingFile(model);
            res.setSubagency(resvVM.getGeneralParameters().getSubagency());
            res.setSalesPoint(resvVM.getGeneralParameters().getSalesPoint());
            res.setType(resvVM.getGeneralParameters().getType());
            res.setResDate(DateUtils.asDate((LocalDateTime)resvVM.getGeneralParameters().getResDate()));
            res.setBookingAgent(resvVM.getGeneralParameters().getBookingAgent());
            res.setTimeLimit(DateUtils.asDate((LocalDateTime)resvVM.getGeneralParameters().getTimeLimit()));
            res.setManualTimeLimit(resvVM.getGeneralParameters().isManualTimeLimit());
            res.getReservationRemarks().clear();
            resvVM.getRemarks().forEach(remarkVM -> res.getReservationRemarks().add(remarkVM.getRemarkReference()));
            res.setExcludedFromAutoSync(Boolean.valueOf(resvVM.getGeneralParameters().isExcludedFromAutoSync()));
            ReservationGdsNameInfo gdsNameInfo = res.getGdsNameInfo();
            resvVM.getGdsNameInfo().getSystemInfos().forEach(siVM -> {
                ReservationSystemInfo si = new ReservationSystemInfo();
                si.setGdsName(siVM.getGdsName());
                si.setBookingAgentDutyCode(siVM.getBookingAgentDutyCode());
                si.setBookingPcc(siVM.getBookingPcc());
                si.getRecordLocators().addAll(siVM.getSuperColumn().getContent().stream().map(rliVM -> {
                    RecordLocatorInfo rli = new RecordLocatorInfo();
                    ReservationsTileHelper.fromVMRecordLocatorInfoCommonParameters(rli, rliVM);
                    return rli;
                }).collect(Collectors.toList()));
                gdsNameInfo.getSystemInfos().add(si);
            });
            gdsNameInfo.setRulesGdsName(resvVM.getGdsNameInfo().getRulesGdsName());
            gdsNameInfo.setStatisticsGdsName(resvVM.getGdsNameInfo().getStatisticsGdsName());
        });
    }

    static void addProduct(BaseProduct product, BookingFileReservationsFullContainerVM resVM) {
        BookingFileReservationsFullProductsVM productVM = new BookingFileReservationsFullProductsVM();
        productVM.setProduct(BookingHelper.generateShortProductName((BaseProduct)product));
        productVM.setProductUID(product.getUid());
        resVM.getProducts().add(productVM);
    }

    public static void toVMRecordLocatorInfoCommonParameters(BookingFileReservationsFullRecordLocatorInfoVM rliVM, RecordLocatorInfo rli) {
        rliVM.setType(rli.getType());
        rliVM.setRecordLocator(rli.getRecordLocator());
        rliVM.setDisplay(rli.isDisplay());
        rliVM.setExport1C(rli.isExport1C());
    }

    public static void fromVMRecordLocatorInfoCommonParameters(RecordLocatorInfo rli, BookingFileReservationsFullRecordLocatorInfoVM rliVM) {
        rli.setType(rliVM.getType());
        rli.setRecordLocator(rliVM.getRecordLocator());
        rli.setDisplay(rliVM.isDisplay());
        rli.setExport1C(rliVM.isExport1C());
    }
}

