/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductBagagePanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductEMDPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.standard.entity.actions.productcopy.CopyTask;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.AirProductFopMapAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.BaseProductCreatePassiveSegmentsActionsProvider;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ChangePayerProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.CopyProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ExchangeProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ExchangeProductToVoucherAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.MoveNextProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.MovePrevProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.PayProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionsProvider;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.RecalculateFOPProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.RefundProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.RefusePaymentProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.SellProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.UnpayProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.UnrefusePaymentProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.UnvoidProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.VatRecalculateAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.VoidProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.AirProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.ProductSellTask;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.AirProductExchangeDialog;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.AirProductExchangeToVoucherDialog;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.AirProductRefundDialog;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javafx.scene.Node;

public class AirProductActionsProvider
implements ProductActionsProvider {
    private List<TileAction<Node, BookingFileProductsFullPanel>> actions;

    public String getId() {
        return "standard-air-product-actions-provider";
    }

    @Override
    public boolean isApplicableTo(Node productView) {
        return productView instanceof BookingFileProductAirPanel || productView instanceof BookingFileProductEMDPanel || productView instanceof BookingFileProductBagagePanel;
    }

    @Override
    public List<TileAction<Node, BookingFileProductsFullPanel>> getAvailableActions() {
        if (this.actions != null) {
            return this.actions;
        }
        this.actions = Arrays.asList(new MovePrevProductAction<Product>(){

            @Override
            protected BaseProduct getPreviousProduct(Product product) {
                return product.getPreviousProduct();
            }
        }, new MoveNextProductAction<Product>(){

            @Override
            protected BaseProduct getNextProduct(Product product) {
                return product.getNextProduct();
            }
        }, new ExchangeProductAction<Product>(){

            @Override
            protected boolean isEnabled(Product product) {
                return product != null && product.getStatus() == ProductStatus.SELL && product.getNextProduct() == null;
            }

            @Override
            protected void execute(ProductActionContext<Product> ctx) {
                Map<Integer, MiscUtil.Pair<String, String>> segmentsPoints = AirProductFXHelper.getSegmentsPoints(ctx.getSelectedProduct().getUid(), (List<Node>)ctx.getProductsWidget().getViews());
                new AirProductExchangeDialog(ctx.getRootPane(), ctx.getSelectedProduct(), segmentsPoints).showDialog();
            }
        }, new ExchangeProductToVoucherAction<Product>(){

            @Override
            protected boolean isEnabled(Product product) {
                return product != null && product.getStatus() == ProductStatus.SELL && product.getNextProduct() == null && (product.getMcoCategory() == null || product.getMcoCategory() == MCOCategory.VOUCHER);
            }

            @Override
            protected void execute(ProductActionContext<Product> ctx) {
                Map<Integer, MiscUtil.Pair<String, String>> segmentsPoints = AirProductFXHelper.getSegmentsPoints(ctx.getSelectedProduct().getUid(), (List<Node>)ctx.getProductsWidget().getViews());
                new AirProductExchangeToVoucherDialog(ctx.getRootPane(), ctx.getSelectedProduct(), segmentsPoints).showDialog();
            }
        }, new RefundProductAction<Product>(){

            @Override
            protected boolean isEnabled(Product product) {
                boolean result = product != null;
                result = result && product.getStatus() == ProductStatus.SELL;
                result = result && product.getNextProduct() == null;
                BookingFile bookingFile = BookingHelper.getBookingFile((BaseProduct)product);
                String number = bookingFile != null ? bookingFile.getNumber() : null;
                result = result && number != null;
                return result;
            }

            @Override
            protected void execute(ProductActionContext<Product> ctx) {
                Map<Integer, MiscUtil.Pair<String, String>> segmentsPoints = AirProductFXHelper.getSegmentsPoints(ctx.getSelectedProduct().getUid(), (List<Node>)ctx.getProductsWidget().getViews());
                new AirProductRefundDialog(ctx.getRootPane(), ctx.getSelectedProduct(), segmentsPoints).showDialog();
            }
        }, new AirProductFopMapAction(), new RecalculateFOPProductAction(), new CopyProductAction<Product>(){

            @Override
            protected boolean isEnabled(Product product) {
                return product != null && (product.getStatus() == ProductStatus.SELL || product.getStatus() == ProductStatus.BOOKING || product.getStatus() == ProductStatus.VOID_BOOKING || product.getStatus() == ProductStatus.VOID);
            }

            @Override
            protected void execute(ProductActionContext<Product> ctx) {
                CopyTask.showCopyDialog((EntityReference<BookingFile>)ctx.getRootPane().getData().getContainer().toReference(), ctx.getSelectedProduct().getUid(), ctx.getRootPane(), ctx.getRootPane().getMutex());
            }
        }, new VoidProductAction<Product>(){

            @Override
            protected boolean isEnabled(Product product) {
                return product != null && (product.getStatus() == ProductStatus.BOOKING || product.getStatus() == ProductStatus.SELL) && product.getNextProduct() == null && AirProductHelper.getDuplicateByRelatedProduct((Product)product).isEmpty();
            }
        }, new UnvoidProductAction<Product>(){

            @Override
            protected boolean isEnabled(Product product) {
                return product != null && (product.getStatus() == ProductStatus.VOID || product.getStatus() == ProductStatus.VOID_BOOKING) && ProductStatus.EXCHANGE != product.getPreviousProductStatus();
            }
        }, new PayProductAction<Product>(){

            @Override
            protected ProductStatus getStatus(Product product) {
                return product.getStatus();
            }
        }, new UnpayProductAction<Product>(){

            @Override
            protected ProductStatus getStatus(Product product) {
                return product.getStatus();
            }
        }, new RefusePaymentProductAction<Product>(){

            @Override
            protected ProductStatus getStatus(Product product) {
                return product.getStatus();
            }
        }, new UnrefusePaymentProductAction<Product>(){

            @Override
            protected ProductStatus getStatus(Product product) {
                return product.getStatus();
            }
        }, new SellProductAction<Product>(){

            @Override
            protected boolean isEnabled(Product product) {
                return product.getStatus() == ProductStatus.BOOKING;
            }

            @Override
            protected void execute(ProductActionContext<Product> ctx) {
                Dialog.confirm((String)Messages.Issuing_Ticket_Confirmation, () -> new TicketNumberDialog((Node)ctx.getRootPane(), number -> {
                    String prodUid = ((Product)ctx.getSelectedProduct()).getUid();
                    EntityReference ref = ctx.getRootPane().getData().getContainer().toReference();
                    Notifications.get().enqueueAsyncTask(new ProductSellTask(prodUid, (EntityReference<BookingFile>)ref, (String)number));
                }).showDialog());
            }
        }, new ChangePayerProductAction(), new VatRecalculateAction(), new BaseProductCreatePassiveSegmentsActionsProvider());
        return this.actions;
    }

    private static class TicketNumberDialog {
        private final Node source;
        private final Consumer<String> callback;

        TicketNumberDialog(Node source, Consumer<String> callback) {
            this.source = source;
            this.callback = callback;
        }

        void showDialog() {
            GridContainer container = new GridContainer();
            TextFieldWidget ticketNumberWidget = new TextFieldWidget(false);
            container.getCells().add((Object)new GridCell(Messages.Number_of_ticket, (Node)ticketNumberWidget));
            Dialog dialog = new Dialog().setTitle(Messages.Entering_Ticket_Number).setBody((Node)container).setAutoClose(false);
            dialog.setOnCloseRequest(() -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Dialog_save, () -> {
                this.callback.accept(ticketNumberWidget.getValue());
                dialog.close();
            }).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).show(this.source);
        }
    }
}

