/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductDeliveryPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.BaseProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.DeliveryProductCreateDeliveryRouteListAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.MoveNextProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.MovePrevProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionsProvider;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.RecalculateFOPProductAction;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.DeliveryStatus;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Arrays;
import java.util.List;
import javafx.scene.Node;

public class DeliveryProductActionsProvider
implements ProductActionsProvider {
    private List<TileAction<Node, BookingFileProductsFullPanel>> actions;

    public String getId() {
        return "standard-delivery-product-actions-provider";
    }

    @Override
    public boolean isApplicableTo(Node productView) {
        return productView instanceof BookingFileProductDeliveryPanel;
    }

    @Override
    public List<TileAction<Node, BookingFileProductsFullPanel>> getAvailableActions() {
        if (this.actions != null) {
            return this.actions;
        }
        this.actions = Arrays.asList(new MovePrevProductAction<Delivery>(){

            @Override
            protected BaseProduct getPreviousProduct(Delivery product) {
                return product.getPreviousProduct();
            }
        }, new MoveNextProductAction<Delivery>(){

            @Override
            protected BaseProduct getNextProduct(Delivery product) {
                return product.getNextProduct();
            }
        }, new RecalculateFOPProductAction(), new DeliveryProductCompleteDeliveryAction(), new DeliveryProductIncompleteDeliveryAction(), new DeliveryProductCreateDeliveryRouteListAction());
        return this.actions;
    }

    private static class DeliveryProductIncompleteDeliveryAction
    extends BaseProductAction<Delivery> {
        private DeliveryProductIncompleteDeliveryAction() {
        }

        @Override
        protected String getName() {
            return Messages.Incomplete_delivery;
        }

        @Override
        protected String getDescription() {
            return null;
        }

        @Override
        protected boolean isEnabled(Delivery product) {
            return product != null && product.getStatus() == DeliveryStatus.COMPLETED && product.getNextProduct() == null;
        }

        @Override
        protected boolean isSaveRequired() {
            return true;
        }

        @Override
        protected void execute(ProductActionContext<Delivery> ctx) {
            ctx.getSelectedProduct().setStatus(DeliveryStatus.PLANNED);
            EntityContainer bookingCtr = ctx.getRootPane().getData().getContainer();
            Notifications.get().submitTask(() -> {
                ((EntityService)RpcServiceManager.get().getService(EntityService.class)).save(ServiceInvocationContext.get(), bookingCtr, null, true);
                EventBus.get().publishAsync((Event)new EntityModificationEvent(null, new EntityModification(bookingCtr.toReference(), EntityModification.ModificationType.CHANGE)));
            }, ctx.getRootPane().getMutex());
        }

        public double getWeight() {
            return 100.0;
        }
    }

    private static class DeliveryProductCompleteDeliveryAction
    extends BaseProductAction<Delivery> {
        private DeliveryProductCompleteDeliveryAction() {
        }

        @Override
        protected String getName() {
            return Messages.Complete_delivery;
        }

        @Override
        protected String getDescription() {
            return null;
        }

        @Override
        protected boolean isEnabled(Delivery product) {
            return product != null && product.getStatus() == DeliveryStatus.PLANNED && product.getNextProduct() == null;
        }

        @Override
        protected boolean isSaveRequired() {
            return true;
        }

        @Override
        protected void execute(ProductActionContext<Delivery> ctx) {
            ctx.getSelectedProduct().setStatus(DeliveryStatus.COMPLETED);
            EntityContainer bookingCtr = ctx.getRootPane().getData().getContainer();
            Notifications.get().submitTask(() -> {
                ((EntityService)RpcServiceManager.get().getService(EntityService.class)).save(ServiceInvocationContext.get(), bookingCtr, null, true);
                EventBus.get().publishAsync((Event)new EntityModificationEvent(null, new EntityModification(bookingCtr.toReference(), EntityModification.ModificationType.CHANGE)));
            }, ctx.getRootPane().getMutex());
        }

        public double getWeight() {
            return 90.0;
        }
    }
}

