/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions;

import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.BaseProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.DeliveryFXHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.DeliveryIndex;
import com.gridnine.xtrip.common.model.helpers.MessageBuilder;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.TemplateDocumentIndex;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.nimbusds.jwt.util.DateUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DeliveryProductCreateDeliveryRouteListAction
extends BaseProductAction<Delivery> {
    @Override
    protected String getName() {
        return Messages.Create_delivery_route_list;
    }

    @Override
    protected String getDescription() {
        return null;
    }

    @Override
    protected boolean isEnabled(Delivery product) {
        return product != null && product.getCourier() != null && product.getStartDate() != null && DateUtils.isAfter((Date)product.getStartDate(), (Date)new Date(), (long)86400L);
    }

    @Override
    protected boolean isSaveRequired() {
        return false;
    }

    @Override
    protected void execute(ProductActionContext<Delivery> ctx) {
        Notifications.get().submitTask(() -> {
            List<TemplateDocumentIndex> data = DeliveryFXHelper.getCourierRouteListTemplates();
            if (data.isEmpty()) {
                Notifications.get().showMessages(new Message[]{MessageBuilder.error((String)Messages.deliveryRouteList_templateNotFound).build()});
                return;
            }
            List<DeliveryIndex> deliveryIndices = DeliveryFXHelper.searchSimilarlyDeliveries((EntityReference<Person>)((Delivery)ctx.getSelectedProduct()).getCourier(), ((Delivery)ctx.getSelectedProduct()).getStartDate());
            BookingFileService.DeliveryRPCResult result = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).renderDeliveryRouteList(ServiceInvocationContext.get(), deliveryIndices, data.get(0).getSource());
            if (!result.getResultMessageList().isEmpty()) {
                Notifications.get().showMessages((Collection)result.getResultMessageList());
                return;
            }
            FxUtil.submitToFxThread(() -> RootEntityEditingService.get().open(result.getResultObject(), false));
        }, Messages.Notifications_getting_data);
    }

    public double getWeight() {
        return 110.0;
    }
}

