/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.BaseProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.ProductRecalculateFOPListTask;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class RecalculateFOPProductAction<P extends BaseProduct>
extends BaseProductAction<P> {
    public double getWeight() {
        return 50.0;
    }

    @Override
    protected String getName() {
        return Messages.To_Recalculate_FOP;
    }

    @Override
    protected String getDescription() {
        return Messages.To_Recalculate_FOP;
    }

    @Override
    protected boolean isEnabled(P product) {
        return true;
    }

    @Override
    protected boolean isSaveRequired() {
        return true;
    }

    @Override
    protected void execute(ProductActionContext<P> ctx) {
        EntityReference bfRef = ctx.getRootPane().getData().getContainer().toReference();
        String productUid = ctx.getSelectedProduct().getUid();
        Notifications.get().submitTask(() -> {
            List messages = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).recalculateFOP(ServiceInvocationContext.get(), Collections.singletonMap(productUid, bfRef), ProductRecalculateFOPListTask.DEFAULT_APPROPRIATE_STATUSES);
            FxUtil.submitToFxThread(() -> {
                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(bfRef, EntityModification.ModificationType.CHANGE)));
                Notifications.get().showMessages((Collection)messages);
            });
        }, ctx.getRootPane().getMutex());
    }
}

