/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.insuranceaccident;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.ComplexCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.ui.tab.ContentError;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileContractPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileGeneralParametersFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileMainFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceAccidentGeneralPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceAccidentPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceAccidentPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceAccidentPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceAccidentSalesChainPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.CustomVatContainer;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.BindingUtil;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.ControllerInterceptorVatHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.helpers.BookingFileProductParametersHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccident;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceOperation;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.collections.ObservableMap;
import javafx.scene.Node;
import javafx.util.StringConverter;

public class BookingFileProductInsuranceAccidentPanelControllerInterceptor
extends ControllerInterceptor<BookingFileProductInsuranceAccidentPanelVM, BookingFileProductInsuranceAccidentPanelController> {
    private static final String ACCESS_DENIED_CELL_ID = "access-denied-cell";

    protected Class<BookingFileProductInsuranceAccidentPanelController> getControllerClass() {
        return BookingFileProductInsuranceAccidentPanelController.class;
    }

    protected void onCreate(BookingFileProductInsuranceAccidentPanelController controller) {
        BindingUtil.addYearValidationListener(controller.getView().getGeneralNode().getTravelerInfoNode().getOperationDateValueNode());
        BookingFileProductInsuranceAccidentPanel view = controller.getView();
        this.configureGeneralNode(controller);
        GeneralProductFXHelper.configureStatusWidget(view.getGeneralNode().getTicketInfoNode().getStatusValueNode(), () -> ((BookingFileProductInsuranceAccidentPanelController)controller).getData());
        BookingFileContractPanel tableView = (BookingFileContractPanel)view.getFopsNode().getContractNode().getView();
        ((TableWidget)tableView.getContractsCard().getContent()).addEventHandler(TableRowEvent.ROW_ADD, event -> {
            Integer ind = event.getRowIndex();
            ComboBoxWidget contractType = (ComboBoxWidget)((TableWidget)tableView.getContractsCard().getContent()).getColumn("contractType").getWidget(ind.intValue());
            ContractType type = (ContractType)contractType.getValue();
            EntityBoxWidget manualContract = (EntityBoxWidget)((TableWidget)tableView.getContractsCard().getContent()).getColumn("manualContract").getWidget(ind.intValue());
            manualContract.setListParametersSupplier(() -> {
                IndexListParameters<Contract, ContractIndex> contractsByType = ControllerInterceptorsHelper.getContractsByType((ContractType)contractType.getValue());
                BookingFileSpace pane = (BookingFileSpace)RootEntityPane.lookup((Node)controller.getView()).getEditor();
                EntityReference client = ((BookingFileGeneralParametersFullPanel)((BookingFileMainFullPanel)pane.getMainTile().getFullNode()).getGeneralParametersCard().getContent()).getClientNode().getValue();
                EntityReference blankOwner = view.getGeneralNode().getSalesChainNode().getBlankOwnerValueNode().getValue();
                EntityReference supplier = view.getGeneralNode().getSalesChainNode().getSupplierValueNode().getValue();
                EntityReference agency = view.getGeneralNode().getSalesChainNode().getAgencyValueNode().getValue();
                EntityReference subagency = view.getGeneralNode().getSalesChainNode().getSubagencyValueNode().getValue();
                if (type.equals((Object)ContractType.CLIENT)) {
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), (Object)client));
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)subagency));
                }
                if (type.equals((Object)ContractType.SUBAGENCY)) {
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)agency));
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), (Object)subagency));
                }
                if (type.equals((Object)ContractType.VENDOR)) {
                    contractsByType.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractIndex.Property.vendor.name(), null), SearchCriterion.eq((String)ContractIndex.Property.vendor.name(), (Object)blankOwner)}));
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.supplier.name(), (Object)supplier));
                    contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), (Object)agency));
                }
                contractsByType.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), (Object)true));
                return contractsByType;
            });
        });
        CustomVatContainer vatContainer = view.getCostNode().getInsurancePremiumSumVatNode();
        vatContainer.getVatRateNode().setItemsSupplier(ControllerInterceptorVatHelper.getVatGeneralSupplier());
        ControllerInterceptorVatHelper.configureVatContainer(vatContainer, view.getCostNode().getInsurancePremiumSumNode());
    }

    private void configureGeneralNode(BookingFileProductInsuranceAccidentPanelController controller) {
        BookingFileProductInsuranceAccidentGeneralPanel view = controller.getView().getGeneralNode();
        view.getTicketInfoNode().getBlankValueNode().setConverter(StandardRenderers.DICT_CODE.createStatefulConverter(() -> ((ViewState)view.getTicketInfoNode().getBlankValueNode().getViewState()).isImmutable()));
        GeneralProductFXHelper.configureBlankTypeNodes((DictBoxWidget<BlankType>)view.getTicketInfoNode().getBlankValueNode(), view.getTicketInfoNode().getScnCaptionCell(), (ComplexCell<TextFieldWidget>)view.getTicketInfoNode().getScnValueCell());
        view.getSalesChainNode().getSubagencyValueNode().valueProperty().addListener((obj, oldValue, newValue) -> view.getSalesChainNode().getSalesPointValueNode().setListParametersSupplier(() -> ControllerInterceptorsHelper.getSalesPoints((EntityReference<Organization>)newValue)));
        view.getSalesChainNode().getBlankOwnerValueNode().valueProperty().addListener((obj, oldValue, newValue) -> view.getTicketInfoNode().getBlankValueNode().setListParametersSupplier(() -> ControllerInterceptorsHelper.getBlanTypesForBlankOwner((EntityReference<Organization>)newValue)));
        ComboBoxWidget relatedValueNode = view.getTravelerInfoNode().getRelatedValueNode();
        relatedValueNode.setItemsSupplier(() -> {
            if (controller.getData() != null) {
                return this.getRelatedProducts(controller.getData().getBookingFile());
            }
            RootEntityPane root = RootEntityPane.lookup((Node)controller.getView());
            if (root != null) {
                return this.getRelatedProducts((BookingFile)root.getData().getContainer().getEntity());
            }
            return Collections.emptyList();
        });
        relatedValueNode.setConverter((StringConverter)new StringConverter<BaseProduct>(){

            public String toString(BaseProduct object) {
                return object != null ? BookingHelper.generateShortProductName((BaseProduct)object) : UiUtil.NULL_TEXT;
            }

            public BaseProduct fromString(String string) {
                return null;
            }
        });
        view.getSalesChainNode().getTicketTypeValueNode().valueProperty().addListener((s, o, n) -> {
            view.getTravelerInfoNode().getCorrectionDateCaptionCell().setHidden(n != TicketType.CORRECTION);
            view.getTravelerInfoNode().getCorrectionDateValueCell().setHidden(n != TicketType.CORRECTION);
        });
        BookingFileProductInsuranceAccidentSalesChainPane salesChainNode = view.getSalesChainNode();
        salesChainNode.getBlankOwnerValueNode().setListParametersSupplier(ControllerInterceptorsHelper::getBlankOwners);
        salesChainNode.getAgencyValueNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        salesChainNode.getSubagencyValueNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        salesChainNode.getSupplierValueNode().setListParametersSupplier(ControllerInterceptorsHelper.getAgenciesAndBlankOwnersMulti());
        salesChainNode.getPrescribeAgentValueNode().setListParametersSupplier(() -> {
            EntityReference spRef = salesChainNode.getSalesPointValueNode().getValue();
            return ControllerInterceptorsHelper.getAgentsForSalesPoint((EntityReference<SalesPoint>)spRef);
        });
        BookingFileProductParametersHelper.configureSupplierPoints((EntityBoxWidget<Organization>)salesChainNode.getSubagencyValueNode(), (EntityBoxWidget<SalesPoint>)salesChainNode.getSalesPointValueNode());
        if (!Prefetched.getData().isFindocsEnabled()) {
            view.getTravelerInfoNode().getShipmentsDateCaptionCell().setHidden(true);
            view.getTravelerInfoNode().getShipmentsDateValueCell().setHidden(true);
        }
    }

    private List<BaseProduct> getRelatedProducts(BookingFile bf) {
        if (bf == null) {
            return Collections.emptyList();
        }
        return bf.getReservations().stream().flatMap(reservation -> reservation.getProducts().stream().filter(baseProduct -> {
            String simpleName = baseProduct.getClass().getSimpleName();
            return !simpleName.equals("InsuranceAccident") && !simpleName.equals("InsuranceTouristic") && !simpleName.equals("InsuranceTripCancel");
        })).collect(Collectors.toList());
    }

    protected void beforeWriteData(BookingFileProductInsuranceAccidentPanelController controller, BookingFileProductInsuranceAccidentPanelVM model) {
        model.setProductType(InsuranceAccident.class);
    }

    protected void afterReadData(BookingFileProductInsuranceAccidentPanelController controller, BookingFileProductInsuranceAccidentPanelVM model) {
        ObservableMap properties = controller.getView().getProperties();
        properties.put((Object)"caption", (Object)model.getProductShortName());
        properties.put((Object)"status", (Object)model.getStatus());
        Optional<BaseProductUIData> productUIData = Optional.ofNullable(model.getProductUiData());
        controller.getView().getGeneralNode().getSalesChainNode().getAgencyValueNode().getViewState().setNotEditable(productUIData.map(BaseProductUIData::isHasSubagentRelatedShipment).orElse(false).booleanValue());
        controller.getView().getGeneralNode().getSalesChainNode().getSubagencyValueNode().getViewState().setNotEditable(productUIData.map(data -> data.isHasClientRelatedShipment() || data.isHasSubagentRelatedShipment()).orElse(false).booleanValue());
    }

    protected boolean isDataAclEnforceable() {
        return true;
    }

    protected void enforceDataAcl(BookingFileProductInsuranceAccidentPanelController controller, ViewController<?, DataTransferPackage<?, ?>> rootController, Set<String> deniedPermissions) {
        GridCell accessDeniedCell;
        boolean editGranted;
        String uid = controller.getView().getProperties().get((Object)"model-uid").toString();
        boolean viewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)uid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean bl = editGranted = !deniedPermissions.contains(AclHelper.createPermission((String)uid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        if (!viewGranted) {
            for (GridCell cells : controller.getView().getCells()) {
                cells.setHidden(true);
            }
        }
        if ((accessDeniedCell = (GridCell)controller.getView().getCells().stream().filter(item -> TextUtil.isSame((String)item.getPayload().getId(), (String)ACCESS_DENIED_CELL_ID)).findFirst().orElse(null)) != null) {
            controller.getView().getCells().remove((Object)accessDeniedCell);
        }
        if (!viewGranted) {
            Node node = ContentError.ACCESS_DENIED.createNode(String.format("<p>Entity UID: <code>%s</code></p>", uid));
            node.setId(ACCESS_DENIED_CELL_ID);
            accessDeniedCell = new GridCell(Messages.General_Access_denied1, node);
            controller.getView().getCells().add((Object)accessDeniedCell);
        }
        controller.setAclNotEditable(!editGranted);
        String productSalesPointUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SALES_POINT.getId());
        boolean productSalesPointViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSalesPointUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean productSalesPointEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSalesPointUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getSalesChain().getView().getSalesPointCaptionCell().setHidden(!productSalesPointViewGranted);
        controller.getGeneral().getSalesChain().getView().getSalesPointValueCell().setHidden(!productSalesPointViewGranted);
        controller.getGeneral().getSalesChain().getView().getSalesPointValueNode().getViewState().setAclNotEditable(!productSalesPointEditGranted);
        String productAgentUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_AGENT.getId());
        boolean productAgentViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productAgentUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean productAgentEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productAgentUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getSalesChain().getView().getPrescribeAgentCaptionCell().setHidden(!productAgentViewGranted);
        controller.getGeneral().getSalesChain().getView().getPrescribeAgentValueCell().setHidden(!productAgentViewGranted);
        controller.getGeneral().getSalesChain().getView().getPrescribeAgentValueNode().getViewState().setAclNotEditable(!productAgentEditGranted);
        String productSubagencyUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SUBAGENCY.getId());
        boolean productSubagencyViewGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSubagencyUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.VIEW));
        boolean productSubagencyEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSubagencyUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getSalesChain().getView().getSubagencyCaptionCell().setHidden(!productSubagencyViewGranted);
        controller.getGeneral().getSalesChain().getView().getSubagencyValueCell().setHidden(!productSubagencyViewGranted);
        controller.getGeneral().getSalesChain().getView().getSubagencyValueNode().getViewState().setAclNotEditable(!productSubagencyEditGranted);
        String productClientShipmentsDateUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_CLIENT_SHIPMENTS_DATE.getId());
        boolean productClientShipmentsDateEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productClientShipmentsDateUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getTravelerInfo().getView().getShipmentsDateValueNode().getViewState().setAclNotEditable(!productClientShipmentsDateEditGranted);
        String productSubagentShipmentsDateUid = AclHelper.createCompoundId((String)uid, (String)ModelRestrictionEntityResources.ENTITY_PRODUCT_SUBAGENT_SHIPMENTS_DATE.getId());
        boolean productSubagentShipmentsDateEditGranted = !deniedPermissions.contains(AclHelper.createPermission((String)productSubagentShipmentsDateUid, (RestrictionResourceOperation)StandardRestrictionResourceOperations.EDIT));
        controller.getGeneral().getTravelerInfo().getView().getShipmentsDateSubagentValueNode().getViewState().setAclNotEditable(!productSubagentShipmentsDateEditGranted);
    }
}

