/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.handler;

import com.gridnine.xtrip.client.fx.core.lib.widgets.extendedtable.ExtendedTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelSalesChainPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.HotelProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.HotelVatHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.uidata.HotelProductUIData;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductIndex;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javafx.scene.Node;

public class HotelProductFXHandler
implements ProductFXHandler<HotelProduct, MainHotelProductIndex, HotelProductUIData, Void> {
    @Override
    public HotelProduct getPreviousProduct(HotelProduct product) {
        return product.getPreviousProduct();
    }

    @Override
    public boolean isDeletable(HotelProduct product) {
        return product != null && product.getNextProduct() == null;
    }

    @Override
    public HotelProduct getNextProduct(HotelProduct product) {
        return product.getNextProduct();
    }

    @Override
    public Class<HotelProduct> getProductClass() {
        return HotelProduct.class;
    }

    @Override
    public Class<MainHotelProductIndex> getProductIndexClass() {
        return MainHotelProductIndex.class;
    }

    @Override
    public String getDisplayName() {
        return ProductType.HOTEL_RESERVATION.toString();
    }

    @Override
    public ProductStatus getProductStatus(HotelProduct product) {
        return product.getStatus();
    }

    @Override
    public StatisticalData getStatisticalData(HotelProduct product) {
        return product.getStatisticalData();
    }

    @Override
    public void newStatisticalData(HotelProduct product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public boolean isMultiTraveller() {
        return true;
    }

    @Override
    public void setAgent(HotelProduct product, EntityReference<Person> agent) {
        product.setCashier(agent);
    }

    @Override
    public Collection<Traveller> getTravellers(HotelProduct product) {
        return product.getTravellers();
    }

    @Override
    public void remove(HotelProduct product) {
        if (product.getNextProduct() == null) {
            product.getReservation().getProducts().remove(product);
            HotelProduct previousProduct = product.getPreviousProduct();
            if (previousProduct != null) {
                previousProduct.setNextProduct(null);
            }
        }
    }

    @Override
    public boolean isAwareOf(Node node) {
        return node instanceof BookingFileProductHotelPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node createNodeForNewProduct(BookingFileSpaceVM bookingFileVM, Void configuration, Map<String, Object> parameters) {
        BookingFile bookingFile = (BookingFile)parameters.get("bookingFile");
        Reservation reservation = (Reservation)parameters.get("reservation");
        BookingFileProductHotelPanelVM productVM = new BookingFileProductHotelPanelVM();
        productVM.setBookingFile(bookingFile);
        productVM.setProductFullNameWithSpaces(ProductType.HOTEL_RESERVATION.toString());
        MiscUtil.Pair<HotelProduct, HotelProductUIData> prototypeData = HotelProductFXHelper.getPrototypeData();
        HotelProduct product = (HotelProduct)prototypeData.getFirst();
        HotelProductUIData productSupplementData = (HotelProductUIData)prototypeData.getSecond();
        productVM.setProductUiData((BaseProductUIData)productSupplementData);
        String reservationUid = UUIDUtil.toString((UUID)UUID.randomUUID());
        if (reservation == null) {
            reservation = new Reservation(reservationUid);
        }
        if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
            bookingFile.getReservations().add(reservation);
            reservation.setBookingFile(bookingFile);
        }
        reservation.getProducts().add(product);
        product.setReservation(reservation);
        GeneralProductHelper.fillCommonCostCodes((BookingFile)bookingFile, (BaseProduct)product);
        try {
            this.toVM(product, productSupplementData, (BaseProductVM)productVM, (EntityReference<Organization>)null);
            BookingFileProductHotelPanel node = new BookingFileProductHotelPanel(false);
            node.getProperties().put((Object)"model-uid", (Object)product.getUid());
            HotelProductFXHelper.updateNode(node, bookingFileVM);
            BookingFileProductHotelPanelController controller = new BookingFileProductHotelPanelController(node, false);
            controller.readData(productVM);
            BookingFileProductHotelPanel bookingFileProductHotelPanel = node;
            return bookingFileProductHotelPanel;
        }
        finally {
            reservation.getProducts().remove(product);
            product.setReservation(null);
            if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
                bookingFile.getReservations().remove(reservation);
                reservation.setBookingFile(null);
            }
        }
    }

    @Override
    public Node createNodeForExistingProduct(BookingFileSpaceVM bookingFileVM, Map<String, Object> parameters) {
        BookingFileProductHotelPanel node = new BookingFileProductHotelPanel(false);
        HotelProductFXHelper.updateNode(node, bookingFileVM);
        return node;
    }

    @Override
    public HotelProduct createProduct() {
        return new HotelProduct();
    }

    @Override
    public HotelProductUIData createUiData() {
        return new HotelProductUIData();
    }

    @Override
    public BaseProductVM createVM(HotelProduct product) {
        return new BookingFileProductHotelPanelVM();
    }

    @Override
    public String getRecordLocator(BaseProductVM vm) {
        return ((BookingFileProductHotelPanelVM)vm).getGeneral().getTravelerInfo().getResNumberValue();
    }

    @Override
    public void toVM(HotelProduct product, HotelProductUIData productData, BaseProductVM vm, EntityReference<Organization> customerProfile) {
        List<ReasonCodeType> reasonCodes = Arrays.asList(ReasonCodeType.REASON_CODE_HOTEL, ReasonCodeType.REASON_CODE_DECLINED, ReasonCodeType.REASON_CODE_NO_HOTEL);
        BookingFileProductHotelPanelVM productVM = (BookingFileProductHotelPanelVM)vm;
        HotelProductFXHelper.toVMRoom(product, productData, productVM);
        HotelProductFXHelper.toVMParameters(product, productData, productVM);
        HotelProductFXHelper.toVMCostParameters(product, productData, productVM.getCost());
        HotelVatHelper helper = (HotelVatHelper)ReflectionUtil.createBySystemPropertyName((ClassLoader)this.getClass().getClassLoader(), (String)"client.fx.hotels.hotelproduct.helpers.HotelVatHelper", null, HotelVatHelper::new);
        helper.setVat(productVM.getCost(), product);
        HotelProductFXHelper.toVMPenalty(product, productVM);
        HotelProductFXHelper.toVMAdditional(product, productVM);
        GeneralProductFXHelper.toVMProductFop((BaseProduct)product, (BaseProductUIData)productData, productVM.getFops());
        GeneralProductFXHelper.toVMProductContract((BaseProductUIData)productData, productVM.getFops().getContract());
        GeneralProductFXHelper.toVMPrepaymentDocuments((BaseProductUIData)productData, productVM.getFops().getPrepaymentDocuments());
        GeneralProductFXHelper.toVMVendorFinanceDocumentsData((BaseProductUIData)productData, productVM.getFops().getVendorFinanceDocumentsData());
        GeneralProductFXHelper.toVMProductCommissions((BaseProduct)product, (BaseProductUIData)productData, productVM.getCommissions());
        GeneralProductFXHelper.toVMProductStatistic(product.getStatisticalData(), (BaseProductUIData)productData, reasonCodes, HotelProduct.class, productVM.getOtherParameters().getStatistic(), customerProfile);
        GeneralProductFXHelper.toVMValidationMessages(product.getValidationMessages(), product.getUid(), productVM.getOtherParameters().getValidation());
    }

    @Override
    public void fromVM(BaseProductVM vm, HotelProduct product, HotelProductUIData productData) {
        HotelProductFXHelper.fillBasicProductFields(product, productData);
        BookingFileProductHotelPanelVM productVM = (BookingFileProductHotelPanelVM)vm;
        HotelProductFXHelper.fromVMParameters(productVM, product, productData);
        HotelProductFXHelper.fromVMCost(productVM.getCost(), product);
        HotelProductFXHelper.fromVMPenalty(productVM, product);
        HotelProductFXHelper.fromVMRoom(productVM, product);
        HotelProductFXHelper.fromVMAdditional(productVM.getOtherParameters().getAdditional(), product);
        GeneralProductFXHelper.fromVMFop((BaseProduct)product, productVM.getFops(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMProductContract(productVM.getFops().getContract(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMCommissions((BaseProduct)product, productVM.getCommissions(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMVendorFinanceDocumentsData(productVM.getFops().getVendorFinanceDocumentsData(), (BaseProductUIData)productData);
        StatisticalData data = product.getStatisticalData();
        if (data == null) {
            data = new StatisticalData();
            product.setStatisticalData(data);
        }
        GeneralProductFXHelper.fromVMProductStatistic(product.getReservation().getBookingFile(), productVM.getOtherParameters().getStatistic(), data, (BaseProductUIData)productData);
    }

    @Override
    public ProductType getProductType(HotelProduct product) {
        return ProductType.HOTEL_RESERVATION;
    }

    @Override
    public Set<ContractType> getHiddenContractTypes(Node node) {
        BookingFileProductHotelSalesChainPane paramsPane = ((BookingFileProductHotelPanel)node).getGeneralNode().getSalesChainNode();
        return GeneralProductFXHelper.getHiddenContractTypes((EntityReference<Organization>)paramsPane.getAgencyValueNode().getValue(), (EntityReference<Organization>)paramsPane.getSubagencyValueNode().getValue());
    }

    @Override
    public void validate(String uid, Node node, List<Message> errors) {
        if (node instanceof BookingFileProductHotelPanel) {
            BookingFileProductHotelPanel panel = (BookingFileProductHotelPanel)node;
            String systemNumber = panel.getGeneralNode().getTicketInfoNode().getTicketNumberValueNode().getValue();
            boolean emptyPaymentType = ((ExtendedTableWidget)panel.getFopsNode().getFopTableCell().getPayload()).getTable().getRows().stream().anyMatch(item -> ((ComboBoxWidget)item.getWidget("paymentType")).getValue() == null);
            if (emptyPaymentType) {
                errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProductPaymentTypeIsEmpty, (Object[])new Object[]{systemNumber}));
            }
        }
    }

    @Override
    public void validateStatisticalData(BookingFileSpace space, String uid, Node node, List<Message> errors) throws Exception {
        if (node instanceof BookingFileProductHotelPanel) {
            BookingFileProductHotelPanel panel = (BookingFileProductHotelPanel)node;
            Collection statisticUdidsVMS = ((TableWidget)((BookingFileProductStatistic)panel.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getUdidsCard().getContent()).getRowsData();
            GeneralProductFXHelper.validateStatisticalData(space, uid, statisticUdidsVMS, errors);
        }
    }
}

