/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.handler;

import com.gridnine.xtrip.client.fx.core.lib.widgets.extendedtable.ExtendedTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceTouristicPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceTouristicPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceTouristicPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceTouristicSalesChainPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.InsuranceTouristicFXHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicHelper;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicIndex;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.InsuranceUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javafx.scene.Node;

public class InsuranceTouristicFXHandler
implements ProductFXHandler<InsuranceTouristic, InsuranceTouristicIndex, InsuranceUIData, Void> {
    @Override
    public Class<InsuranceTouristic> getProductClass() {
        return InsuranceTouristic.class;
    }

    @Override
    public Class<InsuranceTouristicIndex> getProductIndexClass() {
        return InsuranceTouristicIndex.class;
    }

    @Override
    public String getDisplayName() {
        return ProductType.INSURANCE_TOURISTIC.toString();
    }

    @Override
    public void remove(InsuranceTouristic product) {
        InsuranceTouristicHelper.removeProduct((InsuranceTouristic)product, (boolean)true);
    }

    @Override
    public InsuranceTouristic getPreviousProduct(InsuranceTouristic product) {
        return product.getPreviousProduct();
    }

    @Override
    public InsuranceTouristic getNextProduct(InsuranceTouristic product) {
        return product.getNextProduct();
    }

    @Override
    public ProductStatus getProductStatus(InsuranceTouristic product) {
        return product.getStatus();
    }

    @Override
    public StatisticalData getStatisticalData(InsuranceTouristic product) {
        return product.getStatisticalData();
    }

    @Override
    public void newStatisticalData(InsuranceTouristic product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public boolean isMultiTraveller() {
        return true;
    }

    @Override
    public void setAgent(InsuranceTouristic product, EntityReference<Person> agent) {
        product.setAgent(agent);
    }

    @Override
    public Collection<Traveller> getTravellers(InsuranceTouristic product) {
        LinkedHashSet<Traveller> lst = new LinkedHashSet<Traveller>();
        Traveller traveller = GeneralProductFXHelper.findTraveller(product.getReservation().getBookingFile(), product.getPolicyHolderUid());
        if (traveller != null) {
            lst.add(traveller);
        }
        for (String travellerUid : product.getTravellersUids()) {
            traveller = GeneralProductFXHelper.findTraveller(product.getReservation().getBookingFile(), travellerUid);
            if (traveller == null) continue;
            lst.add(traveller);
        }
        return lst;
    }

    @Override
    public InsuranceTouristic createProduct() {
        return new InsuranceTouristic();
    }

    @Override
    public InsuranceUIData createUiData() {
        return new InsuranceUIData();
    }

    @Override
    public BaseProductVM createVM(InsuranceTouristic product) {
        return new BookingFileProductInsuranceTouristicPanelVM();
    }

    @Override
    public String getRecordLocator(BaseProductVM vm) {
        return ((BookingFileProductInsuranceTouristicPanelVM)vm).getGeneral().getTicketInfo().getReservationValue();
    }

    @Override
    public void toVM(InsuranceTouristic product, InsuranceUIData productData, BaseProductVM vm, EntityReference<Organization> customerProfile) {
        List<ReasonCodeType> reasonCodes = Arrays.asList(ReasonCodeType.REASON_CODE_INSURANCE_TOURISTIC, ReasonCodeType.REASON_CODE_DECLINED, ReasonCodeType.REASON_CODE_NO_HOTEL);
        BookingFileProductInsuranceTouristicPanelVM productVM = (BookingFileProductInsuranceTouristicPanelVM)vm;
        productVM.setStatus(product.getStatus());
        InsuranceTouristicFXHelper.toVM(productVM, product, productData);
        GeneralProductFXHelper.toVMProductFop((BaseProduct)product, (BaseProductUIData)productData, productVM.getFops());
        GeneralProductFXHelper.toVMProductContract((BaseProductUIData)productData, productVM.getFops().getContract());
        GeneralProductFXHelper.toVMPrepaymentDocuments((BaseProductUIData)productData, productVM.getFops().getPrepaymentDocuments());
        GeneralProductFXHelper.toVMVendorFinanceDocumentsData((BaseProductUIData)productData, productVM.getFops().getVendorFinanceDocumentsData());
        GeneralProductFXHelper.toVMProductCommissions((BaseProduct)product, (BaseProductUIData)productData, productVM.getCommissions());
        GeneralProductFXHelper.toVMProductStatistic(product.getStatisticalData(), (BaseProductUIData)productData, reasonCodes, InsuranceTouristic.class, productVM.getOtherParameters().getStatistic(), customerProfile);
        GeneralProductFXHelper.toVMValidationMessages(product.getValidationMessages(), product.getUid(), productVM.getOtherParameters().getValidation());
    }

    @Override
    public boolean isAwareOf(Node node) {
        return node instanceof BookingFileProductInsuranceTouristicPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node createNodeForNewProduct(BookingFileSpaceVM bookingFileVM, Void configuration, Map<String, Object> parameters) {
        BookingFile bookingFile = (BookingFile)parameters.get("bookingFile");
        Reservation reservation = (Reservation)parameters.get("reservation");
        BookingFileProductInsuranceTouristicPanelVM productVM = new BookingFileProductInsuranceTouristicPanelVM();
        productVM.setBookingFile(bookingFile);
        productVM.setProductFullNameWithSpaces(ProductType.INSURANCE_TOURISTIC.toString());
        MiscUtil.Pair<InsuranceTouristic, InsuranceUIData> prototypeData = InsuranceTouristicFXHelper.getPrototypeData();
        InsuranceTouristic product = (InsuranceTouristic)prototypeData.getFirst();
        InsuranceUIData productSupplementData = (InsuranceUIData)prototypeData.getSecond();
        productVM.setProductUiData((BaseProductUIData)productSupplementData);
        String reservationUid = UUIDUtil.toString((UUID)UUID.randomUUID());
        if (reservation == null) {
            reservation = new Reservation(reservationUid);
        }
        if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
            bookingFile.getReservations().add(reservation);
            reservation.setBookingFile(bookingFile);
        }
        reservation.getProducts().add(product);
        product.setReservation(reservation);
        GeneralProductHelper.fillCommonCostCodes((BookingFile)bookingFile, (BaseProduct)product);
        try {
            this.toVM(product, productSupplementData, (BaseProductVM)productVM, (EntityReference<Organization>)null);
            BookingFileProductInsuranceTouristicPanel node = new BookingFileProductInsuranceTouristicPanel(false);
            node.getProperties().put((Object)"model-uid", (Object)product.getUid());
            InsuranceTouristicFXHelper.updateNode(node, bookingFileVM);
            BookingFileProductInsuranceTouristicPanelController controller = new BookingFileProductInsuranceTouristicPanelController(node, false);
            controller.readData(productVM);
            BookingFileProductInsuranceTouristicPanel bookingFileProductInsuranceTouristicPanel = node;
            return bookingFileProductInsuranceTouristicPanel;
        }
        finally {
            reservation.getProducts().remove(product);
            product.setReservation(null);
            if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
                bookingFile.getReservations().remove(reservation);
                reservation.setBookingFile(null);
            }
        }
    }

    @Override
    public Node createNodeForExistingProduct(BookingFileSpaceVM bookingFileVM, Map<String, Object> parameters) {
        BookingFileProductInsuranceTouristicPanel node = new BookingFileProductInsuranceTouristicPanel(false);
        InsuranceTouristicFXHelper.updateNode(node, bookingFileVM);
        return node;
    }

    @Override
    public void fromVM(BaseProductVM vm, InsuranceTouristic product, InsuranceUIData productData) {
        BookingFileProductInsuranceTouristicPanelVM productVM = (BookingFileProductInsuranceTouristicPanelVM)vm;
        InsuranceTouristicFXHelper.fromVM(productVM, product, productData);
        GeneralProductFXHelper.fromVMFop((BaseProduct)product, productVM.getFops(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMProductContract(productVM.getFops().getContract(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMCommissions((BaseProduct)product, productVM.getCommissions(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMVendorFinanceDocumentsData(productVM.getFops().getVendorFinanceDocumentsData(), (BaseProductUIData)productData);
        StatisticalData data = product.getStatisticalData();
        if (data == null) {
            data = new StatisticalData();
            product.setStatisticalData(data);
        }
        GeneralProductFXHelper.fromVMProductStatistic(product.getReservation().getBookingFile(), productVM.getOtherParameters().getStatistic(), data, (BaseProductUIData)productData);
        product.setStatisticalData(data);
    }

    @Override
    public ProductType getProductType(InsuranceTouristic product) {
        return ProductType.INSURANCE_TOURISTIC;
    }

    @Override
    public Set<ContractType> getHiddenContractTypes(Node node) {
        BookingFileProductInsuranceTouristicSalesChainPane salesChainPane = ((BookingFileProductInsuranceTouristicPanel)node).getGeneralNode().getSalesChainNode();
        return GeneralProductFXHelper.getHiddenContractTypes((EntityReference<Organization>)salesChainPane.getAgencyValueNode().getValue(), (EntityReference<Organization>)salesChainPane.getSubagencyValueNode().getValue());
    }

    @Override
    public void validate(String uid, Node node, List<Message> errors) {
        BookingFileProductInsuranceTouristicPanel panel = (BookingFileProductInsuranceTouristicPanel)node;
        String systemNumber = panel.getGeneralNode().getTicketInfoNode().getTicketNumberValueNode().getValue();
        boolean emptyPaymentType = ((ExtendedTableWidget)panel.getFopsNode().getFopTableCell().getPayload()).getTable().getRows().stream().anyMatch(item -> ((ComboBoxWidget)item.getWidget("paymentType")).getValue() == null);
        if (emptyPaymentType) {
            errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProductPaymentTypeIsEmpty, (Object[])new Object[]{systemNumber}));
        }
    }

    @Override
    public void validateStatisticalData(BookingFileSpace space, String uid, Node node, List<Message> errors) throws Exception {
        if (node instanceof BookingFileProductInsuranceTouristicPanel) {
            BookingFileProductInsuranceTouristicPanel panel = (BookingFileProductInsuranceTouristicPanel)node;
            Collection statisticUdidsVMS = ((TableWidget)((BookingFileProductStatistic)panel.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getUdidsCard().getContent()).getRowsData();
            GeneralProductFXHelper.validateStatisticalData(space, uid, statisticUdidsVMS, errors);
        }
    }
}

