/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.handler;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductMCOFeesPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductMCOFeesPanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductMCOFeesPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductMCOFeesSelectSourcePanelController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductMCOFeesSelectSourcePanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductMCOFeesSource;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.McoFeesFXHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.MCOFees;
import com.gridnine.xtrip.common.model.booking.MCOFeesIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.BooleanUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.collections.ObservableMap;
import javafx.scene.Node;

public class McoFeesFXHandler
implements ProductFXHandler<MCOFees, MCOFeesIndex, BaseProductUIData, McoFeesFXHelper.Configuration> {
    @Override
    public Class<MCOFees> getProductClass() {
        return MCOFees.class;
    }

    @Override
    public Class<MCOFeesIndex> getProductIndexClass() {
        return MCOFeesIndex.class;
    }

    @Override
    public BaseProductUIData createUiData() {
        return new BaseProductUIData();
    }

    @Override
    public MCOFees createProduct() {
        return new MCOFees();
    }

    @Override
    public BaseProductVM createVM(MCOFees product) {
        return new BookingFileProductMCOFeesPanelVM();
    }

    @Override
    public void toVM(MCOFees product, BaseProductUIData uiData, BaseProductVM vm, EntityReference<Organization> customerProfile) {
        BookingFileProductMCOFeesPanelVM parentVM = (BookingFileProductMCOFeesPanelVM)vm;
        List<ReasonCodeType> reasonCodes = Arrays.asList(ReasonCodeType.REASON_CODE_HOTEL, ReasonCodeType.REASON_CODE_DECLINED, ReasonCodeType.REASON_CODE_NO_HOTEL);
        parentVM.setReservationUid(product.getReservation().getUid());
        parentVM.setStatus(product.getStatus());
        McoFeesFXHelper.toVMChildParameters(parentVM.getGeneral(), product, uiData, parentVM.getStatuses());
        McoFeesFXHelper.toVMAdditionalParameters(parentVM, product);
        GeneralProductFXHelper.toVMProductStatistic(product.getStatisticalData(), uiData, reasonCodes, MCOFees.class, parentVM.getOtherParameters().getStatistic(), customerProfile);
        GeneralProductFXHelper.toVMValidationMessages(product.getValidationMessages(), product.getUid(), parentVM.getOtherParameters().getValidation());
    }

    @Override
    public String getDisplayName() {
        return ProductType.MCO_FEES.toString();
    }

    @Override
    public void fromVM(BaseProductVM vm, MCOFees product, BaseProductUIData uiData) {
        BookingFileProductMCOFeesPanelVM parentVM = (BookingFileProductMCOFeesPanelVM)vm;
        if (product.getStatus() == null) {
            product.setStatus(ProductStatus.SELL);
        }
        McoFeesFXHelper.fromVMChildParameters(parentVM.getGeneral(), product, uiData, parentVM.getStatuses());
        McoFeesFXHelper.fromVMAdditionalParameters(parentVM, product);
        StatisticalData data = product.getStatisticalData();
        if (data == null) {
            data = new StatisticalData();
            product.setStatisticalData(data);
        }
        GeneralProductFXHelper.fromVMProductStatistic(product.getReservation().getBookingFile(), parentVM.getOtherParameters().getStatistic(), data, uiData);
    }

    @Override
    public String getRecordLocator(BaseProductVM vm) {
        return ((BookingFileProductMCOFeesPanelVM)vm).getReservationUid();
    }

    @Override
    public boolean isAwareOf(Node node) {
        return node instanceof BookingFileProductMCOFeesPanel;
    }

    @Override
    public Consumer<Consumer<McoFeesFXHelper.Configuration>> createConfigurator(Map<String, Object> parameters) {
        return creator -> {
            BookingFileProductMCOFeesSelectSourcePanelController sourceController = new BookingFileProductMCOFeesSelectSourcePanelController(false);
            BookingFileProductMCOFeesSelectSourcePanelVM sourceModel = new BookingFileProductMCOFeesSelectSourcePanelVM();
            ReadOnlyIntegerWrapper selectedSourcesCount = new ReadOnlyIntegerWrapper(0);
            sourceController.getView().getSourcesNode().setOnRowsAction(evt -> {
                if (evt.getEventType() == TableRowEvent.ROW_ADD) {
                    BooleanValueWidget selectWidget = (BooleanValueWidget)sourceController.getView().getSourcesNode().getColumn("select").getWidget(evt.getRowIndex().intValue());
                    if (selectWidget.getValue()) {
                        selectedSourcesCount.set(selectedSourcesCount.getValue() + 1);
                    }
                    selectWidget.valueProperty().addListener((observable, oldValue, newValue) -> selectedSourcesCount.set(selectedSourcesCount.getValue() + (newValue != false ? 1 : -1)));
                }
            });
            ComboBoxWidgetColumn mcoFeesSourceCol = (ComboBoxWidgetColumn)sourceController.getView().getSourcesNode().getColumn("mcoFeesSource");
            mcoFeesSourceCol.setConverter(McoFeesFXHelper.getMcoFeesSourceConverter());
            EntityReference bookingFileReference = (EntityReference)parameters.get("reference");
            Node bookingFileSpace = (Node)parameters.get("bookingFileSpace");
            ObservableMap properties = Optional.ofNullable(((CompactNavigatorWidget)((BookingFileProductsFullPanel)((BookingFileSpace)bookingFileSpace).getProductsTile().getFullNode()).getContent()).getSelectedView()).map(Node::getProperties).orElse(null);
            String selectedProductUid = properties != null ? (String)properties.get((Object)"model-uid") : null;
            boolean preselectProduct = properties != null && BooleanUtil.nullAsFalse((Boolean)((Boolean)properties.get((Object)"select-product")));
            new Dialog().setTitle(Messages.MCOFees).setExpandToParent(true).setBody((Node)sourceController.getView()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Create, () -> {
                sourceController.writeData(sourceModel);
                McoFeesFXHelper.Configuration config = new McoFeesFXHelper.Configuration();
                config.setSources(sourceModel.getSources().stream().filter(BookingFileProductMCOFeesSource::isSelect).map(BookingFileProductMCOFeesSource::getMcoFeesSource).collect(Collectors.toList()));
                creator.accept(config);
            }, (BooleanExpression)selectedSourcesCount.greaterThan(0)).show(bookingFileSpace);
            Notifications.get().submitTask(() -> {
                List bookingSources = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).findMCOFeesSources(ServiceInvocationContext.get(), bookingFileReference);
                sourceModel.getSources().addAll(bookingSources.stream().map(source -> {
                    BookingFileProductMCOFeesSource result = new BookingFileProductMCOFeesSource();
                    result.setFare(source.getFare());
                    result.setMcoFeesSource(source);
                    result.setSelect(preselectProduct && MiscUtil.equals((Object)source.getProductUid(), (Object)selectedProductUid));
                    return result;
                }).collect(Collectors.toList()));
                FxUtil.submitToFxThread(() -> sourceController.readData(sourceModel));
            }, Messages.Loading_data);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node createNodeForNewProduct(BookingFileSpaceVM bookingFileVM, McoFeesFXHelper.Configuration configuration, Map<String, Object> parameters) {
        BookingFile bookingFile = (BookingFile)parameters.get("bookingFile");
        Reservation reservation = (Reservation)parameters.get("reservation");
        BookingFileProductMCOFeesPanelVM productVM = new BookingFileProductMCOFeesPanelVM();
        productVM.setBookingFile(bookingFile);
        productVM.setProductFullNameWithSpaces(ProductType.MCO_FEES.toString());
        MiscUtil.Pair<MCOFees, BaseProductUIData> prototypeData = McoFeesFXHelper.getPrototypeData();
        MCOFees product = (MCOFees)prototypeData.getFirst();
        BaseProductUIData productSupplementData = (BaseProductUIData)prototypeData.getSecond();
        productVM.setProductUiData(productSupplementData);
        Map<String, BaseProduct> bookingProducts = bookingFile.getReservations().stream().flatMap(res -> res.getProducts().stream()).collect(Collectors.toMap(BaseIdentity::getUid, pr -> pr));
        String reservationUid = UUIDUtil.toString((UUID)UUID.randomUUID());
        if (reservation == null) {
            reservation = new Reservation(reservationUid);
        }
        if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
            bookingFile.getReservations().add(reservation);
            reservation.setBookingFile(bookingFile);
        }
        reservation.getProducts().add(product);
        product.setReservation(reservation);
        GeneralProductHelper.fillCommonCostCodes((BookingFile)bookingFile, (BaseProduct)product);
        try {
            product.getSources().clear();
            product.getSources().addAll(configuration.getSources());
            product.setTotal(McoFeesFXHelper.calculateTotalFromProductSources(product.getSources()));
            String travellerUid = product.getSources().stream().map(item -> (BaseProduct)bookingProducts.get(item.getProductUid())).flatMap(item -> ProductFXHandler.forProduct(item).getTravellers((BaseProduct)item).stream()).findFirst().map(item -> item.getUid()).orElse(null);
            product.setTravellerUid(travellerUid);
            this.toVM(product, productSupplementData, (BaseProductVM)productVM, (EntityReference<Organization>)null);
            BookingFileProductMCOFeesPanel node = new BookingFileProductMCOFeesPanel(false);
            node.getProperties().put((Object)"model-uid", (Object)product.getUid());
            McoFeesFXHelper.updateNode(node, bookingFileVM);
            BookingFileProductMCOFeesPanelController controller = new BookingFileProductMCOFeesPanelController(node, false);
            controller.readData(productVM);
            BookingFileProductMCOFeesPanel bookingFileProductMCOFeesPanel = node;
            return bookingFileProductMCOFeesPanel;
        }
        finally {
            reservation.getProducts().remove(product);
            product.setReservation(null);
            if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
                bookingFile.getReservations().remove(reservation);
                reservation.setBookingFile(null);
            }
        }
    }

    @Override
    public Node createNodeForExistingProduct(BookingFileSpaceVM bookingFileVM, Map<String, Object> parameters) {
        BookingFileProductMCOFeesPanel node = new BookingFileProductMCOFeesPanel(false);
        McoFeesFXHelper.updateNode(node, bookingFileVM);
        return node;
    }

    @Override
    public MCOFees getPreviousProduct(MCOFees product) {
        return null;
    }

    @Override
    public MCOFees getNextProduct(MCOFees product) {
        return null;
    }

    @Override
    public ProductStatus getProductStatus(MCOFees product) {
        return ProductStatus.SELL;
    }

    @Override
    public void remove(MCOFees product) {
        product.getReservation().getProducts().remove(product);
    }

    @Override
    public StatisticalData getStatisticalData(MCOFees product) {
        return product.getStatisticalData();
    }

    @Override
    public void newStatisticalData(MCOFees product) {
        product.setStatisticalData(new StatisticalData());
    }

    @Override
    public Collection<Traveller> getTravellers(MCOFees product) {
        return null;
    }

    @Override
    public void setAgent(MCOFees product, EntityReference<Person> agent) {
        product.setAgent(agent);
    }

    @Override
    public ProductType getProductType(MCOFees product) {
        return ProductType.MCO_FEES;
    }

    @Override
    public Set<ContractType> getHiddenContractTypes(Node node) {
        return Collections.emptySet();
    }

    @Override
    public void validate(String uid, Node node, List<Message> errors) {
    }

    @Override
    public void validateStatisticalData(BookingFileSpace space, String uid, Node node, List<Message> errors) throws Exception {
    }
}

