/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.model.booking.AirSegmentLuggageDimensionsPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.AirSegmentLuggageExtendedDimensionsPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.AirSegmentLuggageValuePaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileAirSegmentVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirCostPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirCostSumPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirFeesAndChargesRowVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirOBFeesRowVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirOtherParametersPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirSalesChainPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirSegmentAdditionalsPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirSegmentFreeLuggageInfoPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirSegmentSsrVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirSegmentTechStopVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirStatusesPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirTariffComponentsRowVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirTicketInfoPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirTravelerInfoPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirVatDetailsRowVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAviaCharterQuotaBindingVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductBagageOtherParametersPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductBagagePanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductBagagePanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductBagageRelatedProductsTableVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductBagageRelatedProductsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductEMDOtherParametersPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductEMDPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductEMDPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductEMDRelatedProductsTableVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductEMDRelatedProductsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductEMDSegmentAdditionalsPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductFopCardsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductFopTableVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductRatesPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticAfs;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.model.booking.SegmentsData;
import com.gridnine.xtrip.client.fx.model.booking.air.BookingFileProductAviaAdditionalsDiscountVM;
import com.gridnine.xtrip.client.fx.model.booking.air.BookingFileProductAviaAdditionalsReportsVM;
import com.gridnine.xtrip.client.fx.model.booking.air.BookingFileProductAviaAdditionalsTariffVM;
import com.gridnine.xtrip.client.fx.model.booking.air.BookingFileProductAviaCharterBackwardQuotaVM;
import com.gridnine.xtrip.client.fx.model.booking.air.BookingFileProductAviaCharterForwardQuotaVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.rpc.StandardProductPrototypeService;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SpecialServiceRequest;
import com.gridnine.xtrip.common.model.booking.TechStopInfo;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.booking.air.OBFee;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.booking.air.uidata.AirProductUIData;
import com.gridnine.xtrip.common.model.booking.air.uidata.SegmentUIData;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.uidata.CommissionsDiscountsFeesUIDataHandler;
import com.gridnine.xtrip.common.model.booking.uidata.ProductFopUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.gds.ExtendedLuggageInfo;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Card;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendix;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterQuotaReference;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterTariffInfo;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.scene.Node;

public class AirProductFXHelper {
    private static BigDecimal getValue(BigDecimal value, boolean negate) {
        if (value == null) {
            return null;
        }
        return negate ? value.negate() : value;
    }

    public static void toVMAirMainParameters(Product product, AirProductUIData productData, String recordLocator, BookingFileProductAirPanelVM productPaneVM) {
        AirProductFXHelper.toVMAirTicketInformation(product, productData, productPaneVM.getGeneral().getTicketInfo());
        AirProductFXHelper.toVMAirTravelerInformation(product, productData, recordLocator, productPaneVM.getGeneral().getTravelerInfo());
        AirProductFXHelper.toVMAirSalesChain(product, productData, productPaneVM.getGeneral().getSalesChain());
        AirProductFXHelper.toVMAirControlStatuses(product, productData, productPaneVM.getStatuses());
    }

    private static void toVMAirTicketInformation(Product product, AirProductUIData productData, BookingFileProductAirTicketInfoPaneVM vm) {
        String productType = AirProductFXHelper.getProductType(product);
        vm.setProductValue(productType == null ? ProductType.AIR_TICKET.toString() : productType);
        vm.getValidatingCarrierValue().setCarrier(product.getCarrier());
        vm.getValidatingCarrierValue().setCarrierNumber(productData.getValidatingCarrierAirlineNumber());
        vm.setTicketNumberValue(product.getSystemNumber());
        vm.setScnValue(String.join((CharSequence)",", product.getScns()));
        vm.setRelatedTicketsValue(product.getConjCount());
        if (product.getStatus() != null) {
            vm.setStatusValue(product.getStatus().toString());
        }
        vm.setBlankValue(product.getBlankType());
        vm.setOperationDateValue(DateUtils.asLocalDateTime((Date)product.getIssueDate()));
        vm.setSalesOriginProviderValue(product.getSalesOriginProvider());
        vm.setSalesOriginContentValue(product.getSalesOriginContent());
        vm.setCorrectionDateValue(DateUtils.asLocalDateTime((Date)product.getCorrectionDate()));
    }

    private static void toVMAirTravelerInformation(Product product, AirProductUIData productData, String recordLocator, BookingFileProductAirTravelerInfoPaneVM vm) {
        vm.setTransferTypeValue(productData.getTransportationType());
        vm.setShipmentsDateValue(MiscUtil.toLocalDateTime((Date)product.getShipmentsDate()));
        vm.setShipmentsDateSubagentValue(MiscUtil.toLocalDateTime((Date)product.getShipmentsDateSubagent()));
        vm.setTariffTypeValue(product.getTariffType());
        vm.setTourCodeValue(product.getTourCode());
        vm.setPccValue(product.getPcc());
        vm.setBookingValue(recordLocator);
        vm.setPassengerValue(product.getTraveller());
        vm.setPassengerTypeValue(product.getPassengerType());
        vm.setContractCodeValue(product.getTripartiteContractDetails().getContractCode());
    }

    private static void toVMBagageTravelerInformation(Product product, AirProductUIData productData, String recordLocator, BookingFileProductAirTravelerInfoPaneVM vm) {
        vm.setTransferTypeValue(productData.getTransportationType());
        vm.setShipmentsDateValue(MiscUtil.toLocalDateTime((Date)product.getShipmentsDate()));
        vm.setShipmentsDateSubagentValue(MiscUtil.toLocalDateTime((Date)product.getShipmentsDateSubagent()));
        vm.setTariffTypeValue(product.getTariffType());
        vm.setPccValue(product.getPcc());
        vm.setBookingValue(recordLocator);
        vm.setTourCodeValue(product.getTourCode());
        vm.setPassengerValue(product.getTraveller());
        vm.setPassengerTypeValue(product.getPassengerType());
        vm.setContractCodeValue(product.getTripartiteContractDetails().getContractCode());
        vm.getBagageLuggageValue().setAmount(product.getLuggageWeight());
        vm.getBagageLuggageValue().setUnit(product.getLuggageUnits());
    }

    private static void toVMAirSalesChain(Product product, AirProductUIData productData, BookingFileProductAirSalesChainPaneVM vm) {
        vm.getBlankOwnerValue().setBlankOwnerAirlineNumber(productData.getBlankOwnerAirlineNumber());
        vm.getBlankOwnerValue().setAirlineCode(productData.getBlankOwnerAirlineCode());
        vm.getBlankOwnerValue().setBlankOwnerCode(product.getBlankOwnerRef());
        vm.setSupplierValue(productData.getSupplier());
        vm.setAgencyValue(productData.getAgency());
        vm.setSubagencyValue(productData.getSubagency());
        vm.setBranchValue(product.getBranch());
        vm.setSalesPointValue(product.getSalesPoint());
        vm.setPrescribeAgentValue(product.getCashier());
        vm.getValidatorValue().setCode(product.getValidatorCode());
        vm.getValidatorValue().setReference(product.getValidatorRef());
        vm.setTicketTypeValue(product.getTicketType());
        vm.setTechnicalProviderValue(productData.getTechnicalProvider());
    }

    private static void toVMAirControlStatuses(Product product, AirProductUIData productData, BookingFileProductAirStatusesPaneVM controlStatuses) {
        controlStatuses.setChecked(product.isChecked());
        controlStatuses.setFinished(product.isCompleted());
        controlStatuses.setHasErrors(productData.isHasErrors());
        controlStatuses.setHasWarnings(productData.isHasWarnings());
        controlStatuses.setDuplicate(product.isDuplicate());
        controlStatuses.setRulesApplied(product.isContractRulesApplied());
        controlStatuses.setForcedRefund(product.isForcedRefund());
        if (product.getVendorVatDetalization() != null) {
            controlStatuses.setVatSpecified(product.getVendorVatDetalization().isDetalized());
        } else {
            controlStatuses.setVatSpecified(false);
        }
    }

    public static void toVMAirSegments(Product product, AirProductUIData productData, List<BookingFileAirSegmentVM> vms) {
        AirProductFXHelper.toVMAirSegments(product.getSegmentTariffs(), product.getProductCategory(), productData.getSegmentsUIDataList(), vms);
    }

    public static void toVMAirSegments(List<SegmentTariff> segmentTariffs, ProductCategory productCategory, List<SegmentUIData> segmentUIDataList, List<BookingFileAirSegmentVM> vms) {
        for (SegmentTariff tariff : segmentTariffs) {
            boolean first = true;
            for (Segment segment : tariff.getSegments()) {
                AirSegmentLuggageExtendedDimensionsPaneVM extendedDimensions;
                AirSegmentLuggageDimensionsPaneVM freeCabinLuggageInfoDimensions;
                AirSegmentLuggageValuePaneVM freeCabinLuggageInfoWeight;
                ExtendedLuggageInfo cabinLuggageInfo;
                AirSegmentLuggageExtendedDimensionsPaneVM extendedDimensions2;
                AirSegmentLuggageDimensionsPaneVM freeLuggageInfoDimensions;
                AirSegmentLuggageValuePaneVM freeLuggageInfoWeight;
                ExtendedLuggageInfo luggageInfo;
                FareDetails fareDetails;
                AirSegmentLuggageValuePaneVM pqInfoValue;
                LuggageInfo luggageInfo2;
                BookingFileProductAirSegmentFreeLuggageInfoPaneVM freeLuggageInfo;
                BookingFileProductAirSegmentSsrVM ssrVM;
                BookingFileProductAirSegmentAdditionalsPaneVM additionalData;
                SegmentUIData segmentData = AirProductFXHelper.findSegmentUIData(segmentUIDataList, segment.getUid());
                if (segmentData == null) continue;
                BookingFileAirSegmentVM segmentVM = new BookingFileAirSegmentVM();
                segmentVM.setConnected(!first);
                first = false;
                segmentVM.setUid(segment.getUid());
                segmentVM.setNumber(segment.getRecordNumber());
                segmentVM.setDeparturePoint(segment.getDepartureLocation());
                if (!TextUtil.isBlank((String)segmentData.getFrom())) {
                    segmentVM.getDeparturePoint().setCaption(segmentData.getFrom());
                }
                segmentVM.setArrivalPoint(segment.getArriveLocation());
                if (!TextUtil.isBlank((String)segmentData.getTo())) {
                    segmentVM.getArrivalPoint().setCaption(segmentData.getTo());
                }
                segmentVM.setCarrier(segment.getAirline());
                if (!TextUtil.isBlank((String)segmentData.getCarrierCodes())) {
                    segmentVM.getCarrier().setCaption(segmentData.getCarrierCodes());
                }
                segmentVM.setFlyNumber(segment.getFlightNo());
                if (TextUtil.isBlank((String)segment.getClassOfSvcCode())) {
                    segmentVM.setCategory(segment.getClassOfService());
                } else {
                    segmentVM.setCategory(segment.getClassOfSvcCode());
                }
                segmentVM.setTariffCode(segment.getFareBasis());
                if (segment.getStartDate() != null) {
                    segmentVM.setDepartureDate(DateUtils.asLocalDateTime((Date)segment.getStartDate()));
                }
                if (productCategory == ProductCategory.AIR || Objects.isNull(productCategory)) {
                    additionalData = segmentVM.getSuperColumn().getAdditionalData();
                    additionalData.setEndDateValue(DateUtils.asLocalDateTime((Date)segment.getEndDate()));
                    additionalData.setCarrierValue(segment.getCodeShareCarrier());
                    additionalData.setNddValue(DateUtils.asLocalDate((Date)segment.getNotValidBefore()));
                    additionalData.setNdpValue(DateUtils.asLocalDate((Date)segment.getNotValidAfter()));
                    additionalData.setAirlineLocatorValue(segment.getAirlineLocator());
                    additionalData.setSeatValue(segment.getSeatNo());
                    additionalData.setMealValue(segment.getMealServiceIndicator());
                    additionalData.setServiceClassValue(segment.getServiceClass());
                    additionalData.setBoardValue(segment.getBoard());
                    for (SpecialServiceRequest ssr : segment.getSsrs()) {
                        ssrVM = new BookingFileProductAirSegmentSsrVM();
                        ssrVM.setType(ssr.getType());
                        ssrVM.setStatus(ssr.getStatus());
                        ssrVM.setRequestFreeText(ssr.getRequestFreeText());
                        ssrVM.setResponseFreeText(ssr.getResponseFreeText());
                        segmentVM.getSuperColumn().getSpecialServiceRequest().add(ssrVM);
                    }
                    additionalData.setFlightDistanceValue(segment.getFlightDistanceMiles());
                    additionalData.setFlightDurationValue(segment.getFlightDuration());
                    additionalData.setArriveTerminalValue(segment.getArriveTerminal());
                    additionalData.setDepartureTerminalValue(segment.getDepartTerminal());
                    additionalData.setCo2EmissionsKgValue(segment.getCo2EmissionsKg());
                    for (TechStopInfo techStopInfo : segment.getTechStopInfos()) {
                        BookingFileProductAirSegmentTechStopVM technicalStopVM = new BookingFileProductAirSegmentTechStopVM();
                        technicalStopVM.setAirport(techStopInfo.getLocation());
                        if (techStopInfo.getArrivalDateTime() != null) {
                            technicalStopVM.setArrivalDate(techStopInfo.getArrivalDateTime());
                        }
                        if (techStopInfo.getDepartureDateTime() != null) {
                            technicalStopVM.setStartDate(techStopInfo.getDepartureDateTime());
                        }
                        technicalStopVM.setCheckinTime(techStopInfo.getDuration());
                        segmentVM.getSuperColumn().getTechnicalStop().add(technicalStopVM);
                    }
                    freeLuggageInfo = segmentVM.getSuperColumn().getFreeLuggageInfo();
                    luggageInfo2 = segment.getLuggageInfo();
                    if (luggageInfo2 != null) {
                        if (luggageInfo2.isNil()) {
                            freeLuggageInfo.setPqInfoHasLuggage(Boolean.valueOf(false));
                        } else {
                            freeLuggageInfo.setPqInfoHasLuggage(Boolean.valueOf(true));
                            pqInfoValue = freeLuggageInfo.getPqInfoValue();
                            pqInfoValue.setQuantity(luggageInfo2.getQuantity());
                            pqInfoValue.setUnit(luggageInfo2.getUnit());
                        }
                    } else {
                        freeLuggageInfo.setPqInfoHasLuggage(null);
                    }
                    fareDetails = segment.getFareDetails();
                    if (fareDetails != null) {
                        luggageInfo = fareDetails.getLuggageInfo();
                        if (luggageInfo != null) {
                            freeLuggageInfo.setHasFreeLuggageInfo(true);
                            freeLuggageInfo.setFreeLuggageInfoQuantity(luggageInfo.getPieces());
                            freeLuggageInfoWeight = freeLuggageInfo.getFreeLuggageInfoWeight();
                            freeLuggageInfoWeight.setQuantity(luggageInfo.getWeight());
                            freeLuggageInfoWeight.setUnit(luggageInfo.getWeightUnit());
                            freeLuggageInfoDimensions = freeLuggageInfo.getFreeLuggageInfoDimensions();
                            if (luggageInfo.getLength() != null && luggageInfo.getWidth() != null && luggageInfo.getHeight() != null) {
                                freeLuggageInfoDimensions.setHasExtendedDimensions(Boolean.valueOf(true));
                                extendedDimensions2 = freeLuggageInfoDimensions.getExtendedDimensions();
                                extendedDimensions2.setLength(luggageInfo.getLength().intValue());
                                extendedDimensions2.setWidth(luggageInfo.getWidth().intValue());
                                extendedDimensions2.setHeight(luggageInfo.getHeight().intValue());
                                freeLuggageInfoDimensions.setUnit(luggageInfo.getDimensionUnit());
                            } else if (luggageInfo.getDimensionsSum() != null) {
                                freeLuggageInfoDimensions.setHasExtendedDimensions(Boolean.valueOf(false));
                                freeLuggageInfoDimensions.setDimensionSum(luggageInfo.getDimensionsSum().intValue());
                                freeLuggageInfoDimensions.setUnit(luggageInfo.getDimensionUnit());
                            }
                        }
                        if ((cabinLuggageInfo = fareDetails.getCabinLuggageInfo()) != null) {
                            freeLuggageInfo.setHasFreeCabinLuggageInfo(true);
                            freeLuggageInfo.setFreeCabinLuggageInfoQuantity(cabinLuggageInfo.getPieces());
                            freeCabinLuggageInfoWeight = freeLuggageInfo.getFreeCabinLuggageInfoWeight();
                            freeCabinLuggageInfoWeight.setQuantity(cabinLuggageInfo.getWeight());
                            freeCabinLuggageInfoWeight.setUnit(cabinLuggageInfo.getWeightUnit());
                            freeCabinLuggageInfoDimensions = freeLuggageInfo.getFreeCabinLuggageInfoDimensions();
                            if (cabinLuggageInfo.getLength() != null && cabinLuggageInfo.getWidth() != null && cabinLuggageInfo.getHeight() != null) {
                                freeCabinLuggageInfoDimensions.setHasExtendedDimensions(Boolean.valueOf(true));
                                extendedDimensions = freeCabinLuggageInfoDimensions.getExtendedDimensions();
                                extendedDimensions.setLength(cabinLuggageInfo.getLength().intValue());
                                extendedDimensions.setWidth(cabinLuggageInfo.getWidth().intValue());
                                extendedDimensions.setHeight(cabinLuggageInfo.getHeight().intValue());
                                freeCabinLuggageInfoDimensions.setUnit(cabinLuggageInfo.getDimensionUnit());
                            } else if (cabinLuggageInfo.getDimensionsSum() != null) {
                                freeCabinLuggageInfoDimensions.setHasExtendedDimensions(Boolean.valueOf(false));
                                freeCabinLuggageInfoDimensions.setDimensionSum(cabinLuggageInfo.getDimensionsSum().intValue());
                                freeCabinLuggageInfoDimensions.setUnit(cabinLuggageInfo.getDimensionUnit());
                            }
                        }
                    }
                } else if (productCategory != ProductCategory.KRS) {
                    additionalData = segmentVM.getSuperEMDColumn().getAdditionalData();
                    additionalData.setEndDateValue(DateUtils.asLocalDateTime((Date)segment.getEndDate()));
                    additionalData.setCarrierValue(segment.getCodeShareCarrier());
                    additionalData.setNddValue(DateUtils.asLocalDate((Date)segment.getNotValidBefore()));
                    additionalData.setNdpValue(DateUtils.asLocalDate((Date)segment.getNotValidAfter()));
                    additionalData.setAirlineLocatorValue(segment.getAirlineLocator());
                    additionalData.setSeatValue(segment.getSeatNo());
                    additionalData.setMealValue(segment.getMealServiceIndicator());
                    additionalData.setServiceClassValue(segment.getServiceClass());
                    additionalData.setBoardValue(segment.getBoard());
                    for (SpecialServiceRequest ssr : segment.getSsrs()) {
                        ssrVM = new BookingFileProductAirSegmentSsrVM();
                        ssrVM.setType(ssr.getType());
                        ssrVM.setStatus(ssr.getStatus());
                        ssrVM.setRequestFreeText(ssr.getRequestFreeText());
                        ssrVM.setResponseFreeText(ssr.getResponseFreeText());
                        segmentVM.getSuperEMDColumn().getSpecialServiceRequest().add(ssrVM);
                    }
                    freeLuggageInfo = segmentVM.getSuperColumn().getFreeLuggageInfo();
                    luggageInfo2 = segment.getLuggageInfo();
                    if (luggageInfo2 != null) {
                        if (luggageInfo2.isNil()) {
                            freeLuggageInfo.setPqInfoHasLuggage(Boolean.valueOf(false));
                        } else {
                            freeLuggageInfo.setPqInfoHasLuggage(Boolean.valueOf(true));
                            pqInfoValue = freeLuggageInfo.getPqInfoValue();
                            pqInfoValue.setQuantity(luggageInfo2.getQuantity());
                            pqInfoValue.setUnit(luggageInfo2.getUnit());
                        }
                    } else {
                        freeLuggageInfo.setPqInfoHasLuggage(null);
                    }
                    fareDetails = segment.getFareDetails();
                    if (fareDetails != null) {
                        luggageInfo = fareDetails.getLuggageInfo();
                        if (luggageInfo != null) {
                            freeLuggageInfo.setHasFreeLuggageInfo(true);
                            freeLuggageInfo.setFreeLuggageInfoQuantity(luggageInfo.getPieces());
                            freeLuggageInfoWeight = freeLuggageInfo.getFreeLuggageInfoWeight();
                            freeLuggageInfoWeight.setQuantity(luggageInfo.getWeight());
                            freeLuggageInfoWeight.setUnit(luggageInfo.getWeightUnit());
                            freeLuggageInfoDimensions = freeLuggageInfo.getFreeLuggageInfoDimensions();
                            if (luggageInfo.getLength() != null && luggageInfo.getWidth() != null && luggageInfo.getHeight() != null) {
                                freeLuggageInfoDimensions.setHasExtendedDimensions(Boolean.valueOf(true));
                                extendedDimensions2 = freeLuggageInfoDimensions.getExtendedDimensions();
                                extendedDimensions2.setLength(luggageInfo.getLength().intValue());
                                extendedDimensions2.setWidth(luggageInfo.getWidth().intValue());
                                extendedDimensions2.setHeight(luggageInfo.getHeight().intValue());
                                freeLuggageInfoDimensions.setUnit(luggageInfo.getDimensionUnit());
                            } else if (luggageInfo.getDimensionsSum() != null) {
                                freeLuggageInfoDimensions.setHasExtendedDimensions(Boolean.valueOf(false));
                                freeLuggageInfoDimensions.setDimensionSum(luggageInfo.getDimensionsSum().intValue());
                                freeLuggageInfoDimensions.setUnit(luggageInfo.getDimensionUnit());
                            }
                        }
                        if ((cabinLuggageInfo = fareDetails.getCabinLuggageInfo()) != null) {
                            freeLuggageInfo.setHasFreeCabinLuggageInfo(true);
                            freeLuggageInfo.setFreeCabinLuggageInfoQuantity(cabinLuggageInfo.getPieces());
                            freeCabinLuggageInfoWeight = freeLuggageInfo.getFreeCabinLuggageInfoWeight();
                            freeCabinLuggageInfoWeight.setQuantity(cabinLuggageInfo.getWeight());
                            freeCabinLuggageInfoWeight.setUnit(cabinLuggageInfo.getWeightUnit());
                            freeCabinLuggageInfoDimensions = freeLuggageInfo.getFreeCabinLuggageInfoDimensions();
                            if (cabinLuggageInfo.getLength() != null && cabinLuggageInfo.getWidth() != null && cabinLuggageInfo.getHeight() != null) {
                                freeCabinLuggageInfoDimensions.setHasExtendedDimensions(Boolean.valueOf(true));
                                extendedDimensions = freeCabinLuggageInfoDimensions.getExtendedDimensions();
                                extendedDimensions.setLength(cabinLuggageInfo.getLength().intValue());
                                extendedDimensions.setWidth(cabinLuggageInfo.getWidth().intValue());
                                extendedDimensions.setHeight(cabinLuggageInfo.getHeight().intValue());
                                freeCabinLuggageInfoDimensions.setUnit(cabinLuggageInfo.getDimensionUnit());
                            } else if (cabinLuggageInfo.getDimensionsSum() != null) {
                                freeCabinLuggageInfoDimensions.setHasExtendedDimensions(Boolean.valueOf(false));
                                freeCabinLuggageInfoDimensions.setDimensionSum(cabinLuggageInfo.getDimensionsSum().intValue());
                                freeCabinLuggageInfoDimensions.setUnit(cabinLuggageInfo.getDimensionUnit());
                            }
                        }
                    }
                }
                vms.add(segmentVM);
            }
        }
    }

    public static BookingFileProductAirCostPaneVM toVMAirCost(Product product, AirProductUIData productData, BookingFileProductAirCostPaneVM vm) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        vm.setExchange(product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE);
        vm.setSegmentsData(AirProductFXHelper.toSegmentsData(product.getSegmentTariffs()));
        AirProductFXHelper.toVMAirCostColumnSum(negate, vm.getSum(), product, productData);
        AirProductFXHelper.toVMAirCostColumnRates(vm.getRates(), productData);
        List<BookingFileProductAirFeesAndChargesRowVM> taxesVM = AirProductFXHelper.toVMTaxes(negate, product.getTaxes());
        vm.getCell1().getContent().addAll(taxesVM);
        List<BookingFileProductAirOBFeesRowVM> obFeesVM = AirProductFXHelper.toVMObFees(negate, product.getObFees());
        vm.getCell2().getContent().addAll(obFeesVM);
        List tariffsVM = AirProductFXHelper.toVMTariffs(negate, product.getFares()).stream().filter(t -> t.getSegments().getSegments() != null && !t.getSegments().getSegments().isEmpty()).collect(Collectors.toList());
        vm.getCell3().getContent().addAll(tariffsVM);
        ArrayList<BookingFileProductAirVatDetailsRowVM> vatsVM = new ArrayList<BookingFileProductAirVatDetailsRowVM>();
        if (product.getVendorVatDetalization() != null) {
            vatsVM.addAll(AirProductFXHelper.toVMVats(negate, product.getVendorVatDetalization().getComponents(), product.getTaxes()));
        }
        vm.getCell4().getContent().addAll(vatsVM);
        return vm;
    }

    public static void toVMAirAdditionalParameters(Product product, AirProductUIData productData, BookingFileProductAirOtherParametersPanelVM model) {
        AirProductFXHelper.toVMGeneralAdditionalParametersTariff(product, model.getTariff());
        AirProductFXHelper.toVMGeneralAdditionalParametersReport(product, model.getReports());
        AirProductFXHelper.toVMGeneralAdditionalParametersDiscount(product, model.getDiscount());
        AirProductFXHelper.toVMGeneralAdditionalParametersCharter(product, productData, model.getPopups().getCharterBinding());
        model.getPopups().setComments(product.getComments());
        GeneralProductFXHelper.toVMPassiveSegments((BaseProduct)product, model.getPopups().getPassiveSegments());
    }

    private static void toVMGeneralAdditionalParametersTariff(Product product, BookingFileProductAviaAdditionalsTariffVM model) {
        model.setEndorsement(product.getEndorsement());
        model.setFareCalculationData(product.getFareCalculationData());
        model.setTelexNumber(product.getTelexNumber());
        model.setSubsidizedTariff(product.isSubsidizedTariff());
        VMHelper.transfer(product.getSpecialTariffs(), model.getSpecialTariff());
    }

    private static void toVMGeneralAdditionalParametersReport(Product product, BookingFileProductAviaAdditionalsReportsVM model) {
        model.setTchDirectContract(product.getTchDirectContract());
        model.setReturnFareDifference(product.isContainsReturnFareDifferenceData());
    }

    private static void toVMGeneralAdditionalParametersDiscount(Product product, BookingFileProductAviaAdditionalsDiscountVM model) {
        if (product.getTripartiteContractDetails() != null) {
            model.setContract(product.getTripartiteContractDetails().getContract());
            model.setCode(product.getTripartiteContractDetails().getDiscountCode());
            model.setRate(product.getTripartiteContractDetails().getDiscountRate());
            model.setValue(product.getTripartiteContractDetails().getDiscountValue());
            model.setIssuedUnder3d(product.getTripartiteContractDetails().isIssuedUnder3d());
        }
    }

    private static void toVMGeneralAdditionalParametersCharter(Product product, AirProductUIData productData, BookingFileProductAviaCharterQuotaBindingVM model) {
        if (product.getCharterQuotaBinding() != null) {
            NestedEntityReference appendixRef;
            boolean empty;
            SUBlockCharterQuotaReference forwardData = product.getCharterQuotaBinding().getForwardQuota();
            SUBlockCharterQuotaReference backwardData = product.getCharterQuotaBinding().getBackwardQuota();
            if (forwardData != null) {
                model.getForwardQuota().setContract(forwardData.getContract());
                empty = forwardData.getContract() == null || productData.getForwardAppendix() == null;
                appendixRef = empty ? null : new NestedEntityReference(forwardData.getContract().getUid(), Contract.class, productData.getForwardAppendix().getUid(), SUBlockCharterAppendix.class, productData.getForwardAppendix().getNumber());
                model.getForwardQuota().setAppendix(appendixRef);
                model.getForwardQuota().setTariffClassOfBooking(AirProductFXHelper.findTariffInfo(productData.getForwardAppendix(), forwardData.getTariffClassOfBooking()));
                model.getForwardQuota().setQuotaDate(DateUtils.asLocalDate((Date)forwardData.getQuotaDate()));
                model.getForwardQuota().setQuotaFlightNo(forwardData.getQuotaFlightNo());
            }
            if (backwardData != null) {
                model.getBackwardQuota().setContract(backwardData.getContract());
                empty = backwardData.getContract() == null || productData.getBackwardAppendix() == null;
                appendixRef = empty ? null : new NestedEntityReference(backwardData.getContract().getUid(), Contract.class, productData.getBackwardAppendix().getUid(), SUBlockCharterAppendix.class, productData.getBackwardAppendix().getNumber());
                model.getBackwardQuota().setAppendix(appendixRef);
                model.getBackwardQuota().setTariffClassOfBooking(AirProductFXHelper.findTariffInfo(productData.getBackwardAppendix(), backwardData.getTariffClassOfBooking()));
                model.getBackwardQuota().setQuotaDate(DateUtils.asLocalDate((Date)backwardData.getQuotaDate()));
                model.getBackwardQuota().setQuotaFlightNo(backwardData.getQuotaFlightNo());
            }
        }
    }

    public static void toVMEMDOverviewParameters(Product product, AirProductUIData productData, String recordLocator, BookingFileProductEMDPanelVM vm) {
        vm.setProductShortName(BookingHelper.generateShortProductName((BaseProduct)product));
        vm.setUid(product.getUid());
    }

    public static void toVMEMDGeneralParameters(Product product, AirProductUIData productData, String recordLocator, BookingFileProductEMDPanelVM panelVM) {
        AirProductFXHelper.toVMAirTicketInformation(product, productData, panelVM.getGeneral().getTicketInfo());
        AirProductFXHelper.toVMAirTravelerInformation(product, productData, recordLocator, panelVM.getGeneral().getTravelerInfo());
        String productType = AirProductFXHelper.getProductType(product);
        panelVM.getGeneral().getTicketInfo().setProductValue(productType == null ? ProductCategory.MCO.toString() : productType);
        panelVM.getGeneral().getTicketInfo().setEmdCategoryValue(product.getMcoCategory());
        AirProductFXHelper.toVMAirSalesChain(product, productData, panelVM.getGeneral().getSalesChain());
        AirProductFXHelper.toVMAirControlStatuses(product, productData, panelVM.getStatuses());
        if (product.getLuggageWeight() != null) {
            panelVM.getGeneral().getTravelerInfo().setEmdGroupValue(product.getLuggageWeight().doubleValue());
            panelVM.getGeneral().getTravelerInfo().getEmdLuggageValue().setAmount(product.getLuggageWeight().doubleValue());
        }
        panelVM.getGeneral().getTravelerInfo().getEmdLuggageValue().setUnit(product.getLuggageUnits());
        panelVM.getGeneral().getSalesChain().setTicketTypeValue(product.getTicketType());
        panelVM.getGeneral().getTravelerInfo().setReservedSeatValue((String)Optional.ofNullable(CollectionUtil.head((Iterable)AirProductHelper.getSegments((Collection)product.getSegmentTariffs()))).map(Segment::getSeatNo).orElse(null));
    }

    public static void toVMBagageGeneralParameters(Product product, AirProductUIData productData, String recordLocator, BookingFileProductBagagePanelVM panelVM) {
        AirProductFXHelper.toVMAirTicketInformation(product, productData, panelVM.getGeneral().getTicketInfo());
        AirProductFXHelper.toVMBagageTravelerInformation(product, productData, recordLocator, panelVM.getGeneral().getTravelerInfo());
        String productType = AirProductFXHelper.getProductType(product);
        panelVM.getGeneral().getTicketInfo().setProductValue(productType == null ? ProductCategory.MCO.toString() : productType);
        AirProductFXHelper.toVMAirSalesChain(product, productData, panelVM.getGeneral().getSalesChain());
        AirProductFXHelper.toVMAirControlStatuses(product, productData, panelVM.getStatuses());
        if (product.getLuggageWeight() != null) {
            panelVM.getGeneral().getTravelerInfo().setEmdGroupValue(product.getLuggageWeight().doubleValue());
            panelVM.getGeneral().getTravelerInfo().getEmdLuggageValue().setAmount(product.getLuggageWeight().doubleValue());
        }
        panelVM.getGeneral().getTravelerInfo().getEmdLuggageValue().setUnit(product.getLuggageUnits());
        panelVM.getGeneral().getSalesChain().setTicketTypeValue(product.getTicketType());
    }

    public static BookingFileProductEMDRelatedProductsVM toVMEMDRelatedProducts(Product product, AirProductUIData productData) {
        BookingFileProductEMDRelatedProductsVM model = new BookingFileProductEMDRelatedProductsVM();
        AirProductFXHelper.toVMEMDRelatedProducts(product, productData, model);
        return model;
    }

    public static void toVMEMDRelatedProducts(Product product, AirProductUIData productData, BookingFileProductEMDRelatedProductsVM res) {
        res.setMainProductCode(product.getMainProductCode());
        res.setMainProductNumber(product.getMainProductNumber());
        res.setBookingFile(product.getReservation().getBookingFile());
        res.setProductUid(product.getUid());
        product.getRelatedProducts().forEach(p -> {
            BookingFileProductEMDRelatedProductsTableVM productVM = new BookingFileProductEMDRelatedProductsTableVM();
            productVM.setProduct(BookingHelper.generateShortProductName((BaseProduct)p));
            productVM.setProductUID(p.getUid());
            res.getRelatedProducts().add(productVM);
        });
    }

    public static void toVMBagageRelatedProducts(Product product, AirProductUIData productData, BookingFileProductBagageRelatedProductsVM res) {
        res.setMainProductCode(product.getMainProductCode());
        res.setMainProductNumber(product.getMainProductNumber());
        res.setBookingFile(product.getReservation().getBookingFile());
        res.setProductUid(product.getUid());
        product.getRelatedProducts().forEach(p -> {
            BookingFileProductBagageRelatedProductsTableVM productVM = new BookingFileProductBagageRelatedProductsTableVM();
            productVM.setProduct(BookingHelper.generateShortProductName((BaseProduct)p));
            productVM.setProductUID(p.getUid());
            res.getRelatedProducts().add(productVM);
        });
    }

    public static void toVMEMDAdditionalParameters(Product product, AirProductUIData productData, BookingFileProductEMDOtherParametersPanelVM model) {
        AirProductFXHelper.toVMGeneralAdditionalParametersTariff(product, (BookingFileProductAviaAdditionalsTariffVM)model.getTariff());
        model.getTariff().setRfisc(product.getRfisc());
        AirProductFXHelper.toVMGeneralAdditionalParametersReport(product, model.getReports());
        model.getPopups().setComments(product.getComments());
    }

    public static void toVMBagageAdditionalParameters(Product product, AirProductUIData productData, BookingFileProductBagageOtherParametersPanelVM model) {
        AirProductFXHelper.toVMGeneralAdditionalParametersTariff(product, (BookingFileProductAviaAdditionalsTariffVM)model.getTariff());
        model.getTariff().setRfisc(product.getRfisc());
        AirProductFXHelper.toVMGeneralAdditionalParametersReport(product, model.getReports());
        model.getPopups().setComments(product.getComments());
    }

    public static List<BookingFileProductAirFeesAndChargesRowVM> toVMTaxes(boolean negate, List<Tax> taxes) {
        ArrayList<BookingFileProductAirFeesAndChargesRowVM> taxesVM = new ArrayList<BookingFileProductAirFeesAndChargesRowVM>();
        for (Tax tax : taxes) {
            BookingFileProductAirFeesAndChargesRowVM taxVM = new BookingFileProductAirFeesAndChargesRowVM();
            taxVM.setUid(tax.getUid());
            SegmentsData segmentsData = new SegmentsData();
            if (tax.getSegmentTariff() != null) {
                segmentsData.setSegments(tax.getSegmentTariff().getSegments());
            }
            segmentsData.setDescription(AirProductFXHelper.getSegmentsDataDescription(segmentsData.getSegments()));
            taxVM.setSegments(segmentsData);
            taxVM.setCode(tax.getCode());
            taxVM.setSum(tax.getAmount() == null ? null : AirProductFXHelper.getValue(tax.getAmount().getValue(), negate));
            taxVM.setCurrency(tax.getAmount() == null ? null : tax.getAmount().getCurrency());
            taxVM.setEqSum(AirProductFXHelper.getValue(tax.getEquivalentAmount(), negate));
            taxVM.setAddition(AirProductFXHelper.getValue(tax.getAddCollect(), negate));
            taxesVM.add(taxVM);
        }
        return taxesVM;
    }

    public static List<BookingFileProductAirOBFeesRowVM> toVMObFees(boolean negate, List<OBFee> obFees) {
        ArrayList<BookingFileProductAirOBFeesRowVM> obFeesVM = new ArrayList<BookingFileProductAirOBFeesRowVM>();
        for (OBFee obFee : obFees) {
            BookingFileProductAirOBFeesRowVM feeVM = new BookingFileProductAirOBFeesRowVM();
            feeVM.setDescription(obFee.getDescription());
            feeVM.setSum(obFee.getAmount() == null ? null : AirProductFXHelper.getValue(obFee.getAmount().getValue(), negate));
            feeVM.setCurrency(obFee.getAmount() == null ? null : obFee.getAmount().getCurrency());
            feeVM.setEqSum(null);
            obFeesVM.add(feeVM);
        }
        return obFeesVM;
    }

    public static List<BookingFileProductAirTariffComponentsRowVM> toVMTariffs(boolean negate, List<ProductFare> fares) {
        ArrayList<BookingFileProductAirTariffComponentsRowVM> tariffsVM = new ArrayList<BookingFileProductAirTariffComponentsRowVM>();
        for (ProductFare productFare : fares) {
            BookingFileProductAirTariffComponentsRowVM tariffVM = new BookingFileProductAirTariffComponentsRowVM();
            SegmentsData segmentsData = new SegmentsData();
            if (productFare.getSegmentTariff() != null) {
                segmentsData.setSegments(productFare.getSegmentTariff().getSegments());
            }
            segmentsData.setDescription(AirProductFXHelper.getSegmentsDataDescription(segmentsData.getSegments()));
            tariffVM.setSegments(segmentsData);
            tariffVM.setTariff(productFare.getBaseFare() == null ? null : AirProductFXHelper.getValue(productFare.getBaseFare().getValue(), negate));
            tariffVM.setCurrency(productFare.getBaseFare() == null ? null : productFare.getBaseFare().getCurrency());
            tariffVM.setEqTariff(AirProductFXHelper.getValue(productFare.getEquivalentFare(), negate));
            tariffVM.setRoe(productFare.getRoe());
            tariffVM.setNuc(AirProductFXHelper.getValue(productFare.getNucFare(), negate));
            tariffsVM.add(tariffVM);
        }
        return tariffsVM;
    }

    public static List<BookingFileProductAirVatDetailsRowVM> toVMVats(boolean negate, List<VatComponent> vatComponents, List<Tax> taxes) {
        ArrayList<BookingFileProductAirVatDetailsRowVM> vatsVM = new ArrayList<BookingFileProductAirVatDetailsRowVM>();
        for (VatComponent vatComponent : vatComponents) {
            BookingFileProductAirVatDetailsRowVM vatVM = new BookingFileProductAirVatDetailsRowVM();
            vatVM.setUid(vatComponent.getUid());
            vatVM.setRate(vatComponent.getRate() == null ? null : new BigDecimal(vatComponent.getRate()));
            vatVM.setBasis(AirProductFXHelper.getValue(vatComponent.getBasis(), negate));
            vatVM.setSum(AirProductFXHelper.getValue(vatComponent.getSum(), negate));
            vatVM.getBasisTypes().addAll(vatComponent.getBasisTypes());
            vatVM.getTaxesUids().addAll(vatComponent.getTaxesUids());
            vatsVM.add(vatVM);
        }
        return vatsVM;
    }

    public static void fromVMAirMainParameters(BookingFileProductAirPanelVM productPaneVM, BookingFile bookingFile, Product product, AirProductUIData productData, boolean isRefundOrExchange) {
        AirProductFXHelper.fromVMAirTicketInformation(productPaneVM.getGeneral().getTicketInfo(), product);
        AirProductFXHelper.fromVMAirTravelerInformation(productPaneVM.getGeneral().getTravelerInfo(), product);
        AirProductFXHelper.fromVMAirSalesChain(productPaneVM.getGeneral().getSalesChain(), product, productData);
        AirProductFXHelper.fromVMAirControlStatuses(productPaneVM.getStatuses(), product, isRefundOrExchange);
    }

    private static void fromVMAirTicketInformation(BookingFileProductAirTicketInfoPaneVM vm, Product product) {
        if (Objects.isNull(product.getProductCategory())) {
            product.setProductCategory(ProductCategory.AIR);
        }
        product.setCarrier(vm.getValidatingCarrierValue().getCarrier());
        product.setSystemNumber(vm.getTicketNumberValue());
        product.getScns().clear();
        if (vm.getScnValue() != null) {
            product.getScns().addAll(Arrays.stream(vm.getScnValue().trim().split(",")).filter(TextUtil::nonBlank).collect(Collectors.toList()));
        }
        product.setConjCount(vm.getRelatedTicketsValue());
        product.setBlankType(vm.getBlankValue());
        product.setIssueDate(DateUtils.asDate((LocalDateTime)vm.getOperationDateValue()));
        product.setSalesOriginProvider(vm.getSalesOriginProviderValue());
        product.setSalesOriginContent(vm.getSalesOriginContentValue());
        product.setCorrectionDate(DateUtils.asDate((LocalDateTime)vm.getCorrectionDateValue()));
    }

    private static void fromVMBagageTicketInformation(BookingFileProductAirTicketInfoPaneVM vm, Product product) {
        product.setCarrier(vm.getValidatingCarrierValue().getCarrier());
        product.setCarrierNumber(vm.getValidatingCarrierValue().getCarrierNumber());
        product.setSystemNumber(vm.getTicketNumberValue());
        product.getScns().clear();
        if (vm.getScnValue() != null) {
            product.getScns().addAll(Arrays.stream(vm.getScnValue().trim().split(",")).filter(TextUtil::nonBlank).collect(Collectors.toList()));
        }
        product.setConjCount(vm.getRelatedTicketsValue());
        product.setBlankType(vm.getBlankValue());
        product.setIssueDate(DateUtils.asDate((LocalDateTime)vm.getOperationDateValue()));
        product.setCorrectionDate(DateUtils.asDate((LocalDateTime)vm.getCorrectionDateValue()));
    }

    private static void fromVMAirTravelerInformation(BookingFileProductAirTravelerInfoPaneVM vm, Product product) {
        product.setTariffType(vm.getTariffTypeValue());
        product.setTourCode(vm.getTourCodeValue());
        product.setPcc(vm.getPccValue());
        product.getTripartiteContractDetails().setContractCode(vm.getContractCodeValue());
        product.setShipmentsDate(MiscUtil.toDate((LocalDateTime)vm.getShipmentsDateValue()));
        product.setShipmentsDateSubagent(MiscUtil.toDate((LocalDateTime)vm.getShipmentsDateSubagentValue()));
        if (vm.getPassengerValue() != null) {
            Traveller traveller = GeneralProductFXHelper.findTraveller(product.getReservation().getBookingFile(), vm.getPassengerValue().getUid());
            product.setTraveller(traveller);
        } else {
            product.setTraveller(null);
        }
        product.setPassengerType(vm.getPassengerTypeValue());
    }

    private static void fromVMBagageTravelerInformation(BookingFileProductAirTravelerInfoPaneVM vm, Product product) {
        product.setTariffType(vm.getTariffTypeValue());
        product.setPcc(vm.getPccValue());
        product.setTourCode(vm.getTourCodeValue());
        product.getTripartiteContractDetails().setContractCode(vm.getContractCodeValue());
        product.setShipmentsDate(MiscUtil.toDate((LocalDateTime)vm.getShipmentsDateValue()));
        product.setShipmentsDateSubagent(MiscUtil.toDate((LocalDateTime)vm.getShipmentsDateSubagentValue()));
        if (vm.getPassengerValue() != null) {
            Traveller traveller = GeneralProductFXHelper.findTraveller(product.getReservation().getBookingFile(), vm.getPassengerValue().getUid());
            product.setTraveller(traveller);
        } else {
            product.setTraveller(null);
        }
        product.setPassengerType(vm.getPassengerTypeValue());
        product.setLuggageWeight(vm.getBagageLuggageValue().getAmount());
        product.setLuggageUnits(vm.getBagageLuggageValue().getUnit());
    }

    private static void fromVMAirSalesChain(BookingFileProductAirSalesChainPaneVM vm, Product product, AirProductUIData productData) {
        product.setBlankOwnerRef(vm.getBlankOwnerValue().getBlankOwnerCode());
        productData.setSupplier(vm.getSupplierValue());
        productData.setAgency(vm.getAgencyValue());
        productData.setSubagency(vm.getSubagencyValue());
        productData.setTechnicalProvider(vm.getTechnicalProviderValue());
        product.setBranch(vm.getBranchValue());
        product.setSalesPoint(vm.getSalesPointValue());
        product.setCashier(vm.getPrescribeAgentValue());
        product.setValidatorCode(vm.getValidatorValue().getCode());
        product.setValidatorRef(vm.getValidatorValue().getReference());
        product.setTicketType(vm.getTicketTypeValue());
    }

    private static void fromVMAirControlStatuses(BookingFileProductAirStatusesPaneVM controlStatuses, Product product, boolean isRefundOrExchange) {
        product.setChecked(controlStatuses.isChecked());
        product.setCompleted(controlStatuses.isFinished());
        product.setDuplicate(controlStatuses.isDuplicate());
        product.setContractRulesApplied(controlStatuses.isRulesApplied());
        if (isRefundOrExchange) {
            product.setForcedRefund(controlStatuses.isForcedRefund());
        }
        if (product.getVendorVatDetalization() != null) {
            product.getVendorVatDetalization().setDetalized(controlStatuses.isVatSpecified());
        }
    }

    private static void fromVMVatComponents(boolean negate, List<BookingFileProductAirVatDetailsRowVM> vatVM, Product product) {
        VatDetalization detalization = product.getVendorVatDetalization();
        if (detalization == null) {
            detalization = new VatDetalization();
            product.setVendorVatDetalization(detalization);
        }
        VMHelper.transfer(vatVM, detalization.getComponents(), v -> new VatComponent(), (componentVM, vat) -> {
            vat.setRate(componentVM.getRate() == null ? null : Double.valueOf(componentVM.getRate().doubleValue()));
            vat.setBasis(AirProductFXHelper.getValue(componentVM.getBasis(), negate));
            vat.setSum(AirProductFXHelper.getValue(componentVM.getSum(), negate));
            vat.getBasisTypes().clear();
            vat.getBasisTypes().addAll(componentVM.getBasisTypes());
            vat.getTaxesUids().clear();
            vat.getTaxesUids().addAll(componentVM.getTaxesUids());
        });
    }

    public static List<TechStopInfo> fromVMTechnicalStops(List<BookingFileProductAirSegmentTechStopVM> modelList) {
        ArrayList<TechStopInfo> entities = new ArrayList<TechStopInfo>();
        for (BookingFileProductAirSegmentTechStopVM technicalStopVM : modelList) {
            TechStopInfo techStopInfo = new TechStopInfo();
            techStopInfo.setLocation(technicalStopVM.getAirport());
            techStopInfo.setArrivalDateTime(technicalStopVM.getArrivalDate());
            techStopInfo.setDepartureDateTime(technicalStopVM.getStartDate());
            techStopInfo.setDuration(technicalStopVM.getCheckinTime());
            entities.add(techStopInfo);
        }
        return entities;
    }

    public static List<SpecialServiceRequest> fromVMSsrs(List<BookingFileProductAirSegmentSsrVM> modelList) {
        ArrayList<SpecialServiceRequest> entities = new ArrayList<SpecialServiceRequest>();
        for (BookingFileProductAirSegmentSsrVM ssrVM : modelList) {
            SpecialServiceRequest ssr = new SpecialServiceRequest();
            ssr.setType(ssrVM.getType());
            ssr.setStatus(ssrVM.getStatus());
            ssr.setRequestFreeText(ssrVM.getRequestFreeText());
            ssr.setResponseFreeText(ssrVM.getResponseFreeText());
            entities.add(ssr);
        }
        return entities;
    }

    private static void fromVMTaxes(boolean negate, List<BookingFileProductAirFeesAndChargesRowVM> taxesVM, Product product) {
        Map<String, Segment> segmentMap = product.getSegmentTariffs().stream().flatMap(st -> st.getSegments().stream()).collect(Collectors.toMap(BaseIdentity::getUid, s -> s));
        VMHelper.transfer(taxesVM, product.getTaxes(), t -> new Tax(), (taxVM, tax) -> {
            SegmentTariff segmentTariff = null;
            if (taxVM.getSegments() != null && taxVM.getSegments().getSegments() != null) {
                segmentTariff = new SegmentTariff();
                segmentTariff.getSegments().addAll(taxVM.getSegments().getSegments().stream().map(el -> segmentMap.getOrDefault(el.getUid(), (Segment)el)).collect(Collectors.toList()));
            }
            tax.setSegmentTariff(segmentTariff);
            tax.setCode(taxVM.getCode());
            Money amount = null;
            if (taxVM.getSum() != null || taxVM.getCurrency() != null) {
                amount = new Money();
                amount.setValue(AirProductFXHelper.getValue(taxVM.getSum(), negate));
                amount.setCurrency(taxVM.getCurrency());
            }
            tax.setAmount(amount);
            tax.setEquivalentAmount(AirProductFXHelper.getValue(taxVM.getEqSum(), negate));
            tax.setAddCollect(AirProductFXHelper.getValue(taxVM.getAddition(), negate));
        });
    }

    private static List<OBFee> fromVMObFees(boolean negate, List<BookingFileProductAirOBFeesRowVM> obFeesVM) {
        ArrayList<OBFee> obFees = new ArrayList<OBFee>();
        for (BookingFileProductAirOBFeesRowVM feeVM : obFeesVM) {
            OBFee obFee = new OBFee();
            obFee.setDescription(feeVM.getDescription());
            Money amount = null;
            if (feeVM.getSum() != null || feeVM.getCurrency() != null) {
                amount = new Money();
                amount.setValue(AirProductFXHelper.getValue(feeVM.getSum(), negate));
                amount.setCurrency(feeVM.getCurrency());
            }
            obFee.setAmount(amount);
            if (obFee.getAmount() == null) continue;
            obFees.add(obFee);
        }
        return obFees;
    }

    private static List<ProductFare> fromVMProductFares(boolean negate, List<BookingFileProductAirTariffComponentsRowVM> tariffsVM, Set<Segment> existingSegments) {
        ArrayList<ProductFare> productFares = new ArrayList<ProductFare>();
        Map<String, Segment> segmentsUid = existingSegments.stream().collect(Collectors.toMap(BaseIdentity::getUid, el -> el));
        for (BookingFileProductAirTariffComponentsRowVM tariffVM : tariffsVM) {
            ProductFare productFare = new ProductFare();
            SegmentTariff segmentTariff = null;
            if (tariffVM.getSegments() != null && tariffVM.getSegments().getSegments() != null && !tariffVM.getSegments().getSegments().isEmpty()) {
                segmentTariff = new SegmentTariff();
                segmentTariff.getSegments().addAll(tariffVM.getSegments().getSegments().stream().map(el -> segmentsUid.getOrDefault(el.getUid(), (Segment)el)).collect(Collectors.toList()));
            }
            productFare.setSegmentTariff(segmentTariff);
            Money amount = null;
            if (tariffVM.getTariff() != null || tariffVM.getCurrency() != null) {
                amount = new Money();
                amount.setValue(AirProductFXHelper.getValue(tariffVM.getTariff(), negate));
                amount.setCurrency(tariffVM.getCurrency());
            }
            productFare.setBaseFare(amount);
            productFare.setEquivalentFare(AirProductFXHelper.getValue(tariffVM.getEqTariff(), negate));
            productFare.setRoe(tariffVM.getRoe());
            productFare.setNucFare(AirProductFXHelper.getValue(tariffVM.getNuc(), negate));
            productFares.add(productFare);
        }
        return productFares;
    }

    public static void fromVMAirSegmentsAndFares(BookingFileProductAirCostPaneVM costVM, List<BookingFileAirSegmentVM> segmentVMs, Product product) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        AirProductFXHelper.fromVMAirSegments(segmentVMs, product);
        Set<Segment> segments = product.getSegmentTariffs().stream().flatMap(el -> el.getSegments().stream()).collect(Collectors.toSet());
        List productFares = AirProductFXHelper.fromVMProductFares(negate, costVM.getCell3().getContent(), segments).stream().filter(fare -> fare.getSegmentTariff() != null).collect(Collectors.toList());
        product.getFares().clear();
        product.getFares().addAll(productFares);
    }

    private static void fromVMAirSegments(List<BookingFileAirSegmentVM> vms, Product product) {
        AirProductFXHelper.fromVMAirSegments(vms, product.getSegmentTariffs(), product.getProductCategory());
    }

    public static void fromVMAirSegments(List<BookingFileAirSegmentVM> vms, List<SegmentTariff> segmentTariffs, ProductCategory productCategory) {
        Map<String, Segment> oldSegments = segmentTariffs.stream().flatMap(st -> st.getSegments().stream()).collect(Collectors.toMap(BaseIdentity::getUid, s -> s));
        LinkedHashMap<Segment, Boolean> segmentsMap = new LinkedHashMap<Segment, Boolean>();
        for (BookingFileAirSegmentVM segmentVM : vms) {
            Segment segment = oldSegments.containsKey(segmentVM.getUid()) ? oldSegments.get(segmentVM.getUid()) : new Segment();
            AirProductFXHelper.fromVMAirSegment(segment, segmentVM, productCategory);
            segmentsMap.put(segment, segmentVM.isConnected());
        }
        if (!segmentsMap.isEmpty()) {
            Segment firstSegment = (Segment)segmentsMap.keySet().iterator().next();
            segmentsMap.put(firstSegment, false);
        }
        List<SegmentTariff> segmentTariffList = AirProductFXHelper.toSegmentTariffs(segmentsMap);
        segmentTariffs.clear();
        segmentTariffs.addAll(segmentTariffList);
    }

    private static List<SegmentTariff> toSegmentTariffs(Map<Segment, Boolean> segments) {
        ArrayList<SegmentTariff> list = new ArrayList<SegmentTariff>();
        SegmentTariff currentTariff = new SegmentTariff();
        for (Map.Entry<Segment, Boolean> entry : segments.entrySet()) {
            boolean isConnected = entry.getValue();
            Segment segment = entry.getKey();
            if (!isConnected) {
                currentTariff = new SegmentTariff();
                list.add(currentTariff);
            }
            currentTariff.getSegments().add(segment);
        }
        return list;
    }

    private static void fromVMAirSegment(Segment segment, BookingFileAirSegmentVM segmentVM, ProductCategory productCategory) {
        if (segmentVM != null) {
            segment.setDepartureLocation(segmentVM.getDeparturePoint());
            segment.setArriveLocation(segmentVM.getArrivalPoint());
            segment.setAirline(segmentVM.getCarrier());
            segment.setRecordNumber(segmentVM.getNumber());
            segment.setFlightNo(segmentVM.getFlyNumber());
            segment.setFareBasis(segmentVM.getTariffCode());
            segment.setStartDate(segmentVM.getDepartureDate() == null ? null : DateUtils.asDate((LocalDateTime)segmentVM.getDepartureDate()));
            segment.setClassOfService(segmentVM.getCategory());
            segment.setClassOfSvcCode(segmentVM.getCategory());
            segment.setAirline(segmentVM.getCarrier());
            if (productCategory == ProductCategory.AIR || Objects.isNull(productCategory)) {
                AirSegmentLuggageExtendedDimensionsPaneVM extendedDimensions;
                Boolean hasExtendedDimensions;
                ExtendedLuggageInfo info;
                FareDetails fareDetails;
                BookingFileProductAirSegmentAdditionalsPaneVM additionalData = segmentVM.getSuperColumn().getAdditionalData();
                segment.setCodeShareCarrier(additionalData.getCarrierValue());
                segment.setNotValidBefore(additionalData.getNddValue() == null ? null : DateUtils.asDate((LocalDate)additionalData.getNddValue()));
                segment.setNotValidAfter(additionalData.getNdpValue() == null ? null : DateUtils.asDate((LocalDate)additionalData.getNdpValue()));
                segment.setAirlineLocator(additionalData.getAirlineLocatorValue());
                segment.setSeatNo(additionalData.getSeatValue());
                segment.setMealServiceIndicator(additionalData.getMealValue());
                segment.setServiceClass(additionalData.getServiceClassValue());
                segment.setEndDate(DateUtils.asDate((LocalDateTime)additionalData.getEndDateValue()));
                segment.setBoard(additionalData.getBoardValue());
                List<SpecialServiceRequest> ssrs = AirProductFXHelper.fromVMSsrs(segmentVM.getSuperColumn().getSpecialServiceRequest());
                segment.getSsrs().clear();
                segment.getSsrs().addAll(ssrs);
                segment.setFlightDistanceMiles(additionalData.getFlightDistanceValue());
                segment.setFlightDuration(additionalData.getFlightDurationValue());
                segment.setArriveTerminal(additionalData.getArriveTerminalValue());
                segment.setDepartTerminal(additionalData.getDepartureTerminalValue());
                segment.setCo2EmissionsKg(additionalData.getCo2EmissionsKgValue());
                List<TechStopInfo> techStopInfos = AirProductFXHelper.fromVMTechnicalStops(segmentVM.getSuperColumn().getTechnicalStop());
                segment.getTechStopInfos().clear();
                segment.getTechStopInfos().addAll(techStopInfos);
                BookingFileProductAirSegmentFreeLuggageInfoPaneVM freeLuggageInfo = segmentVM.getSuperColumn().getFreeLuggageInfo();
                Boolean pqInfoHasLuggage = freeLuggageInfo.getPqInfoHasLuggage();
                if (pqInfoHasLuggage != null) {
                    LuggageInfo luggageInfo = new LuggageInfo();
                    if (pqInfoHasLuggage.booleanValue()) {
                        AirSegmentLuggageValuePaneVM pqInfoValue = freeLuggageInfo.getPqInfoValue();
                        luggageInfo.setQuantity(pqInfoValue.getQuantity());
                        luggageInfo.setUnit(pqInfoValue.getUnit());
                    } else {
                        luggageInfo.setNil(true);
                    }
                    segment.setLuggageInfo(luggageInfo);
                }
                if (freeLuggageInfo.isHasFreeLuggageInfo()) {
                    fareDetails = segment.getFareDetails();
                    if (fareDetails == null) {
                        fareDetails = new FareDetails();
                        segment.setFareDetails(fareDetails);
                    }
                    info = new ExtendedLuggageInfo();
                    info.setPieces(freeLuggageInfo.getFreeLuggageInfoQuantity());
                    AirSegmentLuggageValuePaneVM freeLuggageInfoWeight = freeLuggageInfo.getFreeLuggageInfoWeight();
                    info.setWeight(freeLuggageInfoWeight.getQuantity());
                    info.setWeightUnit(freeLuggageInfoWeight.getUnit());
                    hasExtendedDimensions = freeLuggageInfo.getFreeLuggageInfoDimensions().getHasExtendedDimensions();
                    if (hasExtendedDimensions != null) {
                        AirSegmentLuggageDimensionsPaneVM freeLuggageInfoDimensions = freeLuggageInfo.getFreeLuggageInfoDimensions();
                        if (hasExtendedDimensions.booleanValue()) {
                            extendedDimensions = freeLuggageInfoDimensions.getExtendedDimensions();
                            info.setLength(Integer.valueOf(extendedDimensions.getLength()));
                            info.setWidth(Integer.valueOf(extendedDimensions.getWidth()));
                            info.setHeight(Integer.valueOf(extendedDimensions.getHeight()));
                        } else {
                            info.setDimensionsSum(Integer.valueOf(freeLuggageInfoDimensions.getDimensionSum()));
                        }
                        info.setDimensionUnit(freeLuggageInfoDimensions.getUnit());
                    }
                    fareDetails.setLuggageInfo(info);
                }
                if (freeLuggageInfo.isHasFreeCabinLuggageInfo()) {
                    fareDetails = segment.getFareDetails();
                    if (fareDetails == null) {
                        fareDetails = new FareDetails();
                        segment.setFareDetails(fareDetails);
                    }
                    info = new ExtendedLuggageInfo();
                    info.setPieces(freeLuggageInfo.getFreeCabinLuggageInfoQuantity());
                    AirSegmentLuggageValuePaneVM freeCabinLuggageInfoWeight = freeLuggageInfo.getFreeCabinLuggageInfoWeight();
                    info.setWeight(freeCabinLuggageInfoWeight.getQuantity());
                    info.setWeightUnit(freeCabinLuggageInfoWeight.getUnit());
                    hasExtendedDimensions = freeLuggageInfo.getFreeCabinLuggageInfoDimensions().getHasExtendedDimensions();
                    if (hasExtendedDimensions != null) {
                        AirSegmentLuggageDimensionsPaneVM freeCabinLuggageInfoDimensions = freeLuggageInfo.getFreeCabinLuggageInfoDimensions();
                        if (hasExtendedDimensions.booleanValue()) {
                            extendedDimensions = freeCabinLuggageInfoDimensions.getExtendedDimensions();
                            info.setLength(Integer.valueOf(extendedDimensions.getLength()));
                            info.setWidth(Integer.valueOf(extendedDimensions.getWidth()));
                            info.setHeight(Integer.valueOf(extendedDimensions.getHeight()));
                        } else {
                            info.setDimensionsSum(Integer.valueOf(freeCabinLuggageInfoDimensions.getDimensionSum()));
                        }
                        info.setDimensionUnit(freeCabinLuggageInfoDimensions.getUnit());
                    }
                    fareDetails.setCabinLuggageInfo(info);
                }
            } else if (productCategory != ProductCategory.KRS) {
                AirSegmentLuggageExtendedDimensionsPaneVM extendedDimensions;
                Boolean hasExtendedDimensions;
                ExtendedLuggageInfo info;
                FareDetails fareDetails;
                BookingFileProductEMDSegmentAdditionalsPaneVM additionalData = segmentVM.getSuperEMDColumn().getAdditionalData();
                segment.setCodeShareCarrier(additionalData.getCarrierValue());
                segment.setNotValidBefore(additionalData.getNddValue() == null ? null : DateUtils.asDate((LocalDate)additionalData.getNddValue()));
                segment.setNotValidAfter(additionalData.getNdpValue() == null ? null : DateUtils.asDate((LocalDate)additionalData.getNdpValue()));
                segment.setAirlineLocator(additionalData.getAirlineLocatorValue());
                segment.setSeatNo(additionalData.getSeatValue());
                segment.setMealServiceIndicator(additionalData.getMealValue());
                segment.setServiceClass(additionalData.getServiceClassValue());
                segment.setEndDate(DateUtils.asDate((LocalDateTime)additionalData.getEndDateValue()));
                segment.setBoard(additionalData.getBoardValue());
                List<SpecialServiceRequest> ssrs = AirProductFXHelper.fromVMSsrs(segmentVM.getSuperEMDColumn().getSpecialServiceRequest());
                segment.getSsrs().clear();
                segment.getSsrs().addAll(ssrs);
                BookingFileProductAirSegmentFreeLuggageInfoPaneVM freeLuggageInfo = segmentVM.getSuperColumn().getFreeLuggageInfo();
                Boolean pqInfoHasLuggage = freeLuggageInfo.getPqInfoHasLuggage();
                if (pqInfoHasLuggage != null) {
                    LuggageInfo luggageInfo = new LuggageInfo();
                    if (pqInfoHasLuggage.booleanValue()) {
                        AirSegmentLuggageValuePaneVM pqInfoValue = freeLuggageInfo.getPqInfoValue();
                        luggageInfo.setQuantity(pqInfoValue.getQuantity());
                        luggageInfo.setUnit(pqInfoValue.getUnit());
                    } else {
                        luggageInfo.setNil(true);
                    }
                    segment.setLuggageInfo(luggageInfo);
                }
                if (freeLuggageInfo.isHasFreeLuggageInfo()) {
                    fareDetails = segment.getFareDetails();
                    if (fareDetails == null) {
                        fareDetails = new FareDetails();
                        segment.setFareDetails(fareDetails);
                    }
                    info = new ExtendedLuggageInfo();
                    info.setPieces(freeLuggageInfo.getFreeLuggageInfoQuantity());
                    AirSegmentLuggageValuePaneVM freeLuggageInfoWeight = freeLuggageInfo.getFreeLuggageInfoWeight();
                    info.setWeight(freeLuggageInfoWeight.getQuantity());
                    info.setWeightUnit(freeLuggageInfoWeight.getUnit());
                    hasExtendedDimensions = freeLuggageInfo.getFreeLuggageInfoDimensions().getHasExtendedDimensions();
                    if (hasExtendedDimensions != null) {
                        AirSegmentLuggageDimensionsPaneVM freeLuggageInfoDimensions = freeLuggageInfo.getFreeLuggageInfoDimensions();
                        if (hasExtendedDimensions.booleanValue()) {
                            extendedDimensions = freeLuggageInfoDimensions.getExtendedDimensions();
                            info.setLength(Integer.valueOf(extendedDimensions.getLength()));
                            info.setWidth(Integer.valueOf(extendedDimensions.getWidth()));
                            info.setHeight(Integer.valueOf(extendedDimensions.getHeight()));
                        } else {
                            info.setDimensionsSum(Integer.valueOf(freeLuggageInfoDimensions.getDimensionSum()));
                        }
                        info.setDimensionUnit(freeLuggageInfoDimensions.getUnit());
                    }
                    fareDetails.setLuggageInfo(info);
                }
                if (freeLuggageInfo.isHasFreeCabinLuggageInfo()) {
                    fareDetails = segment.getFareDetails();
                    if (fareDetails == null) {
                        fareDetails = new FareDetails();
                        segment.setFareDetails(fareDetails);
                    }
                    info = new ExtendedLuggageInfo();
                    info.setPieces(freeLuggageInfo.getFreeCabinLuggageInfoQuantity());
                    AirSegmentLuggageValuePaneVM freeCabinLuggageInfoWeight = freeLuggageInfo.getFreeCabinLuggageInfoWeight();
                    info.setWeight(freeCabinLuggageInfoWeight.getQuantity());
                    info.setWeightUnit(freeCabinLuggageInfoWeight.getUnit());
                    hasExtendedDimensions = freeLuggageInfo.getFreeCabinLuggageInfoDimensions().getHasExtendedDimensions();
                    if (hasExtendedDimensions != null) {
                        AirSegmentLuggageDimensionsPaneVM freeCabinLuggageInfoDimensions = freeLuggageInfo.getFreeCabinLuggageInfoDimensions();
                        if (hasExtendedDimensions.booleanValue()) {
                            extendedDimensions = freeCabinLuggageInfoDimensions.getExtendedDimensions();
                            info.setLength(Integer.valueOf(extendedDimensions.getLength()));
                            info.setWidth(Integer.valueOf(extendedDimensions.getWidth()));
                            info.setHeight(Integer.valueOf(extendedDimensions.getHeight()));
                        } else {
                            info.setDimensionsSum(Integer.valueOf(freeCabinLuggageInfoDimensions.getDimensionSum()));
                        }
                        info.setDimensionUnit(freeCabinLuggageInfoDimensions.getUnit());
                    }
                    fareDetails.setCabinLuggageInfo(info);
                }
            }
        }
    }

    private static void toVMAirCostColumnSum(boolean negate, BookingFileProductAirCostSumPaneVM sumCell, Product product, AirProductUIData productData) {
        if (productData.getTariffBaseFare() != null) {
            sumCell.setBaseSumValue(AirProductFXHelper.getValue(productData.getTariffBaseFare().getValue(), negate));
            sumCell.setBaseCurrencyValue(productData.getTariffBaseFare().getCurrency());
        }
        sumCell.setBaseAdditionValue(AirProductFXHelper.getValue(product.getAddCollectBase(), negate));
        sumCell.setEqSumValue(AirProductFXHelper.getValue(productData.getTariffEquivalentFare(), negate));
        sumCell.setEqAdditionValue(AirProductFXHelper.getValue(product.getAddCollectEquivalent(), negate));
        sumCell.setEqTAXValue(AirProductFXHelper.getValue(productData.getTariffEquivalentVat(), negate));
        sumCell.setSumTaxValue(AirProductFXHelper.getValue(productData.getTaxEquivalentAmount(), negate));
        sumCell.setSumTaxAdditionValue(AirProductFXHelper.getValue(productData.getTaxEquivalentAddCollect(), negate));
        BigDecimal taxEquivalentVat = productData.getTaxEquivalentVat();
        sumCell.setSumTaxTAXValue(AirProductFXHelper.getValue(taxEquivalentVat, negate));
        BigDecimal sum = BigDecimal.ZERO;
        for (OBFee obFee : product.getObFees()) {
            if (obFee.getAmount() == null || obFee.getAmount().getValue() == null) continue;
            sum = sum.add(obFee.getAmount().getValue());
        }
        sumCell.setAdditionalValue(AirProductFXHelper.getValue(sum, negate));
        if (product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE) {
            sumCell.setFineAdditionValue(product.getPenalty());
        }
        sumCell.setFineValue(product.getPenalty());
        sumCell.setFineTAXValue(productData.getPenaltyVat());
        sumCell.setTotalValue(AirProductFXHelper.getValue(productData.getTotalEquivalentAmount(), negate));
        sumCell.setTotalTAXValue(AirProductFXHelper.getValue(product.getTotalVendorEquivalentVatAmount(), negate));
        if (sumCell.getTotalTAXValue() != null && sumCell.getEqTAXValue() != null && sumCell.getEqTAXValue().equals(sumCell.getSumTaxTAXValue()) && sumCell.getEqTAXValue().equals(sumCell.getTotalTAXValue())) {
            sumCell.setEqTAXValue(null);
            sumCell.setSumTaxTAXValue(null);
        }
        sumCell.setTotalAdditionValue(AirProductFXHelper.getValue(productData.getTotalAdditionalAmount(), negate));
        if (productData.getTariffEquiveFareCurrency() != null) {
            String currency = productData.getTariffEquiveFareCurrency();
            sumCell.setEqCurrencyValue(currency);
            sumCell.setSumTaxCurrencyValue(currency);
            sumCell.setAdditionalCurrencyValue(currency);
            sumCell.setFineCurrencyValue(currency);
            sumCell.setTotalCurrencyValue(currency);
        }
    }

    private static void toVMAirCostColumnRates(BookingFileProductRatesPaneVM rates, AirProductUIData productData) {
        if (productData != null && productData.getTariffBaseFare() != null) {
            rates.setBaseCurrencyValue(productData.getTariffBaseFare().getCurrency());
        }
        rates.setEqCurrencyValue(productData == null || productData.getTariffEquiveFareCurrency() == null ? null : productData.getTariffEquiveFareCurrency());
        rates.setRateValue(productData == null ? null : productData.getTariffFareRate());
    }

    public static void fromVMAirCost(BookingFileProductAirCostPaneVM aviaCostVM, Product product, AirProductUIData productData) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        Money tariffBaseFare = new Money();
        BookingFileProductAirCostSumPaneVM sumCell = aviaCostVM.getSum();
        String eqCurrencyValue = sumCell.getEqCurrencyValue();
        tariffBaseFare.setValue(AirProductFXHelper.getValue(sumCell.getBaseSumValue(), negate));
        tariffBaseFare.setCurrency(sumCell.getBaseCurrencyValue());
        product.setAddCollectBase(AirProductFXHelper.getValue(sumCell.getBaseAdditionValue(), negate));
        productData.setTariffBaseFare(tariffBaseFare);
        productData.setTariffEquivalentFare(AirProductFXHelper.getValue(sumCell.getEqSumValue(), negate));
        product.setAddCollectEquivalent(AirProductFXHelper.getValue(sumCell.getEqAdditionValue(), negate));
        product.setPenalty(sumCell.getFineValue());
        product.setTotalVendorEquivalentVatAmount(AirProductFXHelper.getValue(sumCell.getTotalTAXValue(), negate));
        if (product.getGdsCurrency() == null || !Objects.equals(productData.getTariffEquiveFareCurrency(), eqCurrencyValue)) {
            product.setGdsCurrency(eqCurrencyValue);
        }
        AirProductFXHelper.fromVMTaxes(negate, aviaCostVM.getCell1().getContent(), product);
        List<OBFee> obFees = AirProductFXHelper.fromVMObFees(negate, aviaCostVM.getCell2().getContent());
        product.getObFees().clear();
        product.getObFees().addAll(obFees);
        AirProductFXHelper.fromVMVatComponents(negate, aviaCostVM.getCell4().getContent(), product);
    }

    private static void fromVMAirAdditionalParametersTariff(BookingFileProductAviaAdditionalsTariffVM model, Product product) {
        product.setEndorsement(model.getEndorsement());
        product.setFareCalculationData(model.getFareCalculationData());
        product.setTelexNumber(model.getTelexNumber());
        product.setSubsidizedTariff(model.isSubsidizedTariff());
        VMHelper.transfer(model.getSpecialTariff(), product.getSpecialTariffs());
    }

    private static void fromVMAirAdditonalParametersReports(BookingFileProductAviaAdditionalsReportsVM model, Product product) {
        product.setTchDirectContract(model.getTchDirectContract());
        product.setContainsReturnFareDifferenceData(model.isReturnFareDifference());
    }

    private static void fromVMAirAdditionalParametersDiscount(BookingFileProductAviaAdditionalsDiscountVM model, Product product) {
        product.getTripartiteContractDetails().setContract(model.getContract());
        product.getTripartiteContractDetails().setDiscountCode(model.getCode());
        product.getTripartiteContractDetails().setDiscountRate(model.getRate());
        product.getTripartiteContractDetails().setDiscountValue(model.getValue());
        product.getTripartiteContractDetails().setIssuedUnder3d(model.isIssuedUnder3d());
    }

    private static void fromVMAirAdditionalParametersCharter(BookingFileProductAviaCharterQuotaBindingVM model, Product product) {
        SUBlockCharterQuotaReference forwardQuota = product.getCharterQuotaBinding().getForwardQuota();
        BookingFileProductAviaCharterForwardQuotaVM fQuotaVM = model.getForwardQuota();
        forwardQuota.setContract(fQuotaVM.getContract());
        if (fQuotaVM.getAppendix() != null) {
            forwardQuota.setAppendixUid(fQuotaVM.getAppendix().getNestedEntityUid());
            forwardQuota.setAppendixNo(fQuotaVM.getAppendix().getCaption());
        }
        forwardQuota.setTariffClassOfBooking(fQuotaVM.getTariffClassOfBooking() == null ? null : fQuotaVM.getTariffClassOfBooking().getClassOfBooking());
        forwardQuota.setQuotaDate(DateUtils.asDate((LocalDate)fQuotaVM.getQuotaDate()));
        forwardQuota.setQuotaFlightNo(fQuotaVM.getQuotaFlightNo());
        SUBlockCharterQuotaReference backwardQuota = product.getCharterQuotaBinding().getBackwardQuota();
        BookingFileProductAviaCharterBackwardQuotaVM bQuotaVM = model.getBackwardQuota();
        backwardQuota.setContract(bQuotaVM.getContract());
        if (bQuotaVM.getAppendix() != null) {
            backwardQuota.setAppendixUid(bQuotaVM.getAppendix().getNestedEntityUid());
            backwardQuota.setAppendixNo(bQuotaVM.getAppendix().getCaption());
        }
        backwardQuota.setTariffClassOfBooking(bQuotaVM.getTariffClassOfBooking() == null ? null : bQuotaVM.getTariffClassOfBooking().getClassOfBooking());
        backwardQuota.setQuotaDate(DateUtils.asDate((LocalDate)bQuotaVM.getQuotaDate()));
        backwardQuota.setQuotaFlightNo(bQuotaVM.getQuotaFlightNo());
    }

    public static void fromVMAirAdditionalParameters(BookingFileProductAirOtherParametersPanelVM parametersVM, Product product) {
        AirProductFXHelper.fromVMAirAdditionalParametersTariff(parametersVM.getTariff(), product);
        AirProductFXHelper.fromVMAirAdditonalParametersReports(parametersVM.getReports(), product);
        AirProductFXHelper.fromVMAirAdditionalParametersDiscount(parametersVM.getDiscount(), product);
        AirProductFXHelper.fromVMAirAdditionalParametersCharter(parametersVM.getPopups().getCharterBinding(), product);
        product.setComments(parametersVM.getPopups().getComments());
        GeneralProductFXHelper.fromVMPassiveSegments(parametersVM.getPopups().getPassiveSegments(), (BaseProduct)product);
    }

    public static void fromVMEMDGeneralParameters(BookingFileProductEMDPanelVM panelVM, BookingFile bookingFile, Product product, AirProductUIData productData, boolean isRefundOrExchange) {
        AirProductFXHelper.fromVMAirTicketInformation(panelVM.getGeneral().getTicketInfo(), product);
        AirProductFXHelper.fromVMAirTravelerInformation(panelVM.getGeneral().getTravelerInfo(), product);
        product.setMcoCategory(panelVM.getGeneral().getTicketInfo().getEmdCategoryValue());
        product.setProductCategory(ProductCategory.MCO);
        AirProductFXHelper.fromVMAirSalesChain(panelVM.getGeneral().getSalesChain(), product, productData);
        AirProductFXHelper.fromVMAirControlStatuses(panelVM.getStatuses(), product, isRefundOrExchange);
        if (panelVM.getGeneral().getTicketInfo().getEmdCategoryValue() == MCOCategory.EXCESS_LUGGAGE) {
            product.setLuggageUnits(panelVM.getGeneral().getTravelerInfo().getEmdLuggageValue().getUnit());
            product.setLuggageWeight(Double.valueOf(panelVM.getGeneral().getTravelerInfo().getEmdLuggageValue().getAmount()));
        } else if (panelVM.getGeneral().getTicketInfo().getEmdCategoryValue() == MCOCategory.GROUP_PREPAYMENT) {
            product.setLuggageWeight(Double.valueOf(panelVM.getGeneral().getTravelerInfo().getEmdGroupValue()));
        }
        product.setTicketType(panelVM.getGeneral().getSalesChain().getTicketTypeValue());
        Optional.ofNullable(CollectionUtil.head((Iterable)AirProductHelper.getSegments((Collection)product.getSegmentTariffs()))).ifPresent(segment -> segment.setSeatNo(panelVM.getGeneral().getTravelerInfo().getReservedSeatValue()));
    }

    public static void fromVMBagageGeneralParameters(BookingFileProductBagagePanelVM panelVM, BookingFile bookingFile, Product product, AirProductUIData productData, boolean isRefundOrExchange) {
        AirProductFXHelper.fromVMBagageTicketInformation(panelVM.getGeneral().getTicketInfo(), product);
        AirProductFXHelper.fromVMBagageTravelerInformation(panelVM.getGeneral().getTravelerInfo(), product);
        product.setProductCategory(ProductCategory.EXCESS_BAGAGE);
        AirProductFXHelper.fromVMAirSalesChain(panelVM.getGeneral().getSalesChain(), product, productData);
        AirProductFXHelper.fromVMAirControlStatuses(panelVM.getStatuses(), product, isRefundOrExchange);
        product.setTicketType(panelVM.getGeneral().getSalesChain().getTicketTypeValue());
    }

    public static void fromVMEMDAdditionalParameters(BookingFileProductEMDOtherParametersPanelVM parametersVM, Product product) {
        AirProductFXHelper.fromVMAirAdditionalParametersTariff((BookingFileProductAviaAdditionalsTariffVM)parametersVM.getTariff(), product);
        product.setRfisc(parametersVM.getTariff().getRfisc());
        AirProductFXHelper.fromVMAirAdditonalParametersReports(parametersVM.getReports(), product);
        product.setComments(parametersVM.getPopups().getComments());
    }

    public static void fromVMBagageAdditionalParameters(BookingFileProductBagageOtherParametersPanelVM parametersVM, Product product) {
        AirProductFXHelper.fromVMAirAdditionalParametersTariff((BookingFileProductAviaAdditionalsTariffVM)parametersVM.getTariff(), product);
        product.setRfisc(parametersVM.getTariff().getRfisc());
        AirProductFXHelper.fromVMAirAdditonalParametersReports(parametersVM.getReports(), product);
        product.setComments(parametersVM.getPopups().getComments());
    }

    public static void fromVMEMDRelatedProducts(BookingFileProductEMDRelatedProductsVM productsVM, Product product) {
        product.setMainProductCode(productsVM.getMainProductCode());
        product.setMainProductNumber(productsVM.getMainProductNumber());
        Map<String, Product> productMap = product.getReservation().getBookingFile().getReservations().stream().flatMap(el -> el.getProducts().stream()).filter(el -> el instanceof Product).map(el -> (Product)el).collect(Collectors.toMap(BaseIdentity::getUid, el -> el));
        product.getRelatedProducts().forEach(prod -> productMap.put(prod.getUid(), (Product)prod));
        product.getRelatedProducts().clear();
        product.getRelatedProducts().addAll(productsVM.getRelatedProducts().stream().map(vm -> (Product)productMap.get(vm.getProductUID())).collect(Collectors.toList()));
    }

    public static void fromVMBagageRelatedProducts(BookingFileProductBagageRelatedProductsVM productsVM, Product product) {
        product.setMainProductCode(productsVM.getMainProductCode());
        product.setMainProductNumber(productsVM.getMainProductNumber());
        Map<String, Product> productMap = product.getReservation().getBookingFile().getReservations().stream().flatMap(el -> el.getProducts().stream()).filter(el -> el instanceof Product).map(el -> (Product)el).collect(Collectors.toMap(BaseIdentity::getUid, el -> el));
        product.getRelatedProducts().forEach(prod -> productMap.put(prod.getUid(), (Product)prod));
        product.getRelatedProducts().clear();
        product.getRelatedProducts().addAll(productsVM.getRelatedProducts().stream().map(vm -> (Product)productMap.get(vm.getProductUID())).collect(Collectors.toList()));
    }

    public static void fillBasicProductFields(Product product) {
        if (product.getProductCategory() == null) {
            product.setProductCategory(ProductCategory.AIR);
        }
        if (product.getStatus() == null) {
            product.setStatus(ProductStatus.SELL);
        }
        if (product.getTicketType() == null) {
            product.setTicketType(TicketType.OWN);
        }
    }

    private static SUBlockCharterTariffInfo findTariffInfo(SUBlockCharterAppendix appendix, String classOfBooking) {
        Optional<SUBlockCharterTariffInfo> tariff;
        if (appendix != null && classOfBooking != null && (tariff = appendix.getTariffs().stream().filter(t -> classOfBooking.equals(t.getClassOfBooking())).findFirst()).isPresent()) {
            return tariff.get();
        }
        return null;
    }

    private static SegmentUIData findSegmentUIData(List<SegmentUIData> segments, String uid) {
        if (uid == null) {
            return null;
        }
        for (SegmentUIData data : segments) {
            if (!uid.equals(data.getRelatedSegmentUID())) continue;
            return data;
        }
        return null;
    }

    public static List<ProductFopUIData> toUIDataFop(List<BookingFileProductFopTableVM> fopList) {
        ArrayList<ProductFopUIData> fops = new ArrayList<ProductFopUIData>();
        for (BookingFileProductFopTableVM fopVM : fopList) {
            ProductFopUIData fop = new ProductFopUIData();
            fop.setUid(fopVM.getUid());
            fop.setContractType(fopVM.getContractType());
            fop.setAmount(fopVM.getSum());
            fop.setCurrency(fopVM.getCurrency());
            fop.setAgent(fopVM.getAgent());
            BookingFileProductFopCardsVM injectedWidget = fopVM.getSuperColumn().getContent();
            fop.setBankName(injectedWidget.getBank().getBankName());
            fop.setOperationDate(DateUtils.asDate((LocalDateTime)fopVM.getDate()));
            fop.setPassengerStatus(injectedWidget.getDocument().getDetails());
            if (Arrays.asList(PaymentType.CREDIT, PaymentType.INTERLINE, PaymentType.MTD, PaymentType.MTD_AGENCY).contains(fopVM.getPaymentType())) {
                fop.setNumber(injectedWidget.getDocument().getDocumentNumber());
            } else {
                fop.setNumber(injectedWidget.getRelatedTicketNumber().getNumber());
            }
            fop.setPayer(injectedWidget.getContractTypeVendor().getPayer());
            fop.setRefused(fopVM.isDenied());
            fop.setPaymentType(fopVM.getPaymentType());
            fop.setTchCCAccompanyingDocumentType(injectedWidget.getAccompanyingDocument().getAccompanyingDocumentType());
            if (injectedWidget.getCard().getVendor() != null || injectedWidget.getCard().getNumber() != null || injectedWidget.getCard().getSecurityCode() != null || injectedWidget.getCard().getExpirationDate() != null) {
                Card card = new Card();
                card.setExpiration(DateUtils.asDate((LocalDate)injectedWidget.getCard().getExpirationDate()));
                card.setVendor(injectedWidget.getCard().getVendor());
                card.setNumber(injectedWidget.getCard().getNumber());
                card.setSecurityCode(injectedWidget.getCard().getSecurityCode());
                fop.setCard(card);
            }
            fop.getCommissionUids().clear();
            fop.getCommissionUids().addAll(injectedWidget.getDiscounts().stream().filter(d -> d.getDiscount() != null && d.getDiscount().getUid() != null).map(d -> d.getDiscount().getUid()).collect(Collectors.toList()));
            fop.getCommissionUids().addAll(injectedWidget.getFees().stream().filter(f -> f.getFee() != null && f.getFee().getUid() != null).map(f -> f.getFee().getUid()).collect(Collectors.toList()));
            fop.setCategory(fopVM.getCategory());
            fops.add(fop);
        }
        return fops;
    }

    private static String taxesUid2Code(List<Tax> taxes, String uid) {
        for (Tax tax : taxes) {
            if (!MiscUtil.equals((Object)tax.getUid(), (Object)uid)) continue;
            return tax.getCode();
        }
        return uid;
    }

    private static String taxesCode2Uid(List<Tax> taxes, String code) {
        for (Tax tax : taxes) {
            if (!MiscUtil.equals((Object)tax.getCode(), (Object)code)) continue;
            return tax.getUid();
        }
        return code;
    }

    public static List<SegmentsData> toSegmentsData(List<SegmentTariff> segmentTariffs) {
        ArrayList<SegmentsData> list = new ArrayList<SegmentsData>();
        segmentTariffs.forEach(tariff -> {
            SegmentsData data = new SegmentsData();
            list.add(data);
            data.setSegments(new ArrayList());
            data.getSegments().addAll(tariff.getSegments());
            data.setDescription(AirProductFXHelper.getSegmentsDataDescription(data.getSegments()));
        });
        return list;
    }

    public static String getSegmentsDataDescription(SegmentTariff segmentTariff) {
        return segmentTariff == null ? null : AirProductFXHelper.getSegmentsDataDescription(segmentTariff.getSegments());
    }

    public static String getSegmentsDataDescription(List<Segment> segments) {
        int min;
        if (segments == null || segments.isEmpty()) {
            return null;
        }
        int max = min = segments.get(0).getRecordNumber();
        for (Segment segment : segments) {
            if (segment.getRecordNumber() < min) {
                min = segment.getRecordNumber();
            }
            if (segment.getRecordNumber() <= max) continue;
            max = segment.getRecordNumber();
        }
        if (min == max) {
            return Integer.toString(min);
        }
        return min + " - " + max;
    }

    public static String getBigDecimalPresentation(BigDecimal bigDecimal) {
        LocaleManager lm = LocaleManager.get();
        DecimalFormat formatter = lm.getLocaleData(lm.getCurrentLocale()).getPriceFormat();
        return formatter.format(bigDecimal != null ? bigDecimal : BigDecimal.ZERO);
    }

    private static CommissionsDiscountsFeesUIDataHandler findHandler(List<CommissionsDiscountsFeesUIDataHandler> handlers, ContractType contractType) {
        for (CommissionsDiscountsFeesUIDataHandler handler : handlers) {
            if (handler.getContractType() != contractType) continue;
            return handler;
        }
        return null;
    }

    public static Map<Integer, MiscUtil.Pair<String, String>> getSegmentsPoints(String productUid, List<Node> views) {
        Node node = UiUtil.findViewWithModelUid(views, (String)productUid);
        if (node != null) {
            return (Map)node.getProperties().get((Object)"segmentsPoints");
        }
        return null;
    }

    public static String getProductType(Product product) {
        if (product == null) {
            return null;
        }
        ProductCategory productCategory = product.getProductCategory();
        if (productCategory == ProductCategory.AIR) {
            return ProductType.AIR_TICKET.toString();
        }
        if (productCategory == ProductCategory.EXCESS_BAGAGE) {
            return ProductType.EXCESS_BAGAGE.toString();
        }
        if (productCategory == ProductCategory.MCO) {
            return productCategory.toString();
        }
        return null;
    }

    public static MiscUtil.Pair<Product, AirProductUIData> getPrototypeData(ProductCategory productCategory) {
        AgentData agentData = Prefetched.getData().getCurrentAgentData();
        Product product = new Product();
        product.setProductCategory(productCategory);
        GeneralProductFXHelper.loadPrototypeData((BaseProduct)product);
        MiscUtil.Pair prototypeData = null;
        try {
            prototypeData = ((StandardProductPrototypeService)RpcServiceManager.get().getService(StandardProductPrototypeService.class)).getPrototypeData(ServiceInvocationContext.get(), productCategory, agentData, product);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        if (prototypeData == null) {
            prototypeData = new MiscUtil.Pair((Object)new Product(), (Object)new AirProductUIData());
        }
        return prototypeData;
    }

    public static void updateNode(BookingFileProductAirPanel node, BookingFileSpaceVM bookingFileVM) {
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).getParametersNode().productClassProperty().setValue(Product.class);
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).clientProperty().setValue((Object)bookingFileVM.getMainFull().getGeneralParameters().getClient());
    }

    public static void updateNode(BookingFileProductEMDPanel node, BookingFileSpaceVM bookingFileVM) {
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).getParametersNode().productClassProperty().setValue(Product.class);
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).clientProperty().setValue((Object)bookingFileVM.getMainFull().getGeneralParameters().getClient());
    }

    public static void updateNode(BookingFileProductBagagePanel node, BookingFileSpaceVM bookingFileVM) {
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).getParametersNode().productClassProperty().setValue(Product.class);
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).clientProperty().setValue((Object)bookingFileVM.getMainFull().getGeneralParameters().getClient());
    }
}

