/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductDeliveryDeliveryParametersContentsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductDeliveryDeliveryParametersDateVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductDeliveryDeliveryParametersGeneralVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductDeliveryDeliveryParametersInfoVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductDeliveryDeliveryParametersOtherVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductDeliveryDeliveryParametersTotalVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductDeliveryDeliveryParametersVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductDeliveryGeneralPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductDeliveryGeneralParametersGeneralVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductDeliveryGeneralParametersOtherVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductDeliveryPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductDeliveryPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductDeliveryStatusesPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticAfs;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.StandardProductPrototypeService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.uidata.DeliveryUIData;
import com.gridnine.xtrip.common.model.delivery.Delivery;
import com.gridnine.xtrip.common.model.delivery.DeliveryIndex;
import com.gridnine.xtrip.common.model.delivery.DeliveryItem;
import com.gridnine.xtrip.common.model.delivery.DeliveryItemType;
import com.gridnine.xtrip.common.model.delivery.DeliveryStatus;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocumentIndex;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.util.Pair;

public class DeliveryFXHelper {
    public static final String ENTITY = Messages.From_list;
    public static final String TEXT = Messages.Manually;

    public static void toVMDeliveryOverviewParameters(BookingFileProductDeliveryPanelVM view, Delivery product, DeliveryUIData productData) {
        view.setUid(product.getUid());
        view.setProductShortName(BookingHelper.generateShortProductName((BaseProduct)product));
        view.getItemList().addAll(product.getDeliveryItems());
    }

    public static void toVMDeliveryGeneralParameters(BookingFileProductDeliveryGeneralPanelVM view, Delivery product, DeliveryUIData productData, BookingFileProductDeliveryStatusesPaneVM statuses) {
        DeliveryFXHelper.toVMDeliveryNumberAndStatus(view.getGeneral(), product);
        DeliveryFXHelper.toVMDeliveryOwnerParameters(view.getOther(), product);
        DeliveryFXHelper.toVMDeliveryControlStatuses(statuses, product, productData);
    }

    public static void toVMDeliveryContents(BookingFileProductDeliveryDeliveryParametersVM view, Delivery product, DeliveryUIData productData) {
        DeliveryFXHelper.toVMDeliveryAddress(view.getAddress().getGeneral(), product, productData);
        DeliveryFXHelper.toVMDeliveryDate(view.getAddress().getDate(), product);
        DeliveryFXHelper.toVMDeliveryInfo(view.getAddress().getInfo(), product);
        DeliveryFXHelper.toVMDeliveryOther(view.getAddress().getOther(), product);
        DeliveryFXHelper.toVMDeliveryPrice(view.getAddress().getTotal(), product);
        DeliveryFXHelper.toVMDeliveryItems(view.getContents(), product);
    }

    private static void toVMDeliveryNumberAndStatus(BookingFileProductDeliveryGeneralParametersGeneralVM view, Delivery product) {
        String systemNumber = product.getSystemNumber();
        DeliveryStatus status = product.getStatus();
        view.setProductValue(ProductType.DELIVERY.toString());
        view.setNumberValue(systemNumber != null ? systemNumber : null);
        view.setStatusValue(status != null ? status.toString() : null);
        view.setTicketTypeValue(product.getTicketType());
        view.setCreatedValue(DateUtils.asLocalDateTime((Date)product.getIssueDate()));
        view.setCorrectionDateValue(DateUtils.asLocalDateTime((Date)product.getCorrectionDate()));
        view.setShipmentsDateValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDate()));
        view.setShipmentsDateSubagentValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDateSubagent()));
    }

    private static void toVMDeliveryOwnerParameters(BookingFileProductDeliveryGeneralParametersOtherVM view, Delivery product) {
        view.setAgencyValue(product.getAgency());
        view.setSalesPointValue(product.getSalesPoint());
        view.setAgentValue(product.getAgent());
        view.setCourierValue(product.getCourier());
    }

    private static void toVMDeliveryControlStatuses(BookingFileProductDeliveryStatusesPaneVM view, Delivery product, DeliveryUIData productData) {
        view.setChecked(product.isChecked());
        view.setFinished(product.isCompleted());
        view.setHasErrors(productData.isHasErrors());
        view.setHasWarnings(productData.isHasWarnings());
        view.setRulesApplied(product.isContractRulesApplied());
    }

    private static void toVMDeliveryAddress(BookingFileProductDeliveryDeliveryParametersGeneralVM view, Delivery product, DeliveryUIData productData) {
        String addresseeName = product.getAddresseeName();
        EntityReference addressee = product.getAddressee();
        String contactPersonName = product.getContactPersonName();
        EntityReference contactPerson = product.getContactPerson();
        if (addresseeName != null) {
            view.setAddresseeValue(new Pair((Object)TEXT, (Object)addresseeName));
        } else if (addressee != null) {
            view.setAddresseeValue(new Pair((Object)ENTITY, (Object)addressee));
        } else {
            view.setAddresseeValue(new Pair((Object)ENTITY, null));
        }
        view.setAddressValue(product.getAddress());
        view.setRegionValue(product.getDeliveryRegion());
        view.setMetroValue(product.getMetroStation());
        view.setLineValue(productData.getMetroLine());
        if (contactPersonName != null) {
            view.setContactValue(new Pair((Object)TEXT, (Object)contactPersonName));
        } else if (contactPerson != null) {
            view.setContactValue(new Pair((Object)ENTITY, (Object)contactPerson));
        } else {
            view.setContactValue(new Pair((Object)ENTITY, null));
        }
        view.setPhoneValue(product.getContactPhone());
    }

    private static void toVMDeliveryDate(BookingFileProductDeliveryDeliveryParametersDateVM view, Delivery product) {
        view.setDateValue(DateUtils.asLocalDate((Date)product.getStartDate()));
        view.setStartTimeValue(DateUtils.asLocalTime((Date)product.getStartDate()));
        view.setEndTimeValue(DateUtils.asLocalTime((Date)product.getEndDate()));
    }

    private static void toVMDeliveryInfo(BookingFileProductDeliveryDeliveryParametersInfoVM view, Delivery product) {
        view.setInfoValue(product.getAdditionalInfo());
    }

    private static void toVMDeliveryOther(BookingFileProductDeliveryDeliveryParametersOtherVM view, Delivery product) {
        view.setUrgentValue(product.isUrgent());
        view.setWithDocsValue(product.isWithDocuments());
    }

    private static void toVMDeliveryPrice(BookingFileProductDeliveryDeliveryParametersTotalVM view, Delivery product) {
        Map<Optional, BigDecimal> paymentTypeSumMap = product.getDeliveryItems().stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getPaymentType()), Collectors.reducing(BigDecimal.ZERO, item -> Optional.ofNullable(item.getCost()).orElse(BigDecimal.ZERO), BigDecimal::add)));
        BigDecimal totalSum = paymentTypeSumMap.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal cashSum = paymentTypeSumMap.get(Optional.of(PaymentType.CASH));
        view.setTotalValue(totalSum);
        view.setCashValue(cashSum != null ? cashSum : BigDecimal.ZERO);
    }

    private static void toVMDeliveryItems(Collection<BookingFileProductDeliveryDeliveryParametersContentsVM> view, Delivery product) {
        VMHelper.transfer(product.getDeliveryItems(), view, model -> new BookingFileProductDeliveryDeliveryParametersContentsVM(), (itemModel, itemVM) -> {
            itemVM.setObject(new Pair((Object)itemModel.getType(), itemModel.getObject()));
            itemVM.setSum(itemModel.getCost());
            itemVM.setFop(itemModel.getPaymentType());
            itemVM.setCurrency(itemModel.getCurrency());
        });
    }

    public static void toVMDeliveryComments(BookingFileProductDeliveryPanelVM view, Delivery product) {
        view.getOtherParameters().getPopups().setComments(product.getComments());
    }

    public static void fromVMDeliveryGeneralParameters(BookingFileProductDeliveryGeneralPanelVM view, Delivery product, BookingFileProductDeliveryStatusesPaneVM statuses) {
        DeliveryFXHelper.fromVMDeliveryNumber(view.getGeneral(), product);
        DeliveryFXHelper.fromVMDeliveryOwnerParameters(view.getOther(), product);
        DeliveryFXHelper.fromVMDeliveryControlStatuses(statuses, product);
    }

    public static void fromVMDeliveryContents(BookingFileProductDeliveryDeliveryParametersVM view, Delivery product) {
        DeliveryFXHelper.fromVMDeliveryAddress(view.getAddress().getGeneral(), product);
        DeliveryFXHelper.fromVMDeliveryDate(view.getAddress().getDate(), product);
        DeliveryFXHelper.fromVMDeliveryInfo(view.getAddress().getInfo(), product);
        DeliveryFXHelper.fromVMDeliveryOther(view.getAddress().getOther(), product);
        DeliveryFXHelper.fromVMDeliveryItems(view.getContents(), product);
    }

    private static void fromVMDeliveryNumber(BookingFileProductDeliveryGeneralParametersGeneralVM view, Delivery product) {
        product.setSystemNumber(view.getNumberValue());
        product.setTicketType(view.getTicketTypeValue());
        product.setIssueDate(DateUtils.asDate((LocalDateTime)view.getCreatedValue()));
        product.setCorrectionDate(DateUtils.asDate((LocalDateTime)view.getCorrectionDateValue()));
        product.setShipmentsDate(DateUtils.asDate((LocalDateTime)view.getShipmentsDateValue()));
        product.setShipmentsDateSubagent(DateUtils.asDate((LocalDateTime)view.getShipmentsDateSubagentValue()));
    }

    private static void fromVMDeliveryOwnerParameters(BookingFileProductDeliveryGeneralParametersOtherVM view, Delivery product) {
        product.setAgency(view.getAgencyValue());
        product.setSalesPoint(view.getSalesPointValue());
        product.setAgent(view.getAgentValue());
        product.setCourier(view.getCourierValue());
    }

    private static void fromVMDeliveryControlStatuses(BookingFileProductDeliveryStatusesPaneVM view, Delivery product) {
        product.setChecked(view.isChecked());
        product.setCompleted(view.isFinished());
        product.setContractRulesApplied(view.isRulesApplied());
    }

    private static void fromVMDeliveryAddress(BookingFileProductDeliveryDeliveryParametersGeneralVM view, Delivery product) {
        product.setAddresseeName(view.getAddresseeValue() != null ? (TextUtil.isSame((String)((String)view.getAddresseeValue().getKey()), (String)TEXT) ? (String)view.getAddresseeValue().getValue() : null) : null);
        product.setAddressee(view.getAddresseeValue() != null ? (TextUtil.isSame((String)((String)view.getAddresseeValue().getKey()), (String)ENTITY) ? (EntityReference)view.getAddresseeValue().getValue() : null) : null);
        product.setAddress(view.getAddressValue());
        product.setDeliveryRegion(view.getRegionValue());
        product.setMetroStation(view.getMetroValue());
        product.setContactPersonName(view.getContactValue() != null ? (TextUtil.isSame((String)((String)view.getContactValue().getKey()), (String)TEXT) ? (String)view.getContactValue().getValue() : null) : null);
        product.setContactPerson(view.getContactValue() != null ? (TextUtil.isSame((String)((String)view.getContactValue().getKey()), (String)ENTITY) ? (EntityReference)view.getContactValue().getValue() : null) : null);
        product.setContactPhone(view.getPhoneValue());
    }

    private static void fromVMDeliveryDate(BookingFileProductDeliveryDeliveryParametersDateVM view, Delivery product) {
        LocalDate dateVM = view.getDateValue();
        if (dateVM != null) {
            if (view.getStartTimeValue() != null) {
                LocalDateTime startVM = dateVM.atTime(view.getStartTimeValue());
                product.setStartDate(DateUtils.asDate((LocalDateTime)startVM));
            } else {
                product.setStartDate(null);
            }
            if (view.getEndTimeValue() != null) {
                LocalDateTime endVM = dateVM.atTime(view.getEndTimeValue());
                product.setEndDate(DateUtils.asDate((LocalDateTime)endVM));
            } else {
                product.setEndDate(null);
            }
        }
    }

    private static void fromVMDeliveryInfo(BookingFileProductDeliveryDeliveryParametersInfoVM view, Delivery product) {
        product.setAdditionalInfo(view.getInfoValue());
    }

    private static void fromVMDeliveryOther(BookingFileProductDeliveryDeliveryParametersOtherVM view, Delivery product) {
        product.setUrgent(view.isUrgentValue());
        product.setWithDocuments(view.isWithDocsValue());
    }

    private static void fromVMDeliveryItems(List<BookingFileProductDeliveryDeliveryParametersContentsVM> view, Delivery product) {
        VMHelper.transfer(view, product.getDeliveryItems(), vm -> new DeliveryItem(), (itemVM, itemModel) -> {
            itemModel.setType((DeliveryItemType)Optional.ofNullable(itemVM.getObject()).map(item -> (DeliveryItemType)item.getKey()).orElse(null));
            itemModel.setObject(Optional.ofNullable(itemVM.getObject()).map(item -> item.getValue()).orElse(null));
            itemModel.setCost(itemVM.getSum());
            itemModel.setPaymentType(itemVM.getFop());
            itemModel.setCurrency(itemVM.getCurrency());
        });
    }

    public static Reservation findReservationForDelivery(BookingFile bookingFile) {
        if (bookingFile.getReservations().isEmpty()) {
            Reservation reservation = new Reservation();
            reservation.setBookingFile(bookingFile);
            bookingFile.getReservations().add(reservation);
            return reservation;
        }
        Reservation reservation = (Reservation)bookingFile.getReservations().get(0);
        return reservation;
    }

    public static MiscUtil.Pair<Delivery, DeliveryUIData> getPrototypeData() {
        AgentData agentData = Prefetched.getData().getCurrentAgentData();
        Delivery product = new Delivery();
        GeneralProductFXHelper.loadPrototypeData((BaseProduct)product);
        MiscUtil.Pair prototypeData = null;
        try {
            prototypeData = ((StandardProductPrototypeService)RpcServiceManager.get().getService(StandardProductPrototypeService.class)).getPrototypeData(ServiceInvocationContext.get(), agentData, product);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        if (prototypeData == null) {
            prototypeData = new MiscUtil.Pair((Object)new Delivery(), (Object)new DeliveryUIData());
        }
        return prototypeData;
    }

    public static void updateNode(BookingFileProductDeliveryPanel node, BookingFileSpaceVM bookingFileVM) {
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).getParametersNode().productClassProperty().setValue(Delivery.class);
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).clientProperty().setValue((Object)bookingFileVM.getMainFull().getGeneralParameters().getClient());
    }

    public static List<TemplateDocumentIndex> getCourierRouteListTemplates() throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TemplateDocumentIndex.Property.templateId.name(), (Object)"courier-route-list"));
        return ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(ServiceInvocationContext.get(), TemplateDocumentIndex.class, query);
    }

    public static List<DeliveryIndex> searchSimilarlyDeliveries(EntityReference<Person> courier, Date deliveryDate) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.and((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)DeliveryIndex.Property.courier.name(), courier), SearchCriterion.eq((String)DeliveryIndex.Property.deliveryDate.name(), (Object)MiscUtil.clearTime((Date)deliveryDate))}));
        return ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(ServiceInvocationContext.get(), DeliveryIndex.class, query);
    }
}

