/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper;

import com.com.gridnine.xtrip.common.model.booking.xtriphotels.HotelGuaranteeCard;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelAdditionalParametersVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelCancellationChargeVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelCorpParametersVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelCostFineVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelCostPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelCostSumPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelCostTaxVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelParametersVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelPassengerVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelRoomDailyRateItemVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelRoomDetailsPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelRoomServiceVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelRoomVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelSalesChainPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelStatusesPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelTicketInfoPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelTravelerInfoPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductHotelVatVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticAfs;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.rpc.StandardProductPrototypeService;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.air.uidata.HotelProductUIData;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalService;
import com.gridnine.xtrip.common.model.booking.xtriphotels.CancellationCharge;
import com.gridnine.xtrip.common.model.booking.xtriphotels.DailyRate;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductTax;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Meal;
import com.gridnine.xtrip.common.model.booking.xtriphotels.PassengerTypeReference;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Penalty;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.RateMoney;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.EnumUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

public class HotelProductFXHelper {
    private static BigDecimal getValue(BigDecimal value, boolean negate) {
        if (value == null) {
            return null;
        }
        return negate ? value.negate() : value;
    }

    public static void toVMParameters(HotelProduct product, HotelProductUIData productData, BookingFileProductHotelPanelVM vm) {
        HotelProductFXHelper.toVMControlStatuses(product, productData, vm.getStatuses());
        BookingFileProductHotelTicketInfoPaneVM ticketInfoVM = vm.getGeneral().getTicketInfo();
        ticketInfoVM.setTicketNumberValue(product.getSystemNumber());
        ticketInfoVM.setProductValue(ProductType.HOTEL_RESERVATION.toString());
        ticketInfoVM.setStatusValue(EnumUtil.stringValueOf((Enum)product.getStatus()));
        ticketInfoVM.setOperationDateValue(DateUtils.asLocalDateTime((Date)product.getIssueDate()));
        ticketInfoVM.setCorrectionDateValue(DateUtils.asLocalDateTime((Date)product.getCorrectionDate()));
        ticketInfoVM.setUnholdDateValue(DateUtils.asLocalDateTime((Date)product.getUnholdDate()));
        ticketInfoVM.setServiceLocationType(product.getServiceLocationType());
        BookingFileProductHotelTravelerInfoPaneVM travelerInfoVM = vm.getGeneral().getTravelerInfo();
        Reservation reservation = product.getReservation();
        travelerInfoVM.setResNumberValue(reservation.getUid());
        travelerInfoVM.setPccValue(product.getPcc());
        travelerInfoVM.setTariffTypeValue(product.getTariffType());
        travelerInfoVM.setTicketTypeValue(product.getTicketType());
        travelerInfoVM.setProviderValue(product.getProvider());
        travelerInfoVM.setSubProviderValue(product.getSubProvider());
        travelerInfoVM.setSubProviderIdValue(product.getSubProviderId());
        travelerInfoVM.setShipmentsDateValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDate()));
        travelerInfoVM.setShipmentsDateSubagentValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDateSubagent()));
        BookingFileProductHotelSalesChainPaneVM salesChainVM = vm.getGeneral().getSalesChain();
        salesChainVM.getBlankOwnerValue().setBlankOwnerCode(product.getBlankOwnerRef());
        salesChainVM.getBlankOwnerValue().setBlankOwnerHotelNumber(product.getBlankOwnerCode());
        salesChainVM.setSupplierValue(productData.getSupplier());
        salesChainVM.setAgencyValue(productData.getAgency());
        salesChainVM.setSubagencyValue(productData.getSubagency());
        salesChainVM.setSalesPointValue(product.getSalesPoint());
        salesChainVM.setPrescribeAgentValue(product.getCashier());
        salesChainVM.setValidatorCodeValue(product.getValidatorCode());
        salesChainVM.setBranchValue(product.getBranch());
        vm.getGeneral().getOtherHotelParameters().getPassengers().clear();
        product.getTravellers().forEach(traveller -> {
            BookingFileProductHotelPassengerVM passangerVM = new BookingFileProductHotelPassengerVM();
            passangerVM.setPassenger(traveller);
            product.getTravellersPassengerTypes().stream().filter(el -> el.getTravellerUid().equals(traveller.getUid())).findFirst().ifPresent(passengerTypeReference -> passangerVM.setPassengerType(passengerTypeReference.getPassengerType()));
            vm.getGeneral().getOtherHotelParameters().getPassengers().add(passangerVM);
        });
        BookingFileProductHotelCorpParametersVM corpParametersVM = vm.getGeneral().getOtherHotelParameters().getCorpParameters();
        corpParametersVM.setCfValue(product.getCF());
        corpParametersVM.setContractValue(product.getAgencyContract());
        corpParametersVM.setDiscountValue(product.getCorporateDiscount());
        corpParametersVM.setCouponValue(product.getPromoCoupon());
        corpParametersVM.setGuaranteeValue(product.getGuaranteeType());
        if (product.getGuaranteeCard() != null && product.getGuaranteeType() != null) {
            corpParametersVM.setGuaranteePrefixValue(product.getGuaranteeCard().getCardType());
        }
        corpParametersVM.setGuaranteeCodeValue(product.getGuaranteeCode());
        BookingFileProductHotelParametersVM hotelParametersVM = vm.getGeneral().getHotelParameters();
        hotelParametersVM.setProviderCode(product.getProviderHotelCode());
        hotelParametersVM.setCodeValue(product.getHotelPropertyId());
        hotelParametersVM.setCountryValue(product.getHotelCountry());
        hotelParametersVM.setCityValue(product.getHotelLocation());
        hotelParametersVM.setChainValue(product.getHotelChainCode());
        hotelParametersVM.setStarsValue(product.getHotelStars());
        hotelParametersVM.setHotelValue(product.getHotelName());
        hotelParametersVM.setAddressValue(product.getHotelAddress());
        hotelParametersVM.setPhoneValue(product.getHotelPhone());
        hotelParametersVM.setFaxValue(product.getHotelFax());
        hotelParametersVM.setProviderInformationValue(HotelProductHelper.getEssentialInfoString((HotelProduct)product));
    }

    public static void toVMCostParameters(HotelProduct product, HotelProductUIData productData, BookingFileProductHotelCostPaneVM vm) {
        String currency;
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        VMHelper.transfer(product.getTaxes(), vm.getFees().getContent(), m -> new BookingFileProductHotelCostTaxVM(), (mod, modVM) -> {
            modVM.setAddition(mod.getAddCollect());
            modVM.setCode(mod.getCode());
            modVM.setCurrency(mod.getAmount().getCurrency());
            modVM.setEqSum(HotelProductFXHelper.getValue(mod.getEquivalentAmount(), negate));
            modVM.setSum(HotelProductFXHelper.getValue(mod.getAmount().getValue(), negate));
            modVM.setVat(HotelProductFXHelper.getValue(mod.getEquivalentVatAmount(), negate));
            modVM.setVatRate(mod.getEquivalentVatRate());
        });
        List taxes = product.getTaxes();
        if (product.getVendorVatDetalization() != null) {
            VMHelper.transfer(product.getVendorVatDetalization().getComponents(), vm.getVats().getContent(), m -> new BookingFileProductHotelVatVM(), (mod, modVM) -> {
                modVM.setBasis(HotelProductFXHelper.getValue(mod.getBasis(), negate));
                modVM.setRate(mod.getRate() == null ? null : new BigDecimal(mod.getRate()));
                modVM.setSum(HotelProductFXHelper.getValue(mod.getSum(), negate));
                VMHelper.transfer(mod.getBasisTypes(), modVM.getBasisTypes());
                VMHelper.transfer(mod.getTaxesUids().stream().map(uid -> HotelProductFXHelper.taxesUid2Code(taxes, uid)).collect(Collectors.toList()), modVM.getCodes());
            });
        }
        VMHelper.transfer(product.getPenalties(), vm.getFines().getContent(), m -> new BookingFileProductHotelCostFineVM(), (mod, modVM) -> {
            modVM.setCode(mod.getCode());
            modVM.setName(mod.getName());
            modVM.setEqSum(mod.getEquivalentAmount());
            modVM.setVat(mod.getEquivalentVatAmount());
            modVM.setVatRate(mod.getEquivalentVatRate());
        });
        BookingFileProductHotelCostSumPaneVM sumVM = vm.getSum();
        Money basePrice = HotelProductHelper.calcBasePrice((HotelProduct)product);
        if (basePrice != null) {
            sumVM.setBaseCurrencyValue(basePrice.getCurrency());
            sumVM.setBaseSumValue(HotelProductFXHelper.getValue(basePrice.getValue(), negate));
        }
        currency = (currency = product.getGdsCurrency()) == null ? Prefetched.getData().getEquivalentCurrency() : currency;
        sumVM.setEqSumValue(HotelProductFXHelper.getValue(HotelProductHelper.getEquivalentFare((HotelProduct)product), negate));
        sumVM.setEqSumVatValue(HotelProductFXHelper.getValue(HotelProductHelper.getEquivalentVatFare((HotelProduct)product), negate));
        sumVM.setEqCurrencyValue(currency);
        sumVM.setSumTaxValue(HotelProductFXHelper.getValue(HotelProductHelper.calculateTaxesEquivalentAmount((HotelProduct)product), negate));
        sumVM.setSumTaxVatValue(HotelProductFXHelper.getValue(HotelProductHelper.calculateTaxesEquivalentVatAmount((HotelProduct)product), negate));
        sumVM.setSumTaxCurrencyValue(currency);
        sumVM.setFineValue(HotelProductHelper.calculatePenaltyEquivalentAmount((HotelProduct)product, (boolean)false));
        sumVM.setFineVatValue(HotelProductHelper.calculatePenaltyEquivalentVatAmount((HotelProduct)product, (boolean)false));
        sumVM.setFineCurrencyValue(currency);
        sumVM.setAdditionalValue(HotelProductFXHelper.getValue(HotelProductHelper.calculateAddServicesEquivalentAmount((HotelProduct)product), negate));
        sumVM.setAdditionalVatValue(HotelProductFXHelper.getValue(HotelProductHelper.calculateAddServicesEquivalentVatAmount((HotelProduct)product), negate));
        sumVM.setAdditionalCurrencyValue(currency);
        sumVM.setTotalValue(HotelProductFXHelper.getValue(HotelProductHelper.calculateTotalEquivalentFare((HotelProduct)product), negate));
        sumVM.setTotalVatValue(HotelProductFXHelper.getValue(HotelProductHelper.calculateTotalVatAmount((HotelProduct)product), negate));
        sumVM.setTotalCurrencyValue(currency);
        sumVM.setRate(productData.getCurrencyRate());
    }

    private static String taxesUid2Code(List<HotelProductTax> taxes, String uid) {
        for (HotelProductTax tax : taxes) {
            if (!tax.getUid().equals(uid)) continue;
            return tax.getCode();
        }
        return uid;
    }

    public static void toVMPenalty(HotelProduct product, BookingFileProductHotelPanelVM vm) {
        VMHelper.transfer(product.getCancellationCharges(), vm.getCancellationCharges(), el -> new BookingFileProductHotelCancellationChargeVM(), (mod, modVM) -> {
            modVM.setStartDate(DateUtils.asLocalDateTime((Date)mod.getStartDate()));
            modVM.setEndDate(DateUtils.asLocalDateTime((Date)mod.getEndDate()));
            modVM.setDescription(mod.getPolicyText());
            RateMoney penalty = mod.getPenalty();
            if (penalty == null) {
                modVM.setPenaltyMoney(null);
                return;
            }
            Money penaltyMoney = penalty.getMoney();
            RateMoney newRateMoney = new RateMoney();
            Money money = new Money();
            if (penaltyMoney != null) {
                money.setValue(penaltyMoney.getValue());
                money.setCurrency(penaltyMoney.getCurrency());
                newRateMoney.setMoney(money);
            }
            newRateMoney.setRate(penalty.getRate());
            modVM.setPenaltyMoney(newRateMoney);
        });
        vm.setCancellable(product.isCancellable());
        vm.getAdditionalInfo().setInfoValue(product.getCancellationPolicyText());
    }

    public static void toVMRoom(HotelProduct product, HotelProductUIData productData, BookingFileProductHotelPanelVM vm) {
        VMHelper.transfer(product.getRooms(), vm.getRooms(), el -> new BookingFileProductHotelRoomVM(), (mod, modVM) -> {
            modVM.setArrival(HotelProductFXHelper.getLocalDateTime(mod.getCheckInDate(), mod.getCheckInTime()));
            modVM.setDeparture(HotelProductFXHelper.getLocalDateTime(mod.getCheckOutDate(), mod.getCheckOutTime()));
            modVM.setRoomType(mod.getRoomSize());
            modVM.setRoom(mod.getRoomName());
            BookingFileProductHotelRoomDetailsPaneVM main = modVM.getSuperColumn();
            if (mod.getBaseRate() == null) {
                mod.setBaseRate(new Money());
            }
            main.setTariff(mod.getBaseRate().getValue());
            if (mod.getBasePrice() == null) {
                mod.setBasePrice(new Money());
            }
            main.setSum(mod.getBasePrice().getValue());
            main.setCurrency(mod.getBaseRate().getCurrency());
            main.setTariffAgency(mod.getEquivalentRate());
            main.setSumEq(mod.getEquivalentPrice());
            main.setVat(mod.getEquivalentVatPrice());
            main.setVatRate(mod.getEquivVatRate());
            main.setWithVat(mod.getVat());
            main.setSize(mod.getNumberOfPeople());
            if (mod.getMeal() == null) {
                mod.setMeal(new Meal());
            }
            modVM.getSuperColumn().setMealCode(mod.getMeal().getCode());
            modVM.getSuperColumn().setMealName(mod.getMeal().getCaption());
            modVM.getSuperColumn().setGdsCurrencyRate(product.getGdsCurrencyRate());
            modVM.getSuperColumn().setSellWithPenalty(mod.isSellWithPenalty());
            if (mod.getStandardCheckInTime() != null) {
                modVM.getSuperColumn().setStandardArrival(HotelProductFXHelper.getLocalDateTime(mod.getCheckInDate(), mod.getStandardCheckInTime()).toLocalTime());
            }
            if (mod.getStandardCheckOutTime() != null) {
                modVM.getSuperColumn().setStandardDeparture(HotelProductFXHelper.getLocalDateTime(mod.getCheckInDate(), mod.getStandardCheckOutTime()).toLocalTime());
            }
            modVM.getSuperColumn().getDailyRates().clear();
            modVM.getSuperColumn().getDailyRates().addAll(mod.getDailyRates().stream().map(el -> {
                BookingFileProductHotelRoomDailyRateItemVM mealVM = new BookingFileProductHotelRoomDailyRateItemVM();
                mealVM.setStart(DateUtils.asLocalDate((Date)el.getStartDate()));
                mealVM.setEnd(DateUtils.asLocalDate((Date)el.getEndDate()));
                if (el.getRate() != null) {
                    mealVM.setCurrency(el.getRate().getCurrency());
                    mealVM.setRate(el.getRate().getValue());
                }
                if (el.getTax() != null) {
                    mealVM.setTax(el.getTax().getValue());
                }
                if (el.getSurcharge() != null) {
                    mealVM.setSurcharge(el.getSurcharge().getValue());
                }
                return mealVM;
            }).collect(Collectors.toList()));
        });
        VMHelper.transfer(product.getAdditionalServices(), vm.getRoomServices(), el -> new BookingFileProductHotelRoomServiceVM(), (mod, modVM) -> {
            HotelProductFXHelper.additionalServiceToVM(mod, modVM);
            modVM.setNotConfirmed(false);
        });
        product.getNotConfirmedAdditionalServices().forEach(mod -> {
            BookingFileProductHotelRoomServiceVM modVM = new BookingFileProductHotelRoomServiceVM();
            HotelProductFXHelper.additionalServiceToVM(mod, modVM);
            modVM.setNotConfirmed(true);
            vm.getRoomServices().add(modVM);
        });
    }

    private static void additionalServiceToVM(AdditionalService mod, BookingFileProductHotelRoomServiceVM modVM) {
        modVM.setName(mod.getName());
        modVM.setCode(mod.getCode());
        modVM.setType(mod.getType());
        if (mod.getBaseAmount() == null) {
            mod.setBaseAmount(new Money());
        }
        modVM.setCurrency(mod.getBaseAmount().getCurrency());
        modVM.setBaseAmount(mod.getBaseAmount().getValue());
        modVM.setAmount(mod.getEquivalentAmount());
        modVM.setVat(mod.getEquivalentVatAmount());
        modVM.setVatRate(mod.getEquivalentVatRate());
    }

    public static void toVMAdditional(HotelProduct product, BookingFileProductHotelPanelVM vm) {
        vm.getOtherParameters().getAdditional().setComments(product.getComments());
        GeneralProductFXHelper.toVMPassiveSegments((BaseProduct)product, vm.getOtherParameters().getAdditional().getPassiveSegments());
    }

    public static void fillBasicProductFields(HotelProduct product, HotelProductUIData productData) {
        ProductStatus status = productData.getStatus();
        if (status == null) {
            status = ProductStatus.SELL;
        }
        if (product.getStatus() == null) {
            product.setStatus(status);
        }
        if (product.getTicketType() == null) {
            product.setTicketType(TicketType.OWN);
        }
    }

    public static void fromVMParameters(BookingFileProductHotelPanelVM vm, HotelProduct product, HotelProductUIData productData) {
        HotelProductFXHelper.fromVMControlStatuses(vm.getStatuses(), product, productData);
        BookingFileProductHotelTicketInfoPaneVM ticketInfoVM = vm.getGeneral().getTicketInfo();
        product.setSystemNumber(ticketInfoVM.getTicketNumberValue());
        product.setIssueDate(DateUtils.asDate((LocalDateTime)ticketInfoVM.getOperationDateValue()));
        product.setCorrectionDate(DateUtils.asDate((LocalDateTime)ticketInfoVM.getCorrectionDateValue()));
        product.setUnholdDate(DateUtils.asDate((LocalDateTime)ticketInfoVM.getUnholdDateValue()));
        product.setServiceLocationType(ticketInfoVM.getServiceLocationType());
        BookingFileProductHotelTravelerInfoPaneVM travelerInfoVM = vm.getGeneral().getTravelerInfo();
        product.setPcc(travelerInfoVM.getPccValue());
        product.setTariffType(travelerInfoVM.getTariffTypeValue());
        product.setTicketType(travelerInfoVM.getTicketTypeValue());
        product.setProvider(travelerInfoVM.getProviderValue());
        product.setShipmentsDate(DateUtils.asDate((LocalDateTime)travelerInfoVM.getShipmentsDateValue()));
        product.setShipmentsDateSubagent(DateUtils.asDate((LocalDateTime)travelerInfoVM.getShipmentsDateSubagentValue()));
        product.setSubProvider(travelerInfoVM.getSubProviderValue());
        product.setSubProviderId(travelerInfoVM.getSubProviderIdValue());
        BookingFileProductHotelSalesChainPaneVM salesChainVM = vm.getGeneral().getSalesChain();
        product.setBlankOwnerRef(salesChainVM.getBlankOwnerValue().getBlankOwnerCode());
        productData.setSupplier(salesChainVM.getSupplierValue());
        productData.setAgency(salesChainVM.getAgencyValue());
        productData.setSubagency(salesChainVM.getSubagencyValue());
        product.setSalesPoint(salesChainVM.getSalesPointValue());
        product.setCashier(salesChainVM.getPrescribeAgentValue());
        product.setValidatorCode(salesChainVM.getValidatorCodeValue());
        product.setBranch(salesChainVM.getBranchValue());
        List travellers = product.getTravellers();
        travellers.clear();
        List types = product.getTravellersPassengerTypes();
        types.clear();
        vm.getGeneral().getOtherHotelParameters().getPassengers().forEach(passengerVM -> {
            if (passengerVM.getPassenger() != null) {
                Traveller traveller = GeneralProductFXHelper.findTraveller(product.getReservation().getBookingFile(), passengerVM.getPassenger().getUid());
                if (traveller != null) {
                    travellers.add(traveller);
                }
                if (passengerVM.getPassengerType() != null) {
                    PassengerTypeReference ptr = new PassengerTypeReference();
                    ptr.setTravellerUid(passengerVM.getPassenger().getUid());
                    ptr.setPassengerType(passengerVM.getPassengerType());
                    types.add(ptr);
                }
            }
        });
        BookingFileProductHotelCorpParametersVM corpParametersVM = vm.getGeneral().getOtherHotelParameters().getCorpParameters();
        product.setCF(corpParametersVM.getCfValue());
        product.setAgencyContract(corpParametersVM.getContractValue());
        product.setCorporateDiscount(corpParametersVM.getDiscountValue());
        product.setPromoCoupon(corpParametersVM.getCouponValue());
        product.setGuaranteeType(corpParametersVM.getGuaranteeValue());
        product.setGuaranteeCode(corpParametersVM.getGuaranteeCodeValue());
        HotelGuaranteeCard gcard = product.getGuaranteeCard();
        if (gcard == null) {
            gcard = new HotelGuaranteeCard();
            product.setGuaranteeCard(gcard);
        }
        gcard.setCardType(corpParametersVM.getGuaranteePrefixValue());
        gcard.setCardNumber(corpParametersVM.getGuaranteeCodeValue());
        gcard.setType(corpParametersVM.getGuaranteeValue());
        BookingFileProductHotelParametersVM hotelParametersVM = vm.getGeneral().getHotelParameters();
        product.setHotelPropertyId(hotelParametersVM.getCodeValue());
        product.setHotelCountry(hotelParametersVM.getCountryValue());
        product.setHotelLocation(hotelParametersVM.getCityValue());
        product.setHotelChainCode(hotelParametersVM.getChainValue());
        product.setHotelStars(hotelParametersVM.getStarsValue());
        product.setHotelName(hotelParametersVM.getHotelValue());
        product.setHotelAddress(hotelParametersVM.getAddressValue());
        product.setHotelPhone(hotelParametersVM.getPhoneValue());
        product.setHotelFax(hotelParametersVM.getFaxValue());
    }

    public static void fromVMCost(BookingFileProductHotelCostPaneVM vm, HotelProduct product) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        product.setGdsCurrency(vm.getSum().getEqCurrencyValue());
        VMHelper.transfer(vm.getFees().getContent(), product.getTaxes(), m -> new HotelProductTax(), (modVM, mod) -> {
            mod.setAddCollect(modVM.getAddition());
            mod.setCode(modVM.getCode());
            if (mod.getAmount() == null) {
                mod.setAmount(new Money());
            }
            mod.getAmount().setCurrency(modVM.getCurrency());
            mod.getAmount().setValue(HotelProductFXHelper.getValue(modVM.getSum(), negate));
            mod.setEquivalentAmount(HotelProductFXHelper.getValue(modVM.getEqSum(), negate));
            mod.setEquivalentVatAmount(HotelProductFXHelper.getValue(modVM.getVat(), negate));
            mod.setEquivalentVatRate(modVM.getVatRate());
        });
        if (product.getVendorVatDetalization() == null) {
            product.setVendorVatDetalization(new VatDetalization());
        }
        List taxes = product.getTaxes();
        VMHelper.transfer(vm.getVats().getContent(), product.getVendorVatDetalization().getComponents(), m -> new VatComponent(), (modVM, mod) -> {
            mod.setBasis(HotelProductFXHelper.getValue(modVM.getBasis(), negate));
            mod.setRate(modVM.getRate() == null ? null : Double.valueOf(modVM.getRate().doubleValue()));
            mod.setSum(HotelProductFXHelper.getValue(modVM.getSum(), negate));
            VMHelper.transfer(modVM.getBasisTypes(), mod.getBasisTypes());
            VMHelper.transfer(modVM.getCodes().stream().map(code -> HotelProductFXHelper.taxesCode2Uid(taxes, code)).collect(Collectors.toList()), mod.getTaxesUids());
        });
        VMHelper.transfer(vm.getFines().getContent(), product.getPenalties(), m -> new Penalty(), (modVM, mod) -> {
            mod.setCode(modVM.getCode());
            mod.setName(modVM.getName());
            mod.setEquivalentAmount(modVM.getEqSum());
            mod.setEquivalentVatAmount(modVM.getVat());
            mod.setEquivalentVatRate(modVM.getVatRate());
        });
    }

    private static String taxesCode2Uid(List<HotelProductTax> taxes, String code) {
        for (HotelProductTax tax : taxes) {
            if (!tax.getCode().equals(code)) continue;
            return tax.getUid();
        }
        return code;
    }

    public static void fromVMPenalty(BookingFileProductHotelPanelVM vm, HotelProduct product) {
        VMHelper.transfer(vm.getCancellationCharges(), product.getCancellationCharges(), el -> new CancellationCharge(), (modVM, mod) -> {
            mod.setStartDate(DateUtils.asDate((LocalDateTime)modVM.getStartDate()));
            mod.setEndDate(DateUtils.asDate((LocalDateTime)modVM.getEndDate()));
            mod.setPolicyText(modVM.getDescription());
            mod.setPenalty(modVM.getPenaltyMoney());
        });
        product.setCancellable(vm.isCancellable());
        product.setCancellationPolicyText(vm.getAdditionalInfo().getInfoValue());
    }

    public static void fromVMRoom(BookingFileProductHotelPanelVM vm, HotelProduct product) {
        VMHelper.transfer(vm.getRooms(), product.getRooms(), el -> new Room(), (modVM, mod) -> {
            mod.setRoomName(modVM.getRoom());
            mod.setRoomSize(modVM.getRoomType());
            mod.setCheckInDate(MiscUtil.clearTime((Date)DateUtils.asDate((LocalDateTime)modVM.getArrival())));
            mod.setCheckInTime(Integer.valueOf(MiscUtil.getMinutes((Date)DateUtils.asDate((LocalDateTime)modVM.getArrival()))));
            mod.setCheckOutDate(MiscUtil.clearTime((Date)DateUtils.asDate((LocalDateTime)modVM.getDeparture())));
            mod.setCheckOutTime(Integer.valueOf(MiscUtil.getMinutes((Date)DateUtils.asDate((LocalDateTime)modVM.getDeparture()))));
            if (mod.getBaseRate() == null) {
                mod.setBaseRate(new Money());
            }
            BookingFileProductHotelRoomDetailsPaneVM main = modVM.getSuperColumn();
            mod.getBaseRate().setValue(main.getTariff());
            mod.getBaseRate().setCurrency(main.getCurrency());
            if (mod.getBasePrice() == null) {
                mod.setBasePrice(new Money());
            }
            mod.getBasePrice().setValue(main.getSum());
            mod.getBasePrice().setCurrency(main.getCurrency());
            mod.setEquivalentRate(main.getTariffAgency());
            mod.setEquivalentPrice(main.getSumEq());
            mod.setEquivalentVatPrice(main.getVat());
            mod.setEquivVatRate(main.getVatRate());
            mod.setVat(main.getWithVat());
            mod.setVatAmount(main.getVat());
            mod.setNumberOfPeople(main.getSize());
            if (mod.getMeal() == null) {
                mod.setMeal(new Meal());
            }
            mod.getMeal().setCaption(modVM.getSuperColumn().getMealName());
            mod.getMeal().setCode(modVM.getSuperColumn().getMealCode());
            product.setGdsCurrencyRate(modVM.getSuperColumn().getGdsCurrencyRate());
            mod.setSellWithPenalty(modVM.getSuperColumn().isSellWithPenalty());
            mod.setHotelCardNumber(vm.getGeneral().getHotelParameters().getCodeValue());
            List mealTable = modVM.getSuperColumn().getDailyRates();
            mod.getDailyRates().clear();
            mealTable.forEach(el -> {
                DailyRate dr = new DailyRate();
                dr.setStartDate(DateUtils.asDate((LocalDate)el.getStart()));
                dr.setEndDate(DateUtils.asDate((LocalDate)el.getEnd()));
                Money money = new Money();
                money.setCurrency(el.getCurrency());
                money.setValue(el.getRate());
                dr.setRate(money);
                money = new Money();
                money.setCurrency(el.getCurrency());
                money.setValue(el.getTax());
                dr.setTax(money);
                money = new Money();
                money.setCurrency(el.getCurrency());
                money.setValue(el.getSurcharge());
                dr.setSurcharge(money);
                mod.getDailyRates().add(dr);
            });
        });
        VMHelper.transfer(vm.getRoomServices().stream().filter(s -> !s.isNotConfirmed()).collect(Collectors.toList()), product.getAdditionalServices(), el -> new AdditionalService(), HotelProductFXHelper::additionalServiceFromVM);
        VMHelper.transfer(vm.getRoomServices().stream().filter(BookingFileProductHotelRoomServiceVM::isNotConfirmed).collect(Collectors.toList()), product.getNotConfirmedAdditionalServices(), el -> new AdditionalService(), HotelProductFXHelper::additionalServiceFromVM);
        List travellers = product.getTravellers();
        if (!product.getRooms().isEmpty()) {
            if (product.getRooms().size() > 1) {
                throw new IllegalArgumentException("MULTIROOM: " + product.getSystemNumber());
            }
            List travellersUids = ((Room)product.getRooms().get(0)).getRoomTravellersUids();
            travellersUids.clear();
            travellersUids.addAll(travellers.stream().map(BaseIdentity::getUid).collect(Collectors.toList()));
        }
    }

    private static void additionalServiceFromVM(BookingFileProductHotelRoomServiceVM modVM, AdditionalService mod) {
        mod.setName(modVM.getName());
        mod.setCode(modVM.getCode());
        mod.setType(modVM.getType());
        Money money = new Money();
        money.setValue(modVM.getBaseAmount());
        money.setCurrency(modVM.getCurrency());
        mod.setBaseAmount(money);
        mod.setEquivalentAmount(modVM.getAmount());
        mod.setEquivalentVatAmount(modVM.getVat());
        mod.setEquivalentVatRate(modVM.getVatRate());
    }

    public static void fromVMAdditional(BookingFileProductHotelAdditionalParametersVM vm, HotelProduct product) {
        product.setComments(vm.getComments());
        GeneralProductFXHelper.fromVMPassiveSegments(vm.getPassiveSegments(), (BaseProduct)product);
    }

    private static void toVMControlStatuses(HotelProduct product, HotelProductUIData productData, BookingFileProductHotelStatusesPaneVM vm) {
        vm.setChecked(product.isChecked());
        vm.setFinished(product.isCompleted());
        vm.setHasErrors(productData.isHasErrors());
        vm.setHasWarnings(productData.isHasWarnings());
        vm.setRulesApplied(product.isContractRulesApplied());
        vm.setForcedRefund(product.isForcedRefund());
        vm.setOnHold(product.isOnHold());
        if (product.getVendorVatDetalization() != null) {
            vm.setVatSpecified(product.getVendorVatDetalization().isDetalized());
        }
    }

    private static LocalDateTime getLocalDateTime(Date date, Integer time) {
        Date newDate = date;
        if (time != null) {
            newDate = MiscUtil.setMinutes((Date)date, (int)time);
        }
        return DateUtils.asLocalDateTime((Date)newDate);
    }

    private static void fromVMControlStatuses(BookingFileProductHotelStatusesPaneVM vm, HotelProduct product, HotelProductUIData productData) {
        product.setChecked(vm.isChecked());
        product.setCompleted(vm.isFinished());
        product.setContractRulesApplied(vm.isRulesApplied());
        product.setForcedRefund(vm.isForcedRefund());
        product.setOnHold(vm.isOnHold());
        productData.setHasErrors(vm.isHasErrors());
        if (product.getVendorVatDetalization() != null) {
            product.getVendorVatDetalization().setDetalized(vm.isVatSpecified());
        }
    }

    public static MiscUtil.Pair<HotelProduct, HotelProductUIData> getPrototypeData() {
        AgentData agentData = Prefetched.getData().getCurrentAgentData();
        HotelProduct product = new HotelProduct();
        GeneralProductFXHelper.loadPrototypeData((BaseProduct)product);
        MiscUtil.Pair prototypeData = null;
        try {
            prototypeData = ((StandardProductPrototypeService)RpcServiceManager.get().getService(StandardProductPrototypeService.class)).getPrototypeData(ServiceInvocationContext.get(), agentData, product);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        if (prototypeData == null) {
            prototypeData = new MiscUtil.Pair((Object)new HotelProduct(), (Object)new HotelProductUIData());
        }
        return prototypeData;
    }

    public static void updateNode(BookingFileProductHotelPanel node, BookingFileSpaceVM bookingFileVM) {
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).getParametersNode().productClassProperty().setValue(HotelProduct.class);
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).clientProperty().setValue((Object)bookingFileVM.getMainFull().getGeneralParameters().getClient());
    }
}

