/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceChildCostVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceTouristicGeneralPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceTouristicPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceTouristicPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceTouristicSalesChainPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceTouristicTicketInfoPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductInsuranceTouristicTravelerInfoPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticAfs;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatusesPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.rpc.StandardProductPrototypeService;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristic;
import com.gridnine.xtrip.common.model.booking.uidata.InsuranceUIData;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.VatValue;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.stream.Collectors;

public class InsuranceTouristicFXHelper {
    private static BigDecimal getValue(BigDecimal value, boolean negate) {
        if (value == null) {
            return null;
        }
        return negate ? value.negate() : value;
    }

    public static void toVM(BookingFileProductInsuranceTouristicPanelVM vm, InsuranceTouristic product, InsuranceUIData productData) {
        vm.setBookingFile(product.getReservation().getBookingFile());
        InsuranceTouristicFXHelper.toVMGeneral(vm.getGeneral(), product, productData);
        InsuranceTouristicFXHelper.toVMStatuses(vm.getStatuses(), product, productData);
        InsuranceTouristicFXHelper.toVMCost(vm.getCost(), product, productData);
        vm.getOtherParameters().setComments(product.getComments());
    }

    private static void toVMCost(BookingFileProductInsuranceChildCostVM vm, InsuranceTouristic product, InsuranceUIData productData) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        Money insuranceSum = product.getInsuranceSum();
        vm.setInsuranceSum(insuranceSum != null ? InsuranceTouristicFXHelper.getValue(insuranceSum.getValue(), negate) : null);
        vm.setInsuranceCurrency(insuranceSum != null ? insuranceSum.getCurrency() : null);
        vm.setInsurancePremiumSum(InsuranceTouristicFXHelper.getValue(product.getEquivalentSum(), negate));
        vm.setInsurancePremiumCurrency(product.getEquivalentSum() != null ? productData.getCurrency() : null);
        VatValue vatValue = product.getEquivalentFareVatValue();
        if (vatValue != null) {
            vm.getInsurancePremiumSumVat().setVatAmount(InsuranceTouristicFXHelper.getValue(vatValue.getAmount(), negate));
            vm.getInsurancePremiumSumVat().setVatRate(vatValue.getRate());
        }
    }

    private static void toVMGeneral(BookingFileProductInsuranceTouristicGeneralPanelVM vm, InsuranceTouristic product, InsuranceUIData productData) {
        BookingFileProductInsuranceTouristicTicketInfoPaneVM ticketInfoVM = vm.getTicketInfo();
        ticketInfoVM.setProductValue(ProductType.INSURANCE_TOURISTIC.toString());
        ticketInfoVM.setTicketNumberValue(product.getSystemNumber());
        ticketInfoVM.setScnValue(product.getScn());
        ProductStatus productStatus = BookingHelper.getProductStatus((BaseProduct)product);
        ticketInfoVM.setStatusValue(productStatus != null ? productStatus.toString() : null);
        ticketInfoVM.setBlankValue(product.getBlankType());
        ticketInfoVM.setReservationValue(product.getReservation().getUid());
        BookingFile bookingFile = product.getReservation().getBookingFile();
        ticketInfoVM.setInsurer(BookingHelper.findTraveller((BookingFile)bookingFile, (String)product.getPolicyHolderUid()));
        ticketInfoVM.setCountryValue(product.getCountryName());
        ticketInfoVM.setStartValue(DateUtils.asLocalDate((Date)product.getStartDate()));
        ticketInfoVM.setEndValue(DateUtils.asLocalDate((Date)product.getEndDate()));
        ticketInfoVM.setRelatedValue(BookingHelper.findProductByUid((String)product.getRelatedProductUid(), (BookingFile)bookingFile));
        ticketInfoVM.setRelatedTypeValue(product.getRelatedProductType());
        BookingFileProductInsuranceTouristicTravelerInfoPaneVM travelerInfoVM = vm.getTravelerInfo();
        travelerInfoVM.setOperationDateValue(DateUtils.asLocalDateTime((Date)product.getIssueDate()));
        travelerInfoVM.setCorrectionDateValue(DateUtils.asLocalDateTime((Date)product.getCorrectionDate()));
        travelerInfoVM.setShipmentsDateValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDate()));
        travelerInfoVM.setShipmentsDateSubagentValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDateSubagent()));
        product.getTravellersUids().stream().map(uid -> BookingHelper.findTraveller((BookingFile)bookingFile, (String)uid)).filter(traveller -> traveller != null).collect(Collectors.toCollection(() -> ((BookingFileProductInsuranceTouristicTravelerInfoPaneVM)travelerInfoVM).getInsured()));
        travelerInfoVM.setInfo(product.getAdditionalInfo());
        BookingFileProductInsuranceTouristicSalesChainPaneVM salesChainVM = vm.getSalesChain();
        salesChainVM.setBlankOwnerValue(product.getBlankOwner());
        salesChainVM.setSupplierValue(productData.getSupplier());
        salesChainVM.setAgencyValue(productData.getAgency());
        salesChainVM.setSubagencyValue(productData.getSubagency());
        salesChainVM.setBranchValue(product.getBranch());
        salesChainVM.setSalesPointValue(product.getSalesPoint());
        salesChainVM.setPrescribeAgentValue(product.getAgent());
        salesChainVM.setTicketTypeValue(product.getTicketType());
    }

    private static void toVMStatuses(BookingFileProductStatusesPaneVM vm, InsuranceTouristic product, InsuranceUIData productData) {
        vm.setChecked(product.isChecked());
        vm.setFinished(product.isCompleted());
        vm.setHasErrors(productData.isHasErrors());
        vm.setHasWarnings(productData.isHasWarnings());
        vm.setRulesApplied(product.isContractRulesApplied());
    }

    public static void fromVM(BookingFileProductInsuranceTouristicPanelVM vm, InsuranceTouristic product, InsuranceUIData productData) {
        BookingFileProductInsuranceTouristicTicketInfoPaneVM ticketInfoVM = vm.getGeneral().getTicketInfo();
        Traveller insurer = ticketInfoVM.getInsurer();
        product.setSystemNumber(ticketInfoVM.getTicketNumberValue());
        product.setScn(ticketInfoVM.getScnValue());
        product.setBlankType(ticketInfoVM.getBlankValue());
        product.setPolicyHolderUid(insurer != null ? insurer.getUid() : null);
        product.setCountryName(ticketInfoVM.getCountryValue());
        product.setStartDate(DateUtils.asDate((LocalDate)ticketInfoVM.getStartValue()));
        product.setRelatedProductUid(BookingHelper.generateShortProductName((BaseProduct)ticketInfoVM.getRelatedValue()));
        product.setEndDate(DateUtils.asDate((LocalDate)ticketInfoVM.getEndValue()));
        product.setRelatedProductType(ticketInfoVM.getRelatedTypeValue());
        product.setRelatedProductUid(ticketInfoVM.getRelatedValue() != null ? ticketInfoVM.getRelatedValue().getUid() : null);
        BookingFileProductInsuranceTouristicTravelerInfoPaneVM travelerInfoVM = vm.getGeneral().getTravelerInfo();
        product.setIssueDate(DateUtils.asDate((LocalDateTime)travelerInfoVM.getOperationDateValue()));
        product.setCorrectionDate(DateUtils.asDate((LocalDateTime)travelerInfoVM.getCorrectionDateValue()));
        product.setShipmentsDate(DateUtils.asDate((LocalDateTime)travelerInfoVM.getShipmentsDateValue()));
        product.setShipmentsDateSubagent(DateUtils.asDate((LocalDateTime)travelerInfoVM.getShipmentsDateSubagentValue()));
        product.getTravellersUids().clear();
        travelerInfoVM.getInsured().stream().map(BaseIdentity::getUid).collect(Collectors.toCollection(() -> ((InsuranceTouristic)product).getTravellersUids()));
        product.setAdditionalInfo(travelerInfoVM.getInfo());
        BookingFileProductInsuranceTouristicSalesChainPaneVM salesChainVM = vm.getGeneral().getSalesChain();
        product.setTicketType(salesChainVM.getTicketTypeValue());
        product.setBlankOwner(salesChainVM.getBlankOwnerValue());
        productData.setSupplier(salesChainVM.getSupplierValue());
        productData.setAgency(salesChainVM.getAgencyValue());
        productData.setSubagency(salesChainVM.getSubagencyValue());
        product.setBranch(salesChainVM.getBranchValue());
        product.setSalesPoint(salesChainVM.getSalesPointValue());
        product.setAgent(salesChainVM.getPrescribeAgentValue());
        BookingFileProductStatusesPaneVM statusesVM = vm.getStatuses();
        product.setChecked(statusesVM.isChecked());
        product.setCompleted(statusesVM.isFinished());
        product.setContractRulesApplied(statusesVM.isRulesApplied());
        InsuranceTouristicFXHelper.fromVMCost(vm.getCost(), product);
        product.setComments(vm.getOtherParameters().getComments());
    }

    private static void fromVMCost(BookingFileProductInsuranceChildCostVM vm, InsuranceTouristic product) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        BigDecimal insuranceSum = InsuranceTouristicFXHelper.getValue(vm.getInsuranceSum(), negate);
        String insuranceCurrency = vm.getInsuranceCurrency();
        product.setInsuranceSum(insuranceSum != null && insuranceCurrency != null ? MoneyHelper.buildMoney((BigDecimal)insuranceSum, (String)insuranceCurrency) : null);
        product.setEquivalentSum(InsuranceTouristicFXHelper.getValue(vm.getInsurancePremiumSum(), negate));
        if (product.getEquivalentFareVatValue() == null) {
            product.setEquivalentFareVatValue(new VatValue());
        }
        product.getEquivalentFareVatValue().setRate(vm.getInsurancePremiumSumVat().getVatRate());
        product.getEquivalentFareVatValue().setAmount(InsuranceTouristicFXHelper.getValue(vm.getInsurancePremiumSumVat().getVatAmount(), negate));
    }

    public static MiscUtil.Pair<InsuranceTouristic, InsuranceUIData> getPrototypeData() {
        AgentData agentData = Prefetched.getData().getCurrentAgentData();
        InsuranceTouristic product = new InsuranceTouristic();
        GeneralProductFXHelper.loadPrototypeData((BaseProduct)product);
        MiscUtil.Pair prototypeData = null;
        try {
            prototypeData = ((StandardProductPrototypeService)RpcServiceManager.get().getService(StandardProductPrototypeService.class)).getPrototypeData(ServiceInvocationContext.get(), agentData, product);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        if (prototypeData == null) {
            prototypeData = new MiscUtil.Pair((Object)new InsuranceTouristic(), (Object)new InsuranceUIData());
        }
        return prototypeData;
    }

    public static void updateNode(BookingFileProductInsuranceTouristicPanel node, BookingFileSpaceVM bookingFileVM) {
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).getParametersNode().productClassProperty().setValue(InsuranceTouristic.class);
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).clientProperty().setValue((Object)bookingFileVM.getMainFull().getGeneralParameters().getClient());
    }
}

