/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticAfs;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatusesPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTaxiCostPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTaxiCostSumPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTaxiGeneralPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTaxiPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTaxiPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTaxiSalesChainPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTaxiTicketInfoPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductTaxiTravelerInfoPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.model.booking.CustomVatContainerVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.rpc.StandardProductPrototypeService;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiHelper;
import com.gridnine.xtrip.common.model.booking.taxi.TaxiProduct;
import com.gridnine.xtrip.common.model.booking.uidata.TaxiProductUIData;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.VatValue;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

public class TaxiFXHelper {
    private static BigDecimal getValue(BigDecimal value, boolean negate) {
        if (value == null) {
            return null;
        }
        return negate ? value.negate() : value;
    }

    public static void toVM(TaxiProduct product, TaxiProductUIData productData, BookingFileProductTaxiPanelVM vm) {
        vm.setProductShortName(BookingHelper.generateShortProductName((BaseProduct)product));
        vm.setUid(product.getUid());
        TaxiFXHelper.toVMStatuses(vm.getStatuses(), product, productData);
        TaxiFXHelper.toVMGeneral(vm.getGeneral(), productData, product);
        TaxiFXHelper.toVMCost(vm.getCost(), product, productData);
        vm.getOtherParameters().setComments(product.getComments());
    }

    public static void fromVM(BookingFileProductTaxiPanelVM vm, TaxiProduct product, TaxiProductUIData productData) {
        if (product.getStatus() == null) {
            product.setStatus(ProductStatus.SELL);
        }
        if (product.getTicketType() == null) {
            product.setTicketType(TicketType.OWN);
        }
        TaxiFXHelper.fromVMGeneral(vm.getGeneral(), product, productData);
        TaxiFXHelper.fromVMStatuses(vm.getStatuses(), product, productData);
        TaxiFXHelper.fromVMCost(vm.getCost(), product);
        product.setComments(vm.getOtherParameters().getComments());
    }

    private static void toVMGeneral(BookingFileProductTaxiGeneralPanelVM vm, TaxiProductUIData productData, TaxiProduct product) {
        ProductStatus productStatus = BookingHelper.getProductStatus((BaseProduct)product);
        BookingFileProductTaxiTicketInfoPaneVM ticketInfoVM = vm.getTicketInfo();
        ticketInfoVM.setProductValue(ProductType.TAXI.toString());
        ticketInfoVM.setStatusValue(productStatus != null ? productStatus.toString() : null);
        ticketInfoVM.setTicketNumberValue(product.getSystemNumber());
        ticketInfoVM.setOperationDateValue(DateUtils.asLocalDateTime((Date)product.getIssueDate()));
        ticketInfoVM.setCorrectionDateValue(DateUtils.asLocalDateTime((Date)product.getCorrectionDate()));
        ticketInfoVM.setStartDateValue(DateUtils.asLocalDateTime((Date)product.getDateStart()));
        ticketInfoVM.setStartCountryValue(product.getCountry());
        ticketInfoVM.setCityValue(product.getCity());
        ticketInfoVM.setEndDateValue(DateUtils.asLocalDateTime((Date)product.getDateEnd()));
        ticketInfoVM.setDestinationAddressValue(product.getDestination());
        ticketInfoVM.setSourceAddressValue(product.getSource());
        ticketInfoVM.setFinishDateValue(DateUtils.asLocalDateTime((Date)product.getFinishDate()));
        ticketInfoVM.setCanExtendedTime(product.isCanExtendedTime());
        BookingFileProductTaxiTravelerInfoPaneVM travelerInfoVM = vm.getTravelerInfo();
        VMHelper.transfer(product.getTravellers(), travelerInfoVM.getTravellersValue());
        travelerInfoVM.setCarClassValue(product.getCarClass());
        travelerInfoVM.setLimit(product.getLimit());
        travelerInfoVM.setShipmentsDateValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDate()));
        travelerInfoVM.setShipmentsDateSubagentValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDateSubagent()));
        BookingFileProductTaxiSalesChainPaneVM salesChainVM = vm.getSalesChain();
        salesChainVM.setBlankOwnerValue(product.getBlankOwner());
        salesChainVM.setSupplierValue(productData.getSupplier());
        salesChainVM.setAgencyValue(productData.getAgency());
        salesChainVM.setSubagencyValue(productData.getSubagency());
        salesChainVM.setSalesPointValue(product.getSalesPoint());
        salesChainVM.setPrescribeAgentValue(product.getAgent());
        salesChainVM.setTicketTypeValue(product.getTicketType());
    }

    private static void toVMStatuses(BookingFileProductStatusesPaneVM vm, TaxiProduct product, TaxiProductUIData productData) {
        vm.setChecked(product.isChecked());
        vm.setFinished(product.isCompleted());
        vm.setHasErrors(productData.isHasErrors());
        vm.setHasWarnings(productData.isHasWarnings());
        vm.setRulesApplied(product.isContractRulesApplied());
    }

    private static void toVMCost(BookingFileProductTaxiCostPaneVM costVM, TaxiProduct product, TaxiProductUIData productData) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        BookingFileProductTaxiCostSumPaneVM sumVM = costVM.getSum();
        BigDecimal ndsValue = null;
        String currency = null;
        if (product.getFare() != null) {
            currency = product.getFare().getCurrency();
            sumVM.setTariffSum(TaxiFXHelper.getValue(product.getFare().getValue(), negate));
            sumVM.setTariffCurrency(currency);
        }
        if (product.getEquivalentFare() != null) {
            currency = product.getEquivalentFare().getCurrency();
            sumVM.setEqTariffSum(TaxiFXHelper.getValue(product.getEquivalentFare().getValue(), negate));
            sumVM.setEqTariffCurrency(currency);
        }
        if (product.getEquivalentFareVatValue() != null) {
            VatValue vatValue = product.getEquivalentFareVatValue();
            ndsValue = vatValue.getAmount();
            sumVM.getVatIncludedEqTariff().setVatAmount(TaxiFXHelper.getValue(vatValue.getAmount(), negate));
            sumVM.getVatIncludedEqTariff().setVatRate(vatValue.getRate());
        }
        sumVM.setPenaltySum(product.getPenalty());
        sumVM.setPenaltyCurrency(currency);
        sumVM.setTotalSum(TaxiHelper.getTotalPrice((TaxiProduct)product));
        sumVM.setVatIncludedTotal(TaxiFXHelper.getValue(ndsValue, negate));
        sumVM.setTotalCurrency(currency);
        costVM.getRates().setRateValue(productData.getRate());
        costVM.getRates().setEqCurrencyValue(productData.getEqCurrency() == null ? null : productData.getEqCurrency());
        costVM.getRates().setBaseCurrencyValue(productData.getBaseCurrency() == null ? null : productData.getBaseCurrency());
    }

    private static void fromVMGeneral(BookingFileProductTaxiGeneralPanelVM vm, TaxiProduct product, TaxiProductUIData productData) {
        BookingFileProductTaxiTicketInfoPaneVM ticketInfoVM = vm.getTicketInfo();
        product.setSystemNumber(ticketInfoVM.getTicketNumberValue());
        product.setIssueDate(DateUtils.asDate((LocalDateTime)ticketInfoVM.getOperationDateValue()));
        product.setCorrectionDate(DateUtils.asDate((LocalDateTime)ticketInfoVM.getCorrectionDateValue()));
        product.setDateStart(DateUtils.asDate((LocalDateTime)ticketInfoVM.getStartDateValue()));
        product.setFinishDate(DateUtils.asDate((LocalDateTime)ticketInfoVM.getFinishDateValue()));
        product.setSource(ticketInfoVM.getSourceAddressValue());
        product.setCountry(ticketInfoVM.getStartCountryValue());
        product.setCity(ticketInfoVM.getCityValue());
        product.setDateEnd(DateUtils.asDate((LocalDateTime)ticketInfoVM.getEndDateValue()));
        product.setDestination(ticketInfoVM.getDestinationAddressValue());
        product.setCanExtendedTime(ticketInfoVM.isCanExtendedTime());
        BookingFileProductTaxiTravelerInfoPaneVM travelerInfoVM = vm.getTravelerInfo();
        product.getTravellers().clear();
        travelerInfoVM.getTravellersValue().forEach(tr -> {
            Traveller traveller;
            if (tr != null && (traveller = GeneralProductFXHelper.findTraveller(product.getReservation().getBookingFile(), tr.getUid())) != null) {
                product.getTravellers().add(traveller);
            }
        });
        product.setShipmentsDate(DateUtils.asDate((LocalDateTime)travelerInfoVM.getShipmentsDateValue()));
        product.setShipmentsDateSubagent(DateUtils.asDate((LocalDateTime)travelerInfoVM.getShipmentsDateSubagentValue()));
        product.setCarClass(travelerInfoVM.getCarClassValue());
        product.setLimit(travelerInfoVM.getLimit());
        BookingFileProductTaxiSalesChainPaneVM salesChainVM = vm.getSalesChain();
        product.setBlankOwner(salesChainVM.getBlankOwnerValue());
        productData.setSupplier(salesChainVM.getSupplierValue());
        productData.setAgency(salesChainVM.getAgencyValue());
        productData.setSubagency(salesChainVM.getSubagencyValue());
        product.setSalesPoint(salesChainVM.getSalesPointValue());
        product.setAgent(salesChainVM.getPrescribeAgentValue());
        product.setTicketType(salesChainVM.getTicketTypeValue());
    }

    private static void fromVMStatuses(BookingFileProductStatusesPaneVM vm, TaxiProduct product, TaxiProductUIData productData) {
        product.setChecked(vm.isChecked());
        product.setCompleted(vm.isFinished());
        productData.setHasErrors(vm.isHasErrors());
        product.setContractRulesApplied(vm.isRulesApplied());
    }

    public static void fromVMCost(BookingFileProductTaxiCostPaneVM costVM, TaxiProduct product) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        BookingFileProductTaxiCostSumPaneVM sumVM = costVM.getSum();
        if (product.getFare() == null) {
            product.setFare(new Money());
        }
        product.getFare().setValue(TaxiFXHelper.getValue(sumVM.getTariffSum(), negate));
        product.getFare().setCurrency(sumVM.getTariffCurrency());
        if (product.getEquivalentFare() == null) {
            product.setEquivalentFare(new Money());
        }
        product.getEquivalentFare().setValue(TaxiFXHelper.getValue(sumVM.getEqTariffSum(), negate));
        product.getEquivalentFare().setCurrency(sumVM.getEqTariffCurrency());
        if (product.getEquivalentFareVatValue() == null) {
            product.setEquivalentFareVatValue(new VatValue());
        }
        CustomVatContainerVM vatEq = sumVM.getVatIncludedEqTariff();
        product.getEquivalentFareVatValue().setRate(vatEq.getVatRate());
        product.getEquivalentFareVatValue().setAmount(TaxiFXHelper.getValue(vatEq.getVatAmount(), negate));
        product.setPenalty(sumVM.getPenaltySum());
    }

    public static MiscUtil.Pair<TaxiProduct, TaxiProductUIData> getPrototypeData() {
        AgentData agentData = Prefetched.getData().getCurrentAgentData();
        TaxiProduct product = new TaxiProduct();
        GeneralProductFXHelper.loadPrototypeData((BaseProduct)product);
        MiscUtil.Pair prototypeData = null;
        try {
            prototypeData = ((StandardProductPrototypeService)RpcServiceManager.get().getService(StandardProductPrototypeService.class)).getPrototypeData(ServiceInvocationContext.get(), agentData, product);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        if (prototypeData == null) {
            prototypeData = new MiscUtil.Pair((Object)new TaxiProduct(), (Object)new TaxiProductUIData());
        }
        return prototypeData;
    }

    public static void updateNode(BookingFileProductTaxiPanel node, BookingFileSpaceVM bookingFileVM) {
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).getParametersNode().productClassProperty().setValue(TaxiProduct.class);
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).clientProperty().setValue((Object)bookingFileVM.getMainFull().getGeneralParameters().getClient());
    }
}

