/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.commissionproperties;

import com.gridnine.xtrip.client.fx.core.entity.RootEntityEditorInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.model.commission.FeeCalculationParametersContainer;
import com.gridnine.xtrip.client.fx.model.commission.FeeContainerController;
import com.gridnine.xtrip.client.fx.model.commission.FeeContainerVM;
import com.gridnine.xtrip.client.fx.model.commission.FeeGeneralContainer;
import com.gridnine.xtrip.client.fx.model.commission.FeeOtherParametersContainer;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.controllerinterceptors.ControllerInterceptorVatHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.commissionproperties.FeePropertiesEditorInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.commissionproperties.FeePropertiesHandlerConfigurator;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.commission.RefexType;
import com.gridnine.xtrip.common.model.booking.commission.ReturnCase;
import com.gridnine.xtrip.common.model.booking.commission.RouteType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class StandardFeePropertiesHandlerConfigurator
implements FeePropertiesHandlerConfigurator {
    static final List<ProductType> PRODUCT_TYPES = Collections.unmodifiableList(Stream.of(ProductType.values()).filter(type -> type != ProductType.OLD_MISC_PRODUCT).collect(Collectors.toList()));

    StandardFeePropertiesHandlerConfigurator() {
    }

    @Override
    public void configureController(List<BiConsumer<DataTransferPackage<FeeProperties, Void>, FeeContainerVM>> toVM, List<BiConsumer<FeeContainerVM, DataTransferPackage<FeeProperties, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new FeeContainerControllerInterceptor());
        toVM.add((dtp, vm) -> {
            FeeProperties model = (FeeProperties)dtp.getContainer().getEntity();
            vm.getGeneral().setDisplayName(model.getDisplayName());
            vm.getGeneral().setCategory(model.getCategory());
            vm.getGeneral().setOperation(model.getOperation());
            VMHelper.transfer(model.getProductTypes(), vm.getGeneral().getProductTypes());
            vm.getCalculationParameters().setCalculateAsPercent(model.isRate());
            vm.getCalculationParameters().setRoundType(model.getRoundingMode());
            vm.getCalculationParameters().setRoundValue(model.getRoundingValue());
            vm.getCalculationParameters().setFeeType(model.getType());
            vm.getCalculationParameters().setCalculationType(model.getCalculationType());
            vm.getCalculationParameters().setCalculationBasis(model.getCalculationBasis());
            vm.getCalculationParameters().setCalculateFromDifference(model.isCalculateFromDifference());
            vm.getCalculationParameters().setChargeToClientForAllContractTypes(model.isChargeToClientForAllContractTypes());
            vm.getCalculationParameters().setRecalculateVatForAllContractTypes(model.isRecalculateVatForAllContractTypes());
            VMHelper.transfer(model.getReturnCases(), vm.getOtherParameters().getReturnCases());
            VMHelper.transfer(model.getRefexTypes(), vm.getOtherParameters().getRefexTypes());
            VMHelper.transfer(model.getRouteTypes(), vm.getOtherParameters().getRouteTypes());
            vm.getOtherParameters().setFinanceName(model.getFinanceName());
            vm.getOtherParameters().setHidden(model.isHidden());
            vm.getOtherParameters().setHiddenFeeTaxCode(model.getHiddenFeeTaxCode());
            vm.getOtherParameters().setFinanceCode(model.getFinanceCode());
            vm.getOtherParameters().setExternalFee(model.isExternalFee());
            vm.getOtherParameters().setExternalFeeVatRate(model.getExternalFeeVatRate());
            vm.getOtherParameters().setVatNotIncluded(model.isVatNotIncluded());
        });
        fromVM.add((vm, dtp) -> {
            FeeProperties model = (FeeProperties)dtp.getContainer().getEntity();
            model.setDisplayName(vm.getGeneral().getDisplayName());
            model.setCategory(vm.getGeneral().getCategory());
            model.setOperation(vm.getGeneral().getOperation());
            VMHelper.transfer(vm.getGeneral().getProductTypes(), model.getProductTypes());
            model.setRate(vm.getCalculationParameters().isCalculateAsPercent());
            model.setRoundingMode(vm.getCalculationParameters().getRoundType());
            model.setRoundingValue(vm.getCalculationParameters().getRoundValue());
            model.setType(vm.getCalculationParameters().getFeeType());
            model.setCalculationType(vm.getCalculationParameters().getCalculationType());
            model.setCalculationBasis(vm.getCalculationParameters().getCalculationBasis());
            model.setCalculateFromDifference(vm.getCalculationParameters().isCalculateFromDifference());
            model.setChargeToClientForAllContractTypes(vm.getCalculationParameters().isChargeToClientForAllContractTypes());
            model.setRecalculateVatForAllContractTypes(vm.getCalculationParameters().isRecalculateVatForAllContractTypes());
            VMHelper.transfer(vm.getOtherParameters().getReturnCases(), model.getReturnCases());
            VMHelper.transfer(vm.getOtherParameters().getRefexTypes(), model.getRefexTypes());
            VMHelper.transfer(vm.getOtherParameters().getRouteTypes(), model.getRouteTypes());
            model.setFinanceName(vm.getOtherParameters().getFinanceName());
            model.setHidden(vm.getOtherParameters().isHidden());
            model.setHiddenFeeTaxCode(vm.getOtherParameters().getHiddenFeeTaxCode());
            model.setFinanceCode(vm.getOtherParameters().getFinanceCode());
            model.setExternalFee(vm.getOtherParameters().isExternalFee());
            model.setExternalFeeVatRate(vm.getOtherParameters().isExternalFee() ? vm.getOtherParameters().getExternalFeeVatRate() : null);
            model.setVatNotIncluded(vm.getOtherParameters().isVatNotIncluded());
        });
    }

    @Override
    public void collectEditorInterceptors(List<RootEntityEditorInterceptor<FeeProperties, Void>> editorInterceptors) {
        editorInterceptors.add(new FeePropertiesEditorInterceptor());
    }

    private static class FeeContainerControllerInterceptor
    extends ControllerInterceptor<FeeContainerVM, FeeContainerController> {
        FeeContainerControllerInterceptor() {
        }

        protected Class<FeeContainerController> getControllerClass() {
            return FeeContainerController.class;
        }

        protected void onCreate(FeeContainerController controller) {
            this.setStringConverters(controller);
            ((FeeGeneralContainer)controller.getView().getGeneralCard().getContent()).getProductTypesNode().setItemsSupplier(() -> PRODUCT_TYPES);
            ((FeeCalculationParametersContainer)controller.getView().getCalculationParametersCard().getContent()).getCalculateAsPercentNode().valueProperty().addListener((obj, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    ((FeeCalculationParametersContainer)controller.getView().getCalculationParametersCard().getContent()).getCalculationBasisNode().getViewState().setNotEditable(false);
                    ((FeeCalculationParametersContainer)controller.getView().getCalculationParametersCard().getContent()).getCalculationBasisNode().getViewState().setReadonly(false);
                    ((FeeCalculationParametersContainer)controller.getView().getCalculationParametersCard().getContent()).getCalculationTypeNode().setValue(null);
                    ((FeeCalculationParametersContainer)controller.getView().getCalculationParametersCard().getContent()).getCalculationTypeNode().getViewState().setNotEditable(true);
                } else {
                    ((FeeCalculationParametersContainer)controller.getView().getCalculationParametersCard().getContent()).getCalculationBasisNode().setValue(null);
                    ((FeeCalculationParametersContainer)controller.getView().getCalculationParametersCard().getContent()).getCalculationBasisNode().getViewState().setNotEditable(true);
                    ((FeeCalculationParametersContainer)controller.getView().getCalculationParametersCard().getContent()).getCalculationTypeNode().getViewState().setNotEditable(false);
                    ((FeeCalculationParametersContainer)controller.getView().getCalculationParametersCard().getContent()).getCalculationTypeNode().getViewState().setReadonly(false);
                }
            });
            ((FeeGeneralContainer)controller.getView().getGeneralCard().getContent()).getOperationNode().valueProperty().addListener((obj, oldValue, newValue) -> {
                if (newValue != null) {
                    switch (newValue) {
                        case SELL: {
                            ((FeeOtherParametersContainer)controller.getView().getOtherParametersCard().getContent()).getReturnCasesNode().getViewState().setNotEditable(false);
                            break;
                        }
                        case EXCHANGE: 
                        case REFUND: {
                            ((FeeOtherParametersContainer)controller.getView().getOtherParametersCard().getContent()).getReturnCasesNode().getViewState().setNotEditable(true);
                            ((FeeOtherParametersContainer)controller.getView().getOtherParametersCard().getContent()).getReturnCasesNode().getValues().clear();
                            break;
                        }
                        default: {
                            ((FeeOtherParametersContainer)controller.getView().getOtherParametersCard().getContent()).getReturnCasesNode().getViewState().setNotEditable(true);
                            ((FeeOtherParametersContainer)controller.getView().getOtherParametersCard().getContent()).getReturnCasesNode().getValues().clear();
                        }
                    }
                }
            });
            ((FeeOtherParametersContainer)controller.getView().getOtherParametersCard().getContent()).getReturnCasesNode().setItemsSupplier(Suppliers.createEnumSupplier(ReturnCase.class));
            ((FeeOtherParametersContainer)controller.getView().getOtherParametersCard().getContent()).getRefexTypesNode().setItemsSupplier(Suppliers.createEnumSupplier(RefexType.class));
            ((FeeOtherParametersContainer)controller.getView().getOtherParametersCard().getContent()).getRouteTypesNode().setItemsSupplier(Suppliers.createEnumSupplier(RouteType.class));
            ComboBoxWidget vatRate = ((FeeOtherParametersContainer)controller.getView().getOtherParametersCard().getContent()).getExternalFeeVatRateNode();
            vatRate.setItemsSupplier(ControllerInterceptorVatHelper.getVatHotelsSupplier());
            vatRate.setNoNulls(true);
            vatRate.setConverter(ControllerInterceptorVatHelper.vatConverter);
            vatRate.setPromptText(null);
            ((FeeOtherParametersContainer)controller.getView().getOtherParametersCard().getContent()).getExternalFeeNode().valueProperty().addListener((s, o, n) -> ((FeeOtherParametersContainer)controller.getView().getOtherParametersCard().getContent()).getExternalFeeVatRateCell().setHidden(n == false));
            ((FeeOtherParametersContainer)controller.getView().getOtherParametersCard().getContent()).getExternalFeeVatRateCell().setHidden(!((FeeOtherParametersContainer)controller.getView().getOtherParametersCard().getContent()).getExternalFeeNode().getValue());
        }

        protected void afterReadData(FeeContainerController controller, FeeContainerVM model) {
            ((FeeCalculationParametersContainer)controller.getView().getCalculationParametersCard().getContent()).getCalculationBasisNode().getViewState().setNotEditable((Boolean)((FeeCalculationParametersContainer)controller.getView().getCalculationParametersCard().getContent()).getCalculateAsPercentNode().valueProperty().get() == false);
        }

        private void setStringConverters(FeeContainerController main) {
            ((FeeOtherParametersContainer)main.getView().getOtherParametersCard().getContent()).getHiddenNode().setConverter(Converters.boolConverter((String)Messages.Hidden, (String)Messages.Normal));
            ((FeeOtherParametersContainer)main.getView().getOtherParametersCard().getContent()).getVatNotIncludedNode().setConverter(Converters.boolConverter((String)Messages.Vat_Not_Included, (String)Messages.Vat_Included));
            ((FeeCalculationParametersContainer)main.getView().getCalculationParametersCard().getContent()).getCalculateAsPercentNode().setConverter(Converters.boolConverter((String)Messages.Percent, (String)Messages.Fix_sum));
            ((FeeCalculationParametersContainer)main.getView().getCalculationParametersCard().getContent()).getCalculateFromDifferenceNode().setConverter(Converters.boolConverter((String)Messages.Accrue_for_additional, (String)Messages.No_Accrue_for_additional));
            ((FeeCalculationParametersContainer)main.getView().getCalculationParametersCard().getContent()).getChargeToClientForAllContractTypesNode().setConverter(Converters.boolConverter((String)Messages.Cast, (String)Messages.No_cast));
            ((FeeCalculationParametersContainer)main.getView().getCalculationParametersCard().getContent()).getRecalculateVatForAllContractTypesNode().setConverter(Converters.boolConverter((String)Messages.Recalculate_it, (String)Messages.No_recalculate));
        }

        protected void validateData(FeeContainerController controller, List<Message> messages) {
            if (controller.getCalculationParameters().isCalculateAsPercent() && (controller.getCalculationParameters().getRoundValue() == null || controller.getCalculationParameters().getRoundType() == null)) {
                messages.add(this.getMessage(Messages.NotifyEmpty_Round_Value_Type));
            }
        }

        private Message getMessage(String text) {
            Message msg = new Message();
            msg.setType(MessageType.WARNING);
            L10nMessage l10 = new L10nMessage();
            l10.setKey(text);
            msg.setMessage(l10);
            return msg;
        }
    }
}

