/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.contract;

import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.AppliedToVM;
import com.gridnine.xtrip.client.fx.model.profile.ContractSpaceVM;
import com.gridnine.xtrip.client.fx.model.profile.CurrencyRateVM;
import com.gridnine.xtrip.client.fx.model.profile.CurrencyRatesDetailsVM;
import com.gridnine.xtrip.client.fx.model.profile.ExtendedSupplierContractApplicationsFullContainerVM;
import com.gridnine.xtrip.client.fx.model.profile.ExtendedSupplierContractDetailsFullContainerVM;
import com.gridnine.xtrip.client.fx.model.profile.ExtendedSupplierContractMainFullGridPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.ExtendedSupplierContractMainFullPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.PaymentConditionVM;
import com.gridnine.xtrip.client.fx.model.profile.PaymentConditionsDetailsVM;
import com.gridnine.xtrip.client.fx.model.profile.SupplierContractApplicationsChildrenContainerVM;
import com.gridnine.xtrip.client.fx.model.profile.SupplierContractApplicationsNavigateContainerVM;
import com.gridnine.xtrip.client.fx.model.profile.SupplierContractApplicationsParentContainerVM;
import com.gridnine.xtrip.client.fx.model.profile.SupplierContractApplicationsQuotasTableItemVM;
import com.gridnine.xtrip.client.fx.model.profile.TCHContractVM;
import com.gridnine.xtrip.client.fx.model.profile.TCHContractsDetailsVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.contract.ModelContractsTileHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.profile.BaseContractAppendix;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ExchangeRateCondition;
import com.gridnine.xtrip.common.model.profile.PaymentConditionItem;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterAppendix;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterQuota;
import com.gridnine.xtrip.common.model.profile.SUBlockCharterTariffInfo;
import com.gridnine.xtrip.common.model.profile.TchDirectContract;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;

final class ExtendedSupplierContractTileHelper {
    private ExtendedSupplierContractTileHelper() {
    }

    static void toVM(Contract model, ContractSpaceVM contractSpaceVM) {
        ExtendedSupplierContractMainFullPanelVM panelVM = contractSpaceVM.getExtendedSupplierContractFull();
        ExtendedSupplierContractDetailsFullContainerVM detailsVM = contractSpaceVM.getExtendedSupplierContractDetailsFull();
        ExtendedSupplierContractApplicationsFullContainerVM fullApplicationsVM = contractSpaceVM.getExtendedSupplierContractApplicationsFull();
        ExtendedSupplierContractMainFullGridPanelVM supplierVM = panelVM.getSupplierContract();
        supplierVM.setName(model.getName());
        supplierVM.setSupplier(model.getSupplier());
        supplierVM.setVendor(model.getVendor());
        supplierVM.setDefaultContract(model.isDefaultContract());
        supplierVM.setContractNumber(model.getNumber());
        supplierVM.setOrganization(model.getCustomer());
        supplierVM.setIssueDate(DateUtils.asLocalDate((Date)model.getIssueDate()));
        supplierVM.setStartDate(DateUtils.asLocalDate((Date)model.getStartDate()));
        supplierVM.setEndDate(DateUtils.asLocalDate((Date)model.getEndDate()));
        supplierVM.setVendorContractType(model.getVendorContractType());
        supplierVM.setAgreementType(model.getAgreementType());
        supplierVM.setVatExemption(model.isVATExemption());
        PaymentConditionsDetailsVM paymentDetailsVM = detailsVM.getContent().getPaymentDetails();
        VMHelper.transfer(model.getPaymentConditions().getPaymentItems(), paymentDetailsVM.getPaymentConditions(), payment -> new PaymentConditionVM(), (condition, conditionVM) -> {
            if (condition.getAppliedTo() != null) {
                AppliedToVM appliedTo = new AppliedToVM();
                appliedTo.setAppliedTo(condition.getAppliedTo());
                conditionVM.setAppliedTo(appliedTo);
            } else {
                conditionVM.setAppliedTo(null);
            }
            conditionVM.setServicePaymentType(condition.getServicePaymentType());
            conditionVM.setServicePeriodicity(condition.getServicePeriodicity());
            conditionVM.setServicePaymentTime(condition.getServicePaymentTime());
            conditionVM.setFeePaymentType(condition.getFeePaymentType());
            conditionVM.setFeePeriodicity(condition.getFeePeriodicity());
            conditionVM.setFeePaymentTime(condition.getFeePaymentTime());
            conditionVM.setFeeSeparately(condition.isFeeSeparately());
            conditionVM.setPaymentTypeByDefault(condition.isPaymentTypeByDefault());
            conditionVM.setSabreRemark(condition.getSabreRemark());
        });
        CurrencyRatesDetailsVM currencyDetailsVM = detailsVM.getContent().getCurrencyDetails();
        currencyDetailsVM.setPaymentCurrency(model.getPaymentCurrency());
        VMHelper.transfer(model.getExchangeRateConditions(), currencyDetailsVM.getCurrencyRates(), currencyDetail -> new CurrencyRateVM(), (currencyDetail, currencyVM) -> {
            currencyVM.setRateType(currencyDetail.getRateType());
            currencyVM.setCoefficient(currencyDetail.getCoefficient());
            currencyVM.setRoundingMode(currencyDetail.getRoundingMode());
            currencyVM.setRoundingValue(currencyDetail.getRoundingValue());
            currencyVM.setRateRoundingValue(currencyDetail.getRateRoundingValue());
            currencyVM.setRateRoundingMode(currencyDetail.getRateRoundingMode());
            currencyVM.setIndirectRateFirst(currencyDetail.isIndirectRateFirst());
            currencyVM.setIndirectRateRoundingType(currencyDetail.getIndirectRateRoundingType());
            currencyVM.setStartDate(DateUtils.asLocalDate((Date)currencyDetail.getStartDate()));
            currencyVM.setEndDate(DateUtils.asLocalDate((Date)currencyDetail.getEndDate()));
        });
        TCHContractsDetailsVM tchDetailsVM = detailsVM.getContent().getTchDetails();
        VMHelper.transfer(model.getTchDirectContracts(), tchDetailsVM.getTchContracts(), tch -> new TCHContractVM(), (tch, tchVM) -> {
            tchVM.setAirline(tch.getAirline());
            tchVM.setContractNumber(tch.getContractNumber());
            tchVM.setIssueDate(DateUtils.asLocalDate((Date)tch.getIssueDate()));
            tchVM.setStartDate(DateUtils.asLocalDate((Date)tch.getStartDate()));
            tchVM.setEndDate(DateUtils.asLocalDate((Date)tch.getEndDate()));
        });
        SupplierContractApplicationsNavigateContainerVM containerVM = fullApplicationsVM.getContent();
        model.getAppendices().forEach(application -> {
            if (application instanceof SUBlockCharterAppendix) {
                SUBlockCharterAppendix app = (SUBlockCharterAppendix)application;
                SupplierContractApplicationsParentContainerVM parentAppVM = new SupplierContractApplicationsParentContainerVM();
                parentAppVM.setNumber(app.getNumber());
                parentAppVM.setItinerary(app.getItinerary());
                parentAppVM.setType(app.getType());
                parentAppVM.setCurrency(app.getCurrency());
                parentAppVM.setIssueDate(DateUtils.asLocalDate((Date)app.getIssueDate()));
                parentAppVM.setStartDate(DateUtils.asLocalDate((Date)app.getStartDate()));
                parentAppVM.setEndDate(DateUtils.asLocalDate((Date)app.getEndDate()));
                parentAppVM.setTariffCodes(app.getFareBasis());
                parentAppVM.setUid(app.getUid());
                containerVM.getContent().add(parentAppVM);
                app.getTariffs().forEach(tariff -> {
                    SupplierContractApplicationsChildrenContainerVM childAppVM = new SupplierContractApplicationsChildrenContainerVM();
                    childAppVM.getTariffs().setClassOfBooking(tariff.getClassOfBooking());
                    childAppVM.getTariffs().setOwAdultTariff(tariff.getOwAdultTariff());
                    childAppVM.getTariffs().setRtAdultTariff(tariff.getRtAdultTariff());
                    VMHelper.transfer(tariff.getQuotas(), childAppVM.getQuotas(), quota -> new SupplierContractApplicationsQuotasTableItemVM(), (quota, quotaVM) -> {
                        quotaVM.getFullData().setFlightNumber(quota.getFlightNumber());
                        quotaVM.getFullData().setFlightDate(DateUtils.asLocalDate((Date)quota.getFlightDate()));
                        quotaVM.getFullData().setQuota(quota.getQuota());
                        quotaVM.getFullData().setBackwardDirection(quota.isBackwardDirection());
                        quotaVM.setFlightNumber(quota.getFlightNumber());
                        quotaVM.setFlightDate(DateUtils.asLocalDate((Date)quota.getFlightDate()));
                        quotaVM.setQuota((String)StandardRenderers.NUMBER_INTEGRAL.apply((Object)quota.getQuota()));
                        quotaVM.setBackwardDirection((String)StandardRenderers.BOOLEAN.apply((Object)quota.isBackwardDirection()));
                    });
                    containerVM.getContent().add(childAppVM);
                });
            }
        });
        ModelContractsTileHelper.toVM(model, contractSpaceVM.getModelContractsFull());
    }

    static void fromVM(ContractSpaceVM contractSpaceVM, Contract model) {
        ExtendedSupplierContractMainFullPanelVM panelVM = contractSpaceVM.getExtendedSupplierContractFull();
        ExtendedSupplierContractDetailsFullContainerVM detailsVM = contractSpaceVM.getExtendedSupplierContractDetailsFull();
        ExtendedSupplierContractApplicationsFullContainerVM fullApplicationsVM = contractSpaceVM.getExtendedSupplierContractApplicationsFull();
        ExtendedSupplierContractMainFullGridPanelVM supplierVM = panelVM.getSupplierContract();
        model.setName(supplierVM.getName());
        model.setSupplier(supplierVM.getSupplier());
        model.setVendor(supplierVM.getVendor());
        model.setDefaultContract(supplierVM.isDefaultContract());
        model.setNumber(supplierVM.getContractNumber());
        model.setCustomer(supplierVM.getOrganization());
        model.setIssueDate(DateUtils.asDate((LocalDate)supplierVM.getIssueDate()));
        model.setStartDate(DateUtils.asDate((LocalDate)supplierVM.getStartDate()));
        model.setEndDate(DateUtils.asDate((LocalDate)supplierVM.getEndDate()));
        model.setVendorContractType(supplierVM.getVendorContractType());
        model.setAgreementType(supplierVM.getAgreementType());
        model.setVATExemption(supplierVM.isVatExemption());
        PaymentConditionsDetailsVM paymentDetailsVM = detailsVM.getContent().getPaymentDetails();
        VMHelper.transfer(paymentDetailsVM.getPaymentConditions(), model.getPaymentConditions().getPaymentItems(), conditionVM -> new PaymentConditionItem(), (conditionVM, condition) -> {
            condition.setAppliedTo(conditionVM.getAppliedTo() == null ? null : conditionVM.getAppliedTo().getAppliedTo());
            condition.setServicePaymentType(conditionVM.getServicePaymentType());
            condition.setServicePeriodicity(conditionVM.getServicePeriodicity());
            condition.setServicePaymentTime(conditionVM.getServicePaymentTime());
            condition.setFeePaymentType(conditionVM.getFeePaymentType());
            condition.setFeePeriodicity(conditionVM.getFeePeriodicity());
            condition.setFeePaymentTime(conditionVM.getFeePaymentTime());
            condition.setFeeSeparately(conditionVM.isFeeSeparately());
            condition.setPaymentTypeByDefault(conditionVM.isPaymentTypeByDefault());
            condition.setSabreRemark(conditionVM.getSabreRemark());
        });
        CurrencyRatesDetailsVM currencyDetailsVM = detailsVM.getContent().getCurrencyDetails();
        model.setPaymentCurrency(currencyDetailsVM.getPaymentCurrency());
        VMHelper.transfer(currencyDetailsVM.getCurrencyRates(), model.getExchangeRateConditions(), currencyVM -> new ExchangeRateCondition(), (currencyVM, currency) -> {
            currency.setRateType(currencyVM.getRateType());
            currency.setCoefficient(currencyVM.getCoefficient());
            currency.setRoundingMode(currencyVM.getRoundingMode());
            currency.setRoundingValue(currencyVM.getRoundingValue());
            currency.setRateRoundingMode(currencyVM.getRateRoundingMode());
            currency.setRateRoundingValue(currencyVM.getRateRoundingValue());
            currency.setIndirectRateFirst(currencyVM.isIndirectRateFirst());
            currency.setIndirectRateRoundingType(currencyVM.getIndirectRateRoundingType());
            currency.setStartDate(DateUtils.asDate((LocalDate)currencyVM.getStartDate()));
            currency.setEndDate(DateUtils.asDate((LocalDate)currencyVM.getEndDate()));
        });
        TCHContractsDetailsVM tchDetailsVM = detailsVM.getContent().getTchDetails();
        VMHelper.transfer(tchDetailsVM.getTchContracts(), model.getTchDirectContracts(), tchVM -> new TchDirectContract(), (tchVM, tch) -> {
            tch.setAirline(tchVM.getAirline());
            tch.setContractNumber(tchVM.getContractNumber());
            tch.setIssueDate(DateUtils.asDate((LocalDate)tchVM.getIssueDate()));
            tch.setStartDate(DateUtils.asDate((LocalDate)tchVM.getStartDate()));
            tch.setEndDate(DateUtils.asDate((LocalDate)tchVM.getEndDate()));
        });
        SupplierContractApplicationsNavigateContainerVM containerVM = fullApplicationsVM.getContent();
        ArrayList existingAppendices = new ArrayList(model.getAppendices());
        containerVM.getContent().forEach(view -> {
            if (view instanceof SupplierContractApplicationsParentContainerVM) {
                SupplierContractApplicationsParentContainerVM parent = (SupplierContractApplicationsParentContainerVM)view;
                SUBlockCharterAppendix application = existingAppendices.stream().filter(it -> it.getUid().equals(parent.getUid())).findFirst().orElse(null);
                if (application == null) {
                    application = new SUBlockCharterAppendix();
                } else {
                    application.getTariffs().clear();
                }
                application.setNumber(parent.getNumber());
                application.setItinerary(parent.getItinerary());
                application.setType(parent.getType());
                application.setCurrency(parent.getCurrency());
                application.setIssueDate(DateUtils.asDate((LocalDate)parent.getIssueDate()));
                application.setStartDate(DateUtils.asDate((LocalDate)parent.getStartDate()));
                application.setEndDate(DateUtils.asDate((LocalDate)parent.getEndDate()));
                application.setFareBasis(parent.getTariffCodes());
                application.setUid(parent.getUid());
                model.getAppendices().add(application);
            } else if (view instanceof SupplierContractApplicationsChildrenContainerVM) {
                SupplierContractApplicationsChildrenContainerVM child = (SupplierContractApplicationsChildrenContainerVM)view;
                SUBlockCharterTariffInfo tariff = new SUBlockCharterTariffInfo();
                tariff.setClassOfBooking(child.getTariffs().getClassOfBooking());
                tariff.setOwAdultTariff(child.getTariffs().getOwAdultTariff());
                tariff.setRtAdultTariff(child.getTariffs().getRtAdultTariff());
                VMHelper.transfer(child.getQuotas(), tariff.getQuotas(), quotaVM -> new SUBlockCharterQuota(), (quotaVM, quota) -> {
                    quota.setFlightNumber(quotaVM.getFullData().getFlightNumber());
                    quota.setFlightDate(DateUtils.asDate((LocalDate)quotaVM.getFullData().getFlightDate()));
                    quota.setQuota(quotaVM.getFullData().getQuota());
                    quota.setBackwardDirection(quotaVM.getFullData().isBackwardDirection());
                });
                if (model.getAppendices().size() > 0) {
                    ((SUBlockCharterAppendix)model.getAppendices().get(model.getAppendices().size() - 1)).getTariffs().add(tariff);
                }
            }
        });
        Collection<BaseContractAppendix> list = model.getAppendices().stream().collect(Collectors.toMap(BaseIdentity::getUid, el -> el, (o1, o2) -> o1)).values();
        model.getAppendices().clear();
        model.getAppendices().addAll(list);
        ModelContractsTileHelper.fromVM(contractSpaceVM.getModelContractsFull(), model);
    }
}

