/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.exportSettings;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.model.exportSettings.ExportSettingsGeneralVM;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.settings.model.FileConnectionSettingsVM;
import com.gridnine.xtrip.client.fx.standard.settings.model.FtpConnectionSettingsVM;
import com.gridnine.xtrip.client.fx.standard.settings.model.HttpConnectionSettingsVM;
import com.gridnine.xtrip.client.fx.standard.settings.model.SftpConnectionSettingsVM;
import com.gridnine.xtrip.common.fx.model.export.TreeDataWrapper;
import com.gridnine.xtrip.common.model.export.BaseConnectionSettings;
import com.gridnine.xtrip.common.model.export.BaseExportSettings;
import com.gridnine.xtrip.common.model.export.ConnectionType;
import com.gridnine.xtrip.common.model.export.ElementExportSettings;
import com.gridnine.xtrip.common.model.export.FileConnectionSettings;
import com.gridnine.xtrip.common.model.export.FtpConnectionSettings;
import com.gridnine.xtrip.common.model.export.HttpConnectionSettings;
import com.gridnine.xtrip.common.model.export.SftpConnectionSettings;
import com.gridnine.xtrip.common.util.TextUtil;
import java.net.MalformedURLException;
import java.net.URL;

public class ExportSettingsHelper {
    public static void toVM(ExportSettingsGeneralVM common, HttpConnectionSettingsVM httpVM, FtpConnectionSettingsVM ftpVM, SftpConnectionSettingsVM sftpVM, FileConnectionSettingsVM fileVM, BaseExportSettings model) {
        common.setName(model.getName());
        common.setCreateDocuments(model.isCreateDocuments());
        common.setSendData(model.isSendData());
        common.setExportPeriod(model.getExportPeriod());
        common.setExportTime(model.getExportTime());
        if (model.getConnectionSettings() != null && model.getConnectionSettings().getClass() != null) {
            switch (model.getConnectionSettings().getClass().getSimpleName()) {
                case "HttpConnectionSettings": {
                    HttpConnectionSettings httpModel = (HttpConnectionSettings)model.getConnectionSettings();
                    httpVM.setUrl(httpModel.getUrl() == null ? null : httpModel.getUrl().toString());
                    httpVM.setLogin(httpModel.getLogin());
                    httpVM.setPassword(httpModel.getPassword());
                    httpVM.setReference(httpModel.getCommonSettings());
                    common.setConnectionType(ConnectionType.HTTP);
                    break;
                }
                case "FtpConnectionSettings": {
                    FtpConnectionSettings ftpModel = (FtpConnectionSettings)model.getConnectionSettings();
                    ftpVM.setUrl(ftpModel.getUrl() == null ? null : ftpModel.getUrl().toString());
                    ftpVM.setLogin(ftpModel.getLogin());
                    ftpVM.setPassword(ftpModel.getPassword());
                    ftpVM.setTlsEnabled(ftpModel.isTlsEnabled());
                    ftpVM.setPassiveModeEnabled(ftpModel.isPassiveModeEnabled());
                    ftpVM.setReference(ftpModel.getCommonSettings());
                    common.setConnectionType(ConnectionType.FTP);
                    break;
                }
                case "SftpConnectionSettings": {
                    SftpConnectionSettings sftpModel = (SftpConnectionSettings)model.getConnectionSettings();
                    sftpVM.setUrl(sftpModel.getUrl() == null ? null : sftpModel.getUrl().toString());
                    sftpVM.setLogin(sftpModel.getLogin());
                    sftpVM.setPassword(sftpModel.getPassword());
                    sftpVM.setReference(sftpModel.getCommonSettings());
                    sftpVM.setKey(sftpModel.getKey());
                    common.setConnectionType(ConnectionType.SFTP);
                    break;
                }
                case "FileConnectionSettings": {
                    FileConnectionSettings fileModel = (FileConnectionSettings)model.getConnectionSettings();
                    fileVM.setUrl(fileModel.getUrl() == null ? null : fileModel.getUrl().toString());
                    fileVM.setReference(fileModel.getCommonSettings());
                    common.setConnectionType(ConnectionType.FILE);
                }
            }
        }
    }

    public static void fromVM(ExportSettingsGeneralVM common, HttpConnectionSettingsVM httpVM, FtpConnectionSettingsVM ftpVM, SftpConnectionSettingsVM sftpVM, FileConnectionSettingsVM fileVM, BaseExportSettings model) {
        model.setName(common.getName());
        model.setCreateDocuments(common.isCreateDocuments());
        model.setSendData(common.isSendData());
        model.setExportPeriod(common.getExportPeriod());
        model.setExportTime(common.getExportTime());
        if (common.getConnectionType() != null) {
            switch (common.getConnectionType()) {
                case HTTP: {
                    HttpConnectionSettings httpModel = new HttpConnectionSettings();
                    if (!TextUtil.isBlank((String)httpVM.getUrl())) {
                        try {
                            String url = httpVM.getUrl();
                            httpModel.setUrl(new URL(url.startsWith("https://") || url.startsWith("http://") ? url : "http://" + url));
                        }
                        catch (MalformedURLException ignored) {
                            Dialog.info((String)Messages.Invalid_URL_parameter);
                        }
                    } else {
                        Dialog.info((String)Messages.Invalid_URL_parameter);
                    }
                    httpModel.setLogin(httpVM.getLogin());
                    httpModel.setPassword(httpVM.getPassword());
                    httpModel.setCommonSettings(httpVM.getReference());
                    model.setConnectionSettings((BaseConnectionSettings)httpModel);
                    break;
                }
                case FTP: {
                    FtpConnectionSettings ftpModel = new FtpConnectionSettings();
                    if (!TextUtil.isBlank((String)ftpVM.getUrl())) {
                        try {
                            String url = ftpVM.getUrl();
                            ftpModel.setUrl(new URL(url.startsWith("ftps://") || url.startsWith("ftp://") ? url : "ftp://" + url));
                        }
                        catch (MalformedURLException ignored) {
                            Dialog.info((String)Messages.Invalid_URL_parameter);
                        }
                    } else {
                        Dialog.info((String)Messages.Invalid_URL_parameter);
                    }
                    ftpModel.setLogin(ftpVM.getLogin());
                    ftpModel.setPassword(ftpVM.getPassword());
                    ftpModel.setCommonSettings(ftpVM.getReference());
                    ftpModel.setTlsEnabled(ftpVM.isTlsEnabled());
                    ftpModel.setPassiveModeEnabled(ftpVM.isPassiveModeEnabled());
                    model.setConnectionSettings((BaseConnectionSettings)ftpModel);
                    break;
                }
                case SFTP: {
                    SftpConnectionSettings sftpModel = new SftpConnectionSettings();
                    if (!TextUtil.isBlank((String)sftpVM.getUrl())) {
                        try {
                            String url = sftpVM.getUrl();
                            sftpModel.setUrl(new URL(url.startsWith("ftps://") || url.startsWith("ftp://") ? url : "ftp://" + url));
                        }
                        catch (MalformedURLException ignored) {
                            Dialog.info((String)Messages.Invalid_URL_parameter);
                        }
                    } else {
                        Dialog.info((String)Messages.Invalid_URL_parameter);
                    }
                    sftpModel.setLogin(sftpVM.getLogin());
                    sftpModel.setPassword(sftpVM.getPassword());
                    sftpModel.setCommonSettings(sftpVM.getReference());
                    sftpModel.setKey(sftpVM.getKey());
                    model.setConnectionSettings((BaseConnectionSettings)sftpModel);
                    break;
                }
                case FILE: {
                    FileConnectionSettings fileModel = new FileConnectionSettings();
                    if (!TextUtil.isBlank((String)fileVM.getUrl())) {
                        try {
                            String url = fileVM.getUrl();
                            fileModel.setUrl(new URL(url.startsWith("file:/") ? url : "file:/" + url));
                        }
                        catch (MalformedURLException ignored) {
                            Dialog.info((String)Messages.Invalid_URL_parameter);
                        }
                    } else {
                        Dialog.info((String)Messages.Invalid_URL_parameter);
                    }
                    fileModel.setCommonSettings(fileVM.getReference());
                    model.setConnectionSettings((BaseConnectionSettings)fileModel);
                }
            }
        }
    }

    static void toTreeDataWrapper(TreeDataWrapper wrapper, ElementExportSettings settings) {
        wrapper.getSettings().setExported(settings.isExported());
        for (TreeDataWrapper wrap : wrapper.getChildren()) {
            for (ElementExportSettings el : settings.getChildren()) {
                if (!wrap.getSettings().getName().equals(el.getName())) continue;
                ExportSettingsHelper.toTreeDataWrapper(wrap, el);
            }
        }
    }

    static ElementExportSettings fromTreeDataWrapper(TreeDataWrapper wrapper) {
        ElementExportSettings el = new ElementExportSettings();
        el.setExported(wrapper.getSettings().isExported());
        el.setName(wrapper.getSettings().getName());
        for (TreeDataWrapper wrap : wrapper.getChildren()) {
            el.getChildren().add(ExportSettingsHelper.fromTreeDataWrapper(wrap));
        }
        return el;
    }
}

