/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.finance;

import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableActionHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.BasePaymentDocumentDocumentsViewVM;
import com.gridnine.xtrip.client.fx.model.profile.BasePaymentDocumentRelatedDocumentsViewVM;
import com.gridnine.xtrip.client.fx.model.profile.BasePaymentDocumentTransactionsViewVM;
import com.gridnine.xtrip.client.fx.model.profile.CreditSlipCardController;
import com.gridnine.xtrip.client.fx.model.profile.CreditSlipCardVM;
import com.gridnine.xtrip.client.fx.model.profile.CreditSlipMainCard;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.DataViewWidgetHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.finance.BasePaymentDocument;
import com.gridnine.xtrip.common.model.helpers.PersonalLocalizableNameFormatter;
import com.gridnine.xtrip.common.model.helpers.PersonalNameFormat;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Supplier;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;

public class CreditSlipConrollerInterceptor
extends ControllerInterceptor<CreditSlipCardVM, CreditSlipCardController> {
    protected Class<CreditSlipCardController> getControllerClass() {
        return CreditSlipCardController.class;
    }

    protected void onCreate(CreditSlipCardController controller) {
        ((CreditSlipMainCard)controller.getView().getMainCardCard().getContent()).getOrganizationNode().setListParametersSupplier(ControllerInterceptorsHelper.getAgenciesAndBlankOwnersAndClient());
        ((CreditSlipMainCard)controller.getView().getMainCardCard().getContent()).getCashierNode().setListParametersSupplier(ControllerInterceptorsHelper::getCashierAccountant);
        ((CreditSlipMainCard)controller.getView().getMainCardCard().getContent()).getPersonNode().setListParametersSupplier(ControllerInterceptorsHelper::getAgents);
        this.configureCreditSlip(controller);
        this.configurePersonInfo(controller);
        ((DataViewWidget)controller.getView().getRelatedDocumentsCard().getContent()).getTableView().setActionHandler((TableActionHandler)new TableActionHandler<BasePaymentDocumentRelatedDocumentsViewVM>(){

            public boolean isActive(TableColumn<BasePaymentDocumentRelatedDocumentsViewVM, ?> column, BasePaymentDocumentRelatedDocumentsViewVM item) {
                return false;
            }

            public void onAction(TableColumn<BasePaymentDocumentRelatedDocumentsViewVM, ?> column, BasePaymentDocumentRelatedDocumentsViewVM item) {
                RootEntityEditingService.navigateTo((EntityReference)item.getReference());
            }
        });
    }

    protected void afterReadData(CreditSlipCardController controller, CreditSlipCardVM model) {
        ((DataViewWidget)controller.getView().getTransactionsCard().getContent()).reloadData();
    }

    private void configureCreditSlip(CreditSlipCardController controller) {
        Supplier<EntityContainer<? extends BasePaymentDocument>> containerSupplier = () -> {
            RootEntityPane rep = RootEntityPane.lookup((Node)controller.getView());
            if (rep == null) {
                return null;
            }
            return rep.getData() == null || rep.getData().getContainer() == null ? null : rep.getData().getContainer();
        };
        DataViewWidgetHelper.configurePaymentRelatedDocumentsView((DataViewWidget<BasePaymentDocumentRelatedDocumentsViewVM>)((DataViewWidget)controller.getView().getRelatedDocumentsCard().getContent()), containerSupplier, (ObservableValue<Boolean>)controller.getView().getRelatedDocumentsCard().collapsedProperty());
        DataViewWidgetHelper.configureTransactionsDataViewForSlip((DataViewWidget<BasePaymentDocumentTransactionsViewVM>)((DataViewWidget)controller.getView().getTransactionsCard().getContent()), containerSupplier, (ObservableValue<Boolean>)controller.getView().getTransactionsCard().collapsedProperty());
        DataViewWidgetHelper.configurePaymentDocumentsDataView((DataViewWidget<BasePaymentDocumentDocumentsViewVM>)((DataViewWidget)controller.getView().getDocumentsCard().getContent()), containerSupplier, (ObservableValue<Boolean>)controller.getView().getDocumentsCard().collapsedProperty());
    }

    private void configurePersonInfo(CreditSlipCardController controller) {
        EntityBoxWidget personNode = ((CreditSlipMainCard)controller.getView().getMainCardCard().getContent()).getPersonNode();
        TextFieldWidget personNameNode = ((CreditSlipMainCard)controller.getView().getMainCardCard().getContent()).getPersonNameNode();
        TextFieldWidget personDocumentNode = ((CreditSlipMainCard)controller.getView().getMainCardCard().getContent()).getPersonDocumentNode();
        personNode.setValueSelectionListener(ref -> {
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            Notifications.get().submitTask(() -> {
                EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                EntityContainer ctr = entityService.load(sic, ref.getSource());
                if (ctr != null) {
                    FxUtil.waitForFxThread(() -> {
                        Person person = (Person)ctr.getEntity();
                        boolean personNameEmpty = TextUtil.isBlank((String)personNameNode.getValue());
                        if (personNameEmpty) {
                            Locale locale = ClientSettings.get().getDataLocale() != null ? ClientSettings.get().getDataLocale() : ClientSettings.get().getUiLocale();
                            PersonalLocalizableNameFormatter format = new PersonalLocalizableNameFormatter("L F M");
                            String personName = format.format((PersonalLocalizableName)person, locale, false);
                            personNameNode.setValue(personName);
                        }
                        boolean personDocumentEmpty = TextUtil.isBlank((String)personDocumentNode.getValue());
                        for (PassportType type : Arrays.asList(PassportType.INTERNAL, PassportType.FOREIGN)) {
                            SimpleDateFormat format;
                            Passport passport = person.getPassports().stream().filter(item -> item != null && item.getType() == type).findFirst().orElse(null);
                            if (passport == null) continue;
                            if (personNameEmpty && type == PassportType.INTERNAL) {
                                format = new PersonalNameFormat("L F M");
                                String personName = format.format((PersonalName)passport);
                                personNameNode.setValue(personName);
                            }
                            if (!personDocumentEmpty) break;
                            format = new SimpleDateFormat("dd.MM.yyyy");
                            String personDocument = L10n.replace((String)Messages.Passport_message, (Object[])new Object[]{passport.getCitizenship() != null ? passport.getCitizenship() : "", !TextUtil.isBlank((String)passport.getNumber()) ? passport.getNumber().trim() : "", passport.getIssued() != null ? format.format(passport.getIssued()) : "", !TextUtil.isBlank((String)passport.getIssueOrganization()) ? passport.getIssueOrganization().trim() : ""});
                            personDocumentNode.setValue(personDocument);
                            break;
                        }
                    });
                }
            }, Messages.Receiving_data);
        });
    }
}

