/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.finance;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichData;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.finance.FinanceDocumentContainerControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.model.FinanceDocumentContainer;
import com.gridnine.xtrip.client.fx.standard.model.FinanceDocumentContainerController;
import com.gridnine.xtrip.client.fx.standard.model.FinanceDocumentContainerVM;
import com.gridnine.xtrip.client.fx.standard.model.FinanceDocumentItemsBillingItemsVM;
import com.gridnine.xtrip.client.fx.standard.model.FinanceDocumentItemsPaymentItemsVM;
import com.gridnine.xtrip.client.fx.standard.model.FinanceDocumentItemsRelatedShipmentsVM;
import com.gridnine.xtrip.client.fx.standard.model.FinanceDocumentMainGridVM;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.finance.BillingItem;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentRecordIndex;
import com.gridnine.xtrip.common.model.finance.FinanceDocumentUIData;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class FinanceDocumentHandler
extends BaseRootEntityHandler<FinanceDocument, FinanceDocumentUIData, FinanceDocumentContainerVM, FinanceDocumentContainer> {
    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<FinanceDocument, FinanceDocumentUIData>, FinanceDocumentContainerVM>> toVM, List<BiConsumer<FinanceDocumentContainerVM, DataTransferPackage<FinanceDocument, FinanceDocumentUIData>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new FinanceDocumentContainerControllerInterceptor());
        toVM.add((dtp, vm) -> {
            BinaryData content;
            FinanceDocument model = (FinanceDocument)dtp.getContainer().getEntity();
            FinanceDocumentUIData supplement = (FinanceDocumentUIData)dtp.getSupplement();
            FinanceDocumentMainGridVM mainCard = vm.getMain();
            mainCard.setCustomer(model.getCustomer());
            mainCard.setDate(DateUtils.asLocalDate((Date)model.getDate()));
            mainCard.setName(model.getName());
            mainCard.setNumber(model.getNumber());
            mainCard.setPayer(model.getPayer());
            mainCard.setPayerBankAccount(model.getPayerBankAccount());
            mainCard.setSupplier(model.getSupplier());
            mainCard.setSupplierBankAccount(model.getSupplierBankAccount());
            mainCard.setTemplate(model.getTemplate());
            mainCard.setType(model.getType());
            mainCard.setAgent(model.getAgent());
            mainCard.setAmountChecked(model.isAmountChecked());
            mainCard.setUseDelegate(model.isUseDelegate());
            mainCard.setUseFacsimile(model.isUseFacsimile());
            mainCard.setContract(model.getContract());
            mainCard.setCurrency(model.getCurrency());
            vm.setCaptionTemplate(model.getCaptionTemplate());
            if (supplement != null) {
                VMHelper.transfer(supplement.getBillingItems(), vm.getBillingItems(), bi -> new FinanceDocumentItemsBillingItemsVM(), (bi, biVM) -> {
                    biVM.setName(bi.getName());
                    biVM.setPaymentType(bi.getPaymentType());
                    if (bi.getAmount() != null) {
                        biVM.setAmount(bi.getAmount().getTotal());
                        biVM.setVat(bi.getAmount().getVatAmount());
                    }
                    biVM.setProduct(bi.getProduct() != null ? bi.getProduct() : null);
                    biVM.setTraveller(bi.getTraveller() != null ? bi.getTraveller() : null);
                    BigDecimal totalAmount = mainCard.getTotalAmount();
                    totalAmount = totalAmount == null ? bi.getAmount().getTotal() : MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalAmount, bi.getAmount().getTotal()});
                    mainCard.setTotalAmount(totalAmount);
                });
            }
            if (supplement != null && supplement.getPaymentItems() != null) {
                VMHelper.transfer(supplement.getPaymentItems().getData(), vm.getPaymentItems(), bi -> new FinanceDocumentItemsPaymentItemsVM(), (pi, piVM) -> {
                    piVM.setType(pi.getPaymentType());
                    piVM.setAmount(pi.getAmount());
                    piVM.setCurrency(pi.getAmount() == null ? null : pi.getAmount().getCurrency());
                    piVM.setPaymentDocument((EntityReference)supplement.getPaymentItemPaymentDocumentMap().get(pi));
                    Money paymentsTotalAmount = mainCard.getPaymentsTotalAmount();
                    if (paymentsTotalAmount == null) {
                        paymentsTotalAmount = new Money();
                        paymentsTotalAmount.setValue(pi.getAmount().getValue());
                        paymentsTotalAmount.setCurrency(pi.getAmount().getCurrency());
                    } else {
                        paymentsTotalAmount.setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{paymentsTotalAmount.getValue(), pi.getAmount().getValue()}));
                    }
                    mainCard.setPaymentsTotalAmount(paymentsTotalAmount);
                });
            }
            if (supplement != null) {
                VMHelper.transfer(supplement.getRelatedShipments(), vm.getRelatedShipments(), shipmentData -> new FinanceDocumentItemsRelatedShipmentsVM(), (shipmentData, shipmentDataVM) -> {
                    shipmentDataVM.setRelatedShipment(shipmentData.getShipmentReference());
                    shipmentDataVM.setNumber(shipmentData.getNumber());
                    shipmentDataVM.setDate(DateUtils.asLocalDate((Date)shipmentData.getDate()));
                });
            }
            if ((content = model.getContent()) != null) {
                RichData docVM = new RichData();
                docVM.setContent(content.getData());
                docVM.setContentType(content.getContentType());
                vm.setDocument(docVM);
            } else {
                vm.setDocument(null);
            }
        });
        fromVM.add((vm, dtp) -> {
            FinanceDocument model = (FinanceDocument)dtp.getContainer().getEntity();
            FinanceDocumentMainGridVM mainCard = vm.getMain();
            model.setCustomer(mainCard.getCustomer());
            model.setDate(DateUtils.asDate((LocalDate)mainCard.getDate()));
            model.setName(mainCard.getName());
            model.setNumber(mainCard.getNumber());
            model.setPayer(mainCard.getPayer());
            model.setPayerBankAccount(mainCard.getPayerBankAccount());
            model.setSupplier(mainCard.getSupplier());
            model.setSupplierBankAccount(mainCard.getSupplierBankAccount());
            model.setTemplate(mainCard.getTemplate());
            model.setType(mainCard.getType());
            model.setAgent(mainCard.getAgent());
            model.setAmountChecked(mainCard.isAmountChecked());
            model.setUseDelegate(mainCard.isUseDelegate());
            model.setUseFacsimile(mainCard.isUseFacsimile());
            model.setContract(mainCard.getContract());
            model.setCurrency(mainCard.getCurrency());
            model.setCaptionTemplate(vm.getCaptionTemplate());
            RichData docVM = vm.getDocument();
            if (docVM == null) {
                model.setContent(null);
            } else {
                BinaryData content = model.getContent();
                if (content == null) {
                    content = new BinaryData();
                    model.setContent(content);
                }
                content.setData(docVM.getContent());
                content.setContentType(docVM.getContentType());
            }
            FinanceDocumentUIData supplement = (FinanceDocumentUIData)dtp.getSupplement();
            if (supplement != null) {
                List deletedBillingItemUids = supplement.getBillingItems().stream().filter(item -> CollectionUtil.find((Iterable)vm.getBillingItems(), (String)item.getUid()) == null).map(BaseIdentity::getUid).collect(Collectors.toList());
                VMHelper.transfer(vm.getBillingItems(), supplement.getBillingItems(), bi -> new BillingItem(), (biVM, bi) -> {
                    bi.setName(biVM.getName());
                    bi.setPaymentType(biVM.getPaymentType());
                    bi.setAmount(biVM.getVat() != null ? VatAmount.of((BigDecimal)biVM.getAmount(), (BigDecimal)biVM.getVat()) : VatAmount.of((BigDecimal)biVM.getAmount()));
                });
                supplement.getDeletedBillingItemUids().clear();
                supplement.getDeletedBillingItemUids().addAll(deletedBillingItemUids);
            }
        });
    }

    @Override
    protected ViewController<FinanceDocumentContainer, FinanceDocumentContainerVM> createSpaceController(boolean readonly) {
        return new FinanceDocumentContainerController(readonly);
    }

    @Override
    protected FinanceDocumentContainerVM createVM() {
        return new FinanceDocumentContainerVM();
    }

    public Class<FinanceDocument> getEntityClass() {
        return FinanceDocument.class;
    }

    public Class<FinanceDocumentUIData> getSupplementClass() {
        return FinanceDocumentUIData.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return FinanceDocumentRecordIndex.class;
    }
}

