/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.holding;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.model.profile.HoldingSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.holding.HoldingContactsTileHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.holding.HoldingCreditsTileHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.holding.HoldingGeneralTileHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.holding.HoldingHandlerConfigurator;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.holding.HoldingOtherParametersTileHelper;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.holding.controllerinterceptors.HoldingAddressExtraPanelControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.holding.controllerinterceptors.HoldingAddressGeneralPanelControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.holding.controllerinterceptors.HoldingContactsControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.holding.controllerinterceptors.HoldingControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.holding.controllerinterceptors.HoldingPccSettingsControllerInterceptor;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.profile.Holding;
import java.util.List;
import java.util.function.BiConsumer;

class StandardHoldingHandlerConfigurator
implements HoldingHandlerConfigurator {
    StandardHoldingHandlerConfigurator() {
    }

    @Override
    public void configureController(List<BiConsumer<DataTransferPackage<Holding, Void>, HoldingSpaceVM>> toVM, List<BiConsumer<HoldingSpaceVM, DataTransferPackage<Holding, Void>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new HoldingPccSettingsControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new HoldingControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new HoldingContactsControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new HoldingAddressGeneralPanelControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new HoldingAddressExtraPanelControllerInterceptor());
        toVM.add((dtp, vm) -> {
            Holding model = (Holding)dtp.getContainer().getEntity();
            vm.getOverview().setCode(model.getCode());
            vm.getOverview().setName(model.getFullName());
            HoldingGeneralTileHelper.toVM(model, vm.getGeneralFull());
            HoldingContactsTileHelper.toVM(model, vm.getContactsFull());
            HoldingCreditsTileHelper.toVM(model, vm.getFinanceFull());
            HoldingOtherParametersTileHelper.toVM(model, vm.getOtherParametersFull());
        });
        fromVM.add((vm, dtp) -> {
            Holding model = (Holding)dtp.getContainer().getEntity();
            HoldingGeneralTileHelper.fromVM(vm.getGeneralFull(), model);
            HoldingContactsTileHelper.fromVM(vm.getContactsFull(), model);
            HoldingCreditsTileHelper.fromVM(vm.getFinanceFull(), model);
            HoldingOtherParametersTileHelper.fromVM(vm.getOtherParametersFull(), model);
        });
    }
}

