/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.modelcontract;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.model.profile.ModelContractActionsDialogContainer;
import com.gridnine.xtrip.client.fx.model.profile.ModelContractActionsDialogContainerContractsTableVM;
import com.gridnine.xtrip.client.fx.model.profile.ModelContractInContractsDataVM;
import com.gridnine.xtrip.client.fx.model.profile.ModelContractInContractsPanel;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.modelcontract.ModelContractActionsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;

public enum ModelContractInContractsTileActions implements TileAction<Node, ModelContractInContractsPanel>
{
    ADD{

        public String getName(Tile<Node, ModelContractInContractsPanel> tile) {
            return Messages.modelContract_applyToContractButton_caption;
        }

        public String getDescription(Tile<Node, ModelContractInContractsPanel> tile) {
            return Messages.modelContract_applyToContractButton_description;
        }

        public double getWeight() {
            return 10.0;
        }

        public boolean isEnabled(Tile<Node, ModelContractInContractsPanel> tile) {
            RootEntityPane pane = RootEntityPane.lookup((Node)tile.getFullNode());
            boolean isEnabled = false;
            if (pane != null && (pane.getMode() == EditingMode.EDIT || pane.getMode() == EditingMode.CREATE)) {
                isEnabled = true;
            }
            return isEnabled;
        }

        public void execute(Control source, final Tile<Node, ModelContractInContractsPanel> tile, boolean alt) {
            ModelContractActionsDialogContainer dialogContainer = new ModelContractActionsDialogContainer(false);
            TableWidget contractTableWidget = (TableWidget)dialogContainer.getMainCard().getContent();
            EntityBoxWidgetColumn customerColumn = (EntityBoxWidgetColumn)contractTableWidget.getColumn("customer");
            ((TableWidget)dialogContainer.getMainCard().getContent()).setItemsProvider(() -> {
                ModelContractActionsDialogContainerContractsTableVM result = new ModelContractActionsDialogContainerContractsTableVM();
                result.setTranslateSupplierFees(true);
                return result;
            });
            for (int i = 0; i < contractTableWidget.getRowsCount(); ++i) {
                EntityBoxWidget widget = (EntityBoxWidget)customerColumn.getWidget(i);
                widget.setListParametersSupplier(this::getContractsWithNewModel);
            }
            contractTableWidget.setOnRowsAction(event -> {
                if (event.getTarget() == contractTableWidget && TableRowEvent.ROW_ADD.equals(event.getEventType())) {
                    int idx = event.getRowIndex();
                    EntityBoxWidget widget = (EntityBoxWidget)customerColumn.getWidget(idx);
                    widget.setListParametersSupplier(this::getContractsWithNewModel);
                }
            });
            dialogContainer.getMainCard().getCaption();
            EntityContainer container = RootEntityPane.lookup((Node)tile.getFullNode()).getData().getContainer();
            ModelContractActionsHelper.ContractsCallback dataReloadCallback = new ModelContractActionsHelper.ContractsCallback(){

                public void execute() throws Exception {
                    ((DataViewWidget)((ModelContractInContractsPanel)tile.getFullNode()).getContractsTableCard().getContent()).reloadData();
                }
            };
            Dialog dialog = new Dialog();
            dialog.setBody((Node)dialogContainer).setAutoClose(false).setOnCloseRequest(() -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.modelContract_applyToContractButton_applyAction, () -> {
                if (((TableWidget)dialogContainer.getMainCard().getContent()).getRowsData().stream().allMatch(Objects::isNull)) {
                    dialog.addValidationMessages(true, new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.modelContract_applyToContractButton_emptyContractsError, (Object[])new Object[0])});
                    return;
                }
                dialog.close();
                ModelContractActionsHelper.addToContractList(contractTableWidget.getRowsData(), (EntityReference<ModelContract>)container.toReference(), dataReloadCallback);
            }).show((Node)source);
        }
    }
    ,
    DELETE{

        public String getName(Tile<Node, ModelContractInContractsPanel> tile) {
            return Messages.modelContract_removeFromContractButton_caption;
        }

        public String getDescription(Tile<Node, ModelContractInContractsPanel> tile) {
            return Messages.modelContract_removeFromContractButton_description;
        }

        public double getWeight() {
            return 20.0;
        }

        public boolean isEnabled(Tile<Node, ModelContractInContractsPanel> tile) {
            RootEntityPane pane = RootEntityPane.lookup((Node)tile.getFullNode());
            boolean isEnabled = false;
            if (pane != null && (pane.getMode() == EditingMode.EDIT || pane.getMode() == EditingMode.CREATE)) {
                isEnabled = true;
            }
            return isEnabled && ((DataViewWidget)((ModelContractInContractsPanel)tile.getFullNode()).getContractsTableCard().getContent()).getTableView().getSelectionModel().getSelectedCells().size() > 0 && Boolean.TRUE.equals(((ModelContractInContractsDataVM)((DataViewWidget)((ModelContractInContractsPanel)tile.getFullNode()).getContractsTableCard().getContent()).getTableView().getSelectionModel().getSelectedItem()).getDirectBinding());
        }

        public void execute(Control source, final Tile<Node, ModelContractInContractsPanel> tile, boolean alt) {
            ObservableList selectedItems = ((DataViewWidget)((ModelContractInContractsPanel)tile.getFullNode()).getContractsTableCard().getContent()).getTableView().getSelectionModel().getSelectedItems();
            EntityContainer modelContract = RootEntityPane.lookup((Node)tile.getFullNode()).getData().getContainer();
            ModelContractActionsHelper.ContractsCallback dataReloadCallback = new ModelContractActionsHelper.ContractsCallback(){

                public void execute() throws Exception {
                    ((DataViewWidget)((ModelContractInContractsPanel)tile.getFullNode()).getContractsTableCard().getContent()).reloadData();
                }
            };
            String dialogMessage = Messages.modelContract_removeFromContractButton_removeFromOneContractWarning;
            if (selectedItems.size() > 1) {
                dialogMessage = Messages.modelContract_removeFromContractButton_removeFromMultipleContractsWarning;
            }
            Dialog.confirm((Node)source, (String)dialogMessage, null, (String)Messages.modelContract_removeFromContractButton_removeAction, () -> 2.lambda$execute$0((List)selectedItems, modelContract, dataReloadCallback), null);
        }

        private static /* synthetic */ void lambda$execute$0(List selectedItems, EntityContainer modelContract, ModelContractActionsHelper.ContractsCallback dataReloadCallback) {
            ArrayList<ModelContractActionsHelper.ContractData> params = new ArrayList<ModelContractActionsHelper.ContractData>(selectedItems.size());
            for (ModelContractInContractsDataVM vm : selectedItems) {
                params.add(new ModelContractActionsHelper.ContractData((EntityReference<Contract>)vm.getSource(), vm.getStartDate(), vm.getEndDate(), vm.getTranslateSupplierFees()));
            }
            ModelContractActionsHelper.removeFromContractList(params, (EntityReference<ModelContract>)modelContract.toReference(), dataReloadCallback);
        }
    };


    IndexListParameters<Contract, ContractIndex> getContractsWithNewModel() {
        IndexListParameters result = new IndexListParameters();
        result.setIndexType(ContractIndex.class);
        result.getSortings().put(ContractIndex.Property.name.name(), SortOrder.ASC);
        result.getSearchCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), (Object)true));
        TableColumnSettings filter1 = new TableColumnSettings();
        filter1.setId(ContractIndex.Property.contractType.name());
        result.getFilters().add(filter1);
        TableColumnSettings filter2 = new TableColumnSettings();
        filter2.setId(ContractIndex.Property.name.name());
        result.getFilters().add(filter2);
        TableColumnSettings filter3 = new TableColumnSettings();
        filter3.setId(ContractIndex.Property.vendor.name());
        result.getFilters().add(filter3);
        TableColumnSettings filter4 = new TableColumnSettings();
        filter4.setId(ContractIndex.Property.supplier.name());
        result.getFilters().add(filter4);
        TableColumnSettings column1 = new TableColumnSettings();
        column1.setId(ContractIndex.Property.contractType.name());
        result.getColumns().add(column1);
        TableColumnSettings column2 = new TableColumnSettings();
        column2.setId(ContractIndex.Property.name.name());
        result.getColumns().add(column2);
        TableColumnSettings column3 = new TableColumnSettings();
        column3.setId(ContractIndex.Property.vendor.name());
        result.getColumns().add(column3);
        TableColumnSettings column4 = new TableColumnSettings();
        column4.setId(ContractIndex.Property.supplier.name());
        result.getColumns().add(column4);
        return result;
    }
}

