/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.organization;

import com.gridnine.xtrip.client.fx.model.profile.OrganizationAFSPanelMainVM;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.common.model.profile.Organization;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

final class OrganizationAFSTileHelper {
    private static final Map<String, AFSType> AFS_TYPES = Arrays.stream(AFSType.values()).collect(Collectors.toMap(Enum::name, Function.identity()));

    private OrganizationAFSTileHelper() {
    }

    static void toVM(Organization model, OrganizationAFSPanelMainVM full) {
        EnumSet<AFSType> types = EnumSet.noneOf(AFSType.class);
        if (model.getAfsSettings() != null && model.getAfsSettings().length() > 0) {
            for (String str : model.getAfsSettings().split("[|]")) {
                AFSType type = AFS_TYPES.get(str);
                if (type == null) continue;
                types.add(type);
            }
        }
        full.getGeneral().setAfsbkg(types.contains(AFSType.AFSBKG));
        full.getGeneral().setAfstkt(types.contains(AFSType.AFSTKT));
        full.getGeneral().setCorpfr(types.contains(AFSType.CORPFR));
        full.getPrisingOptions().setHbf1(types.contains(AFSType.HBF1));
        full.getPrisingOptions().setHbf2(types.contains(AFSType.HBF2));
        full.getPrisingOptions().setLaf1(types.contains(AFSType.LAF1));
        full.getPrisingOptions().setLaf2(types.contains(AFSType.LAF2));
        full.getPrisingOptions().setLaf3(types.contains(AFSType.LAF3));
        full.getPrisingOptions().setAtf1(types.contains(AFSType.ATF1));
        full.getPrisingOptions().setAtf2(types.contains(AFSType.ATF2));
        full.getPrisingOptions().setLpf1(types.contains(AFSType.LPF1));
        full.getPrisingOptions().setLpf2(types.contains(AFSType.LPF2));
        full.getPrisingOptions().setLpf3(types.contains(AFSType.LPF3));
        full.getPrisingOptions().setP3d(types.contains(AFSType.P3D));
        full.getPrisingOptions().setCtf(types.contains(AFSType.CTF));
        full.getOtherOptions().setDest(types.contains(AFSType.DEST));
        full.getOtherOptions().setOccl(types.contains(AFSType.OCCL));
        full.getOtherOptions().setValc(types.contains(AFSType.VALC));
        full.getOtherOptions().setCo2Emissions(types.contains(AFSType.CO2_EMISSIONS));
        full.getPrisingOptions().setAfsTimeWindow(model.getAfsTimeWindow());
        full.getPrisingOptions().setAfsAirports(model.isAfsAirports());
    }

    static void fromVM(OrganizationAFSPanelMainVM full, Organization model) {
        EnumSet<AFSType> types = EnumSet.noneOf(AFSType.class);
        if (full.getGeneral().isAfsbkg()) {
            types.add(AFSType.AFSBKG);
        }
        if (full.getGeneral().isAfstkt()) {
            types.add(AFSType.AFSTKT);
        }
        if (full.getGeneral().isCorpfr()) {
            types.add(AFSType.CORPFR);
        }
        if (full.getPrisingOptions().isHbf1()) {
            types.add(AFSType.HBF1);
        }
        if (full.getPrisingOptions().isHbf2()) {
            types.add(AFSType.HBF2);
        }
        if (full.getPrisingOptions().isLaf1()) {
            types.add(AFSType.LAF1);
        }
        if (full.getPrisingOptions().isLaf2()) {
            types.add(AFSType.LAF2);
        }
        if (full.getPrisingOptions().isLaf3()) {
            types.add(AFSType.LAF3);
        }
        if (full.getPrisingOptions().isAtf1()) {
            types.add(AFSType.ATF1);
        }
        if (full.getPrisingOptions().isAtf2()) {
            types.add(AFSType.ATF2);
        }
        if (full.getPrisingOptions().isLpf1()) {
            types.add(AFSType.LPF1);
        }
        if (full.getPrisingOptions().isLpf2()) {
            types.add(AFSType.LPF2);
        }
        if (full.getPrisingOptions().isLpf3()) {
            types.add(AFSType.LPF3);
        }
        if (full.getPrisingOptions().isP3d()) {
            types.add(AFSType.P3D);
        }
        if (full.getPrisingOptions().isCtf()) {
            types.add(AFSType.CTF);
        }
        if (full.getOtherOptions().isDest()) {
            types.add(AFSType.DEST);
        }
        if (full.getOtherOptions().isOccl()) {
            types.add(AFSType.OCCL);
        }
        if (full.getOtherOptions().isValc()) {
            types.add(AFSType.VALC);
        }
        if (full.getOtherOptions().isCo2Emissions()) {
            types.add(AFSType.CO2_EMISSIONS);
        }
        model.setAfsSettings(types.stream().map(Enum::name).collect(Collectors.joining("|")));
        model.setAfsTimeWindow(full.getPrisingOptions().getAfsTimeWindow());
        model.setAfsAirports(full.getPrisingOptions().isAfsAirports());
    }
}

