/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.organization;

import com.gridnine.xtrip.client.fx.model.profile.OrganizationContractCommissionWrapperVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationContractCommissionsMainPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationContractCommissionsPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationContractTravelSubjectCommissionsPanelVM;
import com.gridnine.xtrip.common.model.person.uidata.OrganizationContractData;
import com.gridnine.xtrip.common.model.person.uidata.OrganizationContractRuleData;
import com.gridnine.xtrip.common.model.person.uidata.OrganizationUIData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OrganizationContractCommissionsTileHelper {
    private OrganizationContractCommissionsTileHelper() {
    }

    public static void toVM(OrganizationUIData supplement, OrganizationContractCommissionsMainPanelVM full) {
        for (OrganizationContractData contractData : supplement.getContractData()) {
            OrganizationContractCommissionsPanelVM occVM = new OrganizationContractCommissionsPanelVM();
            occVM.setContractReference(contractData.getContract());
            Map<String, List<OrganizationContractRuleData>> groupedRules = contractData.getRules().stream().collect(Collectors.groupingBy(OrganizationContractRuleData::getRuleTargetCaption));
            ArrayList<String> groups = new ArrayList<String>(groupedRules.keySet());
            groups.sort(Comparator.comparing(String::toUpperCase));
            for (String group : groups) {
                OrganizationContractTravelSubjectCommissionsPanelVM rulesVM = new OrganizationContractTravelSubjectCommissionsPanelVM();
                rulesVM.setCaption(group);
                List<OrganizationContractRuleData> rules = groupedRules.get(group);
                rules.stream().map(OrganizationContractCommissionsTileHelper::toVM).forEach(rulesVM.getRules().getContent()::add);
                occVM.getTravelSubjectGroups().add(rulesVM);
            }
            full.getContent().add(occVM);
        }
    }

    private static OrganizationContractCommissionWrapperVM toVM(OrganizationContractRuleData data) {
        OrganizationContractCommissionWrapperVM result = new OrganizationContractCommissionWrapperVM();
        result.getRule().setRulesContainerReference(data.getRuleContainerRef());
        result.getRule().setRuleUid(data.getRuleUid());
        result.getRule().setName(data.getName());
        result.getRule().setConditions(data.getConditions());
        result.getRule().setCommissionProperties(data.getCommissionProperties());
        result.getRule().setValues(data.getValues());
        return result;
    }
}

