/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.organization;

import com.gridnine.xtrip.client.fx.model.profile.OrganizationPNRSettingTransferRemarksOtherVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationPNRSettingTypeVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationPNRSettingsMainPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationPNRSettingsVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PNRBuilderSettings;

final class OrganizationPNRSettingsTileHelper {
    private static final String ALL = Messages.Transfer_all;
    private static final String REQUIRED = Messages.Mandatory_to_carry_over;
    private static final String NO_TRANSFER = Messages.Do_not_transfer;

    private OrganizationPNRSettingsTileHelper() {
    }

    static void toVM(Organization model, OrganizationPNRSettingsMainPanelVM full) {
        VMHelper.transfer(model.getPnrBuildersSettings(), full.getParameters(), pnr -> new OrganizationPNRSettingsVM(), (pnr, vm) -> {
            vm.setApplicableTo(pnr.getApplicableTo());
            if (pnr.getType() != null) {
                OrganizationPNRSettingTypeVM typeVM = new OrganizationPNRSettingTypeVM();
                typeVM.setValue(pnr.getType());
                vm.setType(typeVM);
            } else {
                vm.setType(null);
            }
            vm.setName(pnr.getName());
            vm.setComment(pnr.getDescription());
            vm.getTransferFields().setDKnumber(pnr.isNeedDK());
            vm.getTransferFields().setCID(pnr.isNeedCID());
            vm.getTransferFields().setTravelerName(pnr.isNeedTravelerName());
            vm.getTransferFields().setBonusCards(pnr.isNeedFrequentFlyer());
            vm.getTransferFields().setCreditCards(pnr.isNeedCreditCards());
            vm.getTransferFields().setPhoneNumbers(pnr.isNeedPhones());
            vm.getTransferFields().setEmail(pnr.isNeedEmails());
            vm.getTransferFields().setAddresses(pnr.isNeedAddresses());
            vm.getTransferFields().setDeliveryAddresses(pnr.isNeedDeliveryAddresses());
            vm.getTransferRemarks().setPayers(pnr.isNeedPayers());
            vm.getTransferRemarks().setPassports(pnr.isNeedDOCS());
            String value = pnr.isNeedAllRemarks() ? ALL : (pnr.isNeedOnlyAlwaysMoveRemarks() ? REQUIRED : NO_TRANSFER);
            OrganizationPNRSettingTransferRemarksOtherVM other = new OrganizationPNRSettingTransferRemarksOtherVM();
            other.setValue(value);
            vm.getTransferRemarks().setOtherRemarks(other);
            vm.getProfileBinding().setAgency(pnr.isAssociateWithAgency());
            vm.getProfileBinding().setCorporateClient(pnr.isAssociateWithOrganization());
            vm.getProfileBinding().setRetailClient(pnr.isAssociateWithRetailClient());
        });
    }

    static void fromVM(OrganizationPNRSettingsMainPanelVM full, Organization model) {
        VMHelper.transfer(full.getParameters(), model.getPnrBuildersSettings(), vm -> new PNRBuilderSettings(), (vm, pnr) -> {
            pnr.setApplicableTo(vm.getApplicableTo());
            pnr.setType(vm.getType() == null ? null : vm.getType().getValue());
            pnr.setName(vm.getName());
            pnr.setDescription(vm.getComment());
            pnr.setNeedDK(vm.getTransferFields().isDKnumber());
            pnr.setNeedCID(vm.getTransferFields().isCID());
            pnr.setNeedTravelerName(vm.getTransferFields().isTravelerName());
            pnr.setNeedFrequentFlyer(vm.getTransferFields().isBonusCards());
            pnr.setNeedCreditCards(vm.getTransferFields().isCreditCards());
            pnr.setNeedPhones(vm.getTransferFields().isPhoneNumbers());
            pnr.setNeedEmails(vm.getTransferFields().isEmail());
            pnr.setNeedAddresses(vm.getTransferFields().isAddresses());
            pnr.setNeedDeliveryAddresses(vm.getTransferFields().isDeliveryAddresses());
            pnr.setNeedPayers(vm.getTransferRemarks().isPayers());
            pnr.setNeedDOCS(vm.getTransferRemarks().isPassports());
            OrganizationPNRSettingTransferRemarksOtherVM otherRemarks = vm.getTransferRemarks().getOtherRemarks();
            if (otherRemarks != null && ALL.equals(otherRemarks.getValue())) {
                pnr.setNeedAllRemarks(true);
                pnr.setNeedOnlyAlwaysMoveRemarks(false);
                pnr.setNeedNoRemarks(false);
            } else if (otherRemarks != null && REQUIRED.equals(otherRemarks.getValue())) {
                pnr.setNeedAllRemarks(false);
                pnr.setNeedOnlyAlwaysMoveRemarks(true);
                pnr.setNeedNoRemarks(false);
            } else {
                pnr.setNeedAllRemarks(false);
                pnr.setNeedOnlyAlwaysMoveRemarks(false);
                pnr.setNeedNoRemarks(true);
            }
            pnr.setAssociateWithAgency(vm.getProfileBinding().isAgency());
            pnr.setAssociateWithOrganization(vm.getProfileBinding().isCorporateClient());
            pnr.setAssociateWithRetailClient(vm.getProfileBinding().isRetailClient());
        });
    }
}

