/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.organization;

import com.gridnine.xtrip.client.fx.model.profile.OrganizationAirPreferencesPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationBonusCardAviaVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationBonusCardCarVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationBonusCardHotelVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationBonusCardRailwayVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationBonusCardsPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationDiscountsPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationHotelDiscountsPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationHotelPreferencesPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationPreferredSuppliersPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationPrivilegeMainPanelVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrierReference;
import com.gridnine.xtrip.common.model.profile.AirPreferences;
import com.gridnine.xtrip.common.model.profile.AirlineBonusCard;
import com.gridnine.xtrip.common.model.profile.CarBonusCard;
import com.gridnine.xtrip.common.model.profile.Discounts;
import com.gridnine.xtrip.common.model.profile.HotelBonusCard;
import com.gridnine.xtrip.common.model.profile.HotelDiscount;
import com.gridnine.xtrip.common.model.profile.HotelPreferences;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PreferredSuppliers;
import com.gridnine.xtrip.common.model.profile.RailwayBonusCard;

final class OrganizationPrivilegeTileHelper {
    private OrganizationPrivilegeTileHelper() {
    }

    static void toVM(Organization model, OrganizationPrivilegeMainPanelVM privilegeFull) {
        OrganizationPrivilegeTileHelper.toVMBonusCards(model, privilegeFull.getBonusCard());
        OrganizationPrivilegeTileHelper.toVMPreferredSuppliers(model.getPreferredSuppliers(), privilegeFull.getPreferredSuppliers());
        OrganizationPrivilegeTileHelper.toVMDiscounts(model.getDiscounts(), privilegeFull.getDiscounts());
    }

    static void toVMBonusCards(Organization model, OrganizationBonusCardsPanelVM full) {
        VMHelper.transfer(model.getAirlineBonusCards(), full.getAvia(), card -> new OrganizationBonusCardAviaVM(), (card, vm) -> {
            vm.setOwner(card.getNameOnCard());
            vm.setNumber(card.getNumber());
            vm.setAirline(card.getAirline());
        });
        VMHelper.transfer(model.getRailwayBonusCards(), full.getRailway(), card -> new OrganizationBonusCardRailwayVM(), (card, vm) -> {
            vm.setNumber(card.getNumber());
            vm.setCarrier((DictionaryReference)(card.getRailwayCarrierCode() == null ? null : new RailwayCarrierReference(card.getRailwayCarrierCode())));
        });
        VMHelper.transfer(model.getHotelBonusCards(), full.getHotel(), card -> new OrganizationBonusCardHotelVM(), (card, vm) -> {
            vm.setNumber(card.getNumber());
            vm.setBrand(card.getHotelBrand());
        });
        VMHelper.transfer(model.getCarBonusCards(), full.getCar(), card -> new OrganizationBonusCardCarVM(), (card, vm) -> {
            vm.setNumber(card.getNumber());
            vm.setSupplier(card.getCarSupplier());
        });
    }

    private static void toVMPreferredSuppliers(PreferredSuppliers preferredSuppliers, OrganizationPreferredSuppliersPanelVM preferredSuppliersVM) {
        if (preferredSuppliers != null) {
            VMHelper.transfer(preferredSuppliers.getAirPreferences(), preferredSuppliersVM.getAirlines(), preference -> new OrganizationAirPreferencesPanelVM(), (preference, vm) -> vm.setSupplier(preference.getSupplier()));
            VMHelper.transfer(preferredSuppliers.getHotelPreferences(), preferredSuppliersVM.getHotels(), preference -> new OrganizationHotelPreferencesPanelVM(), (preference, vm) -> vm.setSupplier(preference.getSupplier()));
        }
    }

    private static void toVMDiscounts(Discounts model, OrganizationDiscountsPanelVM discounts) {
        if (model != null) {
            VMHelper.transfer(model.getHotelDiscounts(), discounts.getHotel(), discount -> new OrganizationHotelDiscountsPanelVM(), (discount, vm) -> {
                vm.setSupplier(discount.getSupplier());
                vm.setNumber(discount.getDiscountCode());
            });
        }
    }

    static void fromVM(OrganizationPrivilegeMainPanelVM privilegeFull, Organization model) {
        OrganizationPrivilegeTileHelper.fromVMBonusCards(privilegeFull.getBonusCard(), model);
        if (model.getPreferredSuppliers() == null) {
            model.setPreferredSuppliers(new PreferredSuppliers());
        }
        OrganizationPrivilegeTileHelper.fromVMPreferredSuppliers(privilegeFull.getPreferredSuppliers(), model.getPreferredSuppliers());
        if (model.getDiscounts() == null) {
            model.setDiscounts(new Discounts());
        }
        OrganizationPrivilegeTileHelper.fromVMDiscounts(privilegeFull.getDiscounts(), model.getDiscounts());
    }

    static void fromVMBonusCards(OrganizationBonusCardsPanelVM full, Organization model) {
        VMHelper.transfer(full.getAvia(), model.getAirlineBonusCards(), vm -> new AirlineBonusCard(), (vm, card) -> {
            card.setNameOnCard(vm.getOwner());
            card.setNumber(vm.getNumber());
            card.setAirline(vm.getAirline());
        });
        VMHelper.transfer(full.getRailway(), model.getRailwayBonusCards(), vm -> new RailwayBonusCard(), (vm, card) -> {
            card.setNumber(vm.getNumber());
            card.setRailwayCarrierCode(vm.getCarrier() == null ? null : vm.getCarrier().getCode());
        });
        VMHelper.transfer(full.getHotel(), model.getHotelBonusCards(), vm -> new HotelBonusCard(), (vm, card) -> {
            card.setNumber(vm.getNumber());
            card.setHotelBrand(vm.getBrand());
        });
        VMHelper.transfer(full.getCar(), model.getCarBonusCards(), vm -> new CarBonusCard(), (vm, card) -> {
            card.setNumber(vm.getNumber());
            card.setCarSupplier(vm.getSupplier());
        });
    }

    private static void fromVMPreferredSuppliers(OrganizationPreferredSuppliersPanelVM preferredSuppliersVM, PreferredSuppliers preferredSuppliers) {
        VMHelper.transfer(preferredSuppliersVM.getAirlines(), preferredSuppliers.getAirPreferences(), vm -> new AirPreferences(), (vm, preference) -> preference.setSupplier(vm.getSupplier()));
        VMHelper.transfer(preferredSuppliersVM.getHotels(), preferredSuppliers.getHotelPreferences(), vm -> new HotelPreferences(), (vm, preference) -> preference.setSupplier(vm.getSupplier()));
    }

    private static void fromVMDiscounts(OrganizationDiscountsPanelVM discounts, Discounts model) {
        VMHelper.transfer(discounts.getHotel(), model.getHotelDiscounts(), vm -> new HotelDiscount(), (vm, discount) -> {
            discount.setSupplier(vm.getSupplier());
            discount.setDiscountCode(vm.getNumber());
        });
    }
}

