/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.organization;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationPCCSabreIDVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationSPSyncMainPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationSPSyncMessagesVM;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationSPSyncParamVM;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.SabreProfilesPccSettings;
import java.util.Date;
import java.util.List;

final class OrganizationSabreProfilesSynchronizationTileHelper {
    private OrganizationSabreProfilesSynchronizationTileHelper() {
    }

    static void toVM(Organization model, OrganizationSPSyncMainPanelVM full) {
        full.getSyncResult().setLastSuccessSyncDate(DateUtils.asLocalDateTime((Date)model.getSabreProfilesLastSyncDate()));
        full.getSyncResult().setLastAttemptSyncDate(DateUtils.asLocalDateTime((Date)model.getSabreProfilesLastSyncAttemptDate()));
        full.getSyncResult().setLastSyncStatus(model.getSabreProfilesLastSyncStatus());
        full.getSyncResult().setLastOperationType(model.getSabreProfilesLastOperationType());
        VMHelper.transfer(model.getSabreProfilesUniqueIDs(), full.getOrganizationSabreIDs(), md -> new OrganizationPCCSabreIDVM(), (md, vm) -> {
            vm.setPcc(md.getPcc());
            vm.setSabreID(md.getUniqueID());
        });
        List messages = full.getSyncMessages();
        messages.clear();
        model.getSabreProfilesMessages().forEach(msg -> {
            OrganizationSPSyncMessagesVM msgVM = new OrganizationSPSyncMessagesVM();
            msgVM.setMessageType(msg.getType().toString());
            if (msg.getMessage() != null) {
                msgVM.setMessageBody(msg.getMessage().toString());
            }
            msgVM.getDetails().setType(msg.getType());
            msgVM.getDetails().setMessage(msg.getMessage().toString());
            msgVM.getDetails().setDetails(msg.getDetails());
            messages.add(msgVM);
        });
        VMHelper.transfer(model.getSabreProfilesPccSettings(), full.getSabreProfilesPCC(), params -> new OrganizationSPSyncParamVM(), (params, paramsVM) -> {
            paramsVM.setDescription(params.getDescription());
            paramsVM.setPassword(params.getPassword());
            paramsVM.setPcc(params.getPcc());
        });
        full.getCommonOrgSabreProfileSettings().setSyncNotEnabled(model.isNotSynchronizeWithSabreProfile());
        full.getCommonOrgSabreProfileSettings().setLoadEnabled(model.isSabreProfilesLoadAllowed());
        full.getCommonOrgSabreProfileSettings().setExternalSystem(model.getExternalSystem());
        full.getCommonOrgSabreProfileSettings().setSabreProfilesName(model.getSabreProfilesName());
    }

    static void fromVM(OrganizationSPSyncMainPanelVM full, Organization model) {
        VMHelper.transfer(full.getSabreProfilesPCC(), model.getSabreProfilesPccSettings(), paramsVM -> new SabreProfilesPccSettings(), (paramsVM, params) -> {
            params.setDescription(paramsVM.getDescription());
            params.setPassword(paramsVM.getPassword());
            params.setPcc(paramsVM.getPcc());
        });
        model.setNotSynchronizeWithSabreProfile(full.getCommonOrgSabreProfileSettings().isSyncNotEnabled());
        model.setSabreProfilesLoadAllowed(full.getCommonOrgSabreProfileSettings().isLoadEnabled());
        model.setExternalSystem(full.getCommonOrgSabreProfileSettings().getExternalSystem());
        model.setSabreProfilesName(full.getCommonOrgSabreProfileSettings().getSabreProfilesName());
    }
}

