/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.organization.controllerinterceptors;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.widgets.FileChooserWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationSpace;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidsDetailsPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidsPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationUdidsValuesImportPane;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.async.OrganizationUdidsValuesImportParams;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.VBox;

public enum OrganizationUdidsDetailsTileActions implements TileAction<Node, OrganizationUdidsDetailsPanel>
{
    IMPORT{
        private final List<String> permittedExtensions = Arrays.asList("xlsx", "xls");

        public String getName(Tile<Node, OrganizationUdidsDetailsPanel> tile) {
            return Messages.Import_UDID_values;
        }

        public String getDescription(Tile<Node, OrganizationUdidsDetailsPanel> tile) {
            return "From file (TODO: set from messages)";
        }

        public double getWeight() {
            return 0.0;
        }

        public boolean isEnabled(Tile<Node, OrganizationUdidsDetailsPanel> tile) {
            RootEntityPane pane = RootEntityPane.lookup((Node)tile.getFullNode());
            boolean isEnabled = false;
            if (pane != null) {
                isEnabled = !((TableWidget)((OrganizationUdidsPanel)((OrganizationSpace)pane.getEditor()).getUdidsTile().getFullNode()).getGeneralCard().getContent()).getViewState().isImmutable();
            }
            return isEnabled;
        }

        public void execute(Control source, Tile<Node, OrganizationUdidsDetailsPanel> tile, boolean alt) {
            OrganizationUdidsValuesImportPane udidsValuesImportPane = new OrganizationUdidsValuesImportPane(false);
            VBox body = new VBox(new Node[]{udidsValuesImportPane});
            udidsValuesImportPane.getFullUpdateNode().setConverter(Converters.boolConverter((String)Messages.organization_OrganizationUdidsDetailsTileActions_udidsValuesImportPane_fullUpdateNode_trueValue, (String)Messages.organization_OrganizationUdidsDetailsTileActions_udidsValuesImportPane_fullUpdateNode_falseValue));
            Dialog dialog = new Dialog();
            dialog.setTitle(Messages.organization_OrganizationUdidsDetailsTileActions_description).setBody((Node)body).setAutoClose(false).setOnCloseRequest(() -> ((Dialog)dialog).close()).setExpandToParent(false).addButton(DialogButtonStyle.DECLINE, Messages.organization_OrganizationUdidsDetailsTileActions_dialog_decline, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.organization_OrganizationUdidsDetailsTileActions_dialog_accept_regular, () -> {
                this.clearValidationMessages(body);
                Collection<String> messages = this.validateData(udidsValuesImportPane);
                if (!messages.isEmpty()) {
                    messages.forEach(message -> {
                        body.getChildren().add(0, (Object)MessagePane.error((String)message));
                        Notifications.get().getScheduler().schedule(() -> FxUtil.submitToFxThread(() -> this.clearValidationMessages(body)), 10L, TimeUnit.SECONDS);
                    });
                    return;
                }
                try {
                    this.udidsValuesImport(tile, udidsValuesImportPane);
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                }
                dialog.close();
            }).show((Node)source);
        }

        private void udidsValuesImport(Tile<Node, OrganizationUdidsDetailsPanel> tile, OrganizationUdidsValuesImportPane udidsValuesImportPane) throws Exception {
            RootEntityPane rootPane = RootEntityPane.lookup((Node)tile.getFullNode());
            File file = (File)udidsValuesImportPane.getImportFromFileNode().getFiles().get(0);
            EntityReference orgRef = rootPane.getData().getContainer().toReference();
            byte[] fileContent = Files.readAllBytes(file.toPath());
            OrganizationUdidsValuesImportParams.FileExtension fileExtension = file.getName().contains(".xlsx") ? OrganizationUdidsValuesImportParams.FileExtension.XLSX : OrganizationUdidsValuesImportParams.FileExtension.XLS;
            RootEntityPane.executeAsyncAction((RootEntityPane)rootPane, () -> this.enqueueAsyncServerTask(udidsValuesImportPane, (EntityReference<Organization>)orgRef, fileContent, fileExtension));
        }

        private void enqueueAsyncServerTask(final OrganizationUdidsValuesImportPane pane, final EntityReference<Organization> orgRef, final byte[] fileContent, final OrganizationUdidsValuesImportParams.FileExtension fileExtension) throws Exception {
            Notifications.get().enqueueAsyncTask(new ServerTaskHandler(){

                protected String getTitle() {
                    return Messages.organization_OrganizationUdidsDetailsTileActions_name;
                }

                protected void onCompleted(Object taskResult, List<Message> log) {
                    if (taskResult instanceof Message) {
                        Message message = (Message)taskResult;
                        if (orgRef != null && (message.getType() == MessageType.MESSAGE || message.getType() == MessageType.WARNING)) {
                            EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(orgRef, EntityModification.ModificationType.CHANGE)));
                        }
                        Notifications.get().showMessages(new Message[]{message});
                    }
                }

                protected Serializable getTaskParameters() {
                    OrganizationUdidsValuesImportParams params = new OrganizationUdidsValuesImportParams(orgRef, fileContent, fileExtension);
                    if (pane.getFullUpdateNode().getValue()) {
                        params.setImportType(OrganizationUdidsValuesImportParams.ImportCosCodesType.FULL_UPDATE);
                    } else {
                        params.setImportType(OrganizationUdidsValuesImportParams.ImportCosCodesType.APPEND);
                    }
                    return params;
                }

                protected String getTaskClassName() {
                    return "com.gridnine.xtrip.server.fx.async.OrganizationUdidsValuesImportAsyncTask";
                }
            });
        }

        private Collection<String> validateData(OrganizationUdidsValuesImportPane pane) {
            ArrayList<String> result = new ArrayList<String>();
            FileChooserWidget fileWidget = pane.getImportFromFileNode();
            if (fileWidget.getFiles().isEmpty()) {
                result.add(Messages.organization_OrganizationUdidsDetailsTileActions_validation_fileNotSelected);
            } else {
                File file = (File)fileWidget.getFiles().get(0);
                if (this.permittedExtensions.stream().noneMatch(ext -> file.getName().contains((CharSequence)ext))) {
                    result.add(Messages.organization_OrganizationUdidsDetailsTileActions_validation_wrongFileExtension + this.permittedExtensions);
                }
            }
            return result;
        }

        private void clearValidationMessages(VBox vbox) {
            vbox.getChildren().removeAll((Collection)vbox.getChildren().stream().filter(node -> node.getClass() == MessagePane.class).collect(Collectors.toList()));
        }
    };

}

