/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.handlers.parsers;

import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.parsers.BSPExchangeDocumentSpace;
import com.gridnine.xtrip.client.fx.model.parsers.BSPExchangeDocumentSpaceController;
import com.gridnine.xtrip.client.fx.model.parsers.BSPExchangeDocumentSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.parsers.ParsersHelper;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.parsers.model.BSPExchangeDocument;
import com.gridnine.xtrip.common.parsers.model.BSPExchangeDocumentIndex;
import com.gridnine.xtrip.common.parsers.model.BaseExchangeDocument;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class BSPExchangeDocumentHandler
extends BaseRootEntityHandler<BSPExchangeDocument, Void, BSPExchangeDocumentSpaceVM, BSPExchangeDocumentSpace> {
    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return BSPExchangeDocumentIndex.class;
    }

    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<BSPExchangeDocument, Void>, BSPExchangeDocumentSpaceVM>> toVM, List<BiConsumer<BSPExchangeDocumentSpaceVM, DataTransferPackage<BSPExchangeDocument, Void>>> fromVM) {
        toVM.add((dtp, vm) -> {
            BSPExchangeDocument model = (BSPExchangeDocument)dtp.getContainer().getEntity();
            ParsersHelper.overviewToVM((BaseExchangeDocument)model, vm.getOverview());
            ParsersHelper.generalParametersToVM((BaseExchangeDocument)model, vm.getGeneralParametersFull());
            ParsersHelper.messagesToVM((BaseExchangeDocument)model, vm.getMessagesFull());
            ParsersHelper.contentToVM((BaseExchangeDocument)model, vm.getContentFull());
            vm.getFileASFOFull().setTransactionType(model.getTransactionType());
            vm.getFileASFOFull().setTicketNumber(model.getTicketNumber());
            vm.getFileASFOFull().setTariff(model.getEquivalentFare());
            vm.getFileASFOFull().setCommission(model.getCommissionValue());
            vm.getFileASFOFull().setCommissionPersent(model.getCommissionRate() == null ? 0.0 : model.getCommissionRate().doubleValue());
            vm.getFileASFOFull().setValidator(model.getValidator());
            vm.getFileASFOFull().setTaxes(model.getTaxesSum());
            vm.getFileASFOFull().setIssued(DateUtils.asLocalDate((Date)model.getOperationDate()));
        });
        fromVM.add((vm, dtp) -> {
            BSPExchangeDocument model = (BSPExchangeDocument)dtp.getContainer().getEntity();
            ParsersHelper.generalParametersFromVM(vm.getGeneralParametersFull(), (BaseExchangeDocument)model);
            ParsersHelper.contentFromVM(vm.getContentFull(), (BaseExchangeDocument)model);
            model.setTransactionType(vm.getFileASFOFull().getTransactionType());
            model.setTicketNumber(vm.getFileASFOFull().getTicketNumber());
            model.setEquivalentFare(vm.getFileASFOFull().getTariff());
            model.setCommissionValue(vm.getFileASFOFull().getCommission());
            model.setCommissionRate(new BigDecimal(vm.getFileASFOFull().getCommissionPersent()));
            model.setValidator(vm.getFileASFOFull().getValidator());
            model.setTaxesSum(vm.getFileASFOFull().getTaxes());
            model.setOperationDate(DateUtils.asDate((LocalDate)vm.getFileASFOFull().getIssued()));
        });
    }

    @Override
    protected ViewController<BSPExchangeDocumentSpace, BSPExchangeDocumentSpaceVM> createSpaceController(boolean readonly) {
        return new BSPExchangeDocumentSpaceController(readonly);
    }

    @Override
    protected BSPExchangeDocumentSpaceVM createVM() {
        return new BSPExchangeDocumentSpaceVM();
    }

    public Class<BSPExchangeDocument> getEntityClass() {
        return BSPExchangeDocument.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }
}

